/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations.impl;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.RunAppServerInstanceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.GuiUtils;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class RunAppServerInstanceManagerImpl
extends RunAppServerInstanceManager {
    private final Project myProject;

    RunAppServerInstanceManagerImpl(Project project) {
        this.myProject = project;
    }

    @Nullable
    public J2EEServerInstance findInstance(CommonModel configuration) {
        if (configuration == null) {
            return null;
        }
        String name = configuration.getName();
        if (name == null) {
            return null;
        }
        ProcessHandler[] currentProcesses = ExecutionManager.getInstance((Project)this.myProject).getRunningProcesses();
        J2EEServerInstance terminated = null;
        for (ProcessHandler currentProcess : currentProcesses) {
            J2EEServerInstance serverInstance;
            if (!(currentProcess instanceof J2EEProcess) || (serverInstance = ((J2EEProcess)currentProcess).getServerInstance()) == null || !Comparing.equal((String)serverInstance.getName(), (String)name)) continue;
            if (currentProcess.isProcessTerminating() || currentProcess.isProcessTerminated()) {
                terminated = serverInstance;
                continue;
            }
            return serverInstance;
        }
        return terminated;
    }

    @Nullable
    public ProcessHandler findHandler(J2EEServerInstance existingInstance) {
        ProcessHandler[] currentProcesses;
        for (ProcessHandler currentProcess : currentProcesses = ExecutionManager.getInstance((Project)this.myProject).getRunningProcesses()) {
            J2EEServerInstance serverInstance;
            if (!(currentProcess instanceof J2EEProcess) || (serverInstance = ((J2EEProcess)currentProcess).getServerInstance()) != existingInstance) continue;
            return currentProcess;
        }
        return null;
    }

    public boolean debuggerIsConnected(ProcessHandler processHandler) {
        return new Checker().check(processHandler);
    }

    public boolean debuggerIsPaused(ProcessHandler processHandler) {
        return new Checker(){

            @Override
            protected boolean doCheck(DebuggerSession session) {
                return super.doCheck(session) && session.isPaused();
            }
        }.check(processHandler);
    }

    private class Checker {
        private Checker() {
        }

        public boolean check(ProcessHandler processHandler) {
            Ref result = new Ref((Object)false);
            try {
                Runnable calculableAction = () -> {
                    if (RunAppServerInstanceManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    DebugProcess debugProcess = DebuggerManager.getInstance((Project)RunAppServerInstanceManagerImpl.this.myProject).getDebugProcess(processHandler);
                    if (debugProcess == null) {
                        return;
                    }
                    DebuggerSession session = DebuggerManagerEx.getInstanceEx((Project)RunAppServerInstanceManagerImpl.this.myProject).getSession(debugProcess);
                    if (session == null) {
                        return;
                    }
                    result.set((Object)this.doCheck(session));
                };
                GuiUtils.runOrInvokeAndWait((Runnable)calculableAction);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            return (Boolean)result.get();
        }

        protected boolean doCheck(DebuggerSession session) {
            return session.isAttached();
        }
    }
}

