/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.GenerateInterceptorMethodsHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaeeIcons;
import org.jetbrains.annotations.NotNull;

public class GenerateInterceptorMethods
extends BaseGenerateAction {
    public GenerateInterceptorMethods() {
        super((CodeInsightActionHandler)new GenerateInterceptorMethodsHandler());
        this.getTemplatePresentation().setIcon(JavaeeIcons.EJB_MODULE_SMALL);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/GenerateInterceptorMethods", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/GenerateInterceptorMethods", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/GenerateInterceptorMethods", "isValidForFile"));
        }
        if (!super.isValidForFile(project, editor, file)) {
            return false;
        }
        PsiClass psiClass = this.getTargetClass(editor, file);
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)psiClass);
        if (ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) > 0) {
            return false;
        }
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            return true;
        }
        return false;
    }
}

