/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.GenerateEJBFinderOrSelectorMethodHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaeeIcons;
import org.jetbrains.annotations.NotNull;

public class GenerateEJBFinderOrSelectorMethod
extends BaseGenerateAction {
    public GenerateEJBFinderOrSelectorMethod() {
        super((CodeInsightActionHandler)new GenerateEJBFinderOrSelectorMethodHandler());
        this.getTemplatePresentation().setIcon(JavaeeIcons.EJB_MODULE_SMALL);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/GenerateEJBFinderOrSelectorMethod", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/GenerateEJBFinderOrSelectorMethod", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/GenerateEJBFinderOrSelectorMethod", "isValidForFile"));
        }
        PsiClass psiClass = this.getTargetClass(editor, file);
        if (psiClass == null || psiClass.isEnum()) {
            return false;
        }
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)psiClass);
        if (ejbFacet == null) {
            return false;
        }
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE || !EjbUtil.isCMP(role.getEnterpriseBean(), CmpVersion.CmpVersion_2_X)) continue;
            return true;
        }
        return false;
    }
}

