/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.annotator;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.EjbInspectionToolProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.descriptors.ConfigFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjbValidator
extends InspectionValidator {
    public EjbValidator() {
        super(J2EEBundle.message((String)"ejb.validator.decription", (Object[])new Object[0]), J2EEBundle.message((String)"progress.validating.ejbs.text", (Object[])new Object[0]));
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/daemon/impl/analysis/annotator/EjbValidator", "isAvailableOnScope"));
        }
        return EjbValidator.containsEjbFacet(scope);
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new EjbInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/annotator/EjbValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        VirtualFile[] javaFiles;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile javaFile : javaFiles = context.getProjectCompileScope().getFiles((FileType)StdFileTypes.JAVA, true)) {
            EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((Project)project, (VirtualFile)javaFile);
            if (ejbFacet == null) continue;
            result.add(javaFile);
        }
        THashSet descriptorFiles = new THashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (EjbFacet facet : EjbFacet.getInstances((Module)module)) {
                InspectionValidatorUtil.addDescriptor((Collection)descriptorFiles, (ConfigFile)facet.getEjbJarDescriptor());
            }
        }
        result.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)descriptorFiles, (CompileContext)context));
        return result;
    }

    @NotNull
    public Collection<PsiElement> getDependencies(final PsiFile psiFile) {
        Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiElement>>(){

            public Collection<PsiElement> compute() {
                ArrayList<PsiElement> result = new ArrayList<PsiElement>();
                Set<? extends EnvironmentGroup> parts = EjbUtil.getEnterpriseBeansAndInterceptors(psiFile);
                for (EnvironmentGroup environmentGroup : parts) {
                    Interceptor interceptor;
                    PsiClass interceptorClass;
                    XmlTag tag = JamCommonUtil.getXmlTag((CommonModelElement)environmentGroup);
                    if (tag != null) {
                        result.add((PsiElement)tag);
                    }
                    if (environmentGroup instanceof EnterpriseBean) {
                        EnterpriseBean ejb = (EnterpriseBean)environmentGroup;
                        PsiClass beanClass = (PsiClass)ejb.getEjbClass().getValue();
                        if (beanClass != null) {
                            result.add((PsiElement)beanClass);
                        }
                        for (PsiClass anInterface : EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)true, (boolean)true)) {
                            result.add((PsiElement)anInterface);
                        }
                        continue;
                    }
                    if (!(environmentGroup instanceof Interceptor) || (interceptorClass = (PsiClass)(interceptor = (Interceptor)environmentGroup).getInterceptorClass().getValue()) == null) continue;
                    result.add((PsiElement)interceptorClass);
                }
                return result;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/annotator/EjbValidator", "getDependencies"));
        }
        return collection;
    }

    private static boolean containsEjbFacet(CompileScope compileScope) {
        Module[] modules = compileScope.getAffectedModules();
        return !JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, modules).isEmpty();
    }
}

