/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.annotator;

import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.xml.ejb.CmrField;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.Collection;
import javax.swing.Icon;

public class EjbDomAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, DomElementAnnotationHolder holder) {
        if (element instanceof com.intellij.javaee.model.xml.ejb.CmpField) {
            com.intellij.javaee.model.xml.ejb.CmpField field = (com.intellij.javaee.model.xml.ejb.CmpField)element;
            EjbDomAnnotator.addGutterIcon(holder, (GenericDomValue<String>)field.getFieldName(), EjbUtil.collectFieldAccessors((CmpField)field));
        } else if (element instanceof CmrField) {
            CmrField field = (CmrField)element;
            EjbDomAnnotator.addGutterIcon(holder, (GenericDomValue<String>)field.getCmrFieldName(), EjbUtil.collectFieldAccessors((com.intellij.javaee.model.common.ejb.CmrField)field));
        }
    }

    private static void addGutterIcon(DomElementAnnotationHolder holder, GenericDomValue<String> fieldName, Collection<PsiElement> elements) {
        if (DomUtil.hasXml(fieldName) && !elements.isEmpty()) {
            NavigationGutterIconBuilder.create((Icon)PlatformIcons.METHOD_ICON).setTargets(elements).setTooltipText(EjbHighlightingMessages.message("ejb.field.popup.tooltip.choose.accessor", new Object[0])).setPopupTitle(EjbHighlightingMessages.message("ejb.field.popup.title.choose.accessor", new Object[0])).install(holder, fieldName);
        }
    }
}

