/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.support;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypes;
import com.intellij.plugins.drools.lang.psi.DroolsBlock;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsQueryStatement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleName;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringId;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.DroolsTypeName;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DroolsFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement element = node.getPsi();
        if (element instanceof DroolsFile) {
            DroolsFile file = (DroolsFile)element;
            ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
            for (DroolsRuleStatement droolsRuleStatement : file.getRules()) {
                DroolsFoldingBuilder.addRuleFoldingDescriptors(descriptors, droolsRuleStatement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getDeclarations()) {
                DroolsFoldingBuilder.addDeclareFoldingDescriptors(descriptors, (DroolsDeclareStatement)droolsPsiCompositeElement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getQueries()) {
                DroolsFoldingBuilder.addQueryFoldingDescriptors(descriptors, (DroolsQueryStatement)droolsPsiCompositeElement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getFunctions()) {
                int end;
                int start;
                DroolsBlock block = droolsPsiCompositeElement.getBlock();
                if (block == null || (start = block.getTextRange().getStartOffset() + 1) + 1 >= (end = block.getTextRange().getEndOffset() - 1)) continue;
                descriptors.add(new FoldingDescriptor(droolsPsiCompositeElement.getNode(), new TextRange(start, end)));
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "buildFoldRegions"));
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "buildFoldRegions"));
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addRuleFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsRuleStatement rule) {
        int end;
        if (!rule.textContains('\n')) {
            return;
        }
        DroolsRuleName nameElement = rule.getRuleName();
        int start = nameElement.getTextRange().getEndOffset();
        if (start + 1 < (end = rule.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(rule.getNode(), new TextRange(start, end)));
        }
    }

    private static void addDeclareFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsDeclareStatement statement) {
        int end;
        DroolsTypeName nameElement;
        int start;
        if (!statement.textContains('\n')) {
            return;
        }
        DroolsTypeDeclaration declaration = statement.getTypeDeclaration();
        if (declaration != null && (start = (nameElement = declaration.getTypeName()).getTextRange().getEndOffset()) + 1 < (end = statement.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(statement.getNode(), new TextRange(start, end)));
        }
    }

    private static void addQueryFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsQueryStatement statement) {
        int end;
        if (!statement.textContains('\n')) {
            return;
        }
        DroolsStringId nameElement = statement.getStringId();
        int start = nameElement.getTextRange().getEndOffset();
        if (start + 1 < (end = statement.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(statement.getNode(), new TextRange(start, end)));
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "getPlaceholderText"));
        }
        if (node.getElementType() == DroolsTokenTypes.RULE_STATEMENT) {
            return "<~>";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

