/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionLightMethodBuilder;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NotNull;

public class DroolsFunctionsProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsFunctionsProcessor myInstance;

    private DroolsFunctionsProcessor() {
    }

    public static DroolsFunctionsProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsFunctionsProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsFunctionsProcessor", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsFunctionsProcessor", "processElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsFunctionsProcessor", "processElement"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsFunctionsProcessor", "processElement"));
        }
        for (DroolsFunctionStatement functionStatement : droolsFile.getFunctions()) {
            if (processor.execute((PsiElement)functionStatement, state)) continue;
            return false;
        }
        return true;
    }

    public static LightMethodBuilder createLightMethodBuilder(@NotNull DroolsFunctionStatement function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsFunctionsProcessor", "createLightMethodBuilder"));
        }
        return new DroolsFunctionLightMethodBuilder(function);
    }
}

