/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsArguments;
import com.intellij.plugins.drools.lang.psi.DroolsConstraint;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsExpression;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsGlobalStatement;
import com.intellij.plugins.drools.lang.psi.DroolsIdentifier;
import com.intellij.plugins.drools.lang.psi.DroolsImport;
import com.intellij.plugins.drools.lang.psi.DroolsInsertLogicalRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsInsertRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsLhsPattern;
import com.intellij.plugins.drools.lang.psi.DroolsLhsPatternBind;
import com.intellij.plugins.drools.lang.psi.DroolsModifyRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsPackageStatement;
import com.intellij.plugins.drools.lang.psi.DroolsParExpr;
import com.intellij.plugins.drools.lang.psi.DroolsPrimaryExpr;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsQualifiedIdentifier;
import com.intellij.plugins.drools.lang.psi.DroolsQueryStatement;
import com.intellij.plugins.drools.lang.psi.DroolsReference;
import com.intellij.plugins.drools.lang.psi.DroolsRetractRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsSimpleRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsType;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.DroolsUnaryAssignExpr;
import com.intellij.plugins.drools.lang.psi.DroolsUpdateRhsStatement;
import com.intellij.plugins.drools.lang.psi.DroolsVisitor;
import com.intellij.plugins.drools.lang.psi.impl.DroolsFakePsiMethod;
import com.intellij.plugins.drools.lang.psi.impl.DroolsPsiClassImpl;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclaredTypesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsFunctionsProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsGlobalVariablesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsImplicitVariablesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsImportedClassesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsImportedPackagesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsLhsBindVariablesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsLocalVariablesProcessor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsRhsImplicitAssignExpressionsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsResolveUtil {
    public static DroolsDeclarationsProcessor[] myDeclarationsProcessors = new DroolsDeclarationsProcessor[]{DroolsImportedPackagesProcessor.getInstance(), DroolsImportedClassesProcessor.getInstance(), DroolsLhsBindVariablesProcessor.getInstance(), DroolsImplicitVariablesProcessor.getInstance(), DroolsGlobalVariablesProcessor.getInstance(), DroolsFunctionsProcessor.getInstance(), DroolsDeclaredTypesProcessor.getInstance(), DroolsLocalVariablesProcessor.getInstance(), DroolsRhsImplicitAssignExpressionsProcessor.getInstance()};

    public static boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processDeclarations"));
        }
        DroolsFile droolsFile = (DroolsFile)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{DroolsFile.class});
        if (droolsFile != null) {
            for (DroolsDeclarationsProcessor declarationsProcessor : myDeclarationsProcessors) {
                if (declarationsProcessor.processElement(processor, state, lastParent, place, droolsFile)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<? extends PsiElement> resolve(@NotNull DroolsReference reference, boolean incompleteCode) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "resolve"));
        }
        MyReferenceResolvePsiElementProcessor processor = new MyReferenceResolvePsiElementProcessor(reference.getText());
        DroolsResolveUtil.processQualifiedIdentifier(processor, reference);
        if (processor.getResults().size() == 0) {
            if (PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsType.class) != null) {
                DroolsResolveUtil.processQualifiedIdentifier(processor, reference);
            } else {
                DroolsResolveUtil.processVariables(processor, reference, incompleteCode);
            }
        }
        return processor.getResults();
    }

    public static boolean processVariables(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, @NotNull DroolsReference reference, boolean incompleteCode) {
        PsiElement resolve;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processVariables"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processVariables"));
        }
        DroolsReference leftReference = DroolsResolveUtil.getLeftReference((PsiElement)reference);
        if (leftReference != null && (resolve = leftReference.resolve()) instanceof PsiClass) {
            return DroolsResolveUtil.processClassMembers(processor, Collections.singleton((PsiClass)resolve), true);
        }
        if (leftReference != null) {
            return DroolsResolveUtil.processClassMembers(processor, leftReference);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsRuleStatement.class) != null) {
            if (!DroolsResolveUtil.processModifyStatements(processor, reference)) {
                return false;
            }
            if (!DroolsResolveUtil.processInsertStatements(processor, reference)) {
                return false;
            }
            if (!DroolsResolveUtil.processInsertLogicalStatements(processor, reference)) {
                return false;
            }
            if (!DroolsResolveUtil.processRetractStatements(processor, reference)) {
                return false;
            }
            if (!DroolsResolveUtil.processUpdateStatements(processor, reference)) {
                return false;
            }
        }
        if (!DroolsResolveUtil.processConstrains(processor, reference)) {
            return false;
        }
        if (!DroolsResolveUtil.processPrimaryExpression(processor, reference)) {
            return false;
        }
        if (!DroolsResolveUtil.processPatternBinds(processor, reference)) {
            return false;
        }
        if (!DroolsResolveUtil.processQueries(processor, reference)) {
            return false;
        }
        if (!DroolsResolveUtil.processFunctions(processor, reference)) {
            return false;
        }
        if (!DroolsResolveUtil.processParameters(processor, reference)) {
            return false;
        }
        return DroolsResolveUtil.processGlobalVariables(processor, reference);
    }

    private static boolean processFunctions(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        PsiFile containingFile = reference.getContainingFile();
        if (containingFile instanceof DroolsFile) {
            for (DroolsFunctionStatement functionStatement : ((DroolsFile)containingFile).getFunctions()) {
                if (processor.process((Object)functionStatement)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQueries(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        PsiFile containingFile = reference.getContainingFile();
        if (containingFile instanceof DroolsFile) {
            for (DroolsQueryStatement queryStatement : ((DroolsFile)containingFile).getQueries()) {
                if (processor.process((Object)queryStatement)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processGlobalVariables(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        PsiFile containingFile = reference.getContainingFile();
        if (containingFile instanceof DroolsFile) {
            for (DroolsGlobalStatement globalStatement : ((DroolsFile)containingFile).getGlobalVariables()) {
                if (processor.process((Object)globalStatement)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processModifyStatements(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processModifyStatements"));
        }
        DroolsModifyRhsStatement modifyRhsStatement = (DroolsModifyRhsStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsModifyRhsStatement.class);
        if (modifyRhsStatement != null) {
            PsiClass psiClass;
            DroolsResolveUtil.processLocalVariables(processor, modifyRhsStatement);
            if (PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsParExpr.class) == null && (psiClass = DroolsResolveUtil.getModifyStatementType(modifyRhsStatement)) != null) {
                DroolsResolveUtil.processClassMembers(processor, Collections.singleton(psiClass), false);
            }
        }
        return true;
    }

    private static boolean processInsertStatements(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processInsertStatements"));
        }
        return DroolsResolveUtil.processLocalVariables(processor, (DroolsSimpleRhsStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsInsertRhsStatement.class));
    }

    private static boolean processUpdateStatements(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processUpdateStatements"));
        }
        return DroolsResolveUtil.processLocalVariables(processor, (DroolsSimpleRhsStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsUpdateRhsStatement.class));
    }

    private static boolean processInsertLogicalStatements(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processInsertLogicalStatements"));
        }
        return DroolsResolveUtil.processLocalVariables(processor, (DroolsSimpleRhsStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsInsertLogicalRhsStatement.class));
    }

    private static boolean processRetractStatements(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processRetractStatements"));
        }
        return DroolsResolveUtil.processLocalVariables(processor, (DroolsSimpleRhsStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsRetractRhsStatement.class));
    }

    private static boolean processLocalVariables(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, @Nullable DroolsSimpleRhsStatement rhsStatement) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processLocalVariables"));
        }
        if (rhsStatement != null) {
            Set<PsiVariable> psiVariables = DroolsResolveUtil.getLocalVariables((PsiElement)rhsStatement);
            for (PsiVariable variable : psiVariables) {
                if (processor.process((Object)variable)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static Set<PsiVariable> getLocalVariables(PsiElement rhsStatement) {
        HashSet variables = ContainerUtil.newHashSet();
        variables.addAll(DroolsLocalVariablesProcessor.getLocalVariables(rhsStatement));
        variables.addAll(DroolsRhsImplicitAssignExpressionsProcessor.getLocalVariables(rhsStatement));
        HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getLocalVariables"));
        }
        return hashSet;
    }

    private static boolean processClassMembers(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference leftReference) {
        PsiType type;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processClassMembers"));
        }
        PsiElement resolve = leftReference.resolve();
        if (resolve instanceof DroolsLhsPatternBind) {
            DroolsLhsPatternBind bind = (DroolsLhsPatternBind)resolve;
            return DroolsResolveUtil.processClassMembers(processor, DroolsResolveUtil.getPatternBindType(bind.getLhsPatternList()), false);
        }
        if (resolve instanceof DroolsUnaryAssignExpr) {
            PsiType psiType;
            DroolsLhsPattern droolsLhsPattern = (DroolsLhsPattern)PsiTreeUtil.getParentOfType((PsiElement)resolve, DroolsLhsPattern.class);
            if (droolsLhsPattern != null && (psiType = ((DroolsUnaryAssignExpr)resolve).getType()) instanceof PsiClassType) {
                return DroolsResolveUtil.processClassMembers(processor, Collections.singleton(((PsiClassType)psiType).resolve()), false);
            }
        } else if (resolve instanceof PsiVariable && (type = ((PsiVariable)resolve).getType()) instanceof PsiClassType) {
            return DroolsResolveUtil.processClassMembers(processor, Collections.singleton(((PsiClassType)type).resolve()), false);
        }
        return true;
    }

    private static boolean processConstrains(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        DroolsLhsPattern lhsPatternBind;
        DroolsConstraint constraint = (DroolsConstraint)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsConstraint.class);
        return constraint == null || (lhsPatternBind = (DroolsLhsPattern)PsiTreeUtil.getParentOfType((PsiElement)constraint, DroolsLhsPattern.class)) == null || DroolsResolveUtil.processClassMembers(processor, DroolsResolveUtil.getPatternBindType(Collections.singletonList(lhsPatternBind)), false);
    }

    private static boolean processPrimaryExpression(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        PsiType type;
        DroolsPrimaryExpr primaryExpression;
        DroolsArguments droolsArguments = (DroolsArguments)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsArguments.class);
        return droolsArguments == null || (primaryExpression = (DroolsPrimaryExpr)PsiTreeUtil.getParentOfType((PsiElement)droolsArguments, DroolsPrimaryExpr.class)) == null || !((type = primaryExpression.getType()) instanceof PsiClassType) || DroolsResolveUtil.processClassMembers(processor, Collections.singleton(((PsiClassType)type).resolve()), false);
    }

    private static boolean processPatternBinds(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        Set<PsiVariable> patternBinds = DroolsLhsBindVariablesProcessor.getPatternBinds((PsiElement)reference);
        for (PsiVariable psiVariable : patternBinds) {
            if (processor.process((Object)psiVariable)) continue;
            return false;
        }
        return true;
    }

    private static boolean processParameters(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        DroolsFakePsiMethod psiMethod = (DroolsFakePsiMethod)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsFakePsiMethod.class);
        if (psiMethod != null) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (processor.process((Object)psiParameter)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static Set<PsiClass> resolveBindedVariableType(DroolsLhsPattern lhsPattern) {
        DroolsQualifiedIdentifier qi = lhsPattern.getLhsPatternType().getQualifiedIdentifier();
        Set<PsiClass> set = DroolsResolveUtil.resolveQualifiedIdentifier(qi);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "resolveBindedVariableType"));
        }
        return set;
    }

    @NotNull
    public static Set<PsiClass> resolveQualifiedIdentifier(@NotNull DroolsQualifiedIdentifier qi) {
        PsiElement resolve;
        if (qi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qi", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "resolveQualifiedIdentifier"));
        }
        com.intellij.util.containers.hash.HashSet psiClasses = new com.intellij.util.containers.hash.HashSet();
        DroolsReference[] identifiers = (DroolsReference[])PsiTreeUtil.getChildrenOfType((PsiElement)qi, DroolsReference.class);
        if (identifiers != null && (resolve = DroolsResolveUtil.chooseDroolsTypeResult(identifiers[identifiers.length - 1].multiResolve(false))) instanceof PsiClass) {
            psiClasses.add(new DroolsLightClass((PsiClass)resolve));
        }
        com.intellij.util.containers.hash.HashSet hashSet = psiClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "resolveQualifiedIdentifier"));
        }
        return hashSet;
    }

    public static boolean processQualifiedIdentifier(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, @NotNull DroolsReference reference) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processQualifiedIdentifier"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processQualifiedIdentifier"));
        }
        DroolsReference leftReference = DroolsResolveUtil.getLeftReference((PsiElement)reference);
        if (leftReference == null) {
            return DroolsResolveUtil.processSimplePackageOrClass(processor, reference);
        }
        for (ResolveResult result : leftReference.multiResolve(false)) {
            PsiType propertyType;
            PsiElement element = result.getElement();
            if (element instanceof PsiPackage) {
                for (PsiPackage psiPackage : ((PsiPackage)element).getSubPackages()) {
                    if (processor.process((Object)psiPackage)) continue;
                    return false;
                }
                for (PsiPackage psiPackage : ((PsiPackage)element).getClasses()) {
                    if (processor.process((Object)psiPackage)) continue;
                    return false;
                }
                continue;
            }
            if (element instanceof PsiClass) {
                for (PsiPackage psiPackage : ((PsiClass)element).getInnerClasses()) {
                    if (processor.process((Object)psiPackage)) continue;
                    return false;
                }
                DroolsResolveUtil.processClassMembers(processor, Collections.singleton((PsiClass)element), true);
                continue;
            }
            if (!(element instanceof BeanPropertyElement) || !((propertyType = ((BeanPropertyElement)element).getPropertyType()) instanceof PsiClassType)) continue;
            DroolsResolveUtil.processClassMembers(processor, Collections.singleton(((PsiClassType)propertyType).resolve()), false);
        }
        return false;
    }

    private static boolean processSimplePackageOrClass(CommonProcessors.CollectProcessor<PsiElement> processor, DroolsReference reference) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)reference.getProject());
        DroolsFile droolsFile = (DroolsFile)PsiTreeUtil.getParentOfType((PsiElement)reference, DroolsFile.class);
        if (droolsFile != null) {
            DroolsDeclareStatement[] declarations;
            PsiPackage top = facade.findPackage("");
            if (top != null) {
                for (PsiPackage aPackage : top.getSubPackages()) {
                    if (!DroolsResolveUtil.processPackage(processor, aPackage, false)) continue;
                    return false;
                }
            }
            for (PsiPackage aPackage : DroolsResolveUtil.getImportedPackages(droolsFile)) {
                if (!DroolsResolveUtil.processPackage(processor, aPackage)) continue;
                return false;
            }
            if (!DroolsResolveUtil.processImportedClasses(droolsFile, processor)) {
                return false;
            }
            for (DroolsDeclareStatement declaration : declarations = droolsFile.getDeclarations()) {
                DroolsTypeDeclaration typeDeclaration = declaration.getTypeDeclaration();
                if (typeDeclaration == null || processor.process((Object)typeDeclaration)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPackage(CommonProcessors.CollectProcessor<PsiElement> processor, PsiPackage aPackage) {
        return DroolsResolveUtil.processPackage(processor, aPackage, true);
    }

    private static boolean processPackage(CommonProcessors.CollectProcessor<PsiElement> processor, PsiPackage aPackage, boolean processClasses) {
        if (!processor.process((Object)aPackage)) {
            return true;
        }
        if (processClasses) {
            for (PsiClass psiClass : aPackage.getClasses()) {
                if (processor.process((Object)psiClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static DroolsReference getLeftReference(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement sibling = DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(node, true);
        while (sibling != null) {
            if (!".".equals(sibling.getText())) {
                return sibling instanceof DroolsReference && sibling != node ? (DroolsReference)sibling : null;
            }
            sibling = DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(sibling, true);
        }
        return null;
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipWhiteSpaces(@Nullable PsiElement sibling, boolean strictly) {
        return DroolsResolveUtil.getPrevSiblingSkipingCondition(sibling, (Condition<PsiElement>)((Condition)element -> element instanceof PsiWhiteSpace), strictly);
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipingCondition(@Nullable PsiElement sibling, Condition<PsiElement> condition, boolean strictly) {
        PsiElement result;
        if (sibling == null) {
            return null;
        }
        PsiElement psiElement = result = strictly ? sibling.getPrevSibling() : sibling;
        while (result != null && condition.value((Object)result)) {
            result = result.getPrevSibling();
        }
        return result;
    }

    private static boolean processClassMembers(@NotNull CommonProcessors.CollectProcessor<PsiElement> processor, @NotNull Set<PsiClass> psiClasses, boolean isStatic) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processClassMembers"));
        }
        if (psiClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClasses", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processClassMembers"));
        }
        for (PsiClass psiClass : psiClasses) {
            if (psiClass == null) continue;
            if (isStatic) {
                PsiModifierList modifierList;
                for (PsiField psiField : psiClass.getAllFields()) {
                    modifierList = psiField.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("public") || !modifierList.hasModifierProperty("static") || processor.process((Object)psiField)) continue;
                    return false;
                }
                for (PsiField psiField : psiClass.getAllMethods()) {
                    modifierList = psiField.getModifierList();
                    if (!modifierList.hasModifierProperty("public") || !modifierList.hasModifierProperty("static") || processor.process((Object)psiField)) continue;
                    return false;
                }
                continue;
            }
            for (PsiField psiField : psiClass.getAllMethods()) {
                if (processor.process((Object)psiField)) continue;
                return false;
            }
            for (PsiField psiField : psiClass.getAllFields()) {
                if (processor.process((Object)psiField)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Set<PsiClass> getPatternBindType(@NotNull Collection<DroolsLhsPattern> patternBinds) {
        if (patternBinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternBinds", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getPatternBindType"));
        }
        com.intellij.util.containers.hash.HashSet psiClasses = new com.intellij.util.containers.hash.HashSet();
        for (DroolsLhsPattern lhsPattern : patternBinds) {
            psiClasses.addAll(DroolsResolveUtil.resolveBindedVariableType(lhsPattern));
        }
        com.intellij.util.containers.hash.HashSet hashSet = psiClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getPatternBindType"));
        }
        return hashSet;
    }

    @Nullable
    public static PsiClass getModifyStatementType(@NotNull DroolsModifyRhsStatement modifyRhsStatement) {
        if (modifyRhsStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifyRhsStatement", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getModifyStatementType"));
        }
        DroolsExpression expression = (DroolsExpression)ContainerUtil.getFirstItem(modifyRhsStatement.getExpressionList());
        final Ref ref = new Ref(null);
        if (expression instanceof DroolsParExpr) {
            expression.acceptChildren(new DroolsVisitor(){

                @Override
                public void visitPrimaryExpr(@NotNull DroolsPrimaryExpr droolsPrimary) {
                    if (droolsPrimary == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsPrimary", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil$1", "visitPrimaryExpr"));
                    }
                    ref.set((Object)DroolsResolveUtil.getPrimaryExprType(droolsPrimary));
                }

                @Override
                public void visitPsiCompositeElement(@NotNull DroolsPsiCompositeElement o) {
                    if (o == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil$1", "visitPsiCompositeElement"));
                    }
                    o.acceptChildren(this);
                }
            });
        }
        return (PsiClass)ref.get();
    }

    @Nullable
    private static PsiClass getPrimaryExprType(@NotNull DroolsPrimaryExpr droolsPrimary) {
        if (droolsPrimary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsPrimary", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getPrimaryExprType"));
        }
        DroolsReference[] references = (DroolsReference[])PsiTreeUtil.getChildrenOfType((PsiElement)droolsPrimary, DroolsReference.class);
        if (references != null && references.length > 0) {
            DroolsReference reference = references[references.length - 1];
            String textToResolve = reference.getText();
            MyReferenceResolvePsiElementProcessor processor = new MyReferenceResolvePsiElementProcessor(textToResolve);
            DroolsResolveUtil.processConstrains(processor, reference);
            DroolsResolveUtil.processPatternBinds(processor, reference);
            for (PsiElement resolve : processor.getResults()) {
                PsiType type;
                if (!(resolve instanceof PsiVariable) || !((type = ((PsiVariable)resolve).getType()) instanceof PsiClassType)) continue;
                return ((PsiClassType)type).resolve();
            }
        }
        return null;
    }

    @Nullable
    public static PsiType resolveType(@Nullable DroolsType droolsType) {
        if (droolsType != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)droolsType.getProject());
            PsiType psiType = elementFactory.createTypeFromText(droolsType.getText(), (PsiElement)droolsType);
            if (psiType instanceof PsiPrimitiveType) {
                return psiType;
            }
            if (psiType instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)psiType).resolve();
                if (psiClass != null) {
                    return elementFactory.createType((PsiClass)new DroolsLightClass(psiClass));
                }
            } else {
                List<DroolsIdentifier> identifierList = droolsType.getIdentifierList();
                DroolsIdentifier identifier = identifierList.get(identifierList.size() - 1);
                PsiElement resolve = identifier.resolve();
                if (resolve instanceof PsiClass) {
                    return elementFactory.createType((PsiClass)new DroolsLightClass((PsiClass)resolve));
                }
            }
        }
        return null;
    }

    public static Set<PsiPackage> getImportedPackages(@NotNull DroolsFile droolsFile) {
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getImportedPackages"));
        }
        return DroolsResolveUtil.getImportedPackages(droolsFile, true);
    }

    public static Set<PsiPackage> getImportedPackages(@NotNull DroolsFile droolsFile, boolean addDefaultPackages) {
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getImportedPackages"));
        }
        com.intellij.util.containers.hash.HashSet imported = new com.intellij.util.containers.hash.HashSet();
        if (addDefaultPackages) {
            imported.addAll(DroolsResolveUtil.getDefaultPackages(droolsFile));
        }
        imported.addAll(DroolsResolveUtil.getExplicitlyImportedPackages(droolsFile));
        return imported;
    }

    @NotNull
    public static Set<PsiPackage> getExplicitlyImportedPackages(DroolsFile droolsFile) {
        com.intellij.util.containers.hash.HashSet imported = new com.intellij.util.containers.hash.HashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)droolsFile.getProject());
        for (DroolsImport droolsImport : droolsFile.getImports()) {
            String importedPackage = droolsImport.getImportedPackage();
            if (importedPackage == null) continue;
            DroolsResolveUtil.addNotNull((Set<PsiPackage>)imported, facade.findPackage(importedPackage));
        }
        com.intellij.util.containers.hash.HashSet hashSet = imported;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getExplicitlyImportedPackages"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiPackage> getDefaultPackages(DroolsFile droolsFile) {
        String packageName;
        com.intellij.util.containers.hash.HashSet imported = new com.intellij.util.containers.hash.HashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)droolsFile.getProject());
        DroolsResolveUtil.addNotNull((Set<PsiPackage>)imported, facade.findPackage("java.lang"));
        DroolsPackageStatement packageStatement = droolsFile.getPackage();
        if (packageStatement != null && !StringUtil.isEmptyOrSpaces((String)(packageName = packageStatement.getNamespace().getText()))) {
            DroolsResolveUtil.addNotNull((Set<PsiPackage>)imported, facade.findPackage(packageName));
        }
        com.intellij.util.containers.hash.HashSet hashSet = imported;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getDefaultPackages"));
        }
        return hashSet;
    }

    private static void addNotNull(@NotNull Set<PsiPackage> imported, @Nullable PsiPackage currentPackage) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "addNotNull"));
        }
        if (currentPackage != null) {
            imported.add(currentPackage);
        }
    }

    @NotNull
    public static Set<PsiVariable> getVariables(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getVariables"));
        }
        com.intellij.util.containers.hash.HashSet variables = new com.intellij.util.containers.hash.HashSet();
        PsiFile file = place.getContainingFile();
        if (file instanceof DroolsFile) {
            variables.addAll(Arrays.asList(((DroolsFile)file).getGlobalVariables()));
        }
        variables.addAll(DroolsLhsBindVariablesProcessor.getPatternBinds(place));
        variables.addAll(DroolsResolveUtil.getLocalVariables(place));
        com.intellij.util.containers.hash.HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getVariables"));
        }
        return hashSet;
    }

    public static List<PsiClass> getExplicitlyImportedClasses(@NotNull DroolsFile droolsFile) {
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "getExplicitlyImportedClasses"));
        }
        com.intellij.util.containers.hash.HashSet imported = new com.intellij.util.containers.hash.HashSet();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor((Collection)imported);
        for (PsiPackage aPackage : DroolsResolveUtil.getImportedPackages(droolsFile, false)) {
            for (PsiClass psiClass : aPackage.getClasses()) {
                processor.process((Object)psiClass);
            }
        }
        DroolsResolveUtil.processImportedClasses(droolsFile, (Processor<PsiElement>)processor);
        return ContainerUtil.mapNotNull((Collection)imported, psiElement -> psiElement instanceof PsiClass ? (PsiClass)psiElement : null);
    }

    public static boolean processImportedClasses(@NotNull DroolsFile droolsFile, @NotNull Processor<PsiElement> processor) {
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processImportedClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/DroolsResolveUtil", "processImportedClasses"));
        }
        DroolsImport[] imports = droolsFile.getImports();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)droolsFile.getProject());
        for (DroolsImport droolsImport : imports) {
            PsiClass psiClass;
            String className = droolsImport.getImportedClassName();
            if (className == null || (psiClass = facade.findClass(className, GlobalSearchScope.allScope((Project)droolsFile.getProject()))) == null || processor.process((Object)psiClass)) continue;
            return false;
        }
        return true;
    }

    public static PsiElement chooseDroolsTypeResult(ResolveResult[] resolveResults) {
        PsiElement resultElement = null;
        for (ResolveResult result : resolveResults) {
            if (!result.isValidResult()) continue;
            PsiElement element = result.getElement();
            if (resultElement == null) {
                resultElement = element;
                continue;
            }
            if (!(element instanceof PsiClass) || !(resultElement instanceof DroolsTypeDeclaration) || !((PsiClass)element).getName().equals(((DroolsTypeDeclaration)resultElement).getName())) continue;
            resultElement = element;
        }
        return resultElement;
    }

    private static class MyReferenceResolvePsiElementProcessor
    extends CommonProcessors.CollectProcessor<PsiElement> {
        private final String myTextToResolve;

        public MyReferenceResolvePsiElementProcessor(String textToResolve) {
            super((Collection)new com.intellij.util.containers.hash.HashSet());
            this.myTextToResolve = textToResolve;
        }

        public boolean accept(PsiElement psiElement) {
            if (psiElement instanceof PsiPackage) {
                return this.myTextToResolve.equals(((PsiPackage)psiElement).getName());
            }
            if (psiElement instanceof PsiClass) {
                return this.myTextToResolve.equals(((PsiClass)psiElement).getName());
            }
            if (psiElement instanceof PsiField) {
                return this.myTextToResolve.equals(((PsiField)psiElement).getName());
            }
            if (psiElement instanceof PsiMethod) {
                return this.myTextToResolve.equals(((PsiMethod)psiElement).getName());
            }
            if (psiElement instanceof PsiVariable) {
                return this.myTextToResolve.equals(((PsiVariable)psiElement).getName());
            }
            return false;
        }

        public boolean process(PsiElement psiElement) {
            PsiField psiField;
            if (psiElement instanceof PsiMethod) {
                BeanProperty property;
                PsiMethod psiMethod = (PsiMethod)psiElement;
                if (this.myTextToResolve.equals(psiMethod.getName())) {
                    this.getResults().add(psiMethod);
                } else if (!(psiMethod instanceof DroolsPsiClassImpl.GeneratedLightMethod) && PropertyUtil.isSimplePropertyGetter((PsiMethod)psiMethod) && (property = BeanProperty.createBeanProperty((PsiMethod)psiMethod)) != null && this.myTextToResolve.equals(property.getName())) {
                    this.getResults().add(property.getPsiElement());
                }
            } else if (psiElement instanceof PsiField && this.myTextToResolve.equals((psiField = (PsiField)psiElement).getName())) {
                this.getResults().add(psiField);
            }
            return super.process((Object)psiElement);
        }
    }
}

