/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.drools.DroolsFileType;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsField;
import com.intellij.plugins.drools.lang.psi.DroolsFieldName;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsIdentifier;
import com.intellij.plugins.drools.lang.psi.DroolsImport;
import com.intellij.plugins.drools.lang.psi.DroolsNameId;
import com.intellij.plugins.drools.lang.psi.DroolsStringId;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.DroolsTypeName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsElementsFactory {
    @Nullable
    public static DroolsNameId createPatternBindIdentifier(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createPatternBindIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createPatternBindIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("rule foo when " + name + ": Foo() then aaa"));
        PsiElement deepestElement = psiFile.findElementAt(15);
        if (deepestElement != null && deepestElement.getParent() instanceof DroolsNameId) {
            return (DroolsNameId)deepestElement.getParent();
        }
        return null;
    }

    @Nullable
    public static DroolsTypeName createDeclaredTypeNameIdentifier(@NotNull String name, @NotNull Project project) {
        DroolsTypeDeclaration typeDeclaration;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDeclaredTypeNameIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDeclaredTypeNameIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("declare " + name + " end"));
        DroolsDeclareStatement[] declarations = psiFile.getDeclarations();
        if (declarations.length == 1 && (typeDeclaration = declarations[0].getTypeDeclaration()) != null) {
            return typeDeclaration.getTypeName();
        }
        return null;
    }

    @Nullable
    public static DroolsFieldName createFieldNameIdentifier(@NotNull String name, @NotNull Project project) {
        List<DroolsField> fields;
        DroolsTypeDeclaration typeDeclaration;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createFieldNameIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createFieldNameIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("declare Foo " + name + " : int end"));
        DroolsDeclareStatement[] declarations = psiFile.getDeclarations();
        if (declarations.length == 1 && (typeDeclaration = declarations[0].getTypeDeclaration()) != null && (fields = typeDeclaration.getFieldList()).size() == 1) {
            return fields.get(0).getFieldName();
        }
        return null;
    }

    @Nullable
    public static DroolsNameId createFunctionNameIdentifier(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createFunctionNameIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createFunctionNameIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("function void " + name + "(){}"));
        PsiElement deepestElement = psiFile.findElementAt(15);
        if (deepestElement != null && deepestElement.getParent() instanceof DroolsNameId) {
            return (DroolsNameId)deepestElement.getParent();
        }
        return null;
    }

    @Nullable
    public static DroolsStringId createQueryNameIdentifier(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createQueryNameIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createQueryNameIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("query " + name + " end"));
        return psiFile.getQueries()[0].getStringId();
    }

    @Nullable
    public static DroolsIdentifier createDroolsIdentifier(@NotNull String name, @NotNull Project project) {
        PsiElement element;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDroolsIdentifier"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDroolsIdentifier"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("import " + name));
        PsiElement deepestElement = psiFile.findElementAt(8);
        if (deepestElement != null && (element = deepestElement.getParent()) instanceof DroolsIdentifier) {
            return (DroolsIdentifier)element;
        }
        return null;
    }

    @Nullable
    public static DroolsImport createDroolsImport(@NotNull String className, @NotNull Project project) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDroolsImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/drools/lang/psi/util/DroolsElementsFactory", "createDroolsImport"));
        }
        DroolsFile psiFile = (DroolsFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.drl", (FileType)DroolsFileType.DROOLS_FILE_TYPE, (CharSequence)("import " + className + ";"));
        DroolsImport[] imports = psiFile.getImports();
        if (imports.length == 1) {
            return imports[0];
        }
        return null;
    }
}

