/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.plugins.drools.lang.lexer.DroolsFlexLexer;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypeSets;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class DroolsLexer
extends LookAheadLexer {
    public DroolsLexer() {
        super((Lexer)new DroolsFlexLexer());
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (DroolsTokenTypeSets.CHUNK_START_TOKENS.contains(tokenType)) {
            this.processCodeChunks(baseLexer);
        } else if (DroolsTokenTypeSets.BLOCK_START_TOKENS.contains(tokenType)) {
            this.processBlockExpressions(baseLexer);
        } else if (tokenType == DroolsTokenTypes.THEN) {
            this.advanceLexer(baseLexer);
            this.processRhsStatements(baseLexer);
        } else {
            super.lookAhead(baseLexer);
        }
    }

    private void processRhsStatements(Lexer baseLexer) {
        IElementType currentTokenType;
        this.addAllTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, DroolsTokenTypes.SEMICOLON}));
        if (baseLexer.getTokenType() == DroolsTokenTypes.LBRACKET) {
            this.advanceLexer(baseLexer);
            if (this.skipTokensWithBraces(baseLexer, DroolsTokenTypes.LBRACKET, DroolsTokenTypes.RBRACKET, true)) {
                this.advanceLexer(baseLexer);
                return;
            }
        }
        if ((currentTokenType = baseLexer.getTokenType()) == null) {
            return;
        }
        if (currentTokenType == DroolsTokenTypes.END) {
            this.advanceLexer(baseLexer);
            return;
        }
        TokenSet modifyTokenSet = TokenSet.create((IElementType[])new IElementType[]{DroolsTokenTypes.MODIFY, DroolsTokenTypes.RETRACT, DroolsTokenTypes.UPDATE, DroolsTokenTypes.INSERT_LOGICAL, DroolsTokenTypes.INSERT});
        if (modifyTokenSet.contains(currentTokenType)) {
            this.processModifyStatement(baseLexer);
        } else if (baseLexer.getTokenType() == DroolsTokenTypeSets.SINGLE_LINE_COMMENT_DEPR) {
            this.advanceLexer(baseLexer);
        } else if (currentTokenType == DroolsTokenTypes.THEN) {
            this.advanceLexer(baseLexer);
            this.processRhsStatements(baseLexer);
        } else {
            TokenSet interruptSet = TokenSet.create((IElementType[])new IElementType[]{DroolsTokenTypes.THEN, DroolsTokenTypes.END, DroolsTokenTypes.MODIFY, DroolsTokenTypes.RETRACT, DroolsTokenTypes.UPDATE, DroolsTokenTypes.INSERT_LOGICAL, DroolsTokenTypes.INSERT, DroolsTokenTypeSets.SINGLE_LINE_COMMENT_DEPR});
            if (DroolsLexer.skipTokens(baseLexer, interruptSet)) {
                IElementType nextTokenType = baseLexer.getTokenType();
                if (nextTokenType == null) {
                    this.advanceAs(baseLexer, TokenType.BAD_CHARACTER);
                } else {
                    this.addToken(baseLexer.getTokenStart(), DroolsTokenTypes.JAVA_STATEMENT);
                }
            }
        }
        this.processRhsStatements(baseLexer);
    }

    private void processModifyStatement(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == DroolsTokenTypes.RETRACT || tokenType == DroolsTokenTypes.UPDATE || tokenType == DroolsTokenTypes.INSERT || tokenType == DroolsTokenTypes.INSERT_LOGICAL) {
            this.advanceLexer(baseLexer);
            this.addWhiteSpaces(baseLexer);
            if (baseLexer.getTokenType() == DroolsTokenTypes.LPAREN) {
                this.advanceLexer(baseLexer);
                if (this.skipTokensWithBraces(baseLexer, DroolsTokenTypes.LPAREN, DroolsTokenTypes.RPAREN, true)) {
                    this.advanceLexer(baseLexer);
                    return;
                }
            }
        } else if (tokenType == DroolsTokenTypes.MODIFY) {
            this.advanceLexer(baseLexer);
            this.addWhiteSpaces(baseLexer);
            while (baseLexer.getTokenType() != null) {
                this.advanceLexer(baseLexer);
                if (DroolsTokenTypes.LBRACE != baseLexer.getTokenType()) continue;
                this.advanceLexer(baseLexer);
                if (DroolsTokenTypes.RBRACE == baseLexer.getTokenType() || this.skipTokensWithBraces(baseLexer, DroolsTokenTypes.LBRACE, DroolsTokenTypes.RBRACE, true)) {
                    this.advanceLexer(baseLexer);
                }
                return;
            }
        }
        super.lookAhead(baseLexer);
    }

    private void processCodeChunks(Lexer baseLexer) {
        if (baseLexer.getTokenType() == DroolsTokenTypes.OP_AT) {
            this.advanceLexer(baseLexer);
            if (baseLexer.getTokenType() == DroolsTokenTypes.JAVA_IDENTIFIER) {
                this.processChunkBlock(baseLexer);
            }
        } else {
            this.processChunkBlock(baseLexer);
        }
    }

    private void processChunkBlock(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.addWhiteSpaces(baseLexer);
        if (baseLexer.getTokenType() == DroolsTokenTypes.LPAREN) {
            this.advanceLexer(baseLexer);
            if (this.skipTokensWithBraces(baseLexer, DroolsTokenTypes.LPAREN, DroolsTokenTypes.RPAREN)) {
                this.addToken(baseLexer.getTokenStart(), DroolsTokenTypes.CHUNK_BLOCK);
                this.advanceLexer(baseLexer);
            }
        } else {
            super.lookAhead(baseLexer);
        }
    }

    private void processBlockExpressions(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        while (true) {
            IElementType tokenType;
            if ((tokenType = baseLexer.getTokenType()) == null) {
                this.advanceLexer(baseLexer);
                break;
            }
            if (DroolsTokenTypes.LBRACE == tokenType) {
                LexerPosition currentPosition = baseLexer.getCurrentPosition();
                baseLexer.advance();
                if (this.skipTokensWithBraces(baseLexer, DroolsTokenTypes.LBRACE, DroolsTokenTypes.RBRACE) || baseLexer.getTokenType() == DroolsTokenTypes.RBRACE) {
                    this.advanceAs(baseLexer, DroolsTokenTypes.BLOCK_EXPRESSION);
                    break;
                }
                baseLexer.restore(currentPosition);
                this.advanceLexer(baseLexer);
                break;
            }
            this.advanceLexer(baseLexer);
        }
    }

    private void addWhiteSpaces(Lexer baseLexer) {
        this.addAllTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE}));
    }

    private void addAllTokens(Lexer baseLexer, TokenSet set) {
        while (set.contains(baseLexer.getTokenType())) {
            this.advanceLexer(baseLexer);
        }
    }

    protected static boolean currentOrSkipTokens(Lexer baseLexer, TokenSet until) {
        return until.contains(baseLexer.getTokenType()) || DroolsLexer.skipTokens(baseLexer, until);
    }

    protected static boolean skipTokens(Lexer baseLexer, TokenSet until) {
        boolean skipped = false;
        IElementType tokenType;
        while ((tokenType = baseLexer.getTokenType()) != null && !until.contains(tokenType)) {
            skipped = true;
            baseLexer.advance();
        }
        return skipped;
    }

    protected boolean skipTokensWithBraces(Lexer baseLexer, IElementType lBrace, IElementType rBrace) {
        return this.skipTokensWithBraces(baseLexer, lBrace, rBrace, false);
    }

    protected boolean skipTokensWithBraces(Lexer baseLexer, IElementType lBrace, IElementType rBrace, boolean addSkippedTokens) {
        boolean skipped = false;
        TokenSet until = TokenSet.create((IElementType[])new IElementType[]{lBrace, rBrace});
        int lBraces = 0;
        IElementType tokenType;
        while ((tokenType = baseLexer.getTokenType()) != null) {
            if (until.contains(tokenType)) {
                if (baseLexer.getTokenType() == lBrace) {
                    ++lBraces;
                } else {
                    if (lBraces == 0) {
                        return skipped;
                    }
                    --lBraces;
                }
            }
            skipped = true;
            if (addSkippedTokens) {
                this.advanceLexer(baseLexer);
                continue;
            }
            baseLexer.advance();
        }
        return skipped;
    }
}

