/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.drools.DroolsBundle;
import com.intellij.plugins.drools.DroolsLanguage;
import com.intellij.plugins.drools.lang.support.DroolsEditorHighlighter;
import icons.DroolsIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsFileType
extends LanguageFileType {
    public static final DroolsFileType DROOLS_FILE_TYPE = new DroolsFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "drl";

    private DroolsFileType() {
        super((Language)DroolsLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/plugins/drools/DroolsFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/plugins/drools/DroolsFileType$1", "getEditorHighlighter"));
                }
                return new DroolsEditorHighlighter(project, virtualFile, colors);
            }
        });
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = DroolsBundle.message("drools.file.type.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/DroolsFileType", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getDescription() {
        String string = DroolsBundle.message("drools.file.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/DroolsFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/DroolsFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return DroolsIcons.Drools_16;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/drools/DroolsFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/plugins/drools/DroolsFileType", "getCharset"));
        }
        return "UTF-8";
    }
}

