/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.ClassNameFilter;

class IncludeClassNameFilter
implements ClassNameFilter {
    private final List<Pattern> patterns;
    private final String patternDescription;

    IncludeClassNameFilter(String ... patterns) {
        Preconditions.notEmpty((Object[])patterns, (String)"patterns must not be null or empty");
        Preconditions.containsNoNullElements((Object[])patterns, (String)"patterns must not contain null elements");
        this.patterns = Arrays.stream(patterns).map(Pattern::compile).collect(Collectors.toList());
        this.patternDescription = Arrays.stream(patterns).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.included(this.formatInclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(className)));
    }

    private String formatExclusionReason(String className) {
        return String.format("Class name [%s] does not match any included pattern: %s", className, this.patternDescription);
    }

    private String formatInclusionReason(String className, Pattern pattern) {
        return String.format("Class name [%s] matches included pattern: '%s'", className, pattern);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isPresent();
    }

    private Optional<Pattern> findMatchingPattern(String className) {
        return this.patterns.stream().filter(pattern -> pattern.matcher(className).matches()).findAny();
    }

    public String toString() {
        return "Includes class names that match regular expression " + this.patternDescription;
    }
}

