/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Functions;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.indexing.FxmlDataExternalizer;
import org.jetbrains.plugins.javaFX.indexing.FxmlDataIndexer;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;
import org.jetbrains.plugins.javaFX.indexing.JavaFxCustomComponentsIndex;
import org.xml.sax.SAXException;

public class JavaFxStylesheetsIndex
extends FileBasedIndexExtension<String, Set<String>> {
    @NonNls
    public static final ID<String, Set<String>> KEY = ID.create((String)"javafx.stylesheets.name");
    private final FileBasedIndex.InputFilter myInputFilter = new JavaFxControllerClassIndex.MyInputFilter();
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final FxmlDataExternalizer myDataExternalizer = new FxmlDataExternalizer();

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        FxmlDataExternalizer fxmlDataExternalizer = this.myDataExternalizer;
        if (fxmlDataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getValueExternalizer"));
        }
        return fxmlDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = KEY;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 5;
    }

    public static boolean isUsedInFxml(@NotNull Project project, @NotNull PsiFile stylesheetFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "isUsedInFxml"));
        }
        if (stylesheetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetFile", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "isUsedInFxml"));
        }
        try {
            Ref refFound = new Ref((Object)false);
            FileBasedIndex.getInstance().processValues(KEY, (Object)stylesheetFile.getName(), null, (file, value) -> {
                refFound.set((Object)true);
                return false;
            }, GlobalSearchScope.projectScope((Project)project));
            return (Boolean)refFound.get();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @NotNull
    public static Set<VirtualFile> getFxmls(@NotNull Project project, @NotNull PsiFile stylesheetFile) {
        Collection<Object> files;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getFxmls"));
        }
        if (stylesheetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetFile", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getFxmls"));
        }
        try {
            files = FileBasedIndex.getInstance().getContainingFiles(KEY, (Object)stylesheetFile.getName(), GlobalSearchScope.projectScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            files = Collections.emptyList();
        }
        Set<VirtualFile> set = JavaFxStylesheetsIndex.collectCustomFxmls(project, stylesheetFile, files);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "getFxmls"));
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> collectCustomFxmls(Project project, PsiFile stylesheetFile, Collection<VirtualFile> files) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        result.addAll(files);
        VirtualFile vStylesheet = PsiUtilCore.getVirtualFile((PsiElement)stylesheetFile);
        if (vStylesheet == null) {
            HashSet<VirtualFile> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "collectCustomFxmls"));
            }
            return hashSet;
        }
        final LinkedHashSet customs = new LinkedHashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile virtualFile : files) {
            PsiFile xmlFile;
            if (virtualFile == null || (xmlFile = psiManager.findFile(virtualFile)) == null) continue;
            final GlobalSearchScope resolveScope = stylesheetFile.getResolveScope();
            xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    List customFxml;
                    String qualifiedName;
                    PsiElement declaration;
                    super.visitXmlTag(tag);
                    XmlElementDescriptor descriptor = tag.getDescriptor();
                    if (descriptor != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass && (qualifiedName = ((PsiClass)declaration).getQualifiedName()) != null && (customFxml = JavaFxCustomComponentsIndex.findCustomFxml(declaration.getProject(), qualifiedName, Functions.id(), resolveScope)) != null) {
                        customs.addAll(customFxml);
                    }
                }
            });
        }
        result.addAll(customs);
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxStylesheetsIndex", "collectCustomFxmls"));
        }
        return hashSet;
    }

    private static class MyDataIndexer
    extends FxmlDataIndexer {
        private MyDataIndexer() {
        }

        @Override
        protected void endDocument(String path, VirtualFile sourceRoot, Map<String, Set<String>> map, IXMLBuilder handler) {
            String parent = new File(path).getParent();
            for (String stylesheet : map.keySet()) {
                Set<String> paths = map.get(stylesheet);
                for (String include : ((MyParseHandler)handler).myIncludes) {
                    String includedPath = sourceRoot != null && include.startsWith("/") ? sourceRoot.getPath() + include : new File(parent, include).getPath();
                    paths.add(FileUtil.toSystemIndependentName((String)includedPath));
                }
            }
        }

        @Override
        protected IXMLBuilder createParseHandler(String path, Map<String, Set<String>> map) {
            return new MyParseHandler(map, path);
        }

        private static class MyParseHandler
        extends NanoXmlUtil.IXMLBuilderAdapter {
            private final Map<String, Set<String>> myMap;
            private final Set<String> myIncludes = new HashSet<String>();
            private final String myPath;
            private boolean myParentStylesheets = false;
            private String myAttributeName = null;

            public MyParseHandler(Map<String, Set<String>> map, String path) {
                this.myMap = map;
                this.myPath = path;
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (value != null) {
                    if ("stylesheets".equals(key)) {
                        this.registerStylesheet(value);
                    } else if (this.myAttributeName != null) {
                        if (this.myAttributeName.equals(key)) {
                            if (this.myAttributeName.equals("source")) {
                                this.myIncludes.add(value);
                            } else if (this.myAttributeName.equals("value")) {
                                this.registerStylesheet(StringUtil.trimStart((String)value, (String)"@"));
                            }
                        } else if (this.myAttributeName.equals(MyParseHandler.compoundQName(key, nsPrefix)) && this.myAttributeName.equals("fx:value")) {
                            this.registerStylesheet(value);
                        }
                    }
                }
            }

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.myAttributeName = null;
                if (this.myParentStylesheets) {
                    if ("java.lang.String".equals(name) || "String".equals(name)) {
                        this.myAttributeName = "fx:value";
                    } else if ("URL".equals(name) || "java.net.URL".equals(name)) {
                        this.myAttributeName = "value";
                    }
                }
                if ("fx:include".equals(MyParseHandler.compoundQName(name, nsPrefix))) {
                    this.myAttributeName = "source";
                }
                this.myParentStylesheets |= "stylesheets".equals(name);
            }

            private static String compoundQName(String name, String nsPrefix) {
                return nsPrefix + ":" + name;
            }

            private void registerStylesheet(String attributesValue) {
                if (attributesValue != null) {
                    Set<String> paths = this.myMap.get(attributesValue);
                    if (paths == null) {
                        paths = new HashSet<String>();
                        this.myMap.put(StringUtil.getShortName((String)attributesValue, (char)'/'), paths);
                    }
                    paths.add(this.myPath);
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("stylesheets".equals(qName)) {
                    this.myParentStylesheets = false;
                }
            }
        }
    }
}

