var csInterface = new CSInterface();
var resourceBundle = undefined;

//Stop right click.
document.addEventListener("contextmenu", function (e) {
    e.preventDefault();
}, false);
//stop all drag drop support.
document.addEventListener("dragstart", function (e) {
    e.preventDefault();
}, false);

document.addEventListener("dragend", function (e) {
    e.preventDefault();
}, false);

document.addEventListener("dragover", function (e) {
    e.preventDefault();
}, false);

document.addEventListener("dragenter", function (e) {
    e.preventDefault();
}, false);

document.addEventListener("dragleave", function (e) {
    e.preventDefault();
}, false);
document.addEventListener("drop", function (e) {
    e.preventDefault();
}, false);

var localize = function(key, resourceBundle) {
	var localizedStr = resourceBundle[key];
	if (localizedStr) {
		var index = 1;
		while (localizedStr.indexOf("$" + index) !== -1) {
			localizedStr = localizedStr.replace("$" + index, arguments[index]);
			index++;
    	}
    	return localizedStr;
  	} else {
    	return '';
  	}
};

function workspaceOnboardingEvtHandler(event) {
    var data = event.data;

    if(data.preferencesPresent) {
        $('#skipText').hide();
        $('#workspaceText').show();
        $('.checkBox').hide();
    }
    else {
        $('#skipText').show();
        $('#workspaceText').hide();
    }

    $("#main").slick({
        dots: true,
        infinite: false
    });

    $('#main').on('beforeChange', function(event, slick, currentSlide,nextSlide){
        if(slick.$slides.length == nextSlide + 1) {
            $('#gotItBtn').attr('disabled', false);
            $('#skipText').css({'visibility' : 'hidden'});
            $('.checkBox').css({'visibility' : 'hidden'}) ;
        }
    });
}

function SendEvent(data, type) {
    var rsp_event = new CSEvent("com.adobe.WorkspaceBasicsFTUEEvent", "APPLICATION");
    var jsonObj = {
        "Data": data,
        "type": type
    };
    rsp_event.data = JSON.stringify(jsonObj);
    rsp_event.extensionId = csInterface.getExtensionID();
    csInterface.dispatchEvent(rsp_event);
}

function skipTourClickHandler() {
    var showOnNextLaunch = $('#nextLaunchCheckBox').is(':checked');
    SendEvent({ 'showOnNextLaunch': showOnNextLaunch }, 'FTUERemindMeLaterEvent');
    window.__adobe_cep__.closeExtension();
}

function gotItClickHandler() {
    SendEvent('', 'FTUEGotItEvent');
    window.__adobe_cep__.closeExtension();
}

function previousWorkspaceClickHandler() {
    SendEvent('', 'FTUESwitchToDefaultWorkspaceEvent');
    window.__adobe_cep__.closeExtension();
}

function onLoaded() {
	resourceBundle = csInterface.initResourceBundle();
    csInterface.addEventListener('com.adobe.WorkspaceBasicsSendUserDataEvent', workspaceOnboardingEvtHandler);
    SendEvent('', 'FTUELoadEvent');
};