/*	For all the strings that are being used in the document a key - value pair
	has been created in the InDesign code. So in order to get string from Indesign
	the function "GetTranslatedString(key)" function is used, provide it with the key
	and it will return the translated string for it. So the string initialisation
	is being done on document load in "OnLoaded" function.

	Just for the sake of reference all the strings used in the document are listed
	below in key - value pair format :-

	"TWSHelpGesturesHelp",					"Gestures Help",
	"TWSHelpViewAllGestures",				"View All Gestures",
	"TWSHelpBack",							"Back",
	"TWSHelpGetStarted",					"Get Started",
	"TWSHelpNewDrawingTool",				"New Drawing Tool",
	"TWSHelpWelcomeToTWS",					"Welcome to the <span class=\"bold\">InDesign Touch Workspace</span>",
	"TWSHelpWelcomeGreeting",				"Create your layouts using touch gestures,</br>InDesign will convert your gestures into crisp graphics.",
	"TWSHelpDrawingGestures",				"Drawing Gestures",
	"TWSHelpGestureBelowHeading",			"Tap on any gesture below to see how it works.",
	"TWSHelpGestureHeading",				"Tap on the gesture to see how it works.",
	"TWSHelpRectangleGesture",				"Rectangle",
	"TWSHelpCircleGesture",					"Circle",
	"TWSHelpRoundedRectangleGesture",		"Rounded Rectangle",
	"TWSHelpChamferedRectangleGesture",		"Chamfered Rectangle",
	"TWSHelpImageGesture",					"Image",
	"TWSHelpRoundedImageGesture",			"Rounded Image",
	"TWSHelpCircularImageGesture",			"Circular Image",
	"TWSHelpTriangleGesture",				"Triangle",
	"TWSHelpCornerGesture",					"Corner",
	"TWSHelpPolygonGesture",				"Polygon",
	"TWSHelpLineGesture",					"Line",
	"TWSHelpHeadlineGesture",				"Headline",
	"TWSHelpMultilineGesture",				"Multiline",
	"TWSHelpParagraphGesture",				"Paragraph",
	"TWSHelpEraseGesture",					"Erase",
	"TWSHelpFileMenu",						"File",
	"TWSHelpSave",							"Save",
	"TWSHelpDocumentName",					"Untitled-1",
*/

$.extend({
      getUrlVars: function(){
        var vars = [], hash;
        var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
        for(var i = 0; i < hashes.length; i++)
        {
          hash = hashes[i].split('=');
          vars.push(hash[0]);
          vars[hash[0]] = hash[1];
        }
        return vars;
      },
      getUrlVar: function(name){
        return $.getUrlVars()[name];
      }
    });

	
function OnLoaded()
{
	var obj = window.touchHelp;

	// String initialization
	if(obj)
	{
	    $("#text-more-gestures").text(obj.hostAppGetTranslatedString("TWSHelpGesturesHelp"));
	    $(".button-text-gestures").text(obj.hostAppGetTranslatedString("TWSHelpViewAllGestures"));
	    $(".button-text-back").text(obj.hostAppGetTranslatedString("TWSHelpBack"));
	    $(".button-text-get-started").text(obj.hostAppGetTranslatedString("TWSHelpGetStarted"));
	    $("#text-drawing-tool").text(obj.hostAppGetTranslatedString("TWSHelpNewDrawingTool"));
	    $(".overview-heading").html(obj.hostAppGetTranslatedString("TWSHelpWelcomeToTWS"));
	    $(".gesture-heading").html(obj.hostAppGetTranslatedString("TWSHelpWelcomeGreeting"));
	    $(".gesture-heading2").text(obj.hostAppGetTranslatedString("TWSHelpDrawingGestures"));
	    $(".text-overview-page-gesture-below-info").text(obj.hostAppGetTranslatedString("TWSHelpGestureBelowHeading"));
	    $(".text-overview-page-gesture-info").text(obj.hostAppGetTranslatedString("TWSHelpGestureHeading"));
	    $(".text-square").text(obj.hostAppGetTranslatedString("TWSHelpRectangleGesture"));
	    $(".text-circle").text(obj.hostAppGetTranslatedString("TWSHelpCircleGesture"));
	    $(".text-rounded-rectangle").text(obj.hostAppGetTranslatedString("TWSHelpRoundedRectangleGesture"));
	    $(".text-chamfered-rectangle").text(obj.hostAppGetTranslatedString("TWSHelpChamferedRectangleGesture"));
	    $(".text-image").text(obj.hostAppGetTranslatedString("TWSHelpImageGesture"));
	    $(".text-rounded-image").text(obj.hostAppGetTranslatedString("TWSHelpRoundedImageGesture"));
	    $(".text-circular-image").text(obj.hostAppGetTranslatedString("TWSHelpCircularImageGesture"));
	    $(".text-triangle").text(obj.hostAppGetTranslatedString("TWSHelpTriangleGesture"));
	    $(".text-corner").text(obj.hostAppGetTranslatedString("TWSHelpCornerGesture"));
	    $(".text-polygon").text(obj.hostAppGetTranslatedString("TWSHelpPolygonGesture"));
	    $(".text-line").text(obj.hostAppGetTranslatedString("TWSHelpLineGesture"));
	    $(".text-headline").text(obj.hostAppGetTranslatedString("TWSHelpHeadlineGesture"));
	    $(".text-multiline").text(obj.hostAppGetTranslatedString("TWSHelpMultilineGesture"));
	    $(".text-paragraph").text(obj.hostAppGetTranslatedString("TWSHelpParagraphGesture"));
		$(".text-erase").text(obj.hostAppGetTranslatedString("TWSHelpEraseGesture"));
		$("#text-file-menu").text(obj.hostAppGetTranslatedString("TWSHelpFileMenu"));
		$("#text-save-menu").text(obj.hostAppGetTranslatedString("TWSHelpSave"));
		$("#text-docname-menu").text(obj.hostAppGetTranslatedString("TWSHelpDocumentName"));
	}
	else {
		$("#text-more-gestures").text("Gestures Help");
		$(".button-text-gestures").text("View All Gestures");
		$(".button-text-back").text("Back");
		$(".button-text-get-started").text("Get Started");
		$("#text-drawing-tool").text("New Drawing Tool");
		$(".overview-heading").html("Welcome to the <span class=\"bold\">InDesign Touch Workspace</span>");
		$(".gesture-heading").html("Create your layouts using touch gestures,</br>InDesign will convert your gestures into crisp graphics.");
		$(".gesture-heading2").text("Drawing Gestures");
		$(".text-overview-page-gesture-info").text("Tap on any gesture below to see how it works.");
		$(".text-square").text("Square");
		$(".text-image").text("Image");
		$(".text-rounded-rectangle").text("Rounded Rectangle");
		$(".text-headline").text("Headline");
		$(".text-circle").text("Circle");
		$(".text-chamfered-rectangle").text("Chamfered Rectangle");
		$(".text-rounded-image").text("Rounded Image");
		$(".text-circular-image").text("Circular Image");
		$(".text-triangle").text("Triangle");
		$(".text-corner").text("Corner");
		$(".text-polygon").text("Polygon");
		$(".text-headline").text("Headline");
		$(".text-multiline").text("Multiline");
		$(".text-paragraph").text("Paragraph");
		$(".text-line").text("Line");
		$(".text-erase").text("Erase");
		$("#text-file-menu").text("File");
		$("#text-save-menu").text("Save");
		$("#text-docname-menu").text("Untitled-1");
	}

	//Disabling drop inside whatsnew
    window.ondragenter=function(){ event.dataTransfer.dropEffect='none'; event.stopPropagation(); event.preventDefault(); }  
    window.ondragover=function(){ event.dataTransfer.dropEffect='none';event.stopPropagation(); event.preventDefault(); }
    window.ondrop=function(){ event.dataTransfer.dropEffect='none';event.stopPropagation(); event.preventDefault(); }
	
	// Getting URL var by its nam
    var startPage = $.getUrlVar('startpage');
	var docLaunch = $.getUrlVar('doclaunch');
	
	startpage(startPage);
	doclaunch(docLaunch);
}
/*
function SetColorTheme(theme)
{
	if(theme == "light")
	{
		$("body").removeClass("dark");
		$("body").addClass("light");
	}
	else if(theme == "dark")
	{
		$("body").removeClass("light");
		$("body").addClass("dark");
	}
}
*/
function CloseWindow()
{
	var obj = window.touchHelp;
	obj.hostAppCloseHtmlWindow();
}

function NewDocWindow()
{
	CloseWindow();
	var obj = window.touchHelp;
	obj.hostAppOpenTouchNewDocumentDialog();
}

$(document).ready(function(){
/*	$(".next-click-one").click(function(){
		//$(".ftue-wrapper-overview").fadeOut(300);
		$(".ftue-wrapper-gesture").fadeOut(300);
		$(".ftue-nav-two").animate({
			opacity: 0.01,
			left:"-100%", 
		}, 500);
		$(".ftue-wrapper-three").animate({
			opacity: 1,
			left:"0", 
		}, 500);		
		$(".gif-image").removeClass("hidden");

	});

	$(".back-click-two").click(function(){

		$(".ftue-wrapper-overview").fadeIn(600);
		$(".ftue-wrapper-gesture").fadeOut(300);
		$(".ftue-nav-intro").animate({
			opacity: 1,
			left:"0", 
		}, 500);
		$(".ftue-wrapper-two").animate({
			opacity: 0.01,
			left:"100%", 
		}, 500, function(){
			$(".gif-image").addClass("hidden");
		});		
		
	});*/

	$(".back-click-three").click(function(){
		$(".ftue-wrapper-gesture").fadeIn(600);
		$(".ftue-wrapper-two").animate({
			opacity: 1,
			left:"0", 
		}, 500);
		$(".ftue-wrapper-three").animate({
			opacity: 0.01,
			left:"100%", 
		}, 500);
		$(".gif-image").removeClass("hidden");	
	});

	$(".next-click-two").click(function(){
		$(".ftue-wrapper-gesture").fadeOut(300);
		$(".ftue-wrapper-two").animate({
			opacity: 0.01,
			left:"-100%", 
		}, 500);
		$(".ftue-wrapper-three").animate({
			opacity: 1,
			left:"0", 
		}, 500, function(){
					$(".gif-image").addClass("hidden");
		});		
	});
});

function doclaunch(bool){
	if (bool==true){
	$(".sub-launch-remove").removeClass("hidden");
	$(".sub-launch-add").addClass("hidden");
	}
	else if(bool==false){
		$(".sub-launch-remove").addClass("hidden");
		$(".sub-launch-add").removeClass("hidden");	
	}
}

function startpage(page){
	if (page==1){
		$(".ftue-wrapper-gesture").show();
		$(".ftue-wrapper-two").css({"left":"0","opacity":"1"});
		$(".ftue-wrapper-three").css({"left":"100%","opacity":"0.01"});
		$(".gif-image").removeClass("hidden");	
	}
	else if(page==2){
		$(".ftue-wrapper-gesture").hide();
		$(".ftue-wrapper-three").css({"left":"0","opacity":"1"});
		$(".ftue-wrapper-two").css({"left":"-100%","opacity":"0.01"});
		$(".gif-image").addClass("hidden");			
	}	
}

function notifyHostAppAboutGesturePlayed(element)
{
	var obj = window.touchHelp;
	var id = element.id;
	if(obj)
		obj.hostAppTWSGestureHelpPlayed(id);
}
