// Global context
// ==============
var gSampleDocumentURL = "http://www.adobe.com/go/publishonline_sample1/";
var gSampleInteractiveDocumentURL = "http://www.adobe.com/go/publishonline_sample2/";
var gCurrentSlide = 0;
var resourceBundle;
var headingText = [];
var descriptionText = [];
var gTotalSlides = 5;
var gSlideShowID = -1;
var kSlideShowDelay = 12000;
// ==============

function loadJSX() {
    var csInterface = new CSInterface();
    var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";    
    csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
    new CSInterface().evalScript(script, callback);
}

function onLoaded()
{
	var csInterface = new CSInterface();

	loadJSX();
	
	// For tracking document open/close
	csInterface.addEventListener("com.adobe.indesign.events.FTUE.EnableTryNow", OnTryNowEnabled); 	
	csInterface.addEventListener("com.adobe.indesign.events.FTUE.DisableTryNow", OnTryNowDisabled);

	// Disable drop inside the panel
    window.ondragenter = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    window.ondragover = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    window.ondrop = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };    
    window.oncontextmenu = function(event) { event.stopPropagation(); event.preventDefault(); };
	
	// Intercept all external link clicks
	// External links to be opened in browser
	RefreshLinkIntercepts();
	
	// Initialize locale resources
	resourceBundle = csInterface.initResourceBundle();
	headingText = [resourceBundle["TopHeadingText1"], 
					resourceBundle["TopHeadingText2"],
					resourceBundle["TopHeadingText3"],
					resourceBundle["TopHeadingText4"],
					resourceBundle["TopHeadingText5"],
					];
	descriptionText = [resourceBundle["DescriptionText1"], 
						resourceBundle["DescriptionText2"],
						resourceBundle["DescriptionText3"],
						resourceBundle["DescriptionText4"],
						resourceBundle["DescriptionText5"],
						];

	ActionLinkText = ["", 
						resourceBundle["SampleLinkText"],
						resourceBundle["InteractiveSampleLinktext"],
						"",
						resourceBundle["WebDashBoardLinkText"],						
						];

	ActionLinkURL = ["about:blank",
						gSampleDocumentURL,
						gSampleInteractiveDocumentURL,
						"about:blank",
						gSampleDocumentURL,
						"about:blank"
						];	

	// Scale the images to fit the window. This is important for 1.5x and 2x dpi screens
	// Adjust width of ul to include all the images horizontally.
	var images = $('ul.ImageSlides img');
	for (var i = images.length - 1; i >= 0; i--) {
		$(images[i]).load(function() {			
			var totalWidth = 0;
			for (var i = images.length - 1; i >= 0; i--) {
				images[i].width = $(window).width();
				totalWidth += images[i].width;
			}			
			totalWidth += 16; // Unexplained margin.
			$('ul.ImageSlides').css('width', totalWidth );
		});
	}

	var scaleSuffix = "";
	if(csInterface.getScaleFactor() > 1.9) {
		scaleSuffix = "_2x";
	}else if(csInterface.getScaleFactor() > 1.4) {
		scaleSuffix = "_1.5x";
	}

	for (var i = images.length - 1; i >= 0; i--) {
		var num = i+1;
		$(images[i]).attr("src", "images/FTUE_Images_0"+num+scaleSuffix+".png");
	};

	// Initialize the Try-now button
	$('button.TryNow').text(resourceBundle["TryNowButtonText"]);
	
	$("button").hover(
	  function() {
	    if($(this).hasClass("Disabled") == false) {
	        $(this).addClass("RolloverButton");
	    }
	  },
	  function() {
	  	$(this).removeClass("RolloverButton");
	  }
	);

	$('.NavButton button').click(OnNavigationButtonClick);

	// Register interest in Arrow key events
	if(navigator.platform.indexOf("Mac") < 0){ //Windows
		// registering left and right arrow keycodes
		csInterface.registerKeyEventsInterest("[{ \"keyCode\": 39},{\"keyCode\": 37}]");
	}
	else { // mac
		// Mac behavior is pretty weird. Keycodes 123,124 get registered. But the key presses 37,39 are received from left and right arrows.
		csInterface.registerKeyEventsInterest("[{ \"keyCode\": 123},{\"keyCode\": 124},{ \"keyCode\": 39},{\"keyCode\": 37}]");	
	}
	
	// Initialize to first slide	
	ShowSlide(0);
	StartSlideShow();
}

function OnClickTryNow () {	
	PauseSlideShow();
	PublishAndClose();                
}

function OnClickBody () {
	PauseSlideShow();	
}

function OnNavigationButtonClick() {
	PauseSlideShow();

	if($(this).parent().hasClass("Prev")) {
		ShowSlide(gCurrentSlide - 1);
	}
	else if($(this).parent().hasClass("Next")) {
		ShowSlide(gCurrentSlide + 1);
	}
}

function PublishAndClose () {
	SendEventToApp("com.adobe.events.HtmlPublishFTUETryNow.html", 0);
}

function HandleExternalLink(url)
{
	PauseSlideShow();

	// Open external links in browser
	var err = window.cep.util.openURLInDefaultBrowser(url);
	if(err>0) {
		// TODO: Remove the debugging alert
		alert("Failed to open this URL");
	}
	SendEventToApp("com.adobe.events.HtmlPublishFTUEExtLinkClicked.html", url);
}

function GoToDashboard () {
	PauseSlideShow();
	SendEventToApp("com.adobe.events.HtmlPublishFTUELaunchDashboard.html", 0);
}

function SendEventToApp(eventName, eventData) {
    var csInterface = new CSInterface();
    var event = new CSEvent(eventName, "APPLICATION");
    event.extensionId = csInterface.getExtensionID();
    event.data = eventData;
    csInterface.dispatchEvent(event);
}

function ShowSlide(index) {

	if(typeof(index) == 'undefined')
	{
		index = (gCurrentSlide + 1) % gTotalSlides;
	}

	// Ignore out of range requests
	if(index < 0 || index > (gTotalSlides-1)) {
		return; 
	}

	gCurrentSlide = index;

	$('.TopHeading').html(headingText[index]);
	$('.Description').html(descriptionText[index]);
	
	// Highlight the navigation bullet
	$('.NavigationBullets .highlighted').removeClass("highlighted");	
	$('.NavigationBullets li').eq(index).addClass("highlighted");

	$('.NavigationBullets li img').attr('src', "images/bullet.svg");
	$('.NavigationBullets .highlighted img').attr('src', "images/bullet-highlighted.svg");

	// Show the slide image
	var slideStart = $('.ImageSlides li').eq(index).position().left;
	$('ul.ImageSlides').css('left', (slideStart * -1));

	// Update the action link
	$('.FooterAction a').html(ActionLinkText[index]);
	$('.FooterAction a').attr('href', ActionLinkURL[index]);

	// Special Web dashboard link
	if(index == gTotalSlides-1) {
		$('.FooterAction a').addClass("dashboard");
	}
	else {
		$('.FooterAction a').removeClass("dashboard");
	}

	// Hide first and last arrows
	if(index == 0) {
		$('.Prev.NavButton').css('display', 'none');
		$('.Next.NavButton').css('display', 'block');
	}
	else if(index == gTotalSlides-1) {
		$('.Prev.NavButton').css('display', 'block');
		$('.Next.NavButton').css('display', 'none');
	}
	else {
		$('.Prev.NavButton').css('display', 'block');
		$('.Next.NavButton').css('display', 'block');
	}


	RefreshLinkIntercepts();
}

function RefreshLinkIntercepts() {
	$('a.external').unbind('click');
	$('a.external').click(function(event) {									
									var url = event.currentTarget.href;									
									HandleExternalLink(url);
									return false;
								});
	$('a.dashboard').unbind('click');
	$('a.dashboard').click(function(event) {									
									GoToDashboard();
									return false;
								});
	$('ul.NavigationBullets li').unbind('click');
	$('ul.NavigationBullets li').click(function(event) {
									PauseSlideShow();
									ShowSlide($(this).index());
									return false;
								});	
}

function HandleKeyDown(event) {
	PauseSlideShow();
	if(navigator.platform.indexOf("Mac") < 0) {
		if(event.keyCode == 39) {
			ShowSlide(gCurrentSlide + 1);	
		}
		else if(event.keyCode == 37) {
			ShowSlide(gCurrentSlide - 1);
		}				
	}
	else {
		if(event.keyCode == 124 || event.keyCode == 39) {
			ShowSlide(gCurrentSlide + 1);	
		}
		else if(event.keyCode == 123 || event.keyCode == 37) {
			ShowSlide(gCurrentSlide - 1);	
		}		
	}

}

function OnTryNowEnabled () {
	$('button.TryNow').css('display', 'block');
}


function OnTryNowDisabled () {
	$('button.TryNow').css('display', 'none');
}

function StartSlideShow() {	
	gSlideShowID = setInterval(ShowSlide, kSlideShowDelay);
}

function PauseSlideShow () {
	clearInterval(gSlideShowID);
}
