﻿
var exportFolderPath = Folder.temp.fsName + "/InDesign_HTMLPreview";
var exportResult = {};

function deleteFolderRecursive(path, deleteFolder)
{
    var folderToDelete = new Folder(path);
    var files = folderToDelete.getFiles();
    for(var index = 0; index < files.length; index++)
    {
        var curFile = files[index];
        if(curFile instanceof Folder)
            deleteFolderRecursive(curFile.fullName, true);
        else  // delete file
            curFile.remove();
    }
    if(deleteFolder)
        folderToDelete.remove();
}

function getDocumentPageSize(doc)
{
    var size = {};

    var units = app.scriptPreferences.measurementUnit;
    app.scriptPreferences.measurementUnit = MeasurementUnits.POINTS;

    var prefs = doc.documentPreferences;
    size.width = prefs.pageWidth;
    size.height = prefs.pageHeight;

    // Restore measurement units
    app.scriptPreferences.measurementUnit = units;

    return size;
}

function addSpreadExportData(spread, fileBaseName, fileNum, size, facing)
{
    // The EPUB fixed layout export code exports page pairs from a spread as separate HTML files, for facing pages setup.
    // For non-facing pages setup, there is a digression from EPUB export, in that we are exporting per page HTML files.
    // This behavior has been kept as is for HTML fixed layout export as well (after all the preview feature
    // is meant for previewing EPUB fixed layout interactivity etc.).
    // Any changes in that logic warrant a change in the code below.

    var i;
    var numPages = spread.pages.length;
    var spreadData = []; // empty array

    for(i = 0; i < numPages; i++)
    {
        var pageData = {};

        var exportFileName = fileBaseName;
        if(fileNum)
            exportFileName += "-" + fileNum;
        exportFileName += ".html";

        pageData.exportFileName = exportFileName;
        pageData.exportFilePath = exportFolderPath + "/" + exportFileName;
        fileNum++;

        if(facing)
        {
            if(i < numPages - 1)
            {
                // Page pair.
                pageData.pageRange = spread.pages[i].name + "-" + spread.pages[i + 1].name;
                i++;
            }
            else
            {
                pageData.pageRange = spread.pages[i].name;
            }
            pageData.contentWidth = size.width * 2;
            pageData.contentHeight = size.height;
        }
        else
        {
            pageData.pageRange = spread.pages[i].name;
            pageData.contentWidth = size.width;
            pageData.contentHeight = size.height;
        }
        spreadData.push(pageData);
    }

    exportResult.spreads.push(spreadData);
    return fileNum;
}

function getPageRange(spread)
{
    var pageRange = "";

    // The document can have alternate layouts, or use section numbering, making the
    // page numbering complex. Use absolute numbering instead.
    var version = app.scriptPreferences.version;
    var numbering = app.generalPreferences.pageNumbering;

    try {
        app.scriptPreferences.version = 3;
        app.generalPreferences.pageNumbering = PageNumberingOptions.ABSOLUTE;

        pageRange = "+" + spread.pages.firstItem().name;
        if(spread.pages.length > 1)
            pageRange += "-+" + spread.pages.lastItem().name;
    }
    catch(err) {
    }
    finally {
        app.scriptPreferences.version = version;
        app.generalPreferences.pageNumbering = numbering;
    }

    return pageRange;
}

function doTheExport(doc, spread)
{
    var exportFolder = new Folder(exportFolderPath);
    if(!exportFolder.exists)
        exportFolder.create();

    // Backup user preferences
    var pageRangeFormat = doc.htmlFXLExportPreferences.epubPageRangeFormat;
    var pageRange = doc.htmlFXLExportPreferences.epubPageRange;

    // Randomize the name of the exported html file and related resources.
    // This is to work around a CEP issue due to css caching where the resources are not
    // reloaded otherwise, if re-exported with the same name.
    var exportFileBaseName = "InDesignPreview" + Math.floor((Math.random() * 100000) + 1);
    var exportFilePath = exportFolderPath + "/" + exportFileBaseName + ".html";

    var size = getDocumentPageSize(doc);
    var facingPages = doc.documentPreferences.facingPages;

    if(spread == null || spread == undefined)
    {
        // Exporting the entire document.
        doc.htmlFXLExportPreferences.epubPageRangeFormat = PageRangeFormat.exportAllPages;
        try
        {
            doc.exportFile(ExportFormat.HTMLFXL, exportFilePath);
            var exportFileNum = 0;
            var i;
            for(i = 0; i < doc.spreads.length; i++)
            {
                // Fill in the spread export data.
                exportFileNum = addSpreadExportData(doc.spreads[i], exportFileBaseName, exportFileNum, size, facingPages);
            }
        }
        catch(error)
        {
            exportResult.status = false;
        }
    }
    else
    {
        // Exporting the current spread.
        doc.htmlFXLExportPreferences.epubPageRangeFormat = PageRangeFormat.exportPageRange;
        doc.htmlFXLExportPreferences.epubPageRange = getPageRange(spread);
        try
        {
            doc.exportFile(ExportFormat.HTMLFXL, exportFilePath);    

            // Fill in the spread export data.
            addSpreadExportData(spread, exportFileBaseName, 0, size, facingPages);
        }
        catch(error)
        {
            exportResult.status = false;            
        }              
    }

    exportResult.docName = doc.name;

    // restore user preferences
    doc.htmlFXLExportPreferences.epubPageRangeFormat = pageRangeFormat;
    doc.htmlFXLExportPreferences.epubPageRange = pageRange;
}

function initExportResult()
{
    exportResult.status = false;
    exportResult.docName = "";
    exportResult.spreads = []; // spreads array, empty to begin with
}

$._ext_IDSN = {
    isActiveSpreadMaster : function()
    {
        var result = {};
        result.isMaster = false;

        if(app.documents.length != 0) {
            var masters = app.activeDocument.masterSpreads;
            var spread = app.activeWindow.activeSpread;

            for(var i = 0; i < masters.length; i++) {
                var master = masters.item(i);
                if(spread.id == master.id) {
                    result.isMaster = true;
                    break;
                }
            }
        }

        return JSON.stringify(result);
    },

    doMasterSpreadAlertBox : function(boxTitle, message, buttonLabel)
    {
        var myWindow = new Window("dialog", boxTitle);
        myWindow.orientation = "column";
        myWindow.add("statictext", undefined, message);
        myWindow.add("button", undefined, buttonLabel);
        myWindow.show();
    },

    exportActiveSpread : function()
    {
        initExportResult();
        if(app.documents.length != 0)
        {
            exportResult.status = true;

            // Export the active spread.
            doTheExport(app.activeDocument, app.activeWindow.activeSpread);
        }
        return JSON.stringify(exportResult);
    },

    exportActiveDocument : function()
    {
        initExportResult();
        if(app.documents.length != 0)
        {
            exportResult.status = true;

            // Export the entire document.
            doTheExport(app.activeDocument, null);
        }
        return JSON.stringify(exportResult);
    },

    getNumOpenDocuments : function()
    {
        var openDocs = {};
        openDocs.count = app.documents.length;
        return JSON.stringify(openDocs);
    },

    deletePreviewFiles : function(deleteExportFolder)
    {
        deleteFolderRecursive(exportFolderPath, deleteExportFolder);
    }
};
