/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzbz;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzdc;
import com.google.android.gms.measurement.internal.zzdd;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzt;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class zzby
implements zzcv {
    private static volatile zzby zznn;
    private final Context zzno;
    private final String zzx;
    private final String zznp;
    private final String zznq;
    private final boolean zzv;
    private final zzq zzfq;
    private final zzt zznr;
    private final zzbf zzns;
    private final zzau zznt;
    private final zzbt zznu;
    private final zzfj zznv;
    private final zzgd zznw;
    private final zzas zznx;
    private final Clock zzaa;
    private final zzed zzny;
    private final zzdd zznz;
    private final zza zzoa;
    private final zzdz zzob;
    private zzaq zzoc;
    private zzeg zzod;
    private zzad zzoe;
    private zzap zzof;
    private zzbl zzog;
    private boolean zzce = false;
    private Boolean zzoh;
    private long zzoi;
    private volatile Boolean zzoj;
    @VisibleForTesting
    private Boolean zzok;
    @VisibleForTesting
    private Boolean zzol;
    private int zzom;
    private AtomicInteger zzon = new AtomicInteger(0);
    private final long zzdp;

    private zzby(zzdc zzdc2) {
        Object object;
        Preconditions.checkNotNull((Object)zzdc2);
        Object object2 = zzdc2.zzno;
        this.zzfq = new zzq((Context)object2);
        zzal.zza(this.zzfq);
        this.zzno = zzdc2.zzno;
        this.zzx = zzdc2.zzx;
        this.zznp = zzdc2.zznp;
        this.zznq = zzdc2.zznq;
        this.zzv = zzdc2.zzv;
        this.zzoj = zzdc2.zzoj;
        zzy zzy2 = zzdc2.zzpe;
        if (zzy2 != null && zzy2.zzy != null) {
            object = zzy2.zzy.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzok = (Boolean)object;
            }
            if ((object = zzy2.zzy.get("measurementDeactivated")) instanceof Boolean) {
                this.zzol = (Boolean)object;
            }
        }
        zzcw.zzq(this.zzno);
        this.zzaa = DefaultClock.getInstance();
        this.zzdp = this.zzaa.currentTimeMillis();
        object2 = this;
        this.zznr = new zzt((zzby)object2);
        object2 = this;
        object = new zzbf((zzby)object2);
        ((zzcu)object).zzai();
        this.zzns = object;
        object2 = this;
        zzau zzau2 = new zzau((zzby)object2);
        zzau2.zzai();
        this.zznt = zzau2;
        object2 = this;
        zzgd zzgd2 = new zzgd((zzby)object2);
        zzgd2.zzai();
        this.zznw = zzgd2;
        object2 = this;
        zzas zzas2 = new zzas((zzby)object2);
        zzas2.zzai();
        this.zznx = zzas2;
        object2 = this;
        this.zzoa = new zza((zzby)object2);
        object2 = this;
        zzed zzed2 = new zzed((zzby)object2);
        zzed2.zzai();
        this.zzny = zzed2;
        object2 = this;
        zzdd zzdd2 = new zzdd((zzby)object2);
        zzdd2.zzai();
        this.zznz = zzdd2;
        object2 = this;
        zzfj zzfj2 = new zzfj((zzby)object2);
        zzfj2.zzai();
        this.zznv = zzfj2;
        object2 = this;
        zzdz zzdz2 = new zzdz((zzby)object2);
        zzdz2.zzai();
        this.zzob = zzdz2;
        object2 = this;
        zzbt zzbt2 = new zzbt((zzby)object2);
        zzbt2.zzai();
        this.zznu = zzbt2;
        boolean bl = zzdc2.zzpe != null && zzdc2.zzpe.zzu != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzq zzq2 = ((zzby)object2).zzfq;
        if (((zzby)object2).zzno.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzdd zzdd3 = ((zzby)object2).zzs();
            if (((zzct)zzdd3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzct)zzdd3).getContext().getApplicationContext();
                if (zzdd3.zzpf == null) {
                    zzdd3.zzpf = new zzdx(zzdd3, null);
                }
                if (bl3) {
                    zzdx zzdx2 = zzdd3.zzpf;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdx2);
                    zzdx2 = zzdd3.zzpf;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdx2);
                    ((zzct)zzdd3).zzad().zzdi().zzaq("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzby)object2).zzad().zzdd().zzaq("Application context is not an Application");
        }
        this.zznu.zza(new zzbz(this, zzdc2));
    }

    @WorkerThread
    private final void zza(zzdc zzdc2) {
        ((zzct)this.zzac()).zzq();
        zzt.zzbo();
        Object object = this;
        zzad zzad2 = new zzad((zzby)object);
        zzad2.zzai();
        this.zzoe = zzad2;
        zzby zzby2 = this;
        object = zzdc2;
        zzap zzap2 = new zzap(zzby2, ((zzdc)object).zzu);
        zzap2.zzai();
        this.zzof = zzap2;
        object = this;
        zzaq zzaq2 = new zzaq((zzby)object);
        zzaq2.zzai();
        this.zzoc = zzaq2;
        object = this;
        zzeg zzeg2 = new zzeg((zzby)object);
        zzeg2.zzai();
        this.zzod = zzeg2;
        this.zznw.zzaj();
        this.zzns.zzaj();
        object = this;
        this.zzog = new zzbl((zzby)object);
        this.zzof.zzaj();
        this.zzad().zzdg().zza("App measurement is starting up, version", this.zznr.zzav());
        zzq zzq2 = this.zzfq;
        this.zzad().zzdg().zzaq("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzq2 = this.zzfq;
        String string = zzap2.zzan();
        if (TextUtils.isEmpty((CharSequence)this.zzx)) {
            String string2;
            zzaw zzaw2;
            if (this.zzab().zzbt(string)) {
                zzaw2 = this.zzad().zzdg();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzaw2 = this.zzad().zzdg();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzaw2.zzaq(string2);
        }
        this.zzad().zzdh().zzaq("Debug-level message logging enabled");
        if (this.zzom != this.zzon.get()) {
            this.zzad().zzda().zza("Not all components initialized", this.zzom, this.zzon.get());
        }
        this.zzce = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzct)this.zzac()).zzq();
        if (this.zzae().zzlb.get() == 0L) {
            this.zzae().zzlb.set(this.zzaa.currentTimeMillis());
        }
        if (Long.valueOf(this.zzae().zzlg.get()) == 0L) {
            this.zzad().zzdi().zza("Persisting first open", this.zzdp);
            this.zzae().zzlg.set(this.zzdp);
        }
        if (!this.zzet()) {
            if (this.isEnabled()) {
                if (!this.zzab().zzbr("android.permission.INTERNET")) {
                    this.zzad().zzda().zzaq("App is missing INTERNET permission");
                }
                if (!this.zzab().zzbr("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzad().zzda().zzaq("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzq zzq2 = this.zzfq;
                if (!Wrappers.packageManager((Context)this.zzno).isCallerInstantApp() && !this.zznr.zzbw()) {
                    if (!zzbo.zzl(this.zzno)) {
                        this.zzad().zzda().zzaq("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzgd.zzb(this.zzno, false)) {
                        this.zzad().zzda().zzaq("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzad().zzda().zzaq("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzq zzq3 = this.zzfq;
            if (!TextUtils.isEmpty((CharSequence)this.zzt().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzt().zzao())) {
                this.zzab();
                if (zzgd.zza(this.zzt().getGmpAppId(), this.zzae().zzds(), this.zzt().zzao(), this.zzae().zzdt())) {
                    this.zzad().zzdg().zzaq("Rechecking which service to use due to a GMP App Id change");
                    this.zzae().zzdv();
                    this.zzw().resetAnalyticsData();
                    this.zzod.disconnect();
                    this.zzod.zzfh();
                    this.zzae().zzlg.set(this.zzdp);
                    this.zzae().zzli.zzav(null);
                }
                this.zzae().zzat(this.zzt().getGmpAppId());
                this.zzae().zzau(this.zzt().zzao());
                if (this.zznr.zzaa(this.zzt().zzan())) {
                    this.zznv.zzab(this.zzdp);
                }
            }
            this.zzs().zzbi(this.zzae().zzli.zzed());
            zzq3 = this.zzfq;
            if (!TextUtils.isEmpty((CharSequence)this.zzt().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzt().zzao())) {
                boolean bl = this.isEnabled();
                if (!this.zzae().zzdz() && !this.zznr.zzbq()) {
                    this.zzae().zzf(!bl);
                }
                if (!this.zznr.zzs(this.zzt().zzan()) || bl) {
                    this.zzs().zzfb();
                }
                this.zzu().zza(new AtomicReference<String>());
            }
        }
        this.zzae().zzlq.set(this.zznr.zza(zzal.zziw));
        this.zzae().zzlr.set(this.zznr.zza(zzal.zzix));
    }

    @Override
    public final zzq zzag() {
        return this.zzfq;
    }

    public final zzt zzaf() {
        return this.zznr;
    }

    public final zzbf zzae() {
        zzby.zza((zzct)this.zzns);
        return this.zzns;
    }

    @Override
    public final zzau zzad() {
        zzby.zza(this.zznt);
        return this.zznt;
    }

    public final zzau zzei() {
        if (this.zznt != null && this.zznt.isInitialized()) {
            return this.zznt;
        }
        return null;
    }

    @Override
    public final zzbt zzac() {
        zzby.zza(this.zznu);
        return this.zznu;
    }

    public final zzfj zzx() {
        zzby.zza(this.zznv);
        return this.zznv;
    }

    public final zzbl zzej() {
        return this.zzog;
    }

    final zzbt zzek() {
        return this.zznu;
    }

    public final zzdd zzs() {
        zzby.zza(this.zznz);
        return this.zznz;
    }

    public final zzgd zzab() {
        zzby.zza((zzct)this.zznw);
        return this.zznw;
    }

    public final zzas zzaa() {
        zzby.zza((zzct)this.zznx);
        return this.zznx;
    }

    public final zzaq zzw() {
        zzby.zza(this.zzoc);
        return this.zzoc;
    }

    @Override
    public final Context getContext() {
        return this.zzno;
    }

    public final boolean zzel() {
        return TextUtils.isEmpty((CharSequence)this.zzx);
    }

    public final String zzem() {
        return this.zzx;
    }

    public final String zzen() {
        return this.zznp;
    }

    public final String zzeo() {
        return this.zznq;
    }

    public final boolean zzep() {
        return this.zzv;
    }

    @Override
    public final Clock zzz() {
        return this.zzaa;
    }

    public final zzed zzv() {
        zzby.zza(this.zzny);
        return this.zzny;
    }

    public final zzeg zzu() {
        zzby.zza(this.zzod);
        return this.zzod;
    }

    public final zzad zzy() {
        zzby.zza(this.zzoe);
        return this.zzoe;
    }

    public final zzap zzt() {
        zzby.zza(this.zzof);
        return this.zzof;
    }

    public final zza zzr() {
        if (this.zzoa == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzoa;
    }

    @VisibleForTesting
    public static zzby zza(Context context, String string, String string2, Bundle bundle) {
        return zzby.zza(context, new zzy(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzby zza(Context context, zzy zzy2) {
        if (zzy2 != null && (zzy2.origin == null || zzy2.zzx == null)) {
            zzy2 = new zzy(zzy2.zzt, zzy2.zzu, zzy2.zzv, zzy2.zzw, null, null, zzy2.zzy);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zznn == null) {
            Class<zzby> clazz = zzby.class;
            synchronized (zzby.class) {
                if (zznn == null) {
                    zzdc zzdc2 = new zzdc(context, zzy2);
                    zznn = new zzby(zzdc2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzy2 != null && zzy2.zzy != null && zzy2.zzy.containsKey("dataCollectionDefaultEnabled")) {
            zznn.zza(zzy2.zzy.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zznn;
    }

    private final void zzah() {
        if (!this.zzce) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzcu zzcu2) {
        if (zzcu2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcu2.isInitialized()) {
            String string = String.valueOf(zzcu2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.isInitialized()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzct zzct2) {
        if (zzct2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzoj = bl;
    }

    @WorkerThread
    public final boolean zzeq() {
        return this.zzoj != null && this.zzoj != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzct)this.zzac()).zzq();
        this.zzah();
        if (this.zznr.zza(zzal.zzio)) {
            if (this.zznr.zzbq()) {
                return false;
            }
            if (this.zzol != null && this.zzol.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzae().zzdw();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zznr.zzbr();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzok != null) {
                return this.zzok;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zznr.zza(zzal.zzik) && this.zzoj != null) {
                return this.zzoj;
            }
            return true;
        }
        if (this.zznr.zzbq()) {
            return false;
        }
        Boolean bl4 = this.zznr.zzbr();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzoj != null && ((Boolean)zzal.zzik.get(null)).booleanValue()) {
                bl = this.zzoj;
            }
        }
        return this.zzae().zze(bl);
    }

    final long zzer() {
        Long l = this.zzae().zzlg.get();
        if (l == 0L) {
            return this.zzdp;
        }
        return Math.min(this.zzdp, l);
    }

    final void zzo() {
        zzq zzq2 = this.zzfq;
    }

    final void zzn() {
        zzq zzq2 = this.zzfq;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzcu zzcu2) {
        ++this.zzom;
    }

    final void zzb(zzf zzf2) {
        ++this.zzom;
    }

    final void zzes() {
        this.zzon.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzet() {
        this.zzah();
        ((zzct)this.zzac()).zzq();
        if (this.zzoh == null || this.zzoi == 0L || this.zzoh != null && !this.zzoh.booleanValue() && Math.abs(this.zzaa.elapsedRealtime() - this.zzoi) > 1000L) {
            this.zzoi = this.zzaa.elapsedRealtime();
            zzq zzq2 = this.zzfq;
            this.zzoh = this.zzab().zzbr("android.permission.INTERNET") && this.zzab().zzbr("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzno).isCallerInstantApp() || this.zznr.zzbw() || zzbo.zzl(this.zzno) && zzgd.zzb(this.zzno, false));
            if (this.zzoh.booleanValue()) {
                this.zzoh = this.zzab().zzr(this.zzt().getGmpAppId(), this.zzt().zzao()) || !TextUtils.isEmpty((CharSequence)this.zzt().zzao());
            }
        }
        return this.zzoh;
    }

    static /* synthetic */ void zza(zzby zzby2, zzdc zzdc2) {
        zzby2.zza(zzdc2);
    }
}

