/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzazv;
import com.google.android.gms.internal.ads.zzazx;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzdbg;
import com.google.android.gms.internal.ads.zzyb;
import com.google.android.gms.internal.ads.zzyr;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.UUID;

@zzare
public final class zzazu {
    public static final Handler zzyr = new zzdbg(Looper.getMainLooper());
    private static final String zzdyq = AdView.class.getName();
    private static final String zzdyr = InterstitialAd.class.getName();
    private static final String zzdys = PublisherAdView.class.getName();
    private static final String zzdyt = PublisherInterstitialAd.class.getName();
    private static final String zzdyu = SearchAdView.class.getName();
    private static final String zzdyv = AdLoader.class.getName();
    private float zzdyw = -1.0f;

    public static void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static int zza(Context context, int n) {
        return zzazu.zza(context.getResources().getDisplayMetrics(), n);
    }

    public static int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzb(Context context, int n) {
        if (this.zzdyw < 0.0f) {
            zzazu zzazu2 = this;
            synchronized (zzazu2) {
                if (this.zzdyw < 0.0f) {
                    Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
                    DisplayMetrics displayMetrics = new DisplayMetrics();
                    display.getMetrics(displayMetrics);
                    this.zzdyw = displayMetrics.density;
                }
            }
        }
        return Math.round((float)n / this.zzdyw);
    }

    public static int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public final void zza(ViewGroup viewGroup, zzyb zzyb2, String string, String string2) {
        zzbae.zzep(string2);
        this.zza(viewGroup, zzyb2, string, -65536, -16777216);
    }

    public final void zza(ViewGroup viewGroup, zzyb zzyb2, String string) {
        this.zza(viewGroup, zzyb2, string, -16777216, -1);
    }

    private final void zza(ViewGroup viewGroup, zzyb zzyb2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzazu.zza(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zzyb2.widthPixels - n3, zzyb2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zzyb2.widthPixels, zzyb2.heightPixels);
    }

    public static String zzbe(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return zzazu.zzei(string == null || zzazu.zzwx() ? "emulator" : string);
    }

    @Nullable
    public static String zzbf(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static boolean zzwx() {
        return Build.DEVICE.startsWith("generic");
    }

    public static boolean zzwy() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String zzei(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        return null;
    }

    public static boolean zzc(Context context, int n) {
        return 0 == GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, n);
    }

    public static boolean zzbg(Context context) {
        int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
        return n == 0 || n == 2;
    }

    public static boolean zzbh(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public static boolean zzbi(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public static int zzbj(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    @VisibleForTesting
    public static String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzdyq.equalsIgnoreCase(string3) || zzdyr.equalsIgnoreCase(string3) || zzdys.equalsIgnoreCase(string3) || zzdyt.equalsIgnoreCase(string3) || zzdyu.equalsIgnoreCase(string3) || zzdyv.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5;
            String string6;
            int n2 = 3;
            String string7 = ".";
            String string8 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string8, string7);
            StringBuilder stringBuilder = new StringBuilder();
            --n2;
            if (!stringTokenizer.hasMoreElements()) {
                string6 = string8;
            } else {
                stringBuilder.append(stringTokenizer.nextToken());
                while (n2-- > 0 && stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(".").append(stringTokenizer.nextToken());
                }
                string6 = string5 = stringBuilder.toString();
            }
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        zzazu.zza(context, string, string2, bundle, true, new zzazv(this));
    }

    public static void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zzazx zzazx2) {
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            context2 = context;
        }
        bundle.putString("os", Build.VERSION.RELEASE);
        bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
        bundle.putString("appid", context2.getPackageName());
        if (string == null) {
            int n = GoogleApiAvailabilityLight.getInstance().getApkVersion(context);
            string = new StringBuilder(23).append(n).append(".15000000").toString();
        }
        bundle.putString("js", string);
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzazx2.zzed(context2.toString());
    }

    public static String zzwz() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string;
    }

    public static Throwable zzc(Throwable throwable) {
        Throwable throwable2;
        Object object = zzact.zzclh;
        if (com.google.android.gms.internal.ads.zzyr.zzpe().zzd(object).booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                if (zzazu.zzej(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                object = stackTraceElement.getClassName();
                if (!TextUtils.isEmpty((CharSequence)object) && (((String)object).startsWith("android.") || ((String)object).startsWith("java."))) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }

    @VisibleForTesting
    public static boolean zzej(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzaci<String> zzaci2 = zzact.zzcli;
        if (string.startsWith(com.google.android.gms.internal.ads.zzyr.zzpe().zzd(zzaci2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzare.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzbae.zzb(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class "), exception);
            return false;
        }
    }
}

