/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzbjm;
import com.google.android.gms.internal.ads.zzxp;
import com.google.android.gms.internal.ads.zzyr;
import java.util.Date;
import java.util.Map;
import java.util.Set;

@zzare
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzbjm {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzmd;
    private InterstitialAd zzme;
    private AdLoader zzmf;
    private Context zzmg;
    private InterstitialAd zzmh;
    private MediationRewardedVideoAdListener zzmi;
    @VisibleForTesting
    private final RewardedVideoAdListener zzmj = new com.google.ads.mediation.zza(this);

    public AbstractAdViewAdapter() {
    }

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzyr.zzpa();
            builder.addTestDevice(zzazu.zzbe(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzmd != null) {
            this.zzmd.destroy();
            this.zzmd = null;
        }
        if (this.zzme != null) {
            this.zzme = null;
        }
        if (this.zzmf != null) {
            this.zzmf = null;
        }
        if (this.zzmh != null) {
            this.zzmh = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzmd != null) {
            this.zzmd.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzmd != null) {
            this.zzmd.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzmd = new AdView(context);
        this.zzmd.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzmd.setAdUnitId(this.getAdUnitId(bundle));
        this.zzmd.setAdListener(new zzd(this, mediationBannerListener));
        this.zzmd.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzmd;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzme = new InterstitialAd(context);
        this.zzme.setAdUnitId(this.getAdUnitId(bundle));
        this.zzme.setAdListener(new zze(this, mediationInterstitialListener));
        this.zzme.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzme != null) {
            this.zzme.setImmersiveMode(bl);
        }
        if (this.zzmh != null) {
            this.zzmh.setImmersiveMode(bl);
        }
    }

    @Override
    public zzaap getVideoController() {
        VideoController videoController;
        if (this.zzmd != null && (videoController = this.zzmd.getVideoController()) != null) {
            return videoController.zzdh();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzme.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzdj(1).zzacc();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zzf zzf2 = new zzf(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zzf2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isUnifiedNativeAdRequested()) {
            builder.forUnifiedNativeAd(zzf2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zzf2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zzf2);
        }
        if (nativeMediationAdRequest.zzsu()) {
            for (String string2 : nativeMediationAdRequest.zzsv().keySet()) {
                builder.forCustomTemplateAd(string2, zzf2, nativeMediationAdRequest.zzsv().get(string2) != false ? zzf2 : null);
            }
        }
        this.zzmf = builder.build();
        this.zzmf.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzmg = context.getApplicationContext();
        this.zzmi = mediationRewardedVideoAdListener;
        this.zzmi.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzmg == null || this.zzmi == null) {
            zzbae.zzen("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzmh = new InterstitialAd(this.zzmg);
        this.zzmh.zzc(true);
        this.zzmh.setAdUnitId(this.getAdUnitId(bundle));
        this.zzmh.setRewardedVideoAdListener(this.zzmj);
        this.zzmh.setAdMetadataListener(new com.google.ads.mediation.zzb(this));
        this.zzmh.loadAd(this.zza(this.zzmg, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzmh.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzmi != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzmi;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzmh = null;
        return null;
    }

    static /* synthetic */ InterstitialAd zzb(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzmh;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzmm;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzmm = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzmm);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbql.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzmm);
            }
        }
    }

    static final class zzc
    extends UnifiedNativeAdMapper {
        private final UnifiedNativeAd zzmn;

        public zzc(UnifiedNativeAd unifiedNativeAd) {
            this.zzmn = unifiedNativeAd;
            this.setHeadline(unifiedNativeAd.getHeadline());
            this.setImages(unifiedNativeAd.getImages());
            this.setBody(unifiedNativeAd.getBody());
            this.setIcon(unifiedNativeAd.getIcon());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setAdvertiser(unifiedNativeAd.getAdvertiser());
            this.setStarRating(unifiedNativeAd.getStarRating());
            this.setStore(unifiedNativeAd.getStore());
            this.setPrice(unifiedNativeAd.getPrice());
            this.zzp(unifiedNativeAd.zzkv());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(unifiedNativeAd.getVideoController());
        }

        @Override
        public final void trackViews(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof UnifiedNativeAdView) {
                ((UnifiedNativeAdView)view).setNativeAd(this.zzmn);
                return;
            }
            NativeAdViewHolder nativeAdViewHolder = NativeAdViewHolder.zzbql.get(view);
            if (nativeAdViewHolder != null) {
                nativeAdViewHolder.setNativeAd(this.zzmn);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzml;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzml = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzml);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbql.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzml);
            }
        }
    }

    @VisibleForTesting
    static final class zzf
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.OnUnifiedNativeAdLoadedListener {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmo;
        @VisibleForTesting
        private final MediationNativeListener zzmr;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzmo = abstractAdViewAdapter;
            this.zzmr = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmr.onAdFailedToLoad(this.zzmo, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmr.onAdOpened(this.zzmo);
        }

        @Override
        public final void onAdClosed() {
            this.zzmr.onAdClosed(this.zzmo);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmr.onAdLeftApplication(this.zzmo);
        }

        @Override
        public final void onAdClicked() {
            this.zzmr.onAdClicked(this.zzmo);
        }

        @Override
        public final void onAdImpression() {
            this.zzmr.onAdImpression(this.zzmo);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzmr.onAdLoaded((MediationNativeAdapter)this.zzmo, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
            this.zzmr.onAdLoaded((MediationNativeAdapter)this.zzmo, new zzc(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzmr.onAdLoaded((MediationNativeAdapter)this.zzmo, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzmr.zza(this.zzmo, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzmr.zza(this.zzmo, nativeCustomTemplateAd, string);
        }
    }

    @VisibleForTesting
    static final class zze
    extends AdListener
    implements zzxp {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmo;
        @VisibleForTesting
        private final MediationInterstitialListener zzmq;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzmo = abstractAdViewAdapter;
            this.zzmq = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmq.onAdLoaded(this.zzmo);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmq.onAdFailedToLoad(this.zzmo, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmq.onAdOpened(this.zzmo);
        }

        @Override
        public final void onAdClosed() {
            this.zzmq.onAdClosed(this.zzmo);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmq.onAdLeftApplication(this.zzmo);
        }

        @Override
        public final void onAdClicked() {
            this.zzmq.onAdClicked(this.zzmo);
        }
    }

    @VisibleForTesting
    static final class zzd
    extends AdListener
    implements AppEventListener,
    zzxp {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmo;
        @VisibleForTesting
        private final MediationBannerListener zzmp;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzmo = abstractAdViewAdapter;
            this.zzmp = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmp.onAdLoaded(this.zzmo);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmp.onAdFailedToLoad(this.zzmo, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmp.onAdOpened(this.zzmo);
        }

        @Override
        public final void onAdClosed() {
            this.zzmp.onAdClosed(this.zzmo);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmp.onAdLeftApplication(this.zzmo);
        }

        @Override
        public final void onAdClicked() {
            this.zzmp.onAdClicked(this.zzmo);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzmp.zza(this.zzmo, string, string2);
        }
    }
}

