/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zzse;
import com.google.android.gms.internal.ads.zzsf;
import com.google.android.gms.internal.ads.zzsh;
import com.google.android.gms.internal.ads.zzsi;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsx;
import java.io.IOException;

@SuppressLint(value={"HandlerLeak"})
final class zzsg<T extends zzsh>
extends Handler
implements Runnable {
    private final T zzbmt;
    private final zzsf<T> zzbmu;
    public final int zzbmv;
    private final long zzbmw;
    private IOException zzbmx;
    private int zzbmy;
    private volatile Thread zzaqn;
    private volatile boolean zzacf;
    private final /* synthetic */ zzse zzbmz;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public zzsg(zzse zzse2, Looper looper, zzsh zzsh2, zzsf zzsf2, int n, long l) {
        this.zzbmz = zzse2;
        super(looper);
        this.zzbmt = zzsh2;
        this.zzbmu = zzsf2;
        this.zzbmv = n;
        this.zzbmw = l;
    }

    public final void zzbm(int n) throws IOException {
        if (this.zzbmx != null && this.zzbmy > n) {
            throw this.zzbmx;
        }
    }

    public final void zzeq(long l) {
        zzsk.checkState(zzse.zza(this.zzbmz) == null);
        zzse.zza(this.zzbmz, this);
        if (l > 0L) {
            this.sendEmptyMessageDelayed(0, l);
            return;
        }
        this.execute();
    }

    public final void zzl(boolean bl) {
        this.zzacf = bl;
        this.zzbmx = null;
        if (this.hasMessages(0)) {
            this.removeMessages(0);
            if (!bl) {
                this.sendEmptyMessage(1);
            }
        } else {
            this.zzbmt.zzfp();
            if (this.zzaqn != null) {
                this.zzaqn.interrupt();
            }
        }
        if (bl) {
            this.finish();
            long l = SystemClock.elapsedRealtime();
            this.zzbmu.zza(this.zzbmt, l, l - this.zzbmw, true);
        }
    }

    @Override
    public final void run() {
        try {
            this.zzaqn = Thread.currentThread();
            if (!this.zzbmt.zzfq()) {
                String string2 = String.valueOf(this.zzbmt.getClass().getSimpleName());
                zzsx.beginSection(string2.length() != 0 ? "load:".concat(string2) : new String("load:"));
                try {
                    this.zzbmt.zzfr();
                }
                finally {
                    zzsx.endSection();
                }
            }
            if (!this.zzacf) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (IOException iOException) {
            if (!this.zzacf) {
                this.obtainMessage(3, iOException).sendToTarget();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            zzsk.checkState(this.zzbmt.zzfq());
            if (!this.zzacf) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (Exception exception) {
            Log.e((String)"LoadTask", (String)"Unexpected exception loading stream", (Throwable)exception);
            if (!this.zzacf) {
                this.obtainMessage(3, new zzsi(exception)).sendToTarget();
            }
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)"LoadTask", (String)"OutOfMemory error loading stream", (Throwable)outOfMemoryError);
            if (!this.zzacf) {
                this.obtainMessage(3, new zzsi(outOfMemoryError)).sendToTarget();
            }
            return;
        }
        catch (Error error) {
            Log.e((String)"LoadTask", (String)"Unexpected error loading stream", (Throwable)error);
            if (!this.zzacf) {
                this.obtainMessage(4, error).sendToTarget();
            }
            throw error;
        }
    }

    public final void handleMessage(Message message) {
        if (this.zzacf) {
            return;
        }
        if (message.what == 0) {
            this.execute();
            return;
        }
        if (message.what == 4) {
            throw (Error)message.obj;
        }
        this.finish();
        long l = SystemClock.elapsedRealtime();
        long l2 = l - this.zzbmw;
        if (this.zzbmt.zzfq()) {
            this.zzbmu.zza(this.zzbmt, l, l2, false);
            return;
        }
        switch (message.what) {
            case 1: {
                this.zzbmu.zza(this.zzbmt, l, l2, false);
                return;
            }
            case 2: {
                this.zzbmu.zza(this.zzbmt, l, l2);
                return;
            }
            case 3: {
                this.zzbmx = (IOException)message.obj;
                int n = this.zzbmu.zza(this.zzbmt, l, l2, this.zzbmx);
                if (n == 3) {
                    zzse.zza(this.zzbmz, this.zzbmx);
                    return;
                }
                if (n == 2) break;
                this.zzbmy = n == 1 ? 1 : this.zzbmy + 1;
                this.zzeq(Math.min((this.zzbmy - 1) * 1000, 5000));
            }
        }
    }

    private final void execute() {
        this.zzbmx = null;
        zzse.zzb(this.zzbmz).execute(zzse.zza(this.zzbmz));
    }

    private final void finish() {
        zzse.zza(this.zzbmz, null);
    }
}

