/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import com.google.android.gms.internal.ads.zzgd;
import com.google.android.gms.internal.ads.zzgr;
import com.google.android.gms.internal.ads.zzhe;
import com.google.android.gms.internal.ads.zzhf;
import com.google.android.gms.internal.ads.zzhg;
import com.google.android.gms.internal.ads.zzhh;
import com.google.android.gms.internal.ads.zzhi;
import com.google.android.gms.internal.ads.zzhj;
import com.google.android.gms.internal.ads.zzhk;
import com.google.android.gms.internal.ads.zzhn;
import com.google.android.gms.internal.ads.zzhz;
import com.google.android.gms.internal.ads.zzkl;
import com.google.android.gms.internal.ads.zzkp;
import com.google.android.gms.internal.ads.zzkq;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class zzhd
extends zzgr {
    private final zzhi zzaeu = null;
    private final zzhh zzaev;
    private final long zzaew;
    private final int zzaex;
    private final int zzaey;
    private Surface zzaez;
    private boolean zzafa;
    private boolean zzafb;
    private long zzafc;
    private long zzafd;
    private int zzafe;
    private int zzaff;
    private int zzafg;
    private float zzafh;
    private int zzafi;
    private int zzafj;
    private float zzafk;

    public zzhd(zzhn zzhn2, int n, long l, Handler handler, zzhh zzhh2, int n2) {
        this(zzhn2, null, true, 1, 0L, null, handler, zzhh2, -1);
    }

    private zzhd(zzhn zzhn2, zzhz zzhz2, boolean bl, int n, long l, zzhi zzhi2, Handler handler, zzhh zzhh2, int n2) {
        super(zzhn2, null, true, handler, zzhh2);
        this.zzaex = 1;
        this.zzaew = 0L;
        this.zzaev = zzhh2;
        this.zzaey = -1;
        this.zzafc = -1L;
        this.zzaff = -1;
        this.zzafg = -1;
        this.zzafh = -1.0f;
        this.zzafi = -1;
        this.zzafj = -1;
        this.zzafk = -1.0f;
    }

    @Override
    protected final boolean zzas(String string2) {
        return zzkl.zzau(string2).equals("video") && super.zzas(string2);
    }

    @Override
    protected final void zzb(long l, boolean bl) {
        super.zzb(l, bl);
        this.zzafb = false;
        if (bl && this.zzaew > 0L) {
            this.zzafc = SystemClock.elapsedRealtime() * 1000L + this.zzaew;
        }
    }

    @Override
    protected final void seekTo(long l) throws zzgd {
        super.seekTo(l);
        this.zzafb = false;
        this.zzafc = -1L;
    }

    @Override
    protected final boolean isReady() {
        if (super.isReady() && (this.zzafb || !this.zzec() || this.zzeg() == 2)) {
            this.zzafc = -1L;
            return true;
        }
        if (this.zzafc == -1L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() * 1000L < this.zzafc) {
            return true;
        }
        this.zzafc = -1L;
        return false;
    }

    @Override
    protected final void onStarted() {
        super.onStarted();
        this.zzafe = 0;
        this.zzafd = SystemClock.elapsedRealtime();
    }

    @Override
    protected final void onStopped() {
        this.zzafc = -1L;
        this.zzel();
        super.onStopped();
    }

    @Override
    public final void zzdz() {
        this.zzaff = -1;
        this.zzafg = -1;
        this.zzafh = -1.0f;
        this.zzafi = -1;
        this.zzafj = -1;
        this.zzafk = -1.0f;
        super.zzdz();
    }

    @Override
    public final void zza(int n, Object object) throws zzgd {
        if (n == 1) {
            Surface surface = (Surface)object;
            zzhd zzhd2 = this;
            if (zzhd2.zzaez != surface) {
                zzhd2.zzaez = surface;
                zzhd2.zzafa = false;
                int n2 = zzhd2.getState();
                if (n2 == 2 || n2 == 3) {
                    zzhd2.zzed();
                    zzhd2.zzea();
                }
            }
            return;
        }
        super.zza(n, object);
    }

    @Override
    protected final boolean zzeb() {
        return super.zzeb() && this.zzaez != null && this.zzaez.isValid();
    }

    @Override
    protected final void zza(MediaCodec mediaCodec, String string2, MediaFormat mediaFormat, MediaCrypto mediaCrypto) {
        mediaCodec.configure(mediaFormat, this.zzaez, mediaCrypto, 0);
        mediaCodec.setVideoScalingMode(this.zzaex);
    }

    @Override
    protected final void zza(zzhk zzhk2) throws zzgd {
        super.zza(zzhk2);
        this.zzafh = zzhk2.zzado.zzaft == -1.0f ? 1.0f : zzhk2.zzado.zzaft;
    }

    @Override
    protected final void zza(zzhj zzhj2, MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top");
        this.zzaff = bl ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : mediaFormat.getInteger("width");
        this.zzafg = bl ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : mediaFormat.getInteger("height");
    }

    @Override
    protected final boolean zza(MediaCodec mediaCodec, boolean bl, zzhj zzhj2, zzhj zzhj3) {
        return zzhj3.mimeType.equals(zzhj2.mimeType) && (bl || zzhj2.width == zzhj3.width && zzhj2.height == zzhj3.height);
    }

    @Override
    protected final boolean zza(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n, boolean bl) {
        long l3;
        if (bl) {
            int n2 = n;
            MediaCodec mediaCodec2 = mediaCodec;
            zzhd zzhd2 = this;
            zzkp.beginSection("skipVideoBuffer");
            mediaCodec2.releaseOutputBuffer(n2, false);
            zzkp.endSection();
            ++zzhd2.zzadf.zzabl;
            return true;
        }
        long l4 = SystemClock.elapsedRealtime() * 1000L - l2;
        long l5 = bufferInfo.presentationTimeUs - l - l4;
        long l6 = l3 = System.nanoTime() + l5 * 1000L;
        if (l5 < -30000L) {
            int n3 = n;
            MediaCodec mediaCodec3 = mediaCodec;
            zzhd zzhd3 = this;
            zzkp.beginSection("dropVideoBuffer");
            mediaCodec3.releaseOutputBuffer(n3, false);
            zzkp.endSection();
            ++zzhd3.zzadf.zzabm;
            ++zzhd3.zzafe;
            if (zzhd3.zzafe == zzhd3.zzaey) {
                zzhd3.zzel();
            }
            return true;
        }
        if (!this.zzafb) {
            this.zza(mediaCodec, n);
            return true;
        }
        if (this.getState() != 3) {
            return false;
        }
        if (zzkq.SDK_INT >= 21) {
            if (l5 < 50000L) {
                long l7 = l6;
                int n4 = n;
                MediaCodec mediaCodec4 = mediaCodec;
                zzhd zzhd4 = this;
                zzhd4.zzej();
                zzkp.beginSection("releaseOutputBufferTimed");
                mediaCodec4.releaseOutputBuffer(n4, l7);
                zzkp.endSection();
                ++zzhd4.zzadf.zzabk;
                zzhd4.zzafb = true;
                zzhd4.zzek();
                return true;
            }
        } else if (l5 < 30000L) {
            if (l5 > 11000L) {
                try {
                    Thread.sleep((l5 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.zza(mediaCodec, n);
            return true;
        }
        return false;
    }

    private final void zza(MediaCodec mediaCodec, int n) {
        this.zzej();
        zzkp.beginSection("renderVideoBufferImmediate");
        mediaCodec.releaseOutputBuffer(n, true);
        zzkp.endSection();
        ++this.zzadf.zzabk;
        this.zzafb = true;
        this.zzek();
    }

    private final void zzej() {
        if (this.zzabq == null || this.zzaev == null || this.zzafi == this.zzaff && this.zzafj == this.zzafg && this.zzafk == this.zzafh) {
            return;
        }
        int n = this.zzaff;
        int n2 = this.zzafg;
        float f = this.zzafh;
        this.zzabq.post((Runnable)new zzhe(this, n, n2, f));
        this.zzafi = n;
        this.zzafj = n2;
        this.zzafk = f;
    }

    private final void zzek() {
        if (this.zzabq == null || this.zzaev == null || this.zzafa) {
            return;
        }
        Surface surface = this.zzaez;
        this.zzabq.post((Runnable)new zzhf(this, surface));
        this.zzafa = true;
    }

    private final void zzel() {
        if (this.zzabq == null || this.zzaev == null || this.zzafe == 0) {
            return;
        }
        long l = SystemClock.elapsedRealtime();
        int n = this.zzafe;
        long l2 = l - this.zzafd;
        this.zzabq.post((Runnable)new zzhg(this, n, l2));
        this.zzafe = 0;
        this.zzafd = l;
    }

    static /* synthetic */ zzhh zza(zzhd zzhd2) {
        return zzhd2.zzaev;
    }
}

