/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.internal.ads.zzgc;
import com.google.android.gms.internal.ads.zzgz;
import com.google.android.gms.internal.ads.zzha;
import com.google.android.gms.internal.ads.zzhb;
import com.google.android.gms.internal.ads.zzhc;
import com.google.android.gms.internal.ads.zzkq;
import java.util.HashMap;

@TargetApi(value=16)
public final class zzgx {
    private static final HashMap<zza, Pair<String, MediaCodecInfo.CodecCapabilities>> zzaeq = new HashMap();

    public static zzgc zzc(String string2, boolean bl) throws zzgz {
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = zzgx.zzd(string2, bl);
        if (pair == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = (MediaCodecInfo.CodecCapabilities)pair.second;
        return new zzgc((String)pair.first, zzkq.SDK_INT >= 19 ? codecCapabilities.isFeatureSupported("adaptive-playback") : false);
    }

    private static synchronized Pair<String, MediaCodecInfo.CodecCapabilities> zzd(String string2, boolean bl) throws zzgz {
        zza zza2 = new zza(string2, bl);
        if (zzaeq.containsKey(zza2)) {
            return zzaeq.get(zza2);
        }
        zzha zzha2 = zzkq.SDK_INT >= 21 ? new zzhc(bl) : new zzhb(null);
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = zzgx.zza(zza2, zzha2);
        if (bl && pair == null && zzkq.SDK_INT >= 21 && (pair = zzgx.zza(zza2, zzha2 = new zzhb(null))) != null) {
            String string3 = (String)pair.first;
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("MediaCodecList API didn't list secure decoder for: ").append(string2).append(". Assuming: ").append(string3).toString());
        }
        return pair;
    }

    private static Pair<String, MediaCodecInfo.CodecCapabilities> zza(zza zza2, zzha zzha2) throws zzgz {
        try {
            zzha zzha3 = zzha2;
            zza zza3 = zza2;
            String string2 = zza3.mimeType;
            int n = zzha3.getCodecCount();
            boolean bl = zzha3.zzeh();
            for (int i = 0; i < n; ++i) {
                MediaCodecInfo mediaCodecInfo = zzha3.getCodecInfoAt(i);
                String string3 = mediaCodecInfo.getName();
                if (mediaCodecInfo.isEncoder() || !string3.startsWith("OMX.") || !bl && string3.endsWith(".secure")) continue;
                String[] stringArray = mediaCodecInfo.getSupportedTypes();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string4 = stringArray[j];
                    if (!string4.equalsIgnoreCase(string2)) continue;
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string4);
                    boolean bl2 = zzha3.zza(zza3.mimeType, codecCapabilities);
                    if (!bl) {
                        zzaeq.put(zza3.zzaer ? new zza(string2, false) : zza3, (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)string3, (Object)codecCapabilities));
                        if (bl2) {
                            zzaeq.put(zza3.zzaer ? zza3 : new zza(string2, true), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)String.valueOf(string3).concat(".secure"), (Object)codecCapabilities));
                        }
                    } else {
                        zzaeq.put(zza3.zzaer == bl2 ? zza3 : new zza(string2, bl2), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)string3, (Object)codecCapabilities));
                    }
                    if (!zzaeq.containsKey(zza3)) continue;
                    return zzaeq.get(zza3);
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw new zzgz(exception, null);
        }
    }

    static final class zza {
        public final String mimeType;
        public final boolean zzaer;

        public zza(String string2, boolean bl) {
            this.mimeType = string2;
            this.zzaer = bl;
        }

        public final int hashCode() {
            int n = 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            return n * 31 + (this.zzaer ? 1231 : 1237);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != zza.class) {
                return false;
            }
            zza zza2 = (zza)object;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)zza2.mimeType) && this.zzaer == zza2.zzaer;
        }
    }
}

