/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdkw;
import com.google.android.gms.internal.ads.zzdlf;
import com.google.android.gms.internal.ads.zzdlw;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;

public final class zzdlu {
    public static String zza(zzdlf zzdlf2) throws GeneralSecurityException {
        zzdlw.zzc(zzdlf2);
        String string2 = String.valueOf((Object)zzdlf2);
        return new StringBuilder(9 + String.valueOf(string2).length()).append(string2).append("withECDSA").toString();
    }

    public static String zzb(zzdlf zzdlf2) throws GeneralSecurityException {
        switch (zzdlf2) {
            case zzhaz: {
                return "SHA-1";
            }
            case zzhba: {
                return "SHA-256";
            }
            case zzhbb: {
                return "SHA-512";
            }
        }
        String string2 = String.valueOf((Object)zzdlf2);
        throw new GeneralSecurityException(new StringBuilder(17 + String.valueOf(string2).length()).append("Unsupported hash ").append(string2).toString());
    }

    public static boolean zzavd() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static BigInteger zzx(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static byte[] zza(BigInteger bigInteger, int n) throws GeneralSecurityException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n) {
            return byArray;
        }
        if (byArray.length > n + 1) {
            throw new GeneralSecurityException("integer too large");
        }
        if (byArray.length == n + 1) {
            if (byArray[0] == 0) {
                return Arrays.copyOfRange(byArray, 1, byArray.length);
            }
            throw new GeneralSecurityException("integer too large");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        return byArray2;
    }

    public static byte[] zza(byte[] byArray, int n, zzdlf zzdlf2) throws GeneralSecurityException {
        MessageDigest messageDigest = zzdkw.zzhas.zzgt(zzdlu.zzb(zzdlf2));
        int n2 = messageDigest.getDigestLength();
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        for (int i = 0; i <= (n - 1) / n2; ++i) {
            messageDigest.reset();
            messageDigest.update(byArray);
            messageDigest.update(zzdlu.zza(BigInteger.valueOf(i), 4));
            byte[] byArray3 = messageDigest.digest();
            System.arraycopy(byArray3, 0, byArray2, n3, Math.min(byArray3.length, byArray2.length - n3));
            n3 += byArray3.length;
        }
        return byArray2;
    }
}

