/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdjr;
import com.google.android.gms.internal.ads.zzdlj;
import com.google.android.gms.internal.ads.zzdln;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzdjt
implements zzdlj {
    private static final int[] zzgye = zzdjt.zzr(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107});
    int[] zzgyf;
    private final int zzgyg;

    zzdjt(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzgyf = zzdjt.zzr(byArray);
        this.zzgyg = n;
    }

    abstract int[] zzb(int[] var1, int var2);

    abstract int zzauv();

    @Override
    public final byte[] zzo(byte[] byArray) throws GeneralSecurityException {
        if (byArray.length > Integer.MAX_VALUE - this.zzauv()) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.zzauv() + byArray.length);
        this.zza(byteBuffer, byArray);
        return byteBuffer.array();
    }

    final void zza(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byteBuffer.remaining() - this.zzauv() < byArray.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] byArray2 = zzdln.zzff(this.zzauv());
        byteBuffer.put(byArray2);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        ByteBuffer byteBuffer3 = byteBuffer;
        byte[] byArray3 = byArray2;
        zzdjt zzdjt2 = this;
        int n = byteBuffer2.remaining();
        int n2 = n / 64 + 1;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer4 = zzdjt2.zzc(byArray3, i + zzdjt2.zzgyg);
            if (i == n2 - 1) {
                zzdjr.zza(byteBuffer3, byteBuffer2, byteBuffer4, n % 64);
                continue;
            }
            zzdjr.zza(byteBuffer3, byteBuffer2, byteBuffer4, 64);
        }
    }

    final ByteBuffer zzc(byte[] byArray, int n) {
        int[] nArray = this.zzb(zzdjt.zzr(byArray), n);
        int[] nArray2 = (int[])nArray.clone();
        zzdjt.zzc(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = i;
            nArray[n2] = nArray[n2] + nArray2[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(nArray, 0, 16);
        return byteBuffer;
    }

    static void zza(int[] nArray, int[] nArray2) {
        System.arraycopy(zzgye, 0, nArray, 0, zzgye.length);
        System.arraycopy(nArray2, 0, nArray, zzgye.length, 8);
    }

    static void zzc(int[] nArray) {
        for (int i = 0; i < 10; ++i) {
            zzdjt.zza(nArray, 0, 4, 8, 12);
            zzdjt.zza(nArray, 1, 5, 9, 13);
            zzdjt.zza(nArray, 2, 6, 10, 14);
            zzdjt.zza(nArray, 3, 7, 11, 15);
            zzdjt.zza(nArray, 0, 5, 10, 15);
            zzdjt.zza(nArray, 1, 6, 11, 12);
            zzdjt.zza(nArray, 2, 7, 8, 13);
            zzdjt.zza(nArray, 3, 4, 9, 14);
        }
    }

    private static void zza(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n;
        nArray[n5] = nArray[n5] + nArray[n2];
        nArray[n4] = zzdjt.rotateLeft(nArray[n4] ^ nArray[n], 16);
        int n6 = n3;
        nArray[n6] = nArray[n6] + nArray[n4];
        nArray[n2] = zzdjt.rotateLeft(nArray[n2] ^ nArray[n3], 12);
        int n7 = n;
        nArray[n7] = nArray[n7] + nArray[n2];
        nArray[n4] = zzdjt.rotateLeft(nArray[n4] ^ nArray[n], 8);
        int n8 = n3;
        nArray[n8] = nArray[n8] + nArray[n4];
        nArray[n2] = zzdjt.rotateLeft(nArray[n2] ^ nArray[n3], 7);
    }

    private static int[] zzr(byte[] byArray) {
        IntBuffer intBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }

    private static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }
}

