/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzj;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzada;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzadu;
import com.google.android.gms.internal.ads.zzadw;
import com.google.android.gms.internal.ads.zzahn;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhb;
import com.google.android.gms.internal.ads.zzbho;
import com.google.android.gms.internal.ads.zzbhp;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbhr;
import com.google.android.gms.internal.ads.zzbhu;
import com.google.android.gms.internal.ads.zzbie;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzbio;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdoa;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzwr;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbhn
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzbha {
    private final zzbin zzekp;
    @Nullable
    private final zzdh zzekq;
    private final zzbaj zzbtd;
    private final zzj zzekr;
    private final zza zzeks;
    private final DisplayMetrics zzwb;
    private final float zzekt;
    private boolean zzeku = false;
    private boolean zzekv = false;
    private zzbhb zzekw;
    @GuardedBy(value="this")
    private zzd zzekx;
    @GuardedBy(value="this")
    private IObjectWrapper zzeky;
    @GuardedBy(value="this")
    private zzbio zzekz;
    @GuardedBy(value="this")
    private String zzaap;
    @GuardedBy(value="this")
    private boolean zzdkq;
    @GuardedBy(value="this")
    private boolean zzela;
    @GuardedBy(value="this")
    private boolean zzelb;
    @GuardedBy(value="this")
    private boolean zzelc;
    @GuardedBy(value="this")
    private Boolean zzdtt;
    @GuardedBy(value="this")
    private int zzeld;
    @GuardedBy(value="this")
    private boolean zzele = true;
    @GuardedBy(value="this")
    private boolean zzelf = false;
    @GuardedBy(value="this")
    private String zzdlz = "";
    @GuardedBy(value="this")
    private zzbhr zzelg;
    @GuardedBy(value="this")
    private boolean zzelh;
    @GuardedBy(value="this")
    private boolean zzeli;
    @GuardedBy(value="this")
    private zzadw zzelj;
    @GuardedBy(value="this")
    private zzadu zzelk;
    @GuardedBy(value="this")
    private int zzell;
    @GuardedBy(value="this")
    private int zzelm;
    private zzadf zzeln;
    private zzadf zzeeo;
    private zzadf zzelo;
    private zzadg zzelp;
    private WeakReference<View.OnClickListener> zzelq;
    @GuardedBy(value="this")
    private zzd zzelr;
    @GuardedBy(value="this")
    private boolean zzels;
    private zzazt zzelt;
    private int zzdlw = -1;
    private int zzdlv = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbfu> zzelu;
    private final WindowManager zzbtg;
    private final zzwh zzejf;

    static zzbhn zzb(Context context, zzbio zzbio2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbaj zzbaj2, zzadh zzadh2, zzj zzj2, zza zza2, zzwh zzwh2) {
        zzbin zzbin2 = new zzbin(context);
        return new zzbhn(zzbin2, zzbio2, string2, bl, bl2, zzdh2, zzbaj2, zzadh2, zzj2, zza2, zzwh2);
    }

    @VisibleForTesting
    private zzbhn(zzbin zzbin2, zzbio zzbio2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbaj zzbaj2, zzadh zzadh2, zzj zzj2, zza zza2, zzwh zzwh2) {
        super((Context)zzbin2);
        this.zzekp = zzbin2;
        this.zzekz = zzbio2;
        this.zzaap = string2;
        this.zzelb = bl;
        this.zzeld = -1;
        this.zzekq = zzdh2;
        this.zzbtd = zzbaj2;
        this.zzekr = zzj2;
        this.zzeks = zza2;
        this.zzbtg = (WindowManager)this.getContext().getSystemService("window");
        zzk.zzlg();
        this.zzwb = zzaxj.zza(this.zzbtg);
        this.zzekt = this.zzwb.density;
        this.zzejf = zzwh2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzaxa.zzc((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzk.zzlg().zza((Context)zzbin2, zzbaj2.zzbsy, webSettings);
        zzk.zzli().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzabn();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            this.addJavascriptInterface(zzbhu.zzc(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzelt = new zzazt(this.zzekp.zzyd(), (View)this, this, null);
        zzadh zzadh3 = zzadh2;
        zzbhn zzbhn2 = this;
        zzbhn2.zzabr();
        zzbhn2.zzelp = new zzadg(new zzadh(true, "make_wv", zzbhn2.zzaap));
        zzbhn2.zzelp.zzqw().zzc(zzadh3);
        zzbhn2.zzeeo = zzada.zzb(zzbhn2.zzelp.zzqw());
        zzbhn2.zzelp.zza("native:view_create", zzbhn2.zzeeo);
        zzbhn2.zzelo = null;
        zzbhn2.zzeln = null;
        zzk.zzli().zzay((Context)zzbin2);
        zzk.zzlk().zzuz();
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzbhb) {
            this.zzekw = (zzbhb)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zza zzye() {
        return this.zzeks;
    }

    private final boolean zzabk() {
        int n;
        int n2;
        if (!this.zzekw.zzaay() && !this.zzekw.zzaaz()) {
            return false;
        }
        zzyr.zzpa();
        int n3 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.widthPixels);
        zzyr.zzpa();
        int n4 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.heightPixels);
        Activity activity = this.zzekp.zzyd();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzk.zzlg();
            int[] nArray = zzaxj.zzd(activity);
            zzyr.zzpa();
            n2 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)nArray[0]);
            zzyr.zzpa();
            n = zzazu.zzb((DisplayMetrics)this.zzwb, (int)nArray[1]);
        }
        if (this.zzdlv == n3 && this.zzdlw == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdlv != n3 || this.zzdlw != n4;
        this.zzdlv = n3;
        this.zzdlw = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzaqc(this).zza(n3, n4, n2, n, this.zzwb.density, this.zzbtg.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzk.zzlg().zzi(map);
        }
        catch (JSONException jSONException) {
            zzaxa.zzep((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzaxa.zzer((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    private final synchronized void zzfc(String string2) {
        if (!this.isDestroyed()) {
            this.loadUrl(string2);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                zzk.zzlk().zza(throwable, "AdWebViewImpl.loadUrl");
                zzaxa.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
                return;
            }
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final synchronized void zzfd(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            zzk.zzlk().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
            zzaxa.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        if (!this.isDestroyed()) {
            zzaci zzaci2 = zzact.zzcol;
            String string5 = (Boolean)zzyr.zzpe().zzd(zzaci2) != false ? zzbie.zzf(string3, zzbie.zzabt()) : string3;
            super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @TargetApi(value=19)
    private final synchronized void zza(String string2, ValueCallback<String> valueCallback) {
        if (!this.isDestroyed()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final void zzfe(String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            if (this.zzux() == null) {
                this.zzabl();
            }
            if (this.zzux().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
                return;
            }
            String string3 = String.valueOf(string2);
            this.zzfc(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            return;
        }
        String string4 = String.valueOf(string2);
        this.zzfc(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
    }

    @Override
    public final void zzco(String string2) {
        this.zzfe(string2);
    }

    private final synchronized void zzabl() {
        this.zzdtt = zzk.zzlk().zzux();
        if (this.zzdtt == null) {
            try {
                String string2 = "(function(){})()";
                this.evaluateJavascript(string2, null);
                this.zza(true);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.zza(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void zza(Boolean bl) {
        zzbhn zzbhn2 = this;
        synchronized (zzbhn2) {
            this.zzdtt = bl;
        }
        zzk.zzlk().zza(bl);
    }

    @VisibleForTesting
    private final synchronized Boolean zzux() {
        return this.zzdtt;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzbhn zzbhn2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzbhn2.zzfe(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzaxa.zzdp((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzfe(stringBuilder.toString());
    }

    @Override
    public final void zzaab() {
        this.zzabm();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtd.zzbsy);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzdi(int n) {
        if (n == 0) {
            zzbhn zzbhn2 = this;
            zzada.zza(zzbhn2.zzelp.zzqw(), zzbhn2.zzeeo, "aebb2");
        }
        this.zzabm();
        if (this.zzelp.zzqw() != null) {
            this.zzelp.zzqw().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzbtd.zzbsy);
        this.zza("onhide", hashMap);
    }

    private final void zzabm() {
        zzada.zza(this.zzelp.zzqw(), this.zzeeo, "aeh2");
    }

    @Override
    public final void zztl() {
        if (this.zzeln == null) {
            zzada.zza(this.zzelp.zzqw(), this.zzeeo, "aes2");
            this.zzeln = zzada.zzb(this.zzelp.zzqw());
            this.zzelp.zza("native:view_show", this.zzeln);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtd.zzbsy);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzaac() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzk.zzll().zzpr()));
        hashMap.put("app_volume", String.valueOf(zzk.zzll().zzpq()));
        hashMap.put("device_volume", String.valueOf(zzayb.zzba(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        this.zza("onCacheAccessComplete", hashMap);
    }

    @Override
    public final synchronized zzd zzaae() {
        return this.zzekx;
    }

    @Override
    public final synchronized IObjectWrapper zzaam() {
        return this.zzeky;
    }

    @Override
    public final synchronized zzd zzaaf() {
        return this.zzelr;
    }

    @Override
    public final synchronized zzbio zzaag() {
        return this.zzekz;
    }

    @Override
    public final synchronized String zzaah() {
        return this.zzaap;
    }

    @Override
    public final WebViewClient zzaaj() {
        return this.zzekw;
    }

    @Override
    public final synchronized boolean zzaak() {
        return this.zzdkq;
    }

    @Override
    public final zzdh zzaal() {
        return this.zzekq;
    }

    @Override
    public final zzbaj zzyh() {
        return this.zzbtd;
    }

    @Override
    public final synchronized boolean zzaan() {
        return this.zzelb;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzk.zzlg();
            zzaxj.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzaxa.zzdp((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzekw.zzaaz()) {
            zzbhn zzbhn2 = this;
            synchronized (zzbhn2) {
                if (this.zzelj != null) {
                    this.zzelj.zzc(motionEvent);
                }
            }
        } else if (this.zzekq != null) {
            this.zzekq.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzelb || this.zzekz.zzaby()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekz.zzaca()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekz.zzabz()) {
            zzaci zzaci2 = zzact.zzcsl;
            if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbhr zzbhr2 = this.zzyb();
            if (zzbhr2 != null) {
                f = zzbhr2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzekz.isFluid()) {
            int n11;
            Object object = zzact.zzcso;
            if (((Boolean)zzyr.zzpe().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbhp((zzbhn)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            this.zzfe(string2);
            float f = this.zzwb.density;
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzelm) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzelm * f);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzekz.zzabx()) {
            this.setMeasuredDimension(this.zzwb.widthPixels, this.zzwb.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzekz.widthPixels > n17 || this.zzekz.heightPixels > n18 ? 1 : 0;
        zzaci zzaci3 = zzact.zzcvh;
        if (((Boolean)zzyr.zzpe().zzd(zzaci3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzekz.widthPixels / this.zzekt > (float)n17 / this.zzekt) && !((float)this.zzekz.heightPixels / this.zzekt > (float)n18 / this.zzekt) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzekz.widthPixels / this.zzekt);
            int n21 = (int)((float)this.zzekz.heightPixels / this.zzekt);
            int n22 = (int)((float)n14 / this.zzekt);
            int n23 = (int)((float)n16 / this.zzekt);
            zzaxa.zzep((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            if (!this.zzeku) {
                this.zzejf.zza(zzwj.zza.zzb.zzbyx);
                this.zzeku = true;
                return;
            }
        } else {
            if (this.getVisibility() != 8) {
                this.setVisibility(0);
            }
            if (!this.zzekv) {
                this.zzejf.zza(zzwj.zza.zzb.zzbyy);
                this.zzekv = true;
            }
            this.setMeasuredDimension(this.zzekz.widthPixels, this.zzekz.heightPixels);
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzabk();
        zzd zzd2 = this.zzaae();
        if (zzd2 != null && bl) {
            zzd2.zztk();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzekx = zzd2;
    }

    @Override
    public final synchronized void zzam(IObjectWrapper iObjectWrapper) {
        this.zzeky = iObjectWrapper;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzelr = zzd2;
    }

    @Override
    public final synchronized void zza(zzbio zzbio2) {
        this.zzekz = zzbio2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzelb;
        this.zzelb = bl;
        this.zzabn();
        if (bl2) {
            new zzaqc(this).zzdj(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzaar() {
        this.zzelt.zzwt();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzelt.onAttachedToWindow();
        }
        boolean bl = this.zzelh;
        if (this.zzekw != null && this.zzekw.zzaaz()) {
            bl = true;
            if (!this.zzeli) {
                this.zzekw.zzaba();
                this.zzekw.zzabb();
                this.zzeli = true;
            }
            this.zzabk();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbhn zzbhn2 = this;
        synchronized (zzbhn2) {
            if (!this.isDestroyed()) {
                this.zzelt.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzeli && this.zzekw != null && this.zzekw.zzaaz() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzekw.zzaba();
                this.zzekw.zzabb();
                this.zzeli = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbn(Context context) {
        this.zzekp.setBaseContext(context);
        this.zzelt.zzh(this.zzekp.zzyd());
    }

    @Override
    public final synchronized void zzaf(boolean bl) {
        if (this.zzekx != null) {
            this.zzekx.zza(this.zzekw.zzaay(), bl);
            return;
        }
        this.zzdkq = bl;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzeld = n;
        if (this.zzekx != null) {
            this.zzekx.setRequestedOrientation(this.zzeld);
        }
    }

    @Override
    public final Activity zzyd() {
        return this.zzekp.zzyd();
    }

    @Override
    public final Context zzaad() {
        return this.zzekp.zzaad();
    }

    private final synchronized void zzabn() {
        if (this.zzelb || this.zzekz.zzabx()) {
            zzaxa.zzdp((String)"Enabling hardware acceleration on an overlay.");
            this.zzabp();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzaxa.zzdp((String)"Disabling hardware acceleration on an AdView.");
            this.zzabo();
            return;
        }
        zzaxa.zzdp((String)"Enabling hardware acceleration on an AdView.");
        this.zzabp();
    }

    private final synchronized void zzabo() {
        if (!this.zzelc) {
            zzk.zzli();
            this.setLayerType(1, null);
        }
        this.zzelc = true;
    }

    private final synchronized void zzabp() {
        if (this.zzelc) {
            zzk.zzli();
            this.setLayerType(0, null);
        }
        this.zzelc = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzabr();
        this.zzelt.zzwu();
        if (this.zzekx != null) {
            this.zzekx.close();
            this.zzekx.onDestroy();
            this.zzekx = null;
        }
        this.zzeky = null;
        this.zzekw.reset();
        if (this.zzela) {
            return;
        }
        zzk.zzmc();
        zzbft.zzc(this);
        this.zzabq();
        this.zzela = true;
        zzaxa.zzds("Initiating WebView self destruct sequence in 3...");
        zzaxa.zzds("Loading blank page in WebView, 2...");
        this.zzfd("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzbhn zzbhn2 = this;
            synchronized (zzbhn2) {
                if (!this.zzela) {
                    this.zzekw.reset();
                    zzk.zzmc();
                    zzbft.zzc(this);
                    this.zzabq();
                    this.zzva();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzaao() {
        zzaxa.zzds("Destroying WebView!");
        this.zzva();
        zzaxj.zzdvx.post((Runnable)new zzbhq(this));
    }

    private final synchronized void zzva() {
        if (!this.zzels) {
            this.zzels = true;
            zzk.zzlk().zzva();
        }
    }

    @Override
    public final synchronized boolean isDestroyed() {
        return this.zzela;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public final void zzaas() {
        if (this.zzelo == null) {
            this.zzelo = zzada.zzb(this.zzelp.zzqw());
            this.zzelp.zza("native:view_load", this.zzelo);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzaav() {
        zzaxa.zzds("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzekw.zzat(bl);
    }

    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzele = bl;
    }

    @Override
    public final synchronized boolean zzaap() {
        return this.zzele;
    }

    @Override
    public final synchronized void zzlc() {
        this.zzelf = true;
        if (this.zzekr != null) {
            this.zzekr.zzlc();
        }
    }

    @Override
    public final synchronized void zzld() {
        this.zzelf = false;
        if (this.zzekr != null) {
            this.zzekr.zzld();
        }
    }

    private final synchronized void zzabq() {
        if (this.zzelu != null) {
            Iterator<zzbfu> iterator = this.zzelu.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzelu = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbfu zzbfu2) {
        if (this.zzelu == null) {
            this.zzelu = new HashMap<String, zzbfu>();
        }
        this.zzelu.put(string2, zzbfu2);
    }

    @Override
    public final synchronized zzbfu zzet(String string2) {
        if (this.zzelu == null) {
            return null;
        }
        return this.zzelu.get(string2);
    }

    @Override
    public final synchronized String zzyf() {
        return this.zzdlz;
    }

    @Override
    public final zzbcx zzya() {
        return null;
    }

    @Override
    public final synchronized void zzyk() {
        if (this.zzelk != null) {
            this.zzelk.zzre();
        }
    }

    @Override
    public final synchronized void zza(zzadu zzadu2) {
        this.zzelk = zzadu2;
    }

    @Override
    public final zzadf zzyc() {
        return this.zzeeo;
    }

    @Override
    public final zzadg zzyg() {
        return this.zzelp;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzelq = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzadw zzadw2) {
        this.zzelj = zzadw2;
    }

    @Override
    public final synchronized zzadw zzaat() {
        return this.zzelj;
    }

    @Override
    public final synchronized zzbhr zzyb() {
        return this.zzelg;
    }

    @Override
    public final synchronized void zza(zzbhr zzbhr2) {
        if (this.zzelg != null) {
            zzaxa.zzen((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzelg = zzbhr2;
    }

    @Override
    public final synchronized boolean zzaaq() {
        return this.zzell > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzell += bl ? 1 : -1;
        if (this.zzell <= 0 && this.zzekx != null) {
            this.zzekx.zztn();
        }
    }

    private final void zzabr() {
        if (this.zzelp == null) {
            return;
        }
        zzadh zzadh2 = this.zzelp.zzqw();
        if (zzadh2 != null && zzk.zzlk().zzuw() != null) {
            zzk.zzlk().zzuw().zza(zzadh2);
        }
    }

    @Override
    public final void zzaau() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzekw.zzao(bl);
    }

    @Override
    public final void zztm() {
        zzd zzd2 = this.zzaae();
        if (zzd2 != null) {
            zzd2.zztm();
        }
    }

    @Override
    public final int zzyi() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzyj() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzekw.zza(zzc2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzekw.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzekw.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzekw.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzub zzub2) {
        zzbhn zzbhn2 = this;
        synchronized (zzbhn2) {
            this.zzelh = zzub2.zzbtl;
        }
        this.zzav(zzub2.zzbtl);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzahn<? super zzbha> zzahn2) {
        if (this.zzekw != null) {
            this.zzekw.zza(string2, zzahn2);
        }
    }

    @Override
    public final void zzb(String string2, zzahn<? super zzbha> zzahn2) {
        if (this.zzekw != null) {
            this.zzekw.zzb(string2, zzahn2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzahn<? super zzbha>> predicate) {
        if (this.zzekw != null) {
            this.zzekw.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzejf.zza(new zzbho(bl, n));
        this.zzejf.zza(zzwj.zza.zzb.zzbyz);
        return true;
    }

    @Override
    public final boolean zzaaw() {
        return false;
    }

    @Override
    public final /* synthetic */ zzbij zzaai() {
        return this.zzekw;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zzxl zzxl2) {
        zzwr.zzv.zza zza2 = zzwr.zzv.zzop();
        if (zza2.zzoo() != bl) {
            zza2.zzr(bl);
        }
        zza2.zzcm(n);
        zzxl2.zzcfo = (zzwr.zzv)((zzdoa)zza2.zzaya());
    }

    static /* synthetic */ int zza(zzbhn zzbhn2) {
        return zzbhn2.zzelm;
    }

    static /* synthetic */ int zza(zzbhn zzbhn2, int n) {
        zzbhn2.zzelm = n;
        return zzbhn2.zzelm;
    }

    static /* synthetic */ void zzb(zzbhn zzbhn2) {
        super.destroy();
    }
}

