/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbcs;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbdi;
import com.google.android.gms.internal.ads.zzyr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzare
@ParametersAreNonnullByDefault
public final class zzbcr
extends FrameLayout
implements zzbco {
    private final zzbdg zzebv;
    private final FrameLayout zzebw;
    private final zzadh zzebx;
    private final zzbdi zzeby;
    private final long zzebz;
    @Nullable
    private zzbcp zzeca;
    private boolean zzecb;
    private boolean zzecc;
    private boolean zzecd;
    private boolean zzece;
    private long zzecf;
    private long zzecg;
    private String zzech;
    private String[] zzeci;
    private Bitmap zzecj;
    private ImageView zzeck;
    private boolean zzecl;

    public static void zzb(zzbdg zzbdg2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzbdg2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbdg zzbdg2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzbdg2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbdg zzbdg2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzbdg2.zza("onVideoEvent", hashMap);
    }

    public zzbcr(Context context, zzbdg zzbdg2, int n, boolean bl, zzadh zzadh2, zzbdf zzbdf2) {
        super(context);
        zzaci zzaci2;
        this.zzebv = zzbdg2;
        this.zzebx = zzadh2;
        this.zzebw = new FrameLayout(context);
        this.addView((View)this.zzebw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)zzbdg2.zzye());
        this.zzeca = zzbdg2.zzye().zzbqt.zza(context, zzbdg2, n, bl, zzadh2, zzbdf2);
        if (this.zzeca != null) {
            this.zzebw.addView((View)this.zzeca, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzaci2 = zzact.zzcme;
            if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                this.zzxs();
            }
        }
        this.zzeck = new ImageView(context);
        zzaci2 = zzact.zzcmi;
        this.zzebz = (Long)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcmg;
        this.zzece = (Boolean)zzyr.zzpe().zzd(zzaci2);
        if (this.zzebx != null) {
            this.zzebx.zzh("spinner_used", this.zzece ? "1" : "0");
        }
        this.zzeby = new zzbdi(this);
        if (this.zzeca != null) {
            this.zzeca.zza(this);
        }
        if (this.zzeca == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzebw.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzc(String string2, String[] stringArray) {
        this.zzech = string2;
        this.zzeci = stringArray;
    }

    public final void zza(float f, float f2) {
        if (this.zzeca != null) {
            this.zzeca.zza(f, f2);
        }
    }

    public final void zzfr() {
        if (this.zzeca == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzech)) {
            this.zzeca.zzb(this.zzech, this.zzeci);
            return;
        }
        this.zzd("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzeca == null) {
            return;
        }
        this.zzeca.pause();
    }

    public final void play() {
        if (this.zzeca == null) {
            return;
        }
        this.zzeca.play();
    }

    public final void seekTo(int n) {
        if (this.zzeca == null) {
            return;
        }
        this.zzeca.seekTo(n);
    }

    public final void zzxq() {
        if (this.zzeca == null) {
            return;
        }
        zzbcp zzbcp2 = this.zzeca;
        zzbcp2.zzebu.setMuted(true);
        zzbcp2.zzxk();
    }

    public final void zzxr() {
        if (this.zzeca == null) {
            return;
        }
        zzbcp zzbcp2 = this.zzeca;
        zzbcp2.zzebu.setMuted(false);
        zzbcp2.zzxk();
    }

    public final void setVolume(float f) {
        if (this.zzeca == null) {
            return;
        }
        float f2 = f;
        zzbcp zzbcp2 = this.zzeca;
        zzbcp2.zzebu.setVolume(f2);
        zzbcp2.zzxk();
    }

    public final void zzcy(int n) {
        this.zzeca.zzcy(n);
    }

    public final void zzcz(int n) {
        this.zzeca.zzcz(n);
    }

    public final void zzda(int n) {
        this.zzeca.zzda(n);
    }

    public final void zzdb(int n) {
        this.zzeca.zzdb(n);
    }

    public final void zzdc(int n) {
        this.zzeca.zzdc(n);
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzeca == null) {
            return;
        }
        this.zzeca.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzxs() {
        if (this.zzeca == null) {
            return;
        }
        Context context = this.zzeca.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzeca.zzxg());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzebw.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzebw.bringChildToFront((View)textView);
    }

    @Override
    public final void zzxl() {
        this.zzeby.resume();
        zzaxj.zzdvx.post((Runnable)new zzbcu(this));
    }

    @Override
    public final void zzhd() {
        if (this.zzeca == null) {
            return;
        }
        if (this.zzecg == 0L) {
            float f = (float)this.zzeca.getDuration() / 1000.0f;
            int n = this.zzeca.getVideoWidth();
            int n2 = this.zzeca.getVideoHeight();
            this.zzd("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzxm() {
        zzbcr zzbcr2 = this;
        if (zzbcr2.zzebv.zzyd() != null && !zzbcr2.zzecc) {
            WindowManager.LayoutParams layoutParams = zzbcr2.zzebv.zzyd().getWindow().getAttributes();
            boolean bl = zzbcr2.zzecd = (layoutParams.flags & 0x80) != 0;
            if (!zzbcr2.zzecd) {
                zzbcr2.zzebv.zzyd().getWindow().addFlags(128);
                zzbcr2.zzecc = true;
            }
        }
        this.zzecb = true;
    }

    @Override
    public final void onPaused() {
        this.zzd("pause", new String[0]);
        this.zzxv();
        this.zzecb = false;
    }

    @Override
    public final void zzxn() {
        this.zzd("ended", new String[0]);
        this.zzxv();
    }

    @Override
    public final void zzl(String string2, @Nullable String string3) {
        this.zzd("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzxo() {
        zzbcr zzbcr2 = this;
        if (zzbcr2.zzecl && zzbcr2.zzecj != null && !zzbcr2.zzxu()) {
            zzbcr2.zzeck.setImageBitmap(zzbcr2.zzecj);
            zzbcr2.zzeck.invalidate();
            zzbcr2.zzebw.addView((View)zzbcr2.zzeck, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzbcr2.zzebw.bringChildToFront((View)zzbcr2.zzeck);
        }
        this.zzeby.pause();
        this.zzecg = this.zzecf;
        zzaxj.zzdvx.post((Runnable)new zzbcv(this));
    }

    public final void destroy() {
        this.zzeby.pause();
        if (this.zzeca != null) {
            this.zzeca.stop();
        }
        this.zzxv();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzeby.pause();
            if (this.zzeca != null) {
                zzbcp zzbcp2;
                zzbcp zzbcp3 = zzbcp2 = this.zzeca;
                zzbcp3.getClass();
                zzbbn.zzeag.execute(zzbcs.zza(zzbcp3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzxt() {
        if (this.zzeca == null) {
            return;
        }
        long l = this.zzeca.getCurrentPosition();
        if (this.zzecf != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zzd("timeupdate", "time", String.valueOf(f));
            this.zzecf = l;
        }
    }

    @Override
    public final void zzxp() {
        zzbcr zzbcr2;
        if (this.zzecb && (zzbcr2 = this).zzxu()) {
            zzbcr2.zzebw.removeView((View)zzbcr2.zzeck);
        }
        zzbcr2 = this;
        if (zzbcr2.zzecj != null) {
            long l = zzk.zzln().elapsedRealtime();
            if (zzbcr2.zzeca.getBitmap(zzbcr2.zzecj) != null) {
                zzbcr2.zzecl = true;
            }
            long l2 = zzk.zzln().elapsedRealtime() - l;
            if (zzaxa.zzvj()) {
                zzaxa.zzds(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzbcr2.zzebz) {
                zzaxa.zzep((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzbcr2.zzece = false;
                zzbcr2.zzecj = null;
                if (zzbcr2.zzebx != null) {
                    zzbcr2.zzebx.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzk(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzbcr zzbcr2 = this;
        if (zzbcr2.zzece) {
            zzaci zzaci2 = zzact.zzcmh;
            n4 = Math.max(n4 / (Integer)zzyr.zzpe().zzd(zzaci2), 1);
            zzaci2 = zzact.zzcmh;
            n3 = Math.max(n3 / (Integer)zzyr.zzpe().zzd(zzaci2), 1);
            if (zzbcr2.zzecj == null || zzbcr2.zzecj.getWidth() != n4 || zzbcr2.zzecj.getHeight() != n3) {
                zzbcr2.zzecj = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzbcr2.zzecl = false;
            }
        }
    }

    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzeby.resume();
        } else {
            this.zzeby.pause();
            this.zzecg = this.zzecf;
        }
        zzaxj.zzdvx.post((Runnable)new zzbct(this, bl));
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zzeby.resume();
            bl = true;
        } else {
            this.zzeby.pause();
            this.zzecg = this.zzecf;
            bl = false;
        }
        zzaxj.zzdvx.post((Runnable)new zzbcw(this, bl));
    }

    private final boolean zzxu() {
        return this.zzeck.getParent() != null;
    }

    private final void zzd(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzebv.zza("onVideoEvent", hashMap);
    }

    private final void zzxv() {
        if (this.zzebv.zzyd() == null) {
            return;
        }
        if (this.zzecc && !this.zzecd) {
            this.zzebv.zzyd().getWindow().clearFlags(128);
            this.zzecc = false;
        }
    }

    final /* synthetic */ void zzan(boolean bl) {
        this.zzd("windowFocusChanged", "hasWindowFocus", String.valueOf(bl));
    }

    static /* synthetic */ void zza(zzbcr zzbcr2, String string2, String[] stringArray) {
        zzbcr2.zzd(string2, stringArray);
    }
}

