/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbcf;
import com.google.android.gms.internal.ads.zzbcg;
import com.google.android.gms.internal.ads.zzbch;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbck;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdh;
import com.google.android.gms.internal.ads.zzvt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzare
@TargetApi(value=14)
public final class zzbce
extends zzbcp
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzeax = new HashMap<Integer, String>();
    private final zzbdh zzeay;
    private final boolean zzeaz;
    private int zzeba = 0;
    private int zzebb = 0;
    private MediaPlayer zzebc;
    private Uri zzebd;
    private int zzebe;
    private int zzebf;
    private int zzebg;
    private int zzebh;
    private int zzebi;
    private zzbde zzebj;
    private boolean zzebk;
    private int zzebl;
    private zzbco zzebm;

    public zzbce(Context context, boolean bl, boolean bl2, zzbdf zzbdf2, zzbdh zzbdh2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzeay = zzbdh2;
        this.zzebk = bl;
        this.zzeaz = bl2;
        this.zzeay.zzb(this);
    }

    @Override
    public final String zzxg() {
        String string2 = String.valueOf(this.zzebk ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzbco zzbco2) {
        this.zzebm = zzbco2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzbce zzbce2 = this;
        zzvt zzvt2 = zzvt.zze(uri);
        if (zzvt2 == null || zzvt2.url != null) {
            zzbce2.zzebd = zzvt2 == null ? uri : Uri.parse((String)zzvt2.url);
            zzbce2.zzebl = 0;
            zzbce2.zzxh();
            zzbce2.requestLayout();
            zzbce2.invalidate();
        }
    }

    @Override
    public final void stop() {
        zzaxa.zzds("AdMediaPlayerView stop");
        if (this.zzebc != null) {
            this.zzebc.stop();
            this.zzebc.release();
            this.zzebc = null;
            this.zzcw(0);
            this.zzebb = 0;
        }
        this.zzeay.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzaxa.zzds(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzebe = mediaPlayer.getVideoWidth();
        this.zzebf = mediaPlayer.getVideoHeight();
        if (this.zzebe != 0 && this.zzebf != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzaxa.zzds("AdMediaPlayerView prepared");
        this.zzcw(2);
        this.zzeay.zzhd();
        zzaxj.zzdvx.post((Runnable)new zzbcg(this));
        this.zzebe = mediaPlayer.getVideoWidth();
        this.zzebf = mediaPlayer.getVideoHeight();
        if (this.zzebl != 0) {
            ((zzbcp)this).seekTo(this.zzebl);
        }
        this.zzxi();
        int n = this.zzebe;
        int n2 = this.zzebf;
        zzaxa.zzeo((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzebb == 3) {
            ((zzbcp)this).play();
        }
        ((zzbcp)this).zzxk();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzaxa.zzds("AdMediaPlayerView completion");
        this.zzcw(5);
        this.zzebb = 5;
        zzaxj.zzdvx.post((Runnable)new zzbch(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeax.get(n);
        String string3 = zzeax.get(n2);
        zzaxa.zzds(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeax.get(n);
        String string3 = zzeax.get(n2);
        zzaxa.zzep((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzcw(-1);
        this.zzebb = -1;
        zzaxj.zzdvx.post((Runnable)new zzbci(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzebg = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzaxa.zzds("AdMediaPlayerView surface created");
        this.zzxh();
        zzaxj.zzdvx.post((Runnable)new zzbcj(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzaxa.zzds("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzebb == 3;
        boolean bl3 = bl = this.zzebe == n && this.zzebf == n2;
        if (this.zzebc != null && bl2 && bl) {
            if (this.zzebl != 0) {
                ((zzbcp)this).seekTo(this.zzebl);
            }
            ((zzbcp)this).play();
        }
        if (this.zzebj != null) {
            this.zzebj.zzm(n, n2);
        }
        zzaxj.zzdvx.post((Runnable)new zzbck(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzaxa.zzds("AdMediaPlayerView surface destroyed");
        if (this.zzebc != null && this.zzebl == 0) {
            this.zzebl = this.zzebc.getCurrentPosition();
        }
        if (this.zzebj != null) {
            this.zzebj.zzxx();
        }
        zzaxj.zzdvx.post((Runnable)new zzbcl(this));
        this.zzam(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeay.zzc(this);
        this.zzebt.zza(surfaceTexture, this.zzebm);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzaxa.zzds(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzaxj.zzdvx.post((Runnable)new zzbcf(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzbce.getDefaultSize((int)this.zzebe, (int)n);
        int n4 = zzbce.getDefaultSize((int)this.zzebf, (int)n2);
        if (this.zzebe > 0 && this.zzebf > 0 && this.zzebj == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzebe * n4 < n3 * this.zzebf) {
                    n3 = n4 * this.zzebe / this.zzebf;
                } else if (this.zzebe * n4 > n3 * this.zzebf) {
                    n4 = n3 * this.zzebf / this.zzebe;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzebf / this.zzebe;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzebe / this.zzebf;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzebe;
                n4 = this.zzebf;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzebe / this.zzebf;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzebf / this.zzebe;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebj != null) {
            this.zzebj.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebh > 0 && this.zzebh != n3 || this.zzebi > 0 && this.zzebi != n4) {
                this.zzxi();
            }
            this.zzebh = n3;
            this.zzebi = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzxh() {
        zzaxa.zzds("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzebd == null || surfaceTexture == null) {
            return;
        }
        this.zzam(false);
        try {
            Surface surface;
            zzk.zzlw();
            this.zzebc = new MediaPlayer();
            this.zzebc.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzebc.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzebc.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzebc.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzebc.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzebc.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzebg = 0;
            if (this.zzebk) {
                this.zzebj = new zzbde(this.getContext());
                this.zzebj.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzebj.start();
                surface = this.zzebj.zzxy();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzebj.zzxx();
                    this.zzebj = null;
                }
            }
            this.zzebc.setDataSource(this.getContext(), this.zzebd);
            zzk.zzlx();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzebc.setSurface(surface);
            this.zzebc.setAudioStreamType(3);
            this.zzebc.setScreenOnWhilePlaying(true);
            this.zzebc.prepareAsync();
            this.zzcw(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzebd);
            zzaxa.zzd((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzebc, 1, 0);
            return;
        }
    }

    private final void zzxi() {
        if (!this.zzeaz) {
            return;
        }
        if (this.zzxj() && this.zzebc.getCurrentPosition() > 0 && this.zzebb != 3) {
            zzaxa.zzds("AdMediaPlayerView nudging MediaPlayer");
            this.zzd(0.0f);
            this.zzebc.start();
            int n = this.zzebc.getCurrentPosition();
            long l = zzk.zzln().currentTimeMillis();
            while (this.zzxj() && this.zzebc.getCurrentPosition() == n && zzk.zzln().currentTimeMillis() - l <= 250L) {
            }
            this.zzebc.pause();
            ((zzbcp)this).zzxk();
        }
    }

    private final void zzam(boolean bl) {
        zzaxa.zzds("AdMediaPlayerView release");
        if (this.zzebj != null) {
            this.zzebj.zzxx();
            this.zzebj = null;
        }
        if (this.zzebc != null) {
            this.zzebc.reset();
            this.zzebc.release();
            this.zzebc = null;
            this.zzcw(0);
            if (bl) {
                this.zzebb = 0;
                this.zzebb = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzaxa.zzds("AdMediaPlayerView play");
        if (this.zzxj()) {
            this.zzebc.start();
            this.zzcw(3);
            this.zzebt.zzxm();
            zzaxj.zzdvx.post((Runnable)new zzbcm(this));
        }
        this.zzebb = 3;
    }

    @Override
    public final void pause() {
        zzaxa.zzds("AdMediaPlayerView pause");
        if (this.zzxj() && this.zzebc.isPlaying()) {
            this.zzebc.pause();
            this.zzcw(4);
            zzaxj.zzdvx.post((Runnable)new zzbcn(this));
        }
        this.zzebb = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzxj()) {
            return this.zzebc.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzxj()) {
            return this.zzebc.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzaxa.zzds(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzxj()) {
            this.zzebc.seekTo(n);
            this.zzebl = 0;
            return;
        }
        this.zzebl = n;
    }

    private final boolean zzxj() {
        return this.zzebc != null && this.zzeba != -1 && this.zzeba != 0 && this.zzeba != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebj != null) {
            this.zzebj.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzebc != null) {
            return this.zzebc.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzebc != null) {
            return this.zzebc.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzxk() {
        this.zzd(this.zzebu.getVolume());
    }

    private final void zzd(float f) {
        if (this.zzebc != null) {
            try {
                this.zzebc.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzaxa.zzep((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzcw(int n) {
        if (n == 3) {
            this.zzeay.zzyl();
            this.zzebu.zzyl();
        } else if (this.zzeba == 3) {
            this.zzeay.zzym();
            this.zzebu.zzym();
        }
        this.zzeba = n;
    }

    final /* synthetic */ void zzcx(int n) {
        if (this.zzebm != null) {
            this.zzebm.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzbco zza(zzbce zzbce2) {
        return zzbce2.zzebm;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzeax.put(-1004, "MEDIA_ERROR_IO");
            zzeax.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzeax.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzeax.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzeax.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzeax.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzeax.put(1, "MEDIA_ERROR_UNKNOWN");
        zzeax.put(1, "MEDIA_INFO_UNKNOWN");
        zzeax.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzeax.put(701, "MEDIA_INFO_BUFFERING_START");
        zzeax.put(702, "MEDIA_INFO_BUFFERING_END");
        zzeax.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzeax.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzeax.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzeax.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzeax.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

