/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzadr;
import com.google.android.gms.internal.ads.zzasf;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzyr;
import java.util.Locale;

public final class zzasg {
    private int zzdpg;
    private boolean zzdpo;
    private boolean zzdpp;
    private int zzdpt;
    private int zzdpx;
    private int zzdpy;
    private String zzdpj;
    private int zzdpu;
    private int zzdpv;
    private int zzdpw;
    private boolean zzdqb;
    private int zzdqc;
    private double zzdpz;
    private boolean zzdqa;
    private String zzdqd;
    private String zzdqe;
    private boolean zzdph;
    private boolean zzdpi;
    private String zzdpk;
    private boolean zzdpl;
    private final boolean zzdpm;
    private boolean zzdpn;
    private String zzdpq;
    private String zzdpr;
    private float zzbty;
    private int zzdlv;
    private int zzdlw;
    private String zzdps;
    private boolean zzdqf;

    public zzasg(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzp(context);
        this.zzq(context);
        this.zzr(context);
        Locale locale = Locale.getDefault();
        this.zzdph = zzasg.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzdpi = zzasg.zza(packageManager, "http://www.google.com") != null;
        this.zzdpk = locale.getCountry();
        zzyr.zzpa();
        this.zzdpl = zzazu.zzwx();
        this.zzdpm = DeviceProperties.isLatchsky((Context)context);
        this.zzdpn = DeviceProperties.isSidewinder((Context)context);
        this.zzdpq = locale.getLanguage();
        this.zzdpr = zzasg.zza(context, packageManager);
        this.zzdps = zzasg.zzs(context);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzbty = displayMetrics.density;
        this.zzdlv = displayMetrics.widthPixels;
        this.zzdlw = displayMetrics.heightPixels;
    }

    public zzasg(Context context, zzasf zzasf2) {
        this.zzp(context);
        this.zzq(context);
        this.zzr(context);
        Context context2 = context;
        zzasg zzasg2 = this;
        this.zzdqd = Build.FINGERPRINT;
        zzasg2.zzdqe = Build.DEVICE;
        zzasg2.zzdqf = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzadr.zzj(context2);
        this.zzdph = zzasf2.zzdph;
        this.zzdpi = zzasf2.zzdpi;
        this.zzdpk = zzasf2.zzdpk;
        this.zzdpl = zzasf2.zzdpl;
        this.zzdpm = zzasf2.zzdpm;
        this.zzdpn = zzasf2.zzdpn;
        this.zzdpq = zzasf2.zzdpq;
        this.zzdpr = zzasf2.zzdpr;
        this.zzdps = zzasf2.zzdps;
        this.zzbty = zzasf2.zzbty;
        this.zzdlv = zzasf2.zzdlv;
        this.zzdlw = zzasf2.zzdlw;
    }

    private final void zzp(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzdpg = audioManager.getMode();
                this.zzdpo = audioManager.isMusicActive();
                this.zzdpp = audioManager.isSpeakerphoneOn();
                this.zzdpt = audioManager.getStreamVolume(3);
                this.zzdpx = audioManager.getRingerMode();
                this.zzdpy = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzk.zzlk().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzdpg = -2;
        this.zzdpo = false;
        this.zzdpp = false;
        this.zzdpt = 0;
        this.zzdpx = 2;
        this.zzdpy = 0;
    }

    @TargetApi(value=16)
    private final void zzq(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzdpj = telephonyManager.getNetworkOperator();
        this.zzdpv = telephonyManager.getNetworkType();
        this.zzdpw = telephonyManager.getPhoneType();
        this.zzdpu = -2;
        this.zzdqb = false;
        this.zzdqc = -1;
        zzk.zzlg();
        if (zzaxj.zzp(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzdpu = networkInfo.getType();
                this.zzdqc = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzdpu = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzdqb = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzr(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzdpz = (float)n2 / (float)n3;
            this.zzdqa = n == 2 || n == 5;
            return;
        }
        this.zzdpz = -1.0;
        this.zzdqa = false;
    }

    private static String zzs(Context context) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zza(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzasg.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzk.zzlk().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzasf zzty() {
        return new zzasf(this.zzdpg, this.zzdph, this.zzdpi, this.zzdpj, this.zzdpk, this.zzdpl, this.zzdpm, this.zzdpn, this.zzdpo, this.zzdpp, this.zzdpq, this.zzdpr, this.zzdps, this.zzdpt, this.zzdpu, this.zzdpv, this.zzdpw, this.zzdpx, this.zzdpy, this.zzbty, this.zzdlv, this.zzdlw, this.zzdpz, this.zzdqa, this.zzdqb, this.zzdqc, this.zzdqd, this.zzdqf, this.zzdqe);
    }
}

