/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzaqi;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzaxp;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhg;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzyr;
import java.util.Collections;

@zzare
public class zzd
extends zzaqi
implements zzx {
    @VisibleForTesting
    private static final int zzdjm = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity mActivity;
    @VisibleForTesting
    AdOverlayInfoParcel zzdjn;
    @VisibleForTesting
    zzbha zzdjo;
    @VisibleForTesting
    private zzj zzdjp;
    @VisibleForTesting
    private zzp zzdjq;
    @VisibleForTesting
    private boolean zzdjr = false;
    @VisibleForTesting
    private FrameLayout zzdjs;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzdjt;
    @VisibleForTesting
    private boolean zzdju = false;
    @VisibleForTesting
    private boolean zzdjv = false;
    @VisibleForTesting
    private zzi zzdjw;
    @VisibleForTesting
    private boolean zzdjx = false;
    @VisibleForTesting
    int zzdjy = 0;
    private final Object zzdjz = new Object();
    private Runnable zzdka;
    private boolean zzdkb;
    private boolean zzdkc;
    private boolean zzdkd = false;
    private boolean zzdke = false;
    private boolean zzdkf = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzdjy = 2;
        this.mActivity.finish();
    }

    public final void zzte() {
        if (this.zzdjn != null && this.zzdjr) {
            this.setRequestedOrientation(this.zzdjn.orientation);
        }
        if (this.zzdjs != null) {
            this.mActivity.setContentView((View)this.zzdjw);
            this.zzdkc = true;
            this.zzdjs.removeAllViews();
            this.zzdjs = null;
        }
        if (this.zzdjt != null) {
            this.zzdjt.onCustomViewHidden();
            this.zzdjt = null;
        }
        this.zzdjr = false;
    }

    @Override
    public final void zztf() {
        this.zzdjy = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzdjy = 0;
    }

    public final boolean zztg() {
        this.zzdjy = 0;
        if (this.zzdjo == null) {
            return true;
        }
        boolean bl = this.zzdjo.zzaap();
        if (!bl) {
            this.zzdjo.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzdju = bundle != null && bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false);
        try {
            this.zzdjn = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzdjn == null) {
                throw new zzh("Could not get info for ad overlay.");
            }
            if (this.zzdjn.zzbtd.zzdzf > 7500000) {
                this.zzdjy = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzdkf = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzdjv = this.zzdjn.zzdkv != null ? this.zzdjn.zzdkv.zzbrf : false;
            if (this.zzdjv && this.zzdjn.zzdkv.zzbrk != -1) {
                new com.google.android.gms.ads.internal.overlay.zzk(this, null).zzvi();
            }
            if (bundle == null) {
                if (this.zzdjn.zzdko != null && this.zzdkf) {
                    this.zzdjn.zzdko.zzta();
                }
                if (this.zzdjn.zzdkt != 1 && this.zzdjn.zzcgj != null) {
                    this.zzdjn.zzcgj.onAdClicked();
                }
            }
            this.zzdjw = new zzi((Context)this.mActivity, this.zzdjn.zzdku, this.zzdjn.zzbtd.zzbsy);
            this.zzdjw.setId(1000);
            zzk.zzli().zzg(this.mActivity);
            switch (this.zzdjn.zzdkt) {
                case 1: {
                    this.zzad(false);
                    return;
                }
                case 2: {
                    this.zzdjp = new zzj(this.zzdjn.zzdbu);
                    this.zzad(false);
                    return;
                }
                case 3: {
                    this.zzad(true);
                    return;
                }
            }
            throw new zzh("Could not determine ad overlay type.");
        }
        catch (zzh zzh2) {
            zzaxa.zzep((String)zzh2.getMessage());
            this.zzdjy = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzaci zzaci2 = zzact.zzcuj;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            if (this.zzdjo != null && !this.zzdjo.isDestroyed()) {
                zzk.zzli();
                zzaxp.zzb(this.zzdjo);
                return;
            }
            zzaxa.zzep((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzdjn.zzdko != null) {
            this.zzdjn.zzdko.onResume();
        }
        this.zza(this.mActivity.getResources().getConfiguration());
        zzaci zzaci2 = zzact.zzcuj;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            if (this.zzdjo != null && !this.zzdjo.isDestroyed()) {
                zzk.zzli();
                zzaxp.zzb(this.zzdjo);
                return;
            }
            zzaxa.zzep((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzte();
        if (this.zzdjn.zzdko != null) {
            this.zzdjn.zzdko.onPause();
        }
        zzaci zzaci2 = zzact.zzcuj;
        if (!(((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue() || this.zzdjo == null || this.mActivity.isFinishing() && this.zzdjp != null)) {
            zzk.zzli();
            zzaxp.zza(this.zzdjo);
        }
        this.zzti();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzac(IObjectWrapper iObjectWrapper) {
        Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza(configuration);
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzdju);
    }

    public final void onStop() {
        zzaci zzaci2 = zzact.zzcuj;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue() && this.zzdjo != null && (!this.mActivity.isFinishing() || this.zzdjp == null)) {
            zzk.zzli();
            zzaxp.zza(this.zzdjo);
        }
        this.zzti();
    }

    public final void onDestroy() {
        if (this.zzdjo != null) {
            this.zzdjw.removeView(this.zzdjo.getView());
        }
        this.zzti();
    }

    private final void zzac(boolean bl) {
        zzaci zzaci2 = zzact.zzcul;
        int n = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzq zzq2 = new zzq();
        new zzq().size = 50;
        zzq2.paddingLeft = bl ? n : 0;
        zzq2.paddingRight = bl ? 0 : n;
        zzq2.paddingTop = 0;
        zzq2.paddingBottom = n;
        this.zzdjq = new zzp((Context)this.mActivity, zzq2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzdjn.zzdkq);
        this.zzdjw.addView((View)this.zzdjq, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzdd() {
        this.zzdkc = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzaci zzaci2 = zzact.zzcpf;
        boolean bl4 = (Boolean)zzyr.zzpe().zzd(zzaci2) != false && this.zzdjn != null && this.zzdjn.zzdkv != null && this.zzdjn.zzdkv.zzbrm;
        zzaci2 = zzact.zzcpg;
        boolean bl5 = bl3 = (Boolean)zzyr.zzpe().zzd(zzaci2) != false && this.zzdjn != null && this.zzdjn.zzdkv != null && this.zzdjn.zzdkv.zzbrn;
        if (bl && bl2 && bl4 && !bl3) {
            new zzaqc(this.zzdjo, "useCustomClose").zzdh("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzdjq != null) {
            this.zzdjq.zzaf(bl3 || bl2 && !bl4);
        }
    }

    public final void zzth() {
        this.zzdjw.removeView((View)this.zzdjq);
        this.zzac(true);
    }

    public final void setRequestedOrientation(int n) {
        zzaci zzaci2 = zzact.zzcwg;
        if (this.mActivity.getApplicationInfo().targetSdkVersion >= (Integer)zzyr.zzpe().zzd(zzaci2)) {
            zzaci2 = zzact.zzcwh;
            if (this.mActivity.getApplicationInfo().targetSdkVersion <= (Integer)zzyr.zzpe().zzd(zzaci2)) {
                zzaci2 = zzact.zzcwi;
                if (Build.VERSION.SDK_INT >= (Integer)zzyr.zzpe().zzd(zzaci2)) {
                    zzaci2 = zzact.zzcwj;
                    if (Build.VERSION.SDK_INT <= (Integer)zzyr.zzpe().zzd(zzaci2)) {
                        return;
                    }
                }
            }
        }
        try {
            this.mActivity.setRequestedOrientation(n);
            return;
        }
        catch (Throwable throwable) {
            zzk.zzlk().zzb(throwable, "AdOverlay.setRequestedOrientation");
            return;
        }
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzdjs = new FrameLayout((Context)this.mActivity);
        this.zzdjs.setBackgroundColor(-16777216);
        this.zzdjs.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzdjs);
        this.zzdkc = true;
        this.zzdjt = customViewCallback;
        this.zzdjr = true;
    }

    private final void zzad(boolean bl) throws zzh {
        ViewParent viewParent;
        Window window;
        if (!this.zzdkc) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzh("Invalid activity, no window available.");
        }
        zzbij zzbij2 = this.zzdjn.zzdbu != null ? this.zzdjn.zzdbu.zzaai() : null;
        boolean bl2 = zzbij2 != null && zzbij2.zzaay();
        this.zzdjx = false;
        if (bl2) {
            int n = this.zzdjn.orientation;
            zzk.zzli();
            if (n == 6) {
                this.zzdjx = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else {
                int n2 = this.zzdjn.orientation;
                zzk.zzli();
                if (n2 == 7) {
                    this.zzdjx = this.mActivity.getResources().getConfiguration().orientation == 2;
                }
            }
        }
        boolean bl3 = this.zzdjx;
        zzaxa.zzdp((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzdjn.orientation);
        zzk.zzli();
        window.setFlags(0x1000000, 0x1000000);
        zzaxa.zzdp((String)"Hardware acceleration on the AdActivity window enabled.");
        if (!this.zzdjv) {
            this.zzdjw.setBackgroundColor(-16777216);
        } else {
            this.zzdjw.setBackgroundColor(zzdjm);
        }
        this.mActivity.setContentView((View)this.zzdjw);
        this.zzdkc = true;
        if (bl) {
            try {
                zzk.zzlh();
                this.zzdjo = zzbhg.zza((Context)this.mActivity, this.zzdjn.zzdbu != null ? this.zzdjn.zzdbu.zzaag() : null, this.zzdjn.zzdbu != null ? this.zzdjn.zzdbu.zzaah() : null, true, bl2, null, this.zzdjn.zzbtd, null, null, this.zzdjn.zzdbu != null ? this.zzdjn.zzdbu.zzye() : null, zzwh.zznl());
            }
            catch (Exception exception) {
                zzaxa.zzc((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzh("Could not obtain webview for the overlay.");
            }
            this.zzdjo.zzaai().zza(null, this.zzdjn.zzczo, null, this.zzdjn.zzczp, this.zzdjn.zzdks, true, null, this.zzdjn.zzdbu != null ? this.zzdjn.zzdbu.zzaai().zzaax() : null, null, null);
            this.zzdjo.zzaai().zza(new zze(this));
            if (this.zzdjn.url != null) {
                this.zzdjo.loadUrl(this.zzdjn.url);
            } else if (this.zzdjn.zzdkr != null) {
                this.zzdjo.loadDataWithBaseURL(this.zzdjn.zzdkp, this.zzdjn.zzdkr, "text/html", "UTF-8", null);
            } else {
                throw new zzh("No URL or HTML to display in ad overlay.");
            }
            if (this.zzdjn.zzdbu != null) {
                this.zzdjn.zzdbu.zzb(this);
            }
        } else {
            this.zzdjo = this.zzdjn.zzdbu;
            this.zzdjo.zzbn((Context)this.mActivity);
        }
        this.zzdjo.zza(this);
        if (this.zzdjn.zzdbu != null) {
            zzd.zzb(this.zzdjn.zzdbu.zzaam(), (View)this.zzdjw);
        }
        if ((viewParent = this.zzdjo.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzdjo.getView());
        }
        if (this.zzdjv) {
            this.zzdjo.zzaau();
        }
        this.zzdjw.addView(this.zzdjo.getView(), -1, -1);
        if (!bl && !this.zzdjx) {
            this.zztl();
        }
        this.zzac(bl2);
        if (this.zzdjo.zzaak()) {
            this.zza(bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzti() {
        if (!this.mActivity.isFinishing() || this.zzdkd) {
            return;
        }
        this.zzdkd = true;
        if (this.zzdjo != null) {
            int n = this.zzdjy;
            this.zzdjo.zzdi(n);
            Object object = this.zzdjz;
            synchronized (object) {
                if (!this.zzdkb && this.zzdjo.zzaaq()) {
                    this.zzdka = new zzf(this);
                    zzaci zzaci2 = zzact.zzcpe;
                    zzaxj.zzdvx.postDelayed(this.zzdka, ((Long)zzyr.zzpe().zzd(zzaci2)).longValue());
                    return;
                }
            }
        }
        this.zztj();
    }

    @VisibleForTesting
    final void zztj() {
        if (this.zzdke) {
            return;
        }
        this.zzdke = true;
        if (this.zzdjo != null) {
            this.zzdjw.removeView(this.zzdjo.getView());
            if (this.zzdjp != null) {
                this.zzdjo.zzbn(this.zzdjp.zzlj);
                this.zzdjo.zzaq(false);
                this.zzdjp.parent.addView(this.zzdjo.getView(), this.zzdjp.index, this.zzdjp.zzdkj);
                this.zzdjp = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzdjo.zzbn(this.mActivity.getApplicationContext());
            }
            this.zzdjo = null;
        }
        if (this.zzdjn != null && this.zzdjn.zzdko != null) {
            this.zzdjn.zzdko.zzsz();
        }
        if (this.zzdjn != null && this.zzdjn.zzdbu != null) {
            zzd.zzb(this.zzdjn.zzdbu.zzaam(), this.zzdjn.zzdbu.getView());
        }
    }

    private static void zzb(@Nullable IObjectWrapper iObjectWrapper, @Nullable View view) {
        if (iObjectWrapper != null && view != null) {
            zzk.zzlv().zza(iObjectWrapper, view);
        }
    }

    public final void zztk() {
        if (this.zzdjx) {
            this.zzdjx = false;
            this.zztl();
        }
    }

    private final void zztl() {
        this.zzdjo.zztl();
    }

    public final void zztm() {
        this.zzdjw.zzdki = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zztn() {
        Object object = this.zzdjz;
        synchronized (object) {
            this.zzdkb = true;
            if (this.zzdka != null) {
                zzaxj.zzdvx.removeCallbacks(this.zzdka);
                zzaxj.zzdvx.post(this.zzdka);
            }
            return;
        }
    }

    private final void zza(Configuration configuration) {
        boolean bl = this.zzdjn.zzdkv != null && this.zzdjn.zzdkv.zzbrg;
        boolean bl2 = zzk.zzli().zza(this.mActivity, configuration);
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(this.zzdjv && !bl || bl2)) {
            bl3 = true;
            if (Build.VERSION.SDK_INT >= 19 && this.zzdjn.zzdkv != null && this.zzdjn.zzdkv.zzbrl) {
                bl4 = true;
            }
        }
        Window window = this.mActivity.getWindow();
        zzaci zzaci2 = zzact.zzcph;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue() && Build.VERSION.SDK_INT >= 19) {
            View view = window.getDecorView();
            int n = 256;
            if (bl3) {
                n = 5380;
                if (bl4) {
                    n = 5894;
                }
            }
            view.setSystemUiVisibility(n);
            return;
        }
        if (bl3) {
            window.addFlags(1024);
            window.clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19 && bl4) {
                window.getDecorView().setSystemUiVisibility(4098);
                return;
            }
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }
}

