/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzcg;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbs;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzft
implements zzcv {
    private static volatile zzft zzrt;
    private zzbs zzru;
    private zzay zzrv;
    private zzw zzrw;
    private zzbd zzrx;
    private zzfp zzry;
    private zzo zzrz;
    private final zzfz zzsa;
    private zzea zzsb;
    private final zzby zzl;
    private boolean zzce = false;
    private boolean zzsc;
    private boolean zzsd;
    @VisibleForTesting
    private long zzse;
    private List<Runnable> zzsf;
    private int zzsg;
    private int zzsh;
    private boolean zzsi;
    private boolean zzsj;
    private boolean zzsk;
    private FileLock zzsl;
    private FileChannel zzsm;
    private List<Long> zzsn;
    private List<Long> zzso;
    private long zzsp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzft zzm(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzrt != null) return zzrt;
        Class<zzft> clazz = zzft.class;
        synchronized (zzft.class) {
            if (zzrt != null) return zzrt;
            zzfy zzfy2 = new zzfy(context);
            zzrt = new zzft(zzfy2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzrt;
        }
    }

    private zzft(zzfy zzfy2) {
        this(zzfy2, null);
    }

    private zzft(zzfy zzfy2, zzby zzby2) {
        Preconditions.checkNotNull((Object)zzfy2);
        this.zzl = zzby2 = zzby.zza((Context)zzfy2.zzno, null);
        this.zzsp = -1L;
        zzft zzft2 = this;
        zzfz zzfz2 = new zzfz(zzft2);
        zzfz2.zzai();
        this.zzsa = zzfz2;
        zzft2 = this;
        zzay zzay2 = new zzay(zzft2);
        zzay2.zzai();
        this.zzrv = zzay2;
        zzft2 = this;
        zzbs zzbs2 = new zzbs(zzft2);
        zzbs2.zzai();
        this.zzru = zzbs2;
        this.zzl.zzac().zza((Runnable)new zzfu(this, zzfy2));
    }

    @WorkerThread
    private final void zza(zzfy zzfy2) {
        this.zzl.zzac().zzq();
        zzft zzft2 = this;
        zzw zzw2 = new zzw(zzft2);
        zzw2.zzai();
        this.zzrw = zzw2;
        this.zzl.zzaf().zza((zzv)this.zzru);
        zzft2 = this;
        zzo zzo2 = new zzo(zzft2);
        zzo2.zzai();
        this.zzrz = zzo2;
        zzft2 = this;
        zzea zzea2 = new zzea(zzft2);
        zzea2.zzai();
        this.zzsb = zzea2;
        zzft2 = this;
        zzfp zzfp2 = new zzfp(zzft2);
        zzfp2.zzai();
        this.zzry = zzfp2;
        zzft2 = this;
        this.zzrx = new zzbd(zzft2);
        if (this.zzsg != this.zzsh) {
            this.zzl.zzad().zzda().zza("Not all upload components initialized", (Object)this.zzsg, (Object)this.zzsh);
        }
        this.zzce = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzl.zzac().zzq();
        this.zzdo().zzca();
        if (this.zzl.zzae().zzlb.get() == 0L) {
            this.zzl.zzae().zzlb.set(this.zzl.zzz().currentTimeMillis());
        }
        this.zzgc();
    }

    public final zzq zzag() {
        return this.zzl.zzag();
    }

    public final zzt zzaf() {
        return this.zzl.zzaf();
    }

    public final zzau zzad() {
        return this.zzl.zzad();
    }

    public final zzbt zzac() {
        return this.zzl.zzac();
    }

    public final zzbs zzdp() {
        zzft.zza(this.zzru);
        return this.zzru;
    }

    public final zzay zzfu() {
        zzft.zza(this.zzrv);
        return this.zzrv;
    }

    public final zzw zzdo() {
        zzft.zza(this.zzrw);
        return this.zzrw;
    }

    private final zzbd zzfv() {
        if (this.zzrx == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzrx;
    }

    private final zzfp zzfw() {
        zzft.zza(this.zzry);
        return this.zzry;
    }

    public final zzo zzdn() {
        zzft.zza(this.zzrz);
        return this.zzrz;
    }

    public final zzea zzfx() {
        zzft.zza(this.zzsb);
        return this.zzsb;
    }

    public final zzfz zzdm() {
        zzft.zza(this.zzsa);
        return this.zzsa;
    }

    public final zzas zzaa() {
        return this.zzl.zzaa();
    }

    public final Context getContext() {
        return this.zzl.getContext();
    }

    public final Clock zzz() {
        return this.zzl.zzz();
    }

    public final zzgd zzab() {
        return this.zzl.zzab();
    }

    @WorkerThread
    private final void zzq() {
        this.zzl.zzac().zzq();
    }

    final void zzfy() {
        if (!this.zzce) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzfs zzfs2) {
        if (zzfs2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzfs2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzfs2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzm zzm2) {
        this.zzq();
        this.zzfy();
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        this.zzg(zzm2);
    }

    private final long zzfz() {
        long l = this.zzl.zzz().currentTimeMillis();
        zzbf zzbf2 = this.zzl.zzae();
        zzbf2.zzah();
        zzbf2.zzq();
        long l2 = zzbf2.zzlf.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzbf2.zzab().zzgl().nextInt(86400000);
            zzbf2.zzlf.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzd(zzaj zzaj2, String string) {
        zzg zzg2 = this.zzdo().zzae(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzas())) {
            this.zzl.zzad().zzdh().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzaj2.name)) {
                this.zzl.zzad().zzdd().zza("Could not find package. appId", zzau.zzao((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzl.zzad().zzda().zza("App version does not match; dropping event. appId", zzau.zzao((String)string));
            return;
        }
        zzm zzm2 = new zzm(string, zzg2.getGmpAppId(), zzg2.zzas(), zzg2.zzat(), zzg2.zzau(), zzg2.zzav(), zzg2.zzaw(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzbk(), 0L, 0, zzg2.zzbl(), zzg2.zzbm(), false, zzg2.zzao(), zzg2.zzbn(), zzg2.zzax());
        this.zzc(zzaj2, zzm2);
    }

    @WorkerThread
    final void zzc(zzaj zzaj2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        this.zzq();
        this.zzfy();
        String string = zzm2.packageName;
        long l = zzaj2.zzfp;
        if (!this.zzdm().zze(zzaj2, zzm2)) {
            return;
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        this.zzdo().beginTransaction();
        try {
            zzr zzr2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzw zzw2 = this.zzdo();
            Preconditions.checkNotEmpty((String)string3);
            zzw2.zzq();
            zzw2.zzah();
            if (l2 < 0L) {
                zzw2.zzad().zzdd().zza("Invalid time querying timed out conditional properties", zzau.zzao((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzw2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzl.zzad().zzdh().zza("User property timed out", (Object)((zzr)object22).packageName, (Object)this.zzl.zzaa().zzan(((zzr)object22).zzdv.name), ((zzr)object22).zzdv.getValue());
                if (((zzr)object22).zzdw != null) {
                    this.zzd(new zzaj(((zzr)object22).zzdw, l), zzm2);
                }
                this.zzdo().zzg(string, ((zzr)object22).zzdv.name);
            }
            l2 = l;
            string3 = string;
            zzw2 = this.zzdo();
            Preconditions.checkNotEmpty((String)string3);
            zzw2.zzq();
            zzw2.zzah();
            if (l2 < 0L) {
                zzw2.zzad().zzdd().zza("Invalid time querying expired conditional properties", zzau.zzao((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzw2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzr)object4.next();
                if (object == null) continue;
                this.zzl.zzad().zzdh().zza("User property expired", (Object)((zzr)object).packageName, (Object)this.zzl.zzaa().zzan(((zzr)object).zzdv.name), ((zzr)object).zzdv.getValue());
                this.zzdo().zzd(string, ((zzr)object).zzdv.name);
                if (((zzr)object).zzdy != null) {
                    object22.add(((zzr)object).zzdy);
                }
                this.zzdo().zzg(string, ((zzr)object).zzdv.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzaj)e;
                this.zzd(new zzaj((zzaj)object, l), zzm2);
            }
            long l3 = l;
            String string4 = zzaj2.name;
            string3 = string;
            zzw2 = this.zzdo();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzw2.zzq();
            zzw2.zzah();
            if (l3 < 0L) {
                zzw2.zzad().zzdd().zza("Invalid time querying triggered conditional properties", zzau.zzao((String)string3), (Object)zzw2.zzaa().zzal(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzw2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzr2 = (zzr)iterator.next();
                if (zzr2 == null) continue;
                zzga zzga2 = zzr2.zzdv;
                zzgc zzgc2 = new zzgc(zzr2.packageName, zzr2.origin, zzga2.name, l, zzga2.getValue());
                if (this.zzdo().zza(zzgc2)) {
                    this.zzl.zzad().zzdh().zza("User property triggered", (Object)zzr2.packageName, (Object)this.zzl.zzaa().zzan(zzgc2.name), zzgc2.value);
                } else {
                    this.zzl.zzad().zzda().zza("Too many active user properties, ignoring", zzau.zzao((String)zzr2.packageName), (Object)this.zzl.zzaa().zzan(zzgc2.name), zzgc2.value);
                }
                if (zzr2.zzdx != null) {
                    object.add(zzr2.zzdx);
                }
                zzr2.zzdv = new zzga(zzgc2);
                zzr2.active = true;
                this.zzdo().zza(zzr2);
            }
            this.zzd(zzaj2, zzm2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzr2 = (zzaj)e;
                this.zzd(new zzaj((zzaj)zzr2, l), zzm2);
            }
            this.zzdo().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzd(zzaj var1_1, zzm var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzq();
        this.zzfy();
        var5_4 = var2_2.packageName;
        if (!this.zzdm().zze(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzcr) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzdp().zzk(var5_4, var1_1.name)) {
            this.zzl.zzad().zzdd().zza("Dropping blacklisted event. appId", zzau.zzao((String)var5_4), (Object)this.zzl.zzaa().zzal(var1_1.name));
            var6_5 = this.zzdp().zzbe(var5_4) != false || this.zzdp().zzbf(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzl.zzab().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzdo().zzae(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzba(), var7_7.zzaz());
                if (Math.abs(this.zzl.zzz().currentTimeMillis() - var8_9) > (Long)zzal.zzhc.get(null)) {
                    this.zzl.zzad().zzdh().zzaq("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzl.zzad().isLoggable(2)) {
            this.zzl.zzad().zzdi().zza("Logging event", (Object)this.zzl.zzaa().zzb(var1_1));
        }
        this.zzdo().beginTransaction();
        try {
            block57: {
                block58: {
                    block60: {
                        block64: {
                            block63: {
                                block61: {
                                    block62: {
                                        this.zzg(var2_2);
                                        if (!"_iap".equals(var1_1.name) && !"ecommerce_purchase".equals(var1_1.name)) break block60;
                                        var20_11 = var1_1;
                                        var19_15 = var5_4;
                                        var18_16 = this;
                                        var21_17 = var20_11.zzfd.getString("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.name)) break block61;
                                        var24_18 = var20_11.zzfd.zzaj("value") * 1000000.0;
                                        if (var24_18 == 0.0) {
                                            var24_18 = (double)var20_11.zzfd.getLong("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_18 <= 9.223372036854776E18) || !(var24_18 >= -9.223372036854776E18)) break block62;
                                        var22_21 = Math.round(var24_18);
                                        break block63;
                                    }
                                    var18_16.zzl.zzad().zzdd().zza("Data lost. Currency value is too big. appId", zzau.zzao((String)var19_15), (Object)var24_18);
                                    v0 = false;
                                    break block64;
                                }
                                var22_21 = var20_11.zzfd.getLong("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_17) && (var21_17 = var21_17.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_17);
                                var24_19 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_23 = var18_16.zzdo().zze(var19_15, var24_19);
                                if (var25_23 == null || !(var25_23.value instanceof Long)) {
                                    var29_26 = var19_15;
                                    var34_27 = var18_16.zzl.zzaf().zzb(var29_26, zzal.zzhh) - 1;
                                    var33_28 = var19_15;
                                    var32_29 = var18_16.zzdo();
                                    Preconditions.checkNotEmpty((String)var33_28);
                                    var32_29.zzq();
                                    var32_29.zzah();
                                    try {
                                        var32_29.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_28, var33_28, String.valueOf(var34_27)});
                                    }
                                    catch (SQLiteException var35_30) {
                                        var32_29.zzad().zzda().zza("Error pruning currencies. appId", zzau.zzao((String)var33_28), (Object)var35_30);
                                    }
                                    var25_23 = new zzgc(var19_15, var20_11.origin, var24_19, var18_16.zzl.zzz().currentTimeMillis(), (Object)var22_21);
                                } else {
                                    var26_31 = (Long)var25_23.value;
                                    var25_23 = new zzgc(var19_15, var20_11.origin, var24_19, var18_16.zzl.zzz().currentTimeMillis(), (Object)(var26_31 + var22_21));
                                }
                                if (!var18_16.zzdo().zza(var25_23)) {
                                    var18_16.zzl.zzad().zzda().zza("Too many unique user properties are set. Ignoring user property. appId", zzau.zzao((String)var19_15), (Object)var18_16.zzl.zzaa().zzan(var25_23.name), var25_23.value);
                                    var18_16.zzl.zzab().zza(var19_15, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zzdo().setTransactionSuccessful();
                            return;
                        }
                    }
                    var6_6 = zzgd.zzbm((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzdo().zza(this.zzfz(), var5_4, true, var6_6, false, var7_8, false);
                    var9_33 = var8_10.zzem - (long)((Integer)zzal.zzgn.get(null)).intValue();
                    if (var9_33 > 0L) {
                        if (var9_33 % 1000L == 1L) {
                            this.zzl.zzad().zzda().zza("Data loss. Too many events logged. appId, count", zzau.zzao((String)var5_4), (Object)var8_10.zzem);
                        }
                        this.zzdo().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_33 = var8_10.zzel - (long)((Integer)zzal.zzgp.get(null)).intValue()) > 0L) {
                        if (var9_33 % 1000L == 1L) {
                            this.zzl.zzad().zzda().zza("Data loss. Too many public events logged. appId, count", zzau.zzao((String)var5_4), (Object)var8_10.zzel);
                        }
                        this.zzl.zzab().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzdo().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_15 = var2_2.packageName;
                        var20_12 = this.zzl.zzaf().zzb(var19_15, zzal.zzgo);
                        var9_33 = var8_10.zzeo - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_33 > 0L) {
                            if (var9_33 == 1L) {
                                this.zzl.zzad().zzda().zza("Too many error events logged. appId, count", zzau.zzao((String)var5_4), (Object)var8_10.zzeo);
                            }
                            this.zzdo().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_34 = var1_1.zzfd.zzct();
                    this.zzl.zzab().zza(var11_34, "_o", (Object)var1_1.origin);
                    if (this.zzl.zzab().zzbt(var5_4)) {
                        this.zzl.zzab().zza(var11_34, "_dbg", (Object)1L);
                        this.zzl.zzab().zza(var11_34, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.name) && this.zzl.zzaf().zzz(var2_2.packageName) && (var12_35 = this.zzdo().zze(var2_2.packageName, "_sno")) != null && var12_35.value instanceof Long) {
                        this.zzl.zzab().zza(var11_34, "_sno", var12_35.value);
                    }
                    if ("_s".equals(var1_1.name) && this.zzl.zzaf().zze(var2_2.packageName, zzal.zzij)) {
                        var19_15 = var2_2;
                        var18_16 = this;
                        if (!var18_16.zzl.zzaf().zzz(var19_15.packageName)) {
                            var20_13 = new zzga("_sno", 0L, null);
                            var18_16.zzc(var20_13, (zzm)var19_15);
                        }
                    }
                    if ((var12_36 = this.zzdo().zzaf(var5_4)) > 0L) {
                        this.zzl.zzad().zzdd().zza("Data lost. Too many events stored on disk, deleted. appId", zzau.zzao((String)var5_4), (Object)var12_36);
                    }
                    var14_37 = new zzae(this.zzl, var1_1.origin, var5_4, var1_1.name, var1_1.zzfp, 0L, var11_34);
                    var15_38 = this.zzdo().zzc(var5_4, var14_37.name);
                    if (var15_38 == null) {
                        if (this.zzdo().zzai(var5_4) >= 500L && var6_6) {
                            this.zzl.zzad().zzda().zza("Too many event names used, ignoring event. appId, name, supported count", zzau.zzao((String)var5_4), (Object)this.zzl.zzaa().zzal(var14_37.name), (Object)500);
                            this.zzl.zzab().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_39 = new zzaf(var5_4, var14_37.name, 0L, 0L, var14_37.timestamp, 0L, null, null, null, null);
                    } else {
                        var14_37 = var14_37.zza(this.zzl, var15_38.zzfg);
                        var16_39 = var15_38.zzw(var14_37.timestamp);
                    }
                    this.zzdo().zza(var16_39);
                    var20_14 = var2_2;
                    var19_15 = var14_37;
                    var18_16 = this;
                    var18_16.zzq();
                    var18_16.zzfy();
                    Preconditions.checkNotNull((Object)var19_15);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_15.zzcf);
                    Preconditions.checkArgument((boolean)var19_15.zzcf.equals(var20_14.packageName));
                    var21_17 = new zzch();
                    new zzch().zzxn = 1;
                    var21_17.zzxv = "android";
                    var21_17.zzcf = var20_14.packageName;
                    var21_17.zzcp = var20_14.zzcp;
                    var21_17.zzcn = var20_14.zzcn;
                    var21_17.zzyh = var20_14.zzco == -2147483648L ? null : Integer.valueOf((int)var20_14.zzco);
                    var21_17.zzxz = var20_14.zzt;
                    var21_17.zzch = var20_14.zzch;
                    if (!var18_16.zzl.zzaf().zza(zzal.zziv) || TextUtils.isEmpty((CharSequence)var21_17.zzch)) {
                        var21_17.zzxf = var20_14.zzcv;
                    }
                    var21_17.zzyd = var20_14.zzcq == 0L ? null : Long.valueOf(var20_14.zzcq);
                    var21_17.zzys = var20_14.zzu;
                    if (var18_16.zzl.zzaf().zze(var20_14.packageName, zzal.zziq)) {
                        var21_17.zzyr = var18_16.zzdm().zzgj();
                    }
                    if ((var22_22 = var18_16.zzl.zzae().zzar(var20_14.packageName)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzct) {
                            var21_17.zzyb = (String)var22_22.first;
                            var21_17.zzyc = (Boolean)var22_22.second;
                        }
                    } else if (!var18_16.zzl.zzy().zzj(var18_16.zzl.getContext()) && var20_14.zzcu) {
                        var23_40 = Settings.Secure.getString((ContentResolver)var18_16.zzl.getContext().getContentResolver(), (String)"android_id");
                        if (var23_40 == null) {
                            var18_16.zzl.zzad().zzdd().zza("null secure ID. appId", zzau.zzao((String)var21_17.zzcf));
                            var23_40 = "null";
                        } else if (var23_40.isEmpty()) {
                            var18_16.zzl.zzad().zzdd().zza("empty secure ID. appId", zzau.zzao((String)var21_17.zzcf));
                        }
                        var21_17.zzyk = var23_40;
                    }
                    var18_16.zzl.zzy().zzah();
                    var21_17.zzxx = Build.MODEL;
                    var18_16.zzl.zzy().zzah();
                    var21_17.zzxw = Build.VERSION.RELEASE;
                    var21_17.zzxy = (int)var18_16.zzl.zzy().zzco();
                    var21_17.zzex = var18_16.zzl.zzy().zzcp();
                    var21_17.zzya = null;
                    var21_17.zzxq = null;
                    var21_17.zzxr = null;
                    var21_17.zzxs = null;
                    var21_17.zzym = var20_14.zzcs;
                    if (var18_16.zzl.isEnabled() && zzt.zzbv()) {
                        var21_17.zzyn = null;
                    }
                    if ((var23_40 = var18_16.zzdo().zzae(var20_14.packageName)) == null) {
                        var23_40 = new zzg(var18_16.zzl, var20_14.packageName);
                        var23_40.zza(var18_16.zzl.zzab().zzgn());
                        var23_40.zze(var20_14.zzcj);
                        var23_40.zzb(var20_14.zzch);
                        var23_40.zzd(var18_16.zzl.zzae().zzas(var20_14.packageName));
                        var23_40.zzk(0L);
                        var23_40.zze(0L);
                        var23_40.zzf(0L);
                        var23_40.zzf(var20_14.zzcn);
                        var23_40.zzg(var20_14.zzco);
                        var23_40.zzg(var20_14.zzcp);
                        var23_40.zzh(var20_14.zzt);
                        var23_40.zzi(var20_14.zzcq);
                        var23_40.setMeasurementEnabled(var20_14.zzcr);
                        var23_40.zzt(var20_14.zzcs);
                        var23_40.zzj(var20_14.zzu);
                        var18_16.zzdo().zza((zzg)var23_40);
                    }
                    var21_17.zzcg = var23_40.getAppInstanceId();
                    var21_17.zzcj = var23_40.getFirebaseInstanceId();
                    var24_20 = var18_16.zzdo().zzad(var20_14.packageName);
                    var21_17.zzxp = new zzbt.zzh[var24_20.size()];
                    for (var25_24 = 0; var25_24 < var24_20.size(); ++var25_24) {
                        var26_32 = zzbt.zzh.zziu().zzby(var24_20.get((int)var25_24).name).zzan(var24_20.get((int)var25_24).zzsx);
                        var18_16.zzdm().zza(var26_32, var24_20.get((int)var25_24).value);
                        var21_17.zzxp[var25_24] = (zzbt.zzh)((zzez)var26_32.zzmr());
                    }
                    try {
                        var25_25 = var18_16.zzdo().zza((zzch)var21_17);
                    }
                    catch (IOException var27_41) {
                        var18_16.zzl.zzad().zzda().zza("Data loss. Failed to insert raw event metadata. appId", zzau.zzao((String)var21_17.zzcf), (Object)var27_41);
                        break block57;
                    }
                    v3 = var18_16.zzdo();
                    var29_26 = var19_15;
                    var28_42 = var18_16;
                    if (var29_26.zzfd == null) ** GOTO lbl-1000
                    for (Object var31_45 : var29_26.zzfd) {
                        if (!"_r".equals(var31_45)) continue;
                        v4 = true;
                        break block58;
                    }
                    var30_44 = var28_42.zzdp().zzl(var29_26.zzcf, var29_26.name);
                    var31_45 = var28_42.zzdo().zza(var28_42.zzfz(), var29_26.zzcf, false, false, false, false, false);
                    if (var30_44 && var31_45.zzep < (long)var28_42.zzl.zzaf().zzi(var29_26.zzcf)) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                }
                if (v3.zza((zzae)var19_15, var25_25, v4)) {
                    var18_16.zzse = 0L;
                }
            }
            this.zzdo().setTransactionSuccessful();
            if (this.zzl.zzad().isLoggable(2)) {
                this.zzl.zzad().zzdi().zza("Event recorded", (Object)this.zzl.zzaa().zza(var14_37));
            }
        }
        finally {
            this.zzdo().endTransaction();
        }
        this.zzgc();
        this.zzl.zzad().zzdi().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzga() {
        this.zzq();
        this.zzfy();
        this.zzsk = true;
        try {
            String string;
            zzq zzq2 = this.zzl.zzag();
            Boolean bl = this.zzl.zzu().zzfi();
            if (bl == null) {
                this.zzl.zzad().zzdd().zzaq("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzl.zzad().zzda().zzaq("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzse > 0L) {
                this.zzgc();
                return;
            }
            zzcv zzcv2 = this;
            zzcv2.zzq();
            if (zzcv2.zzsn != null) {
                this.zzl.zzad().zzdi().zzaq("Uploading requested multiple times");
                return;
            }
            if (!this.zzfu().zzdl()) {
                this.zzl.zzad().zzdi().zzaq("Network not connected, ignoring upload request");
                this.zzgc();
                return;
            }
            long l = this.zzl.zzz().currentTimeMillis();
            long l2 = l - zzt.zzbt();
            this.zzd(null, l2);
            long l3 = this.zzl.zzae().zzlb.get();
            if (l3 != 0L) {
                this.zzl.zzad().zzdh().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzdo().zzby()))) {
                if (this.zzsp == -1L) {
                    this.zzsp = this.zzdo().zzcf();
                }
                Object object = string;
                int n = this.zzl.zzaf().zzb((String)object, zzal.zzgj);
                object = string;
                zzcv2 = this.zzl.zzaf();
                int n2 = Math.max(0, zzcv2.zzb((String)object, zzal.zzgk));
                List<Pair<zzch, Long>> list = this.zzdo().zza(string, n, n2);
                if (!list.isEmpty()) {
                    byte[] byArray;
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzch zzch2 = (zzch)object3.next().first;
                        if (TextUtils.isEmpty((CharSequence)zzch2.zzyb)) continue;
                        string2 = zzch2.zzyb;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzch)list.get((int)i).first;
                            if (TextUtils.isEmpty((CharSequence)((zzch)object2).zzyb) || ((zzch)object2).zzyb.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzcg();
                    new zzcg().zzxl = new zzch[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzt.zzbv() && this.zzl.zzaf().zzk(string);
                    for (int i = 0; i < ((zzcg)object3).zzxl.length; ++i) {
                        ((zzcg)object3).zzxl[i] = (zzch)list.get((int)i).first;
                        object2.add((Long)list.get((int)i).second);
                        ((zzcg)object3).zzxl[i].zzya = this.zzl.zzaf().zzav();
                        ((zzcg)object3).zzxl[i].zzxq = l;
                        zzq2 = this.zzl.zzag();
                        ((zzcg)object3).zzxl[i].zzyf = false;
                        if (!bl2) {
                            ((zzcg)object3).zzxl[i].zzyn = null;
                        }
                        if (!this.zzl.zzaf().zze(string, zzal.zziu)) continue;
                        byArray = zzch.zzb(((zzcg)object3).zzxl[i]);
                        ((zzcg)object3).zzxl[i].zzyt = this.zzdm().zza(byArray);
                    }
                    String string3 = null;
                    if (this.zzl.zzad().isLoggable(2)) {
                        string3 = this.zzdm().zzb((zzcg)object3);
                    }
                    byArray = this.zzdm().zza((zzcg)object3);
                    String string4 = (String)zzal.zzgt.get(null);
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzcv2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzcv2.zzsn != null) {
                            zzcv2.zzl.zzad().zzda().zzaq("Set uploading progress before finishing the previous upload");
                        } else {
                            zzcv2.zzsn = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzl.zzae().zzlc.set(l);
                        String string5 = "?";
                        if (((zzcg)object3).zzxl.length > 0) {
                            string5 = ((zzcg)object3).zzxl[0].zzcf;
                        }
                        this.zzl.zzad().zzdi().zza("Uploading data. app, uncompressed size, data", (Object)string5, (Object)byArray.length, (Object)string3);
                        this.zzsj = true;
                        zzfv zzfv2 = new zzfv(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzcv2 = this.zzfu();
                        zzcv2.zzq();
                        zzcv2.zzah();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzfv2);
                        zzcv2.zzac().zzb((Runnable)new zzbc((zzay)zzcv2, (String)object, uRL2, byArray2, null, zzfv2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzl.zzad().zzda().zza("Failed to parse upload URL. Not uploading. appId", zzau.zzao((String)string), (Object)string4);
                    }
                }
            } else {
                zzg zzg2;
                this.zzsp = -1L;
                String string6 = this.zzdo().zzu(l - zzt.zzbt());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzg2 = this.zzdo().zzae(string6)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzsk = false;
            this.zzgd();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzdo().beginTransaction();
        try {
            block149: {
                Object object;
                int zzdArray;
                Object object2;
                int n3;
                Object object3;
                Object object4;
                zza zza2;
                block147: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzsp;
                    long l3 = l;
                    object4 = null;
                    object3 = this.zzdo();
                    Preconditions.checkNotNull((Object)zza3);
                    object3.zzq();
                    object3.zzah();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string2;
                        String string3;
                        Object object5;
                        Object[] objectArray;
                        SQLiteDatabase sQLiteDatabase = object3.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(object5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block147;
                            object4 = cursor.getString(0);
                            string3 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(object5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object5).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block147;
                            string3 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object4, string3}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object3.zzad().zzda().zza("Raw event metadata record is missing. appId", zzau.zzao((String)object4));
                            break block147;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object5 = zzch.zzf((byte[])objectArray);
                        }
                        catch (IOException iOException) {
                            object3.zzad().zzda().zza("Data loss. Failed to merge raw event metadata. appId", zzau.zzao((String)object4), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block147;
                        }
                        if (cursor.moveToNext()) {
                            object3.zzad().zzdd().zza("Get multiple raw event metadata records, expected one. appId", zzau.zzao((String)object4));
                        }
                        cursor.close();
                        zza3.zzb((zzch)object5);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object4, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object4, string3};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object3.zzad().zzdd().zza("Raw event data disappeared while in transaction. appId", zzau.zzao((String)object4));
                            break block147;
                        }
                        do {
                            zzcf zzcf2;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zzcf2 = zzcf.zze((byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object3.zzad().zzda().zza("Data loss. Failed to merge raw event. appId", zzau.zzao((String)object4), (Object)iOException);
                                continue;
                            }
                            zzcf2.name = cursor.getString(1);
                            zzcf2.zzxj = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcf2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object3 = zza2;
                if (((zza)object3).zzsv == null || ((zza)object3).zzsv.isEmpty()) break block149;
                boolean bl = false;
                zzch zzch2 = zza2.zzst;
                zza2.zzst.zzxo = new zzcf[zza2.zzsv.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzl.zzaf().zzm(zzch2.zzcf);
                boolean bl3 = this.zzl.zzaf().zze(zza2.zzst.zzcf, zzal.zzim);
                Object object6 = null;
                Object object7 = null;
                for (n3 = 0; n3 < zza2.zzsv.size(); ++n3) {
                    boolean bl4;
                    block151: {
                        zzgj i;
                        boolean bl5;
                        block150: {
                            boolean bl6;
                            bl5 = bl;
                            object2 = zza2.zzsv.get(n3);
                            if (this.zzdp().zzk(zza2.zzst.zzcf, ((zzcf)object2).name)) {
                                this.zzl.zzad().zzdd().zza("Dropping blacklisted raw event. appId", zzau.zzao((String)zza2.zzst.zzcf), (Object)this.zzl.zzaa().zzal(((zzcf)object2).name));
                                if (this.zzdp().zzbe(zza2.zzst.zzcf) || this.zzdp().zzbf(zza2.zzst.zzcf) || "_err".equals(((zzcf)object2).name)) continue;
                                this.zzl.zzab().zza(zza2.zzst.zzcf, 11, "_ev", ((zzcf)object2).name, 0);
                                continue;
                            }
                            bl4 = this.zzdp().zzl(zza2.zzst.zzcf, ((zzcf)object2).name);
                            if (bl4) break block150;
                            this.zzdm();
                            object3 = ((zzcf)object2).name;
                            Preconditions.checkNotEmpty((String)object3);
                            switch (object3) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl6 = true;
                                    break;
                                }
                                default: {
                                    bl6 = false;
                                }
                            }
                            if (!bl6) break block151;
                        }
                        boolean bl7 = false;
                        boolean n2 = false;
                        if (((zzcf)object2).zzxi == null) {
                            ((zzcf)object2).zzxi = new zzbt.zzd[0];
                        }
                        for (zzdArray = 0; zzdArray < ((zzcf)object2).zzxi.length; ++zzdArray) {
                            i = (zzbt.zzd.zza)((zzcf)object2).zzxi[zzdArray].zzmh();
                            if ("_c".equals(i.getName())) {
                                i.zzaj(1L);
                                bl7 = true;
                            } else if ("_r".equals(i.getName())) {
                                i.zzaj(1L);
                                n2 = true;
                            }
                            ((zzcf)object2).zzxi[zzdArray] = (zzbt.zzd)((zzez)i.zzmr());
                        }
                        if (!bl7 && bl4) {
                            this.zzl.zzad().zzdi().zza("Marking event as conversion", (Object)this.zzl.zzaa().zzal(((zzcf)object2).name));
                            zzbt.zzd[] zzdArray2 = Arrays.copyOf(((zzcf)object2).zzxi, ((zzcf)object2).zzxi.length + 1);
                            i = (zzbt.zzd)((zzez)zzbt.zzd.zzht().zzbw("_c").zzaj(1L).zzmr());
                            zzdArray2[zzdArray2.length - 1] = i;
                            ((zzcf)object2).zzxi = zzdArray2;
                        }
                        if (!n2) {
                            this.zzl.zzad().zzdi().zza("Marking event as real-time", (Object)this.zzl.zzaa().zzal(((zzcf)object2).name));
                            zzbt.zzd[] zzdArray3 = Arrays.copyOf(((zzcf)object2).zzxi, ((zzcf)object2).zzxi.length + 1);
                            i = (zzbt.zzd)((zzez)zzbt.zzd.zzht().zzbw("_r").zzaj(1L).zzmr());
                            zzdArray3[zzdArray3.length - 1] = i;
                            ((zzcf)object2).zzxi = zzdArray3;
                        }
                        bl = true;
                        if (this.zzdo().zza((long)this.zzfz(), (String)zza2.zzst.zzcf, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzep > (long)this.zzl.zzaf().zzi(zza2.zzst.zzcf)) {
                            for (int zzcf4 = 0; zzcf4 < ((zzcf)object2).zzxi.length; ++zzcf4) {
                                if (!"_r".equals(((zzcf)object2).zzxi[zzcf4].getName())) continue;
                                zzbt.zzd[] bl8 = new zzbt.zzd[((zzcf)object2).zzxi.length - 1];
                                if (zzcf4 > 0) {
                                    System.arraycopy(((zzcf)object2).zzxi, 0, bl8, 0, zzcf4);
                                }
                                if (zzcf4 < bl8.length) {
                                    System.arraycopy(((zzcf)object2).zzxi, zzcf4 + 1, bl8, zzcf4, bl8.length - zzcf4);
                                }
                                ((zzcf)object2).zzxi = bl8;
                                break;
                            }
                            bl = bl5;
                        }
                        if (zzgd.zzbm((String)((zzcf)object2).name) && bl4) {
                            object4 = zza2.zzst.zzcf;
                            if (this.zzdo().zza((long)this.zzfz(), (String)zza2.zzst.zzcf, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzen > (long)this.zzl.zzaf().zzb((String)object4, zzal.zzgq)) {
                                this.zzl.zzad().zzdd().zza("Too many conversions. Not logging as conversion. appId", zzau.zzao((String)zza2.zzst.zzcf));
                                boolean string5 = false;
                                object = null;
                                int n = -1;
                                for (int zzd3 = 0; zzd3 < ((zzcf)object2).zzxi.length; ++zzd3) {
                                    zzbt.zzd n11 = ((zzcf)object2).zzxi[zzd3];
                                    if ("_c".equals(n11.getName())) {
                                        object = (zzbt.zzd.zza)n11.zzmh();
                                        n = zzd3;
                                        continue;
                                    }
                                    if (!"_err".equals(n11.getName())) continue;
                                    string5 = true;
                                }
                                if (string5 && object != null) {
                                    ((zzcf)object2).zzxi = (zzbt.zzd[])ArrayUtils.removeAll((Object[])((zzcf)object2).zzxi, (Object[])new zzbt.zzd[]{(zzbt.zzd)((zzez)object.zzmr())});
                                } else if (object != null) {
                                    zzbt.zzd zzd2;
                                    ((zzcf)object2).zzxi[n] = zzd2 = (zzbt.zzd)((zzez)((zzbt.zzd.zza)((zzez.zza)object.clone())).zzbw("_err").zzaj(10L).zzmr());
                                } else {
                                    this.zzl.zzad().zzda().zza("Did not find conversion parameter. appId", zzau.zzao((String)zza2.zzst.zzcf));
                                }
                            }
                        }
                    }
                    if (this.zzl.zzaf().zzv(zza2.zzst.zzcf) && bl4) {
                        int n6;
                        object4 = ((zzcf)object2).zzxi;
                        object3 = this;
                        int n7 = -1;
                        int zzh3 = -1;
                        for (n6 = 0; n6 < ((zzbt.zzd[])object4).length; ++n6) {
                            if ("value".equals(object4[n6].getName())) {
                                n7 = n6;
                                continue;
                            }
                            if (!"currency".equals(object4[n6].getName())) continue;
                            zzh3 = n6;
                        }
                        if (n7 != -1) {
                            if (!object4[n7].zzhn() && !object4[n7].zzhq()) {
                                ((zzft)object3).zzl.zzad().zzdf().zzaq("Value must be specified with a numeric type.");
                                object4 = zzft.zza((zzbt.zzd[])object4, n7);
                                object4 = zzft.zza(zzft.zza((zzbt.zzd[])object4, "_c"), 18, "value");
                            } else {
                                n6 = 0;
                                if (zzh3 == -1) {
                                    n6 = 1;
                                } else {
                                    String i = object4[zzh3].zzhl();
                                    if (i.length() != 3) {
                                        n6 = 1;
                                    } else {
                                        int n9;
                                        for (int i2 = 0; i2 < i.length(); i2 += Character.charCount(n9)) {
                                            n9 = i.codePointAt(i2);
                                            if (Character.isLetter(n9)) continue;
                                            n6 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n6 != 0) {
                                    ((zzft)object3).zzl.zzad().zzdf().zzaq("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    object4 = zzft.zza((zzbt.zzd[])object4, n7);
                                    object4 = zzft.zza(zzft.zza((zzbt.zzd[])object4, "_c"), 19, "currency");
                                }
                            }
                        }
                        ((zzcf)object2).zzxi = object4;
                    }
                    if (this.zzl.zzaf().zze(zza2.zzst.zzcf, zzal.zzil)) {
                        if ("_e".equals(((zzcf)object2).name)) {
                            this.zzdm();
                            if (zzfz.zza((zzcf)object2, "_fr") == null) {
                                if (object7 != null && Math.abs(((zzcf)object7).zzxj - ((zzcf)object2).zzxj) <= 1000L) {
                                    if (this.zza((zzcf)object2, (zzcf)object7)) {
                                        object6 = null;
                                        object7 = null;
                                    } else {
                                        object6 = object2;
                                    }
                                } else {
                                    object6 = object2;
                                }
                            }
                        } else if ("_vs".equals(((zzcf)object2).name)) {
                            this.zzdm();
                            if (zzfz.zza((zzcf)object2, "_et") == null) {
                                if (object6 != null && Math.abs(((zzcf)object6).zzxj - ((zzcf)object2).zzxj) <= 1000L) {
                                    if (this.zza((zzcf)object6, (zzcf)object2)) {
                                        object6 = null;
                                        object7 = null;
                                    } else {
                                        object7 = object2;
                                    }
                                } else {
                                    object7 = object2;
                                }
                            }
                        }
                    }
                    if (bl2 && !bl3 && "_e".equals(((zzcf)object2).name)) {
                        if (((zzcf)object2).zzxi == null || ((zzcf)object2).zzxi.length == 0) {
                            this.zzl.zzad().zzdd().zza("Engagement event does not contain any parameters. appId", zzau.zzao((String)zza2.zzst.zzcf));
                        } else {
                            this.zzdm();
                            Long l6 = (Long)zzfz.zzb((zzcf)object2, "_et");
                            if (l6 == null) {
                                this.zzl.zzad().zzdd().zza("Engagement event does not include duration. appId", zzau.zzao((String)zza2.zzst.zzcf));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzch2.zzxo[n4++] = object2;
                }
                if (bl3) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Long l7;
                        zzcf zzcf3 = zzch2.zzxo[n3];
                        if ("_e".equals(zzcf3.name)) {
                            this.zzdm();
                            if (zzfz.zza(zzcf3, "_fr") != null) {
                                System.arraycopy(zzch2.zzxo, n3 + 1, zzch2.zzxo, n3, n4 - n3 - 1);
                                --n4;
                                --n3;
                                continue;
                            }
                        }
                        if (!bl2) continue;
                        this.zzdm();
                        object2 = zzfz.zza(zzcf3, "_et");
                        if (object2 == null || (l7 = ((zzbt.zzd)((Object)object2)).zzhn() ? Long.valueOf(((zzbt.zzd)((Object)object2)).zzho()) : null) == null || l7 <= 0L) continue;
                        l5 += l7.longValue();
                    }
                }
                if (n4 < zza2.zzsv.size()) {
                    zzch2.zzxo = Arrays.copyOf(zzch2.zzxo, n4);
                }
                if (bl2) {
                    zzgc zzgc2 = this.zzdo().zze(zzch2.zzcf, "_lte");
                    zzgc2 = zzgc2 == null || zzgc2.value == null ? new zzgc(zzch2.zzcf, "auto", "_lte", this.zzl.zzz().currentTimeMillis(), (Object)l5) : new zzgc(zzch2.zzcf, "auto", "_lte", this.zzl.zzz().currentTimeMillis(), (Object)((Long)zzgc2.value + l5));
                    zzbt.zzh zzh2 = (zzbt.zzh)((zzez)zzbt.zzh.zziu().zzby("_lte").zzan(this.zzl.zzz().currentTimeMillis()).zzao((Long)zzgc2.value).zzmr());
                    boolean bl9 = false;
                    for (int i = 0; i < zzch2.zzxp.length; ++i) {
                        if (!"_lte".equals(zzch2.zzxp[i].getName())) continue;
                        zzch2.zzxp[i] = zzh2;
                        bl9 = true;
                        break;
                    }
                    if (!bl9) {
                        zzch2.zzxp = Arrays.copyOf(zzch2.zzxp, zzch2.zzxp.length + 1);
                        zzch2.zzxp[zza2.zzst.zzxp.length - 1] = zzh2;
                    }
                    if (l5 > 0L) {
                        this.zzdo().zza(zzgc2);
                        this.zzl.zzad().zzdh().zza("Updated lifetime engagement user property with value. Value", zzgc2.value);
                    }
                }
                if (this.zzl.zzaf().zze(zzch2.zzcf, zzal.zzin)) {
                    zzg zzg2;
                    object4 = zzch2;
                    object3 = this.zzdm();
                    object3.zzad().zzdi().zzaq("Checking account type status for ad personalization signals");
                    if (object3.zzdp().zzbc(((zzch)object4).zzcf) && (zzg2 = object3.zzdo().zzae(((zzch)object4).zzcf)) != null && zzg2.zzbl() && object3.zzy().zzcs()) {
                        object3.zzad().zzdh().zzaq("Turning off ad personalization due to account type");
                        zzbt.zzh zzh2 = (zzbt.zzh)((zzez)zzbt.zzh.zziu().zzby("_npa").zzan(object3.zzy().zzcq()).zzao(1L).zzmr());
                        boolean bl10 = false;
                        for (int n12 = 0; n12 < ((zzch)object4).zzxp.length; ++n12) {
                            if (!"_npa".equals(((zzch)object4).zzxp[n12].getName())) continue;
                            ((zzch)object4).zzxp[n12] = zzh2;
                            bl10 = true;
                            break;
                        }
                        if (!bl10) {
                            ((zzch)object4).zzxp = Arrays.copyOf(((zzch)object4).zzxp, ((zzch)object4).zzxp.length + 1);
                            ((zzch)object4).zzxp[((zzch)object4).zzxp.length - 1] = zzh2;
                        }
                    }
                }
                zzcf[] i = zzch2.zzxo;
                Object object8 = zzch2.zzxp;
                object4 = zzch2.zzcf;
                object3 = this;
                Preconditions.checkNotEmpty((String)object4);
                zzch2.zzyg = ((zzft)object3).zzdn().zza((String)object4, i, (zzbt.zzh[])object8);
                if (this.zzl.zzaf().zzl(zza2.zzst.zzcf)) {
                    HashMap<String, zzaf> hashMap = new HashMap<String, zzaf>();
                    zzcf[] zzcfArray2 = new zzcf[zzch2.zzxo.length];
                    int n10 = 0;
                    SecureRandom secureRandom = this.zzl.zzab().zzgl();
                    zzcf[] zzcfArray3 = zzch2.zzxo;
                    int n = zzch2.zzxo.length;
                    for (zzdArray = 0; zzdArray < n; ++zzdArray) {
                        boolean bl7;
                        long l2;
                        boolean bl8;
                        int n2;
                        long l3;
                        long l4;
                        zzcf zzcf2;
                        block148: {
                            zzcf2 = zzcfArray3[zzdArray];
                            if (zzcf2.name.equals("_ep")) {
                                this.zzdm();
                                String l10 = (String)zzfz.zzb(zzcf2, "_en");
                                object = (zzaf)hashMap.get(l10);
                                if (object == null) {
                                    object = this.zzdo().zzc(zza2.zzst.zzcf, l10);
                                    hashMap.put(l10, (zzaf)object);
                                }
                                if (object.zzfj != null) continue;
                                if (object.zzfk > 1L) {
                                    this.zzdm();
                                    zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_sr", object.zzfk);
                                }
                                if (object.zzfl != null && object.zzfl.booleanValue()) {
                                    this.zzdm();
                                    zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_efs", 1L);
                                }
                                zzcfArray2[n10++] = zzcf2;
                                continue;
                            }
                            l4 = this.zzdp().zzbd(zza2.zzst.zzcf);
                            this.zzl.zzab();
                            l3 = zzgd.zzc((long)zzcf2.zzxj, (long)l4);
                            n2 = 1;
                            object8 = 1L;
                            object4 = "_dbg";
                            object3 = zzcf2;
                            if (TextUtils.isEmpty((CharSequence)object4) || object8 == null) {
                                bl8 = false;
                            } else {
                                zzbt.zzd[] zzdArray4 = ((zzcf)object3).zzxi;
                                int n5 = ((zzcf)object3).zzxi.length;
                                for (int i3 = 0; i3 < n5; ++i3) {
                                    zzbt.zzd zzd4 = zzdArray4[i3];
                                    if (!((String)object4).equals(zzd4.getName())) continue;
                                    bl8 = object8 instanceof Long && object8.equals(zzd4.zzho()) || object8 instanceof String && object8.equals(zzd4.zzhl()) || object8 instanceof Double && object8.equals(zzd4.zzhr());
                                    break block148;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n2 = this.zzdp().zzm(zza2.zzst.zzcf, zzcf2.name);
                        }
                        if (n2 <= 0) {
                            this.zzl.zzad().zzdd().zza("Sample rate must be positive. event, rate", (Object)zzcf2.name, (Object)n2);
                            zzcfArray2[n10++] = zzcf2;
                            continue;
                        }
                        zzaf zzaf2 = (zzaf)hashMap.get(zzcf2.name);
                        if (zzaf2 == null && (zzaf2 = this.zzdo().zzc(zza2.zzst.zzcf, zzcf2.name)) == null) {
                            this.zzl.zzad().zzdd().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zzst.zzcf, (Object)zzcf2.name);
                            zzaf2 = new zzaf(zza2.zzst.zzcf, zzcf2.name, 1L, 1L, zzcf2.zzxj.longValue(), 0L, null, null, null, null);
                        }
                        this.zzdm();
                        Long l6 = (Long)zzfz.zzb(zzcf2, "_eid");
                        Boolean bl9 = l6 != null;
                        if (n2 == 1) {
                            zzcfArray2[n10++] = zzcf2;
                            if (!bl9.booleanValue() || zzaf2.zzfj == null && zzaf2.zzfk == null && zzaf2.zzfl == null) continue;
                            zzaf2 = zzaf2.zza(null, null, null);
                            hashMap.put(zzcf2.name, zzaf2);
                            continue;
                        }
                        if (secureRandom.nextInt(n2) == 0) {
                            this.zzdm();
                            zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_sr", n2);
                            zzcfArray2[n10++] = zzcf2;
                            if (bl9.booleanValue()) {
                                zzaf2 = zzaf2.zza(null, Long.valueOf(n2), null);
                            }
                            hashMap.put(zzcf2.name, zzaf2.zza(zzcf2.zzxj.longValue(), l3));
                            continue;
                        }
                        if (this.zzl.zzaf().zzx(zza2.zzst.zzcf)) {
                            if (zzaf2.zzfi != null) {
                                l2 = zzaf2.zzfi;
                            } else {
                                this.zzl.zzab();
                                l2 = zzgd.zzc((long)zzcf2.zzxk, (long)l4);
                            }
                            bl7 = l2 != l3;
                        } else {
                            l2 = zzaf2.zzfh;
                            boolean bl10 = bl7 = Math.abs(zzcf2.zzxj - l2) >= 86400000L;
                        }
                        if (bl7) {
                            this.zzdm();
                            zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_efs", 1L);
                            this.zzdm();
                            zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_sr", n2);
                            zzcfArray2[n10++] = zzcf2;
                            if (bl9.booleanValue()) {
                                zzaf2 = zzaf2.zza(null, Long.valueOf(n2), Boolean.valueOf(true));
                            }
                            hashMap.put(zzcf2.name, zzaf2.zza(zzcf2.zzxj.longValue(), l3));
                            continue;
                        }
                        if (!bl9.booleanValue()) continue;
                        hashMap.put(zzcf2.name, zzaf2.zza(l6, null, null));
                    }
                    if (n10 < zzch2.zzxo.length) {
                        zzch2.zzxo = Arrays.copyOf(zzcfArray2, n10);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzdo().zza((zzaf)entry.getValue());
                    }
                }
                zzch2.zzxr = Long.MAX_VALUE;
                zzch2.zzxs = Long.MIN_VALUE;
                for (int i4 = 0; i4 < zzch2.zzxo.length; ++i4) {
                    zzcf zzcf5 = zzch2.zzxo[i4];
                    if (zzcf5.zzxj < zzch2.zzxr) {
                        zzch2.zzxr = zzcf5.zzxj;
                    }
                    if (zzcf5.zzxj <= zzch2.zzxs) continue;
                    zzch2.zzxs = zzcf5.zzxj;
                }
                String string6 = zza2.zzst.zzcf;
                zzg zzg3 = this.zzdo().zzae(string6);
                if (zzg3 == null) {
                    this.zzl.zzad().zzda().zza("Bundling raw events w/o app info. appId", zzau.zzao((String)zza2.zzst.zzcf));
                } else if (zzch2.zzxo.length > 0) {
                    long l12 = zzg3.zzar();
                    zzch2.zzxu = l12 != 0L ? Long.valueOf(l12) : null;
                    long l13 = zzg3.zzaq();
                    if (l13 == 0L) {
                        l13 = l12;
                    }
                    zzch2.zzxt = l13 != 0L ? Long.valueOf(l13) : null;
                    zzg3.zzbb();
                    zzch2.zzye = (int)zzg3.zzay();
                    zzg3.zze(zzch2.zzxr.longValue());
                    zzg3.zzf(zzch2.zzxs.longValue());
                    zzch2.zzdn = zzg3.zzbj();
                    this.zzdo().zza(zzg3);
                }
                if (zzch2.zzxo.length > 0) {
                    zzq zzq2 = this.zzl.zzag();
                    zzce zzce2 = this.zzdp().zzay(zza2.zzst.zzcf);
                    if (zzce2 == null || zzce2.zzxa == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzst.zzch)) {
                            zzch2.zzyl = -1L;
                        } else {
                            this.zzl.zzad().zzdd().zza("Did not find measurement config or missing version info. appId", zzau.zzao((String)zza2.zzst.zzcf));
                        }
                    } else {
                        zzch2.zzyl = zzce2.zzxa;
                    }
                    this.zzdo().zza(zzch2, bl);
                }
                object4 = zza2.zzsu;
                object3 = this.zzdo();
                Preconditions.checkNotNull((Object)object4);
                object3.zzq();
                object3.zzah();
                object8 = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object4.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        ((StringBuilder)object8).append(",");
                    }
                    ((StringBuilder)object8).append((Long)object4.get(sQLiteException));
                }
                ((StringBuilder)object8).append(")");
                int n13 = object3.getWritableDatabase().delete("raw_events", ((StringBuilder)object8).toString(), null);
                if (n13 != object4.size()) {
                    object3.zzad().zzda().zza("Deleted fewer rows from raw events table than expected", (Object)n13, (Object)object4.size());
                }
                object4 = string6;
                object3 = this.zzdo();
                object8 = object3.getWritableDatabase();
                try {
                    object8.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object4, object4});
                }
                catch (SQLiteException sQLiteException) {
                    object3.zzad().zzda().zza("Failed to remove unused event metadata. appId", zzau.zzao((String)object4), (Object)sQLiteException);
                }
                this.zzdo().setTransactionSuccessful();
                return true;
            }
            this.zzdo().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    private final boolean zza(zzcf zzcf2, zzcf zzcf3) {
        Preconditions.checkArgument((boolean)"_e".equals(zzcf2.name));
        this.zzdm();
        zzbt.zzd zzd2 = zzfz.zza(zzcf2, "_sc");
        String string = zzd2 == null ? null : zzd2.zzhl();
        this.zzdm();
        zzbt.zzd zzd3 = zzfz.zza(zzcf3, "_pc");
        String string2 = zzd3 == null ? null : zzd3.zzhl();
        if (string2 != null && string2.equals(string)) {
            this.zzdm();
            zzbt.zzd zzd4 = zzfz.zza(zzcf2, "_et");
            if (!zzd4.zzhn() || zzd4.zzho() <= 0L) {
                return true;
            }
            long l = zzd4.zzho();
            this.zzdm();
            zzd4 = zzfz.zza(zzcf3, "_et");
            if (zzd4 != null && zzd4.zzho() > 0L) {
                l += zzd4.zzho();
            }
            this.zzdm();
            zzcf3.zzxi = zzfz.zza(zzcf3.zzxi, "_et", l);
            this.zzdm();
            zzcf2.zzxi = zzfz.zza(zzcf2.zzxi, "_fr", 1L);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private static zzbt.zzd[] zza(zzbt.zzd[] zzdArray, @NonNull String string) {
        int n = -1;
        for (int i = 0; i < zzdArray.length; ++i) {
            if (!string.equals(zzdArray[i].getName())) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return zzdArray;
        }
        return zzft.zza(zzdArray, n);
    }

    @VisibleForTesting
    private static zzbt.zzd[] zza(zzbt.zzd[] zzdArray, int n) {
        zzbt.zzd[] zzdArray2 = new zzbt.zzd[zzdArray.length - 1];
        if (n > 0) {
            System.arraycopy(zzdArray, 0, zzdArray2, 0, n);
        }
        if (n < zzdArray2.length) {
            System.arraycopy(zzdArray, n + 1, zzdArray2, n, zzdArray2.length - n);
        }
        return zzdArray2;
    }

    @VisibleForTesting
    private static zzbt.zzd[] zza(zzbt.zzd[] zzdArray, int n, String string) {
        for (int i = 0; i < zzdArray.length; ++i) {
            if (!"_err".equals(zzdArray[i].getName())) continue;
            return zzdArray;
        }
        zzbt.zzd[] zzdArray2 = new zzbt.zzd[zzdArray.length + 2];
        System.arraycopy(zzdArray, 0, zzdArray2, 0, zzdArray.length);
        zzbt.zzd zzd2 = (zzbt.zzd)((zzez)zzbt.zzd.zzht().zzbw("_err").zzaj(n).zzmr());
        zzbt.zzd zzd3 = (zzbt.zzd)((zzez)zzbt.zzd.zzht().zzbw("_ev").zzbx(string).zzmr());
        zzdArray2[zzdArray2.length - 2] = zzd2;
        zzdArray2[zzdArray2.length - 1] = zzd3;
        return zzdArray2;
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzq();
        this.zzfy();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzsn;
            this.zzsn = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzl.zzae().zzlb.set(this.zzl.zzz().currentTimeMillis());
                    this.zzl.zzae().zzlc.set(0L);
                    this.zzgc();
                    this.zzl.zzad().zzdi().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzdo().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzw zzw2 = this.zzdo();
                                zzw2.zzq();
                                zzw2.zzah();
                                SQLiteDatabase sQLiteDatabase = zzw2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzw2.zzad().zzda().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzso != null && this.zzso.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzdo().setTransactionSuccessful();
                    }
                    finally {
                        this.zzdo().endTransaction();
                    }
                    this.zzso = null;
                    if (this.zzfu().zzdl() && this.zzgb()) {
                        this.zzga();
                    } else {
                        this.zzsp = -1L;
                        this.zzgc();
                    }
                    this.zzse = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzl.zzad().zzda().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzse = this.zzl.zzz().elapsedRealtime();
                    this.zzl.zzad().zzdi().zza("Disable upload, time", (Object)this.zzse);
                }
            } else {
                this.zzl.zzad().zzdi().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzl.zzae().zzlc.set(this.zzl.zzz().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzl.zzae().zzld.set(this.zzl.zzz().currentTimeMillis());
                }
                if (this.zzl.zzaf().zzo(string)) {
                    this.zzdo().zza(list);
                }
                this.zzgc();
            }
            return;
        }
        finally {
            this.zzsj = false;
            this.zzgd();
        }
    }

    private final boolean zzgb() {
        this.zzq();
        this.zzfy();
        return this.zzdo().zzcd() || !TextUtils.isEmpty((CharSequence)this.zzdo().zzby());
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzq();
        if (TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && (!zzt.zzbx() || TextUtils.isEmpty((CharSequence)zzg2.zzao()))) {
            this.zzb(zzg2.zzan(), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = this.zzl.zzaf();
        Object object3 = new Uri.Builder();
        String string = object.getGmpAppId();
        if (TextUtils.isEmpty((CharSequence)string) && zzt.zzbx()) {
            string = object.zzao();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzal.zzgh.get(null)).encodedAuthority((String)zzal.zzgi.get(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.getAppInstanceId()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzav()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzl.zzad().zzdi().zza("Fetching remote configuration", (Object)zzg2.zzan());
            zzce zzce2 = this.zzdp().zzay(zzg2.zzan());
            ArrayMap arrayMap = null;
            String string4 = this.zzdp().zzaz(zzg2.zzan());
            if (zzce2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzsi = true;
            zzfw zzfw2 = new zzfw(this);
            string = arrayMap;
            object3 = uRL;
            object = zzg2.zzan();
            object2 = this.zzfu();
            object2.zzq();
            ((zzfs)((Object)object2)).zzah();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzfw2);
            object2.zzac().zzb((Runnable)new zzbc((zzay)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzfw2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzl.zzad().zzda().zza("Failed to parse config URL. Not fetching. appId", zzau.zzao((String)zzg2.zzan()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzq();
        this.zzfy();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzl.zzad().zzdi().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzdo().beginTransaction();
            try {
                boolean bl;
                zzg zzg2 = this.zzdo().zzae(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzl.zzad().zzdd().zza("App does not exist in onConfigFetched. appId", zzau.zzao((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzdp().zzay(string) == null && !this.zzdp().zza(string, null, null) : !this.zzdp().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzl(this.zzl.zzz().currentTimeMillis());
                    this.zzdo().zza(zzg2);
                    if (n == 404) {
                        this.zzl.zzad().zzdf().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzl.zzad().zzdi().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzfu().zzdl() && this.zzgb()) {
                        this.zzga();
                    } else {
                        this.zzgc();
                    }
                } else {
                    zzg2.zzm(this.zzl.zzz().currentTimeMillis());
                    this.zzdo().zza(zzg2);
                    this.zzl.zzad().zzdi().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzdp().zzba(string);
                    this.zzl.zzae().zzlc.set(this.zzl.zzz().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzl.zzae().zzld.set(this.zzl.zzz().currentTimeMillis());
                    }
                    this.zzgc();
                }
                this.zzdo().setTransactionSuccessful();
            }
            finally {
                this.zzdo().endTransaction();
            }
            return;
        }
        finally {
            this.zzsi = false;
            this.zzgd();
        }
    }

    @WorkerThread
    private final void zzgc() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzq();
            this.zzfy();
            if (!this.zzgg() && !this.zzl.zzaf().zza(zzal.zzip)) {
                return;
            }
            if (this.zzse > 0L) {
                l3 = this.zzl.zzz().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzse);
                if (l2 > 0L) {
                    this.zzl.zzad().zzdi().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzfv().unregister();
                    this.zzfw().cancel();
                    return;
                }
                this.zzse = 0L;
            }
            if (!this.zzl.zzet() || !this.zzgb()) {
                this.zzl.zzad().zzdi().zzaq("Nothing to upload or uploading impossible");
                this.zzfv().unregister();
                this.zzfw().cancel();
                return;
            }
            zzft zzft2 = this;
            long l4 = zzft2.zzl.zzz().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzal.zzhd.get(null));
            boolean bl = zzft2.zzdo().zzce() || zzft2.zzdo().zzbz();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzft2.zzl.zzaf().zzbu())) && !".none.".equals(string) ? Math.max(0L, (Long)zzal.zzgy.get(null)) : Math.max(0L, (Long)zzal.zzgx.get(null))) : Math.max(0L, (Long)zzal.zzgw.get(null));
            long l7 = zzft2.zzl.zzae().zzlb.get();
            long l8 = zzft2.zzl.zzae().zzlc.get();
            long l9 = zzft2.zzdo().zzcb();
            long l10 = zzft2.zzdo().zzcc();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzft2.zzdm().zzb(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzal.zzhf.get(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzal.zzhe.get(null)) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzl.zzad().zzdi().zzaq("Next upload time is 0");
            this.zzfv().unregister();
            this.zzfw().cancel();
            return;
        }
        if (!this.zzfu().zzdl()) {
            this.zzl.zzad().zzdi().zzaq("No network");
            this.zzfv().zzdq();
            this.zzfw().cancel();
            return;
        }
        l2 = this.zzl.zzae().zzld.get();
        long l16 = Math.max(0L, (Long)zzal.zzgu.get(null));
        if (!this.zzdm().zzb(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzfv().unregister();
        long l17 = l3 - this.zzl.zzz().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzal.zzgz.get(null));
            this.zzl.zzae().zzlb.set(this.zzl.zzz().currentTimeMillis());
        }
        this.zzl.zzad().zzdi().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzfw().zzv(l17);
    }

    @WorkerThread
    final void zzf(Runnable runnable) {
        this.zzq();
        if (this.zzsf == null) {
            this.zzsf = new ArrayList<Runnable>();
        }
        this.zzsf.add(runnable);
    }

    @WorkerThread
    private final void zzgd() {
        this.zzq();
        if (this.zzsi || this.zzsj || this.zzsk) {
            this.zzl.zzad().zzdi().zza("Not stopping services. fetch, network, upload", (Object)this.zzsi, (Object)this.zzsj, (Object)this.zzsk);
            return;
        }
        this.zzl.zzad().zzdi().zzaq("Stopping uploading service(s)");
        if (this.zzsf == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzsf.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzsf.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzg zzg2) {
        try {
            if (zzg2.zzat() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzl.getContext()).getPackageInfo((String)zzg2.zzan(), (int)0).versionCode;
                if (zzg2.zzat() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzl.getContext()).getPackageInfo((String)zzg2.zzan(), (int)0).versionName;
                if (zzg2.zzas() != null && zzg2.zzas().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzge() {
        this.zzq();
        String string = "google_app_measurement.db";
        File file = this.zzl.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzsm = new RandomAccessFile(file2, "rw").getChannel();
            this.zzsl = this.zzsm.tryLock();
            if (this.zzsl != null) {
                this.zzl.zzad().zzdi().zzaq("Storage concurrent access okay");
                return true;
            }
            this.zzl.zzad().zzda().zzaq("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzl.zzad().zzda().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzl.zzad().zzda().zza("Failed to access storage lock file", (Object)iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzq();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzl.zzad().zzda().zzaq("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzl.zzad().zzdd().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzl.zzad().zzda().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzq();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzl.zzad().zzda().zzaq("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzl.zzad().zzda().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzl.zzad().zzda().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final void zzgf() {
        block3: {
            block4: {
                this.zzq();
                this.zzfy();
                if (this.zzsd) break block3;
                this.zzsd = true;
                var1_1 = this;
                var1_1.zzq();
                var1_1.zzfy();
                if (!var1_1.zzl.zzaf().zza(zzal.zzip) && !var1_1.zzgg() || !var1_1.zzge()) break block3;
                var2_2 = var1_1.zza(var1_1.zzsm);
                var6_4 = var3_3 = var1_1.zzl.zzt().zzcx();
                var5_5 = var2_2;
                var4_6 = var1_1;
                var4_6.zzq();
                if (var5_5 <= var6_4) break block4;
                var4_6.zzl.zzad().zzda().zza("Panic: can't downgrade version. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
                break block3;
            }
            if (var5_5 >= var6_4) ** GOTO lbl25
            if (!var4_6.zza(var6_4, var4_6.zzsm)) {
                var4_6.zzl.zzad().zzda().zza("Storage version upgrade failed. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
            } else {
                var4_6.zzl.zzad().zzdi().zza("Storage version upgraded. Previous, current version", (Object)var5_5, (Object)var6_4);
lbl25:
                // 2 sources

                v0 = true;
            }
        }
        if (!this.zzsc && !this.zzl.zzaf().zza(zzal.zzip)) {
            this.zzl.zzad().zzdg().zzaq("This instance being marked as an uploader");
            this.zzsc = true;
            this.zzgc();
        }
    }

    @WorkerThread
    private final boolean zzgg() {
        this.zzq();
        this.zzfy();
        return this.zzsc;
        {
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzm zzm2) {
        if (this.zzsn != null) {
            this.zzso = new ArrayList<Long>();
            this.zzso.addAll(this.zzsn);
        }
        String string = zzm2.packageName;
        zzw zzw2 = this.zzdo();
        Preconditions.checkNotEmpty((String)string);
        zzw2.zzq();
        zzw2.zzah();
        try {
            SQLiteDatabase sQLiteDatabase = zzw2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzw2.zzad().zzdi().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzw2.zzad().zzda().zza("Error resetting analytics data. appId, error", zzau.zzao((String)string), (Object)sQLiteException);
        }
        zzm zzm3 = this.zza(this.zzl.getContext(), zzm2.packageName, zzm2.zzch, zzm2.zzcr, zzm2.zzct, zzm2.zzcu, zzm2.zzdp, zzm2.zzcv);
        if (!this.zzl.zzaf().zzs(zzm2.packageName) || zzm2.zzcr) {
            this.zzf(zzm3);
        }
    }

    private final zzm zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzl.zzad().zzda().zzaq("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzl.zzad().zzda().zza("Error retrieving installer package name. appId", zzau.zzao((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzl.zzad().zzda().zza("Error retrieving newly installed package info. appId, appName", zzau.zzao((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzq zzq2 = this.zzl.zzag();
        long l3 = 0L;
        if (this.zzl.zzaf().zzu(string)) {
            l3 = l;
        }
        return new zzm(string, string2, string5, (long)n, string4, this.zzl.zzaf().zzav(), this.zzl.zzab().zzc(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3, null, 0L);
    }

    @WorkerThread
    final void zzb(zzga zzga2, zzm zzm2) {
        this.zzq();
        this.zzfy();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            return;
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        int n = this.zzl.zzab().zzbo(zzga2.name);
        if (n != 0) {
            this.zzl.zzab();
            String string = zzgd.zza((String)zzga2.name, (int)24, (boolean)true);
            int n2 = zzga2.name != null ? zzga2.name.length() : 0;
            this.zzl.zzab().zza(zzm2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzl.zzab().zzc(zzga2.name, zzga2.getValue());
        if (n != 0) {
            this.zzl.zzab();
            String string = zzgd.zza((String)zzga2.name, (int)24, (boolean)true);
            Object object = zzga2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzl.zzab().zza(zzm2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzl.zzab().zzd(zzga2.name, zzga2.getValue());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzga2.name) && this.zzl.zzaf().zzz(zzm2.packageName)) {
            zzaf zzaf2;
            zzm zzm3 = zzm2;
            String string = zzga2.origin;
            long l = zzga2.zzsx;
            zzft zzft2 = this;
            long l2 = 0L;
            zzgc zzgc2 = zzft2.zzdo().zze(zzm3.packageName, "_sno");
            if (zzgc2 != null && zzgc2.value instanceof Long) {
                l2 = (Long)zzgc2.value;
            } else {
                if (zzgc2 != null) {
                    zzft2.zzl.zzad().zzdd().zza("Retrieved last session number from database does not contain a valid (long) value", zzgc2.value);
                }
                if (zzft2.zzl.zzaf().zze(zzm3.packageName, zzal.zzii) && (zzaf2 = zzft2.zzdo().zzc(zzm3.packageName, "_s")) != null) {
                    l2 = zzaf2.zzfe;
                    zzft2.zzl.zzad().zzdi().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzaf2 = new zzga("_sno", l, (Object)(++l2), string);
            zzft2.zzb((zzga)zzaf2, zzm3);
        }
        zzgc zzgc3 = new zzgc(zzm2.packageName, zzga2.origin, zzga2.name, zzga2.zzsx, object);
        this.zzl.zzad().zzdh().zza("Setting user property", (Object)this.zzl.zzaa().zzan(zzgc3.name), object);
        this.zzdo().beginTransaction();
        try {
            this.zzg(zzm2);
            boolean bl = this.zzdo().zza(zzgc3);
            this.zzdo().setTransactionSuccessful();
            if (bl) {
                this.zzl.zzad().zzdh().zza("User property set", (Object)this.zzl.zzaa().zzan(zzgc3.name), zzgc3.value);
            } else {
                this.zzl.zzad().zzda().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzl.zzaa().zzan(zzgc3.name), zzgc3.value);
                this.zzl.zzab().zza(zzm2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzga zzga2, zzm zzm2) {
        this.zzq();
        this.zzfy();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            return;
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        if (this.zzl.zzaf().zze(zzm2.packageName, zzal.zzin)) {
            if ("_npa".equals(zzga2.name) && zzm2.zzcw != null) {
                this.zzl.zzad().zzdh().zzaq("Falling back to manifest metadata value for ad personalization");
                zzga zzga3 = new zzga("_npa", this.zzl.zzz().currentTimeMillis(), (Object)(zzm2.zzcw != false ? 1L : 0L), "auto");
                this.zzb(zzga3, zzm2);
                return;
            }
            this.zzl.zzad().zzdh().zza("Removing user property", (Object)this.zzl.zzaa().zzan(zzga2.name));
            this.zzdo().beginTransaction();
            try {
                this.zzg(zzm2);
                this.zzdo().zzd(zzm2.packageName, zzga2.name);
                this.zzdo().setTransactionSuccessful();
                this.zzl.zzad().zzdh().zza("User property removed", (Object)this.zzl.zzaa().zzan(zzga2.name));
                return;
            }
            finally {
                this.zzdo().endTransaction();
            }
        }
        this.zzl.zzad().zzdh().zza("Removing user property", (Object)this.zzl.zzaa().zzan(zzga2.name));
        this.zzdo().beginTransaction();
        try {
            this.zzg(zzm2);
            this.zzdo().zzd(zzm2.packageName, zzga2.name);
            this.zzdo().setTransactionSuccessful();
            this.zzl.zzad().zzdh().zza("User property removed", (Object)this.zzl.zzaa().zzan(zzga2.name));
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    final void zzb(zzfs zzfs2) {
        ++this.zzsg;
    }

    final void zzgh() {
        ++this.zzsh;
    }

    final zzby zzgi() {
        return this.zzl;
    }

    @WorkerThread
    final void zzf(zzm zzm2) {
        int n;
        this.zzq();
        this.zzfy();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            return;
        }
        zzg zzg2 = this.zzdo().zzae(zzm2.packageName);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzm2.zzch)) {
            zzg2.zzl(0L);
            this.zzdo().zza(zzg2);
            this.zzdp().zzbb(zzm2.packageName);
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        long l = zzm2.zzdp;
        if (l == 0L) {
            l = this.zzl.zzz().currentTimeMillis();
        }
        if (this.zzl.zzaf().zze(zzm2.packageName, zzal.zzin)) {
            this.zzl.zzy().zzcr();
        }
        if ((n = zzm2.zzdq) != 0 && n != 1) {
            this.zzl.zzad().zzdd().zza("Incorrect app type, assuming installed app. appId, appType", zzau.zzao((String)zzm2.packageName), (Object)n);
            n = 0;
        }
        this.zzdo().beginTransaction();
        try {
            zzaj zzaj2;
            Bundle bundle;
            zzgc zzgc2;
            if (this.zzl.zzaf().zze(zzm2.packageName, zzal.zzin) && ((zzgc2 = this.zzdo().zze(zzm2.packageName, "_npa")) == null || "auto".equals(zzgc2.origin))) {
                zzga zzga2;
                if (zzm2.zzcw != null) {
                    zzga2 = new zzga("_npa", l, (Object)(zzm2.zzcw != false ? 1L : 0L), "auto");
                    if (zzgc2 == null || !zzgc2.value.equals(zzga2.zzsy)) {
                        this.zzb(zzga2, zzm2);
                    }
                } else if (zzgc2 != null) {
                    zzga2 = new zzga("_npa", l, null, "auto");
                    this.zzc(zzga2, zzm2);
                }
            }
            long l2 = l;
            zzm zzm3 = zzm2;
            zzft zzft2 = this;
            zzg zzg3 = zzft2.zzdo().zzae(zzm3.packageName);
            if (zzg3 != null) {
                zzft2.zzl.zzab();
                if (zzgd.zza((String)zzm3.zzch, (String)zzg3.getGmpAppId(), (String)zzm3.zzcv, (String)zzg3.zzao())) {
                    zzft2.zzl.zzad().zzdd().zza("New GMP App Id passed in. Removing cached database data. appId", zzau.zzao((String)zzg3.zzan()));
                    String string = zzg3.zzan();
                    zzw zzw2 = zzft2.zzdo();
                    zzw2.zzah();
                    zzw2.zzq();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzw2.getWritableDatabase();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzw2.zzad().zzdi().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzw2.zzad().zzda().zza("Error deleting application data. appId, error", zzau.zzao((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null) {
                if (zzg3.zzat() != Integer.MIN_VALUE) {
                    if (zzg3.zzat() != zzm3.zzco) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzg3.zzas());
                        zzaj2 = new zzaj("_au", new zzag(bundle), "auto", l2);
                        zzft2.zzc(zzaj2, zzm3);
                    }
                } else if (zzg3.zzas() != null && !zzg3.zzas().equals(zzm3.zzcn)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzg3.zzas());
                    zzaj2 = new zzaj("_au", new zzag(bundle), "auto", l2);
                    zzft2.zzc(zzaj2, zzm3);
                }
            }
            this.zzg(zzm2);
            zzgc2 = null;
            if (n == 0) {
                zzgc2 = this.zzdo().zzc(zzm2.packageName, "_f");
            } else if (n == 1) {
                zzgc2 = this.zzdo().zzc(zzm2.packageName, "_v");
            }
            if (zzgc2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzga zzga3;
                    zzga zzga4 = new zzga("_fot", l, (Object)l3, "auto");
                    this.zzb(zzga4, zzm2);
                    if (this.zzl.zzaf().zzw(zzm2.zzch)) {
                        zzm3 = zzm2;
                        zzft2 = this;
                        zzft2.zzq();
                        zzft2.zzl.zzej().zzaw(zzm3.packageName);
                    }
                    l2 = l;
                    zzm3 = zzm2;
                    zzft2 = this;
                    zzft2.zzq();
                    zzft2.zzfy();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzft2.zzl.zzaf().zzac(zzm3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzft2.zzl.zzaf().zzs(zzm3.packageName) && zzm3.zzdr) {
                        zzg3.putLong("_dac", 1L);
                    }
                    if (zzft2.zzl.getContext().getPackageManager() == null) {
                        zzft2.zzl.zzad().zzda().zza("PackageManager is null, first open report might be inaccurate. appId", zzau.zzao((String)zzm3.packageName));
                    } else {
                        zzaj2 = null;
                        try {
                            zzaj2 = Wrappers.packageManager((Context)zzft2.zzl.getContext()).getPackageInfo(zzm3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzft2.zzl.zzad().zzda().zza("Package info is null, first open report might be inaccurate. appId", zzau.zzao((String)zzm3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzaj2 != null && zzaj2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzaj2.firstInstallTime != zzaj2.lastUpdateTime) {
                                zzg3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzga3 = new zzga("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzft2.zzb(zzga3, zzm3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzft2.zzl.getContext()).getApplicationInfo(zzm3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzft2.zzl.zzad().zzda().zza("Application info is null, first open report might be inaccurate. appId", zzau.zzao((String)zzm3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzm3.packageName;
                    zzw zzw3 = zzft2.zzdo();
                    Preconditions.checkNotEmpty((String)string);
                    zzw3.zzq();
                    zzw3.zzah();
                    long l4 = zzw3.zzj(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    zzga3 = new zzaj("_f", new zzag((Bundle)zzg3), "auto", l2);
                    zzft2.zzc((zzaj)zzga3, zzm3);
                } else if (n == 1) {
                    zzga zzga5 = new zzga("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzga5, zzm2);
                    l2 = l;
                    zzm3 = zzm2;
                    zzft2 = this;
                    zzft2.zzq();
                    zzft2.zzfy();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzft2.zzl.zzaf().zzac(zzm3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzft2.zzl.zzaf().zzs(zzm3.packageName) && zzm3.zzdr) {
                        zzg3.putLong("_dac", 1L);
                    }
                    bundle = new zzaj("_v", new zzag((Bundle)zzg3), "auto", l2);
                    zzft2.zzc((zzaj)bundle, zzm3);
                }
                if (!this.zzl.zzaf().zze(zzm2.packageName, zzal.zzim)) {
                    l2 = l;
                    zzm3 = zzm2;
                    zzft2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzft2.zzl.zzaf().zzac(zzm3.packageName)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    bundle = new zzaj("_e", new zzag((Bundle)zzg3), "auto", l2);
                    zzft2.zzc((zzaj)bundle, zzm3);
                }
            } else if (zzm2.zzdo) {
                l2 = l;
                zzm3 = zzm2;
                zzft2 = this;
                zzg3 = new Bundle();
                bundle = new zzaj("_cd", new zzag((Bundle)zzg3), "auto", l2);
                zzft2.zzc((zzaj)bundle, zzm3);
            }
            this.zzdo().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    @WorkerThread
    private final zzm zzbk(String string) {
        zzg zzg2 = this.zzdo().zzae(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzas())) {
            this.zzl.zzad().zzdh().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzl.zzad().zzda().zza("App version does not match; dropping. appId", zzau.zzao((String)string));
            return null;
        }
        return new zzm(string, zzg2.getGmpAppId(), zzg2.zzas(), zzg2.zzat(), zzg2.zzau(), zzg2.zzav(), zzg2.zzaw(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzbk(), 0L, 0, zzg2.zzbl(), zzg2.zzbm(), false, zzg2.zzao(), zzg2.zzbn(), zzg2.zzax());
    }

    @WorkerThread
    final void zze(zzr zzr2) {
        zzm zzm2 = this.zzbk(zzr2.packageName);
        if (zzm2 != null) {
            this.zzb(zzr2, zzm2);
        }
    }

    @WorkerThread
    final void zzb(zzr zzr2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzr2);
        Preconditions.checkNotEmpty((String)zzr2.packageName);
        Preconditions.checkNotNull((Object)zzr2.origin);
        Preconditions.checkNotNull((Object)zzr2.zzdv);
        Preconditions.checkNotEmpty((String)zzr2.zzdv.name);
        this.zzq();
        this.zzfy();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            return;
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        zzr zzr3 = new zzr(zzr2);
        new zzr(zzr2).active = false;
        this.zzdo().beginTransaction();
        try {
            boolean bl = false;
            zzr zzr4 = this.zzdo().zzf(zzr3.packageName, zzr3.zzdv.name);
            if (zzr4 != null && !zzr4.origin.equals(zzr3.origin)) {
                this.zzl.zzad().zzdd().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzl.zzaa().zzan(zzr3.zzdv.name), (Object)zzr3.origin, (Object)zzr4.origin);
            }
            if (zzr4 != null && zzr4.active) {
                zzr3.origin = zzr4.origin;
                zzr3.creationTimestamp = zzr4.creationTimestamp;
                zzr3.triggerTimeout = zzr4.triggerTimeout;
                zzr3.triggerEventName = zzr4.triggerEventName;
                zzr3.zzdx = zzr4.zzdx;
                zzr3.active = zzr4.active;
                zzr3.zzdv = new zzga(zzr3.zzdv.name, zzr4.zzdv.zzsx, zzr3.zzdv.getValue(), zzr4.zzdv.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzr3.triggerEventName)) {
                zzr3.zzdv = new zzga(zzr3.zzdv.name, zzr3.creationTimestamp, zzr3.zzdv.getValue(), zzr3.zzdv.origin);
                zzr3.active = true;
                bl = true;
            }
            if (zzr3.active) {
                zzga zzga2 = zzr3.zzdv;
                zzgc zzgc2 = new zzgc(zzr3.packageName, zzr3.origin, zzga2.name, zzga2.zzsx, zzga2.getValue());
                if (this.zzdo().zza(zzgc2)) {
                    this.zzl.zzad().zzdh().zza("User property updated immediately", (Object)zzr3.packageName, (Object)this.zzl.zzaa().zzan(zzgc2.name), zzgc2.value);
                } else {
                    this.zzl.zzad().zzda().zza("(2)Too many active user properties, ignoring", zzau.zzao((String)zzr3.packageName), (Object)this.zzl.zzaa().zzan(zzgc2.name), zzgc2.value);
                }
                if (bl && zzr3.zzdx != null) {
                    zzaj zzaj2 = new zzaj(zzr3.zzdx, zzr3.creationTimestamp);
                    this.zzd(zzaj2, zzm2);
                }
            }
            if (this.zzdo().zza(zzr3)) {
                this.zzl.zzad().zzdh().zza("Conditional property added", (Object)zzr3.packageName, (Object)this.zzl.zzaa().zzan(zzr3.zzdv.name), zzr3.zzdv.getValue());
            } else {
                this.zzl.zzad().zzda().zza("Too many conditional properties, ignoring", zzau.zzao((String)zzr3.packageName), (Object)this.zzl.zzaa().zzan(zzr3.zzdv.name), zzr3.zzdv.getValue());
            }
            this.zzdo().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzr zzr2) {
        zzm zzm2 = this.zzbk(zzr2.packageName);
        if (zzm2 != null) {
            this.zzc(zzr2, zzm2);
        }
    }

    @WorkerThread
    final void zzc(zzr zzr2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzr2);
        Preconditions.checkNotEmpty((String)zzr2.packageName);
        Preconditions.checkNotNull((Object)zzr2.zzdv);
        Preconditions.checkNotEmpty((String)zzr2.zzdv.name);
        this.zzq();
        this.zzfy();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            return;
        }
        if (!zzm2.zzcr) {
            this.zzg(zzm2);
            return;
        }
        this.zzdo().beginTransaction();
        try {
            this.zzg(zzm2);
            zzr zzr3 = this.zzdo().zzf(zzr2.packageName, zzr2.zzdv.name);
            if (zzr3 != null) {
                this.zzl.zzad().zzdh().zza("Removing conditional user property", (Object)zzr2.packageName, (Object)this.zzl.zzaa().zzan(zzr2.zzdv.name));
                this.zzdo().zzg(zzr2.packageName, zzr2.zzdv.name);
                if (zzr3.active) {
                    this.zzdo().zzd(zzr2.packageName, zzr2.zzdv.name);
                }
                if (zzr2.zzdy != null) {
                    Bundle bundle = null;
                    if (zzr2.zzdy.zzfd != null) {
                        bundle = zzr2.zzdy.zzfd.zzct();
                    }
                    zzaj zzaj2 = this.zzl.zzab().zza(zzr2.packageName, zzr2.zzdy.name, bundle, zzr3.origin, zzr2.zzdy.zzfp, true, false);
                    this.zzd(zzaj2, zzm2);
                }
            } else {
                this.zzl.zzad().zzdd().zza("Conditional user property doesn't exist", zzau.zzao((String)zzr2.packageName), (Object)this.zzl.zzaa().zzan(zzr2.zzdv.name));
            }
            this.zzdo().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzdo().endTransaction();
        }
    }

    @WorkerThread
    private final zzg zzg(zzm zzm2) {
        this.zzq();
        this.zzfy();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        zzg zzg2 = this.zzdo().zzae(zzm2.packageName);
        String string = this.zzl.zzae().zzas(zzm2.packageName);
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzl, zzm2.packageName);
            zzg2.zza(this.zzl.zzab().zzgn());
            zzg2.zzd(string);
            bl = true;
        } else if (!string.equals(zzg2.zzap())) {
            zzg2.zzd(string);
            zzg2.zza(this.zzl.zzab().zzgn());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzch, (CharSequence)zzg2.getGmpAppId())) {
            zzg2.zzb(zzm2.zzch);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzcv, (CharSequence)zzg2.zzao())) {
            zzg2.zzc(zzm2.zzcv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzcj) && !zzm2.zzcj.equals(zzg2.getFirebaseInstanceId())) {
            zzg2.zze(zzm2.zzcj);
            bl = true;
        }
        if (zzm2.zzt != 0L && zzm2.zzt != zzg2.zzav()) {
            zzg2.zzh(zzm2.zzt);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzcn) && !zzm2.zzcn.equals(zzg2.zzas())) {
            zzg2.zzf(zzm2.zzcn);
            bl = true;
        }
        if (zzm2.zzco != zzg2.zzat()) {
            zzg2.zzg(zzm2.zzco);
            bl = true;
        }
        if (zzm2.zzcp != null && !zzm2.zzcp.equals(zzg2.zzau())) {
            zzg2.zzg(zzm2.zzcp);
            bl = true;
        }
        if (zzm2.zzcq != zzg2.zzaw()) {
            zzg2.zzi(zzm2.zzcq);
            bl = true;
        }
        if (zzm2.zzcr != zzg2.isMeasurementEnabled()) {
            zzg2.setMeasurementEnabled(zzm2.zzcr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzdn) && !zzm2.zzdn.equals(zzg2.zzbi())) {
            zzg2.zzh(zzm2.zzdn);
            bl = true;
        }
        if (zzm2.zzcs != zzg2.zzbk()) {
            zzg2.zzt(zzm2.zzcs);
            bl = true;
        }
        if (zzm2.zzct != zzg2.zzbl()) {
            zzg2.zzb(zzm2.zzct);
            bl = true;
        }
        if (zzm2.zzcu != zzg2.zzbm()) {
            zzg2.zzc(zzm2.zzcu);
            bl = true;
        }
        if (this.zzl.zzaf().zze(zzm2.packageName, zzal.zzin) && zzm2.zzcw != zzg2.zzbn()) {
            zzg2.zza(zzm2.zzcw);
            bl = true;
        }
        if (zzm2.zzu != 0L && zzm2.zzu != zzg2.zzax()) {
            zzg2.zzj(zzm2.zzu);
            bl = true;
        }
        if (bl) {
            this.zzdo().zza(zzg2);
        }
        return zzg2;
    }

    final String zzh(zzm zzm2) {
        Future future = this.zzl.zzac().zza((Callable)new zzfx(this, zzm2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzl.zzad().zzda().zza("Failed to get app instance id. appId", zzau.zzao((String)zzm2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzj(boolean bl) {
        this.zzgc();
    }

    static /* synthetic */ void zza(zzft zzft2, zzfy zzfy2) {
        zzft2.zza(zzfy2);
    }

    static /* synthetic */ zzg zza(zzft zzft2, zzm zzm2) {
        return zzft2.zzg(zzm2);
    }

    final class zza
    implements zzy {
        zzch zzst;
        List<Long> zzsu;
        List<zzcf> zzsv;
        private long zzsw;

        private zza() {
        }

        @Override
        public final void zzb(zzch zzch2) {
            Preconditions.checkNotNull((Object)zzch2);
            this.zzst = zzch2;
        }

        @Override
        public final boolean zza(long l, zzcf zzcf2) {
            Preconditions.checkNotNull((Object)zzcf2);
            if (this.zzsv == null) {
                this.zzsv = new ArrayList<zzcf>();
            }
            if (this.zzsu == null) {
                this.zzsu = new ArrayList<Long>();
            }
            if (this.zzsv.size() > 0 && zza.zza(this.zzsv.get(0)) != zza.zza(zzcf2)) {
                return false;
            }
            long l2 = this.zzsw + (long)zzcf2.zzly();
            if (l2 >= (long)Math.max(0, (Integer)zzal.zzgl.get(null))) {
                return false;
            }
            this.zzsw = l2;
            this.zzsv.add(zzcf2);
            this.zzsu.add(l);
            return this.zzsv.size() < Math.max(1, (Integer)zzal.zzgm.get(null));
        }

        private static long zza(zzcf zzcf2) {
            return zzcf2.zzxj / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzfu zzfu2) {
            this();
        }
    }
}

