/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import com.sun.jdi.ClassNotLoadedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.display.DisplayMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.widgets.Shell;

public class DisplayCompletionProcessor
implements IContentAssistProcessor {
    private CompletionProposalCollector fCollector;
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private String fErrorMessage = null;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DisplayCompletionProcessor() {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fCollector != null) {
            return this.fCollector.getErrorMessage();
        }
        return null;
    }

    protected void setErrorMessage(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.fErrorMessage = string;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IJavaStackFrame stackFrame;
        block9: {
            IAdaptable context;
            block7: {
                try {
                    this.setErrorMessage(DisplayMessages.DisplayCompletionProcessor_0);
                    context = DebugUITools.getDebugContext();
                    if (context != null) break block7;
                    ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{};
                    Object var5_7 = null;
                    this.releaseCollector();
                    return iCompletionProposalArray;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    this.releaseCollector();
                    throw throwable;
                }
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((stackFrame = (IJavaStackFrame)context.getAdapter((Class)clazz)) != null) break block9;
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{};
            Object var5_8 = null;
            this.releaseCollector();
            return iCompletionProposalArray;
        }
        this.setErrorMessage(null);
        ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(stackFrame, viewer, documentOffset);
        Object var5_9 = null;
        this.releaseCollector();
        return iCompletionProposalArray;
    }

    protected ICompletionProposal[] computeCompletionProposals(IJavaStackFrame stackFrame, ITextViewer viewer, int documentOffset) {
        this.setErrorMessage(null);
        try {
            IType receivingType = this.resolveType(stackFrame.getLaunch(), stackFrame.getReceivingTypeName(), this.getReceivingSourcePath(stackFrame));
            if (receivingType == null) {
                this.setErrorMessage(DisplayMessages.DisplayCompletionProcessor_1);
                return new ICompletionProposal[0];
            }
            IJavaProject project = receivingType.getJavaProject();
            IJavaVariable[] variables = stackFrame.getLocalVariables();
            char[][][] res = this.resolveLocalVariables((IVariable[])variables);
            char[][] localVariableNames = res[0];
            char[][] localVariableTypeNames = res[1];
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            this.configureResultCollector(project, selection);
            int[] localModifiers = new int[localVariableNames.length];
            Arrays.fill(localModifiers, 0);
            int insertionPosition = this.computeInsertionPosition(receivingType, stackFrame);
            receivingType.codeComplete(viewer.getDocument().get().toCharArray(), insertionPosition, documentOffset, localVariableTypeNames, localVariableNames, localModifiers, stackFrame.isStatic(), (CompletionRequestor)this.fCollector);
            IJavaCompletionProposal[] results = this.fCollector.getJavaCompletionProposals();
            if (this.fTemplateEngine != null) {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, documentOffset, null);
                TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
                IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
                System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                System.arraycopy(results, 0, total, templateResults.length, results.length);
                results = total;
            }
            return this.order(results);
        }
        catch (JavaModelException x) {
            this.handle(viewer, (CoreException)((Object)x));
        }
        catch (DebugException de) {
            this.handle(viewer, (CoreException)((Object)de));
        }
        return null;
    }

    protected int computeInsertionPosition(IType receivingType, IJavaStackFrame stackFrame) throws JavaModelException, DebugException {
        int insertion = -1;
        if (!receivingType.isBinary() && receivingType.getDeclaringType() == null) {
            ICompilationUnit stackCU = this.getCompilationUnit(stackFrame);
            ICompilationUnit typeCU = receivingType.getCompilationUnit();
            if (typeCU != null && typeCU.equals(stackCU) && stackCU != null) {
                Document doc = new Document(stackCU.getSource());
                try {
                    insertion = doc.getLineOffset(stackFrame.getLineNumber() - 1);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        }
        return insertion;
    }

    protected ICompilationUnit getCompilationUnit(IJavaStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)stackFrame);
        if (sourceElement instanceof IType) {
            return ((IType)sourceElement).getCompilationUnit();
        }
        if (sourceElement instanceof ICompilationUnit) {
            return (ICompilationUnit)sourceElement;
        }
        return null;
    }

    protected void handle(ITextViewer viewer, CoreException x) {
        Shell shell = viewer.getTextWidget().getShell();
        ErrorDialog.openError((Shell)shell, (String)DisplayMessages.DisplayCompletionProcessor_Problems_during_completion_1, (String)DisplayMessages.DisplayCompletionProcessor_An_exception_occurred_during_code_completion_2, (IStatus)x.getStatus());
        JDIDebugUIPlugin.log(x);
    }

    protected char[][][] resolveLocalVariables(IVariable[] variables) throws DebugException {
        ArrayList<char[]> localVariableNames = new ArrayList<char[]>();
        ArrayList<char[]> localVariableTypeNames = new ArrayList<char[]>();
        int i = 0;
        while (i < variables.length) {
            block5: {
                IVariable variable = variables[i];
                try {
                    localVariableTypeNames.add(this.getTranslatedTypeName(variable.getReferenceTypeName()).toCharArray());
                    localVariableNames.add(variable.getName().toCharArray());
                }
                catch (DebugException e) {
                    if (e.getStatus().getException() instanceof ClassNotLoadedException) break block5;
                    throw e;
                }
            }
            ++i;
        }
        char[][] names = new char[localVariableNames.size()][];
        int i2 = 0;
        Iterator iter = localVariableNames.iterator();
        while (iter.hasNext()) {
            names[i2++] = (char[])iter.next();
        }
        char[][] typeNames = new char[localVariableNames.size()][];
        i2 = 0;
        Iterator iter2 = localVariableTypeNames.iterator();
        while (iter2.hasNext()) {
            typeNames[i2++] = (char[])iter2.next();
        }
        return new char[][][]{names, typeNames};
    }

    protected IJavaProject getJavaProject(IStackFrame stackFrame) {
        IJavaProject project;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        return null;
    }

    protected IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    protected void configureResultCollector(IJavaProject project, ITextSelection selection) {
        this.fCollector = new CompletionProposalCollector(project);
        if (selection.getLength() != 0) {
            this.fCollector.setReplacementLength(selection.getLength());
        }
    }

    protected String[] getNestedTypeNames(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            typeName = typeName.substring(index + 1);
        }
        index = typeName.indexOf(36);
        ArrayList<String> list = new ArrayList<String>(1);
        while (index >= 0) {
            list.add(typeName.substring(0, index));
            typeName = typeName.substring(index + 1);
            index = typeName.indexOf(36);
        }
        list.add(typeName);
        return list.toArray(new String[list.size()]);
    }

    protected String getTranslatedTypeName(String typeName) {
        int index = typeName.lastIndexOf(36);
        if (index == -1) {
            return typeName;
        }
        if (index + 1 > typeName.length()) {
            return typeName;
        }
        String last = typeName.substring(index + 1);
        try {
            Integer.parseInt(last);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return typeName.replace('$', '.');
        }
    }

    protected String getReceivingSourcePath(IJavaStackFrame frame) throws DebugException {
        String typeName = frame.getReceivingTypeName();
        String sourceName = frame.getSourceName();
        if (sourceName == null || !typeName.equals(frame.getDeclaringTypeName())) {
            int dollarIndex = typeName.indexOf(36);
            if (dollarIndex >= 0) {
                typeName = typeName.substring(0, dollarIndex);
            }
            typeName = typeName.replace('.', '/');
            typeName = String.valueOf(typeName) + ".java";
        } else {
            int index = typeName.lastIndexOf(46);
            if (index >= 0) {
                typeName = typeName.substring(0, index + 1);
                typeName = typeName.replace('.', '/');
            } else {
                typeName = "";
            }
            typeName = String.valueOf(typeName) + sourceName;
        }
        return typeName;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    protected CompletionProposalCollector getCollector() {
        return this.fCollector;
    }

    protected void releaseCollector() {
        if (this.fCollector != null && this.fCollector.getErrorMessage().length() > 0 && this.fErrorMessage != null) {
            this.setErrorMessage(this.fCollector.getErrorMessage());
        }
        this.fCollector = null;
    }

    protected void setCollector(CompletionProposalCollector collector) {
        this.fCollector = collector;
    }

    protected IType getType(IJavaProject project, String originalTypeName, String typeName) throws DebugException {
        int dollarIndex = typeName.indexOf(36);
        if (dollarIndex > 0) {
            typeName = typeName.substring(0, dollarIndex);
        }
        Path sourcePath = new Path(typeName);
        IType type = null;
        try {
            IJavaElement result = project.findElement((IPath)sourcePath);
            String[] typeNames = this.getNestedTypeNames(originalTypeName);
            if (result != null) {
                if (result instanceof IClassFile) {
                    type = ((IClassFile)result).getType();
                } else if (result instanceof ICompilationUnit) {
                    type = ((ICompilationUnit)result).getType(typeNames[0]);
                } else if (result instanceof IType) {
                    type = (IType)result;
                }
            }
            int i = 1;
            while (i < typeNames.length) {
                String innerTypeName = typeNames[i];
                try {
                    Integer.parseInt(innerTypeName);
                    return type;
                }
                catch (NumberFormatException numberFormatException) {
                    type = type.getType(innerTypeName);
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            throw new DebugException(e.getStatus());
        }
        return type;
    }

    public TemplateEngine getTemplateEngine() {
        return this.fTemplateEngine;
    }

    protected IType resolveType(ILaunch launch, String typeName, String sourceName) throws DebugException {
        block16: {
            ISourceLocator sourceLocator = launch.getSourceLocator();
            if (sourceLocator != null && sourceLocator instanceof ISourceLookupDirector) {
                ISourceLookupDirector director = (ISourceLookupDirector)sourceLocator;
                try {
                    IJavaElement javaElement;
                    Object element;
                    Object[] objects = director.findSourceElements((Object)sourceName);
                    if (objects.length <= 0 || !((element = objects[0]) instanceof IAdaptable)) break block16;
                    IAdaptable adaptable = (IAdaptable)element;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((javaElement = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null) {
                        IType type = null;
                        String[] typeNames = this.getNestedTypeNames(typeName);
                        if (javaElement instanceof IClassFile) {
                            type = ((IClassFile)javaElement).getType();
                        } else if (javaElement instanceof ICompilationUnit) {
                            type = ((ICompilationUnit)javaElement).getType(typeNames[0]);
                        } else if (javaElement instanceof IType) {
                            type = (IType)javaElement;
                        }
                        if (type != null) {
                            int i = 1;
                            while (i < typeNames.length) {
                                String innerTypeName = typeNames[i];
                                try {
                                    Integer.parseInt(innerTypeName);
                                    return type;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    type = type.getType(innerTypeName);
                                    ++i;
                                }
                            }
                        }
                        return type;
                    }
                }
                catch (CoreException e) {
                    throw new DebugException(e.getStatus());
                }
            }
        }
        return null;
    }
}

