/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaLineBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class JavaWatchpointTypeChange
extends JavaLineBreakpointTypeChange {
    private String fFieldName;
    private boolean fIsAccess;
    private boolean fIsModification;

    public JavaWatchpointTypeChange(IJavaWatchpoint watchpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        super((IJavaLineBreakpoint)watchpoint, changedElement, argument, changeType);
        this.fFieldName = watchpoint.getFieldName();
        this.fIsAccess = watchpoint.isAccess();
        this.fIsModification = watchpoint.isModification();
    }

    public String getErrorMessageNoMoreExists() {
        return MessageFormat.format(RefactoringMessages.JavaWatchpointTypeChange_0, this.getDeclaringType().getElementName(), this.fFieldName);
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaWatchpointTypeChange_1, this.getDeclaringType().getElementName(), this.fFieldName);
    }

    public Change performChange(IType newType, Object undoChangedElement, Object undoArgument, int changeType) throws CoreException {
        IField newField = newType.getField(this.fFieldName);
        int start = -1;
        int end = -1;
        ISourceRange range = newField.getNameRange();
        if (range != null) {
            start = range.getOffset();
            end = start + range.getLength();
        }
        Map attributes = this.getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)newField);
        IJavaWatchpoint newWatchpoint = JDIDebugModel.createWatchpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)newType), (String)newType.getFullyQualifiedName(), (String)this.fFieldName, (int)-1, (int)start, (int)end, (int)this.getHitCount(), (boolean)true, (Map)attributes);
        newWatchpoint.setAccess(this.fIsAccess);
        newWatchpoint.setModification(this.fIsModification);
        newWatchpoint.setEnabled(this.getEnable());
        this.getBreakpoint().delete();
        return new JavaWatchpointTypeChange(newWatchpoint, undoChangedElement, undoArgument, changeType);
    }
}

