/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.ui.launcher.WorkingDirectoryBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntWorkingDirectoryBlock
extends WorkingDirectoryBlock {
    private String fDefaultWorkingDirPath;

    public String getDefaultWorkingDirPath() {
        return this.fDefaultWorkingDirPath;
    }

    protected void setDefaultWorkingDir() {
        if (this.fDefaultWorkingDirPath == null) {
            super.setDefaultWorkingDir();
            return;
        }
        this.fWorkingDirText.setText(this.fDefaultWorkingDirPath);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            try {
                this.fDefaultWorkingDirPath = ExternalToolsUtil.getLocation((ILaunchConfiguration)configuration).removeLastSegments(1).toOSString();
            }
            catch (CoreException coreException) {}
            String wd = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
            this.fWorkingDirText.setText("");
            if (wd == null || this.isSameAsDefault(wd)) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                this.fWorkingDirText.setText(wd);
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException e) {
            this.setErrorMessage(MessageFormat.format(AntLaunchConfigurationMessages.AntWorkingDirectoryBlock_0, e.getStatus().getMessage()));
            AntUIPlugin.log(e);
        }
    }

    private boolean isSameAsDefault(String workingDir) {
        return workingDir == null || workingDir.equals(this.fDefaultWorkingDirPath) || workingDir.equals(System.getProperty("user.dir"));
    }

    public void setEnabled(boolean enabled) {
        this.fUseDefaultWorkingDirButton.setEnabled(enabled);
        boolean def = this.isDefaultWorkingDirectory();
        this.fUseDefaultWorkingDirButton.setSelection(def);
        enabled = enabled && !def;
        this.fWorkingDirText.setEnabled(enabled);
        this.fWorkspaceButton.setEnabled(enabled);
        this.fFileSystemButton.setEnabled(enabled);
        this.fVariablesButton.setEnabled(enabled);
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (this.fUseDefaultWorkingDirButton.isEnabled()) {
            return super.isValid(config);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

