/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class EclipseClasspath {
    public List srcDirs = new ArrayList();
    public List classDirs = new ArrayList();
    public List inclusionLists = new ArrayList();
    public List exclusionLists = new ArrayList();
    public Map class2sourcesMap = new TreeMap();
    public Map class2includesMap = new TreeMap();
    public Map class2excludesMap = new TreeMap();
    public Map variable2valueMap = new TreeMap();
    public List rawClassPathEntries = new ArrayList();
    public List rawClassPathEntriesAbsolute = new ArrayList();
    private IJavaProject project;
    private String newProjectRoot;
    private String jreLocation;

    public EclipseClasspath(IJavaProject project) throws JavaModelException {
        this(project, null);
    }

    public EclipseClasspath(IJavaProject project, String newProjectRoot) throws JavaModelException {
        this.project = project;
        this.jreLocation = this.getJRELocation();
        this.newProjectRoot = newProjectRoot;
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            this.handleSources(entries[i]);
            this.handleVariables(entries[i]);
            this.handleJars(entries[i]);
            this.handleUserLibraries(entries[i]);
            ++i;
        }
        this.addClasses();
        this.initClassMaps();
    }

    private String getJRELocation() {
        try {
            File installLocation;
            IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.project);
            if (install != null && (installLocation = install.getInstallLocation()) != null) {
                return new Path(installLocation.toString()).toString();
            }
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        return "";
    }

    public List getClassDirsUnique() {
        return this.removeDuplicates(this.classDirs);
    }

    private void handleSources(IClasspathEntry entry) throws JavaModelException {
        String projectRoot = ExportUtil.getProjectRoot(this.project);
        String defaultClassDir = this.project.getOutputLocation().toString();
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 3) {
            IPath srcDirPath = entry.getPath();
            IPath classDirPath = entry.getOutputLocation();
            String srcDir = ExportUtil.removeProjectRoot(srcDirPath != null ? srcDirPath.toString() : projectRoot, this.project.getProject());
            String classDir = ExportUtil.removeProjectRoot(classDirPath != null ? classDirPath.toString() : defaultClassDir, this.project.getProject());
            this.srcDirs.add(srcDir);
            this.classDirs.add(classDir);
            IPath[] inclusions = entry.getInclusionPatterns();
            ArrayList<String> inclusionList = new ArrayList<String>();
            int j = 0;
            while (j < inclusions.length) {
                if (inclusions[j] != null) {
                    inclusionList.add(ExportUtil.removeProjectRoot(inclusions[j].toString(), this.project.getProject()));
                }
                ++j;
            }
            this.inclusionLists.add(inclusionList);
            IPath[] exclusions = entry.getExclusionPatterns();
            ArrayList<String> exclusionList = new ArrayList<String>();
            int j2 = 0;
            while (j2 < exclusions.length) {
                if (exclusions[j2] != null) {
                    exclusionList.add(ExportUtil.removeProjectRoot(exclusions[j2].toString(), this.project.getProject()));
                }
                ++j2;
            }
            this.exclusionLists.add(exclusionList);
        }
    }

    private void initClassMaps() {
        int i = 0;
        while (i < this.srcDirs.size()) {
            String srcDir = (String)this.srcDirs.get(i);
            String classDir = (String)this.classDirs.get(i);
            List includeList = (List)this.inclusionLists.get(i);
            List excludeList = (List)this.exclusionLists.get(i);
            TreeSet<String> sources = (TreeSet<String>)this.class2sourcesMap.get(classDir);
            if (sources == null) {
                sources = new TreeSet<String>();
            }
            sources.add(srcDir);
            this.class2sourcesMap.put(classDir, sources);
            TreeSet includes = (TreeSet)this.class2includesMap.get(classDir);
            if (includes == null) {
                includes = new TreeSet();
            }
            includes.addAll(includeList);
            this.class2includesMap.put(classDir, includes);
            TreeSet excludes = (TreeSet)this.class2excludesMap.get(classDir);
            if (excludes == null) {
                excludes = new TreeSet();
            }
            excludes.addAll(excludeList);
            this.class2excludesMap.put(classDir, excludes);
            ++i;
        }
    }

    private void handleJars(IClasspathEntry entry) {
        if (entry.getContentKind() == 2 && entry.getEntryKind() == 1) {
            String jarFileOld;
            String jarFile = entry.getPath().toString();
            if (jarFile.startsWith(this.jreLocation)) {
                return;
            }
            StringBuffer jarFileBuffer = new StringBuffer();
            StringBuffer jarFileAbsoluteBuffer = new StringBuffer();
            String jarFileAbsolute = ExportUtil.resolve(entry.getPath());
            if (jarFileAbsolute == null) {
                jarFileAbsolute = jarFile;
                if (this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                    jarFile = jarFileBuffer.toString();
                    jarFileAbsolute = jarFileAbsoluteBuffer.toString();
                }
            }
            if ((jarFile = this.newProjectRoot == null ? ExportUtil.removeProjectRoot(jarFile, this.project.getProject()) : ExportUtil.replaceProjectRoot(jarFile, this.project.getProject(), this.newProjectRoot)).equals(jarFileOld = jarFile) && this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                jarFile = jarFileBuffer.toString();
                jarFileAbsolute = jarFileAbsoluteBuffer.toString();
            }
            this.rawClassPathEntries.add(jarFile);
            this.rawClassPathEntriesAbsolute.add(jarFileAbsolute);
        }
    }

    private boolean handleSubProjectClassesDirectory(String file, StringBuffer jarFile, StringBuffer jarFileAbsolute) {
        int i;
        String subproject;
        IJavaProject javaproject;
        if (file != null && file.indexOf(47) == 0 && (javaproject = ExportUtil.getJavaProjectByName(subproject = file.substring(1, i = (i = file.indexOf("/", 1)) != -1 ? i : file.length()))) != null) {
            jarFile.setLength(0);
            jarFileAbsolute.setLength(0);
            String location = String.valueOf(javaproject.getProject().getName()) + ".location";
            jarFileAbsolute.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), ExportUtil.getProjectRoot(javaproject)));
            jarFile.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), "${" + location + "}"));
            this.variable2valueMap.put(location, ExportUtil.getProjectRoot(javaproject));
            return true;
        }
        return false;
    }

    private void handleVariables(IClasspathEntry entry) {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 4) {
            String e = entry.getPath().toString();
            int index = e.indexOf(47);
            if (index == -1) {
                index = e.indexOf(92);
            }
            String variable = e;
            String path = "";
            if (index != -1) {
                variable = e.substring(0, index);
                path = e.substring(index);
            }
            String value = JavaCore.getClasspathVariable((String)variable).toString();
            this.variable2valueMap.put(variable, value);
            this.rawClassPathEntriesAbsolute.add(String.valueOf(value) + path);
            this.rawClassPathEntries.add("${" + variable + "}" + path);
        }
    }

    private void handleUserLibraries(IClasspathEntry entry) throws JavaModelException {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 5) {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.project);
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                this.handleJars(entries[i]);
                ++i;
            }
        }
    }

    private void addClasses() {
        Iterator iter = this.classDirs.iterator();
        while (iter.hasNext()) {
            String classDir = (String)iter.next();
            if (this.newProjectRoot != null) {
                classDir = String.valueOf(this.newProjectRoot) + '/' + classDir;
            }
            this.rawClassPathEntries.add(0, classDir);
            this.rawClassPathEntriesAbsolute.add(0, classDir);
        }
    }

    public static String getClasspath(IJavaProject project) throws JavaModelException {
        List items = EclipseClasspath.getClasspathList(project);
        return EclipseClasspath.toString(items, File.pathSeparator);
    }

    public static String getClasspath(IJavaProject project, boolean includeSubProjects) throws JavaModelException {
        List items = EclipseClasspath.getClasspathList(project, includeSubProjects);
        return EclipseClasspath.toString(items, File.pathSeparator);
    }

    public static List getClasspathList(IJavaProject project) throws JavaModelException {
        EclipseClasspath instance = new EclipseClasspath(project, ExportUtil.getProjectRoot(project));
        return instance.removeDuplicates(instance.rawClassPathEntriesAbsolute);
    }

    public static List getClasspathList(IJavaProject project, boolean includeSubProjects) throws JavaModelException {
        EclipseClasspath instance = new EclipseClasspath(project, ExportUtil.getProjectRoot(project));
        List classpath = instance.rawClassPathEntriesAbsolute;
        if (!includeSubProjects) {
            return instance.removeDuplicates(classpath);
        }
        Set subprojects = ExportUtil.getClasspathProjectsRecursive(project);
        Iterator iter = subprojects.iterator();
        while (iter.hasNext()) {
            IJavaProject subproject = (IJavaProject)iter.next();
            instance = new EclipseClasspath(subproject, ExportUtil.getProjectRoot(subproject));
            classpath.addAll(instance.rawClassPathEntriesAbsolute);
        }
        return instance.removeDuplicates(classpath);
    }

    public static String toString(Collection c, String separator) {
        StringBuffer b = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            b.append((String)iter.next());
            b.append(separator);
        }
        if (c.size() > 0) {
            b.delete(b.length() - separator.length(), b.length());
        }
        return b.toString();
    }

    protected List removeDuplicates(List l) {
        ArrayList res = new ArrayList();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (res.contains(element)) continue;
            res.add(element);
        }
        return res;
    }
}

