/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

public abstract class PseudoLanguageChangeElement
extends ChangeElement {
    private List fChildren;

    public PseudoLanguageChangeElement(ChangeElement parent) {
        super(parent);
    }

    public Change getChange() {
        return null;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextChange) {
                List edits = this.collectTextEditChanges();
                viewer.setInput(TextChangePreviewViewer.createInput(change, edits.toArray(new TextEditChangeGroup[edits.size()]), this.getTextRange()));
            }
        } else {
            viewer.setInput(null);
        }
    }

    public void setEnabled(boolean enabled) {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            ChangeElement element = (ChangeElement)iter.next();
            element.setEnabled(enabled);
        }
    }

    public void setEnabledShallow(boolean enabled) {
    }

    public int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((ChangeElement)this.fChildren.get(0)).getActive();
        int i = 1;
        while (i < this.fChildren.size()) {
            ChangeElement element = (ChangeElement)this.fChildren.get(i);
            result = ACTIVATION_TABLE[element.getActive()][result];
            if (result == 1) break;
            ++i;
        }
        return result;
    }

    public ChangeElement[] getChildren() {
        if (this.fChildren == null) {
            return EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new ChangeElement[this.fChildren.size()]);
    }

    public void addChild(TextEditChangeElement child) {
        this.doAddChild(child);
    }

    public void addChild(PseudoLanguageChangeElement child) {
        this.doAddChild(child);
    }

    private void doAddChild(ChangeElement child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(child);
    }

    private DefaultChangeElement getDefaultChangeElement() {
        ChangeElement element = this.getParent();
        while (!(element instanceof DefaultChangeElement) && element != null) {
            element = element.getParent();
        }
        return (DefaultChangeElement)element;
    }

    private List collectTextEditChanges() {
        ArrayList<TextEditChangeGroup> result = new ArrayList<TextEditChangeGroup>(10);
        ChangeElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeElement child = children[i];
            if (child instanceof TextEditChangeElement) {
                result.add(((TextEditChangeElement)child).getTextEditChange());
            } else if (child instanceof PseudoLanguageChangeElement) {
                result.addAll(((PseudoLanguageChangeElement)child).collectTextEditChanges());
            }
            ++i;
        }
        return result;
    }

    public abstract IRegion getTextRange() throws CoreException;
}

