/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.util.ViewerPane;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    private Change fChange;
    private CompositeChange fTreeViewerInputChange;
    private ChangeElement fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    private ChangeElementTreeViewer fTreeViewer;
    private PageBook fPreviewContainer;
    private ChangePreviewViewerDescriptor fCurrentDescriptor;
    private IChangePreviewViewer fCurrentPreviewViewer;
    private IChangePreviewViewer fNullPreviewer;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringUIMessages.PreviewWizardPage_description);
    }

    public void setChange(Change change) {
        if (this.fChange == change) {
            return;
        }
        this.fChange = change;
        if (this.fChange instanceof CompositeChange) {
            this.fTreeViewerInputChange = (CompositeChange)this.fChange;
        } else {
            this.fTreeViewerInputChange = new CompositeChange("Dummy Change");
            this.fTreeViewerInputChange.add(this.fChange);
        }
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite parent) {
        return new ChangeElementTreeViewer(parent);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider();
    }

    protected boolean performFinish() {
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), this.fChange, this.getContainer());
        FinishResult result = this.getRefactoringWizard().internalPerformFinish(InternalAPI.INSTANCE, operation);
        if (result.isException()) {
            return true;
        }
        if (result.isInterrupted()) {
            return false;
        }
        RefactoringStatus fValidationStatus = operation.getValidationStatus();
        if (fValidationStatus != null && fValidationStatus.hasFatalError()) {
            RefactoringWizard wizard = this.getRefactoringWizard();
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)Messages.format(RefactoringUIMessages.RefactoringUI_cannot_execute, fValidationStatus.getMessageMatchingSeverity(4)));
            return true;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fPageContainer = new PageBook(parent, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(result, 512);
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setText(RefactoringUIMessages.PreviewWizardPage_changes);
        ToolBarManager tbm = pane.getToolBarManager();
        tbm.add((IAction)new NextChange());
        tbm.add((IAction)new PreviousChange());
        tbm.update(true);
        this.fTreeViewer = this.createTreeViewer((Composite)pane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        pane.setContent(this.fTreeViewer.getControl());
        this.setTreeViewerInput();
        this.fPreviewContainer = new PageBook((Composite)sashForm, 0);
        this.fNullPreviewer = new NullPreviewer();
        this.fNullPreviewer.createControl((Composite)this.fPreviewContainer);
        this.fPreviewContainer.showPage(this.fNullPreviewer.getControl());
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fCurrentDescriptor = null;
        sashForm.setWeights(new int[]{33, 67});
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createNullPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0x1000000);
        label.setText(RefactoringUIMessages.PreviewWizardPage_no_source_code_change);
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void setVisible(boolean visible) {
        this.fCurrentSelection = null;
        if (this.hasChanges()) {
            ITreeContentProvider provider;
            ChangeElement element;
            IStructuredSelection selection;
            this.fPageContainer.showPage(this.fStandardPage);
            ChangeElement treeViewerInput = (ChangeElement)this.fTreeViewer.getInput();
            if (visible && treeViewerInput != null && (selection = (IStructuredSelection)this.fTreeViewer.getSelection()).isEmpty() && (element = this.getFirstNonCompositeChange(provider = (ITreeContentProvider)this.fTreeViewer.getContentProvider(), treeViewerInput)) != null) {
                Object[] subElements;
                if (this.getRefactoringWizard().internalGetExpandFirstNode(InternalAPI.INSTANCE) && (subElements = provider.getElements((Object)element)) != null && subElements.length > 0) {
                    this.fTreeViewer.expandToLevel(element, 999);
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
            super.setVisible(visible);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(visible);
        }
        this.getRefactoringWizard().internalSetPreviewShown(InternalAPI.INSTANCE, visible);
    }

    private ChangeElement getFirstNonCompositeChange(ITreeContentProvider provider, ChangeElement input) {
        ChangeElement focus = input;
        Change change = input.getChange();
        while (change != null && change instanceof CompositeChange) {
            ChangeElement[] children = (ChangeElement[])provider.getElements((Object)focus);
            if (children == null || children.length == 0) {
                return null;
            }
            focus = children[0];
            change = focus.getChange();
        }
        return focus;
    }

    private void setTreeViewerInput() {
        if (this.fTreeViewer == null) {
            return;
        }
        DefaultChangeElement input = null;
        if (this.fTreeViewerInputChange != null) {
            input = new DefaultChangeElement(null, (Change)this.fTreeViewerInputChange);
        }
        this.fTreeViewer.setInput(input);
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangeElement element = (ChangeElement)event.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, element) || this.isChild(element, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(ChangeElement element, ChangeElement child) {
                while (child != null) {
                    if (child == element) {
                        return true;
                    }
                    child = child.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    ChangeElement newSelection = (ChangeElement)sel.getFirstElement();
                    if (newSelection != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = newSelection;
                        PreviewWizardPage.this.showPreview(newSelection);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(ChangeElement element) {
        try {
            if (element == null) {
                this.showNullPreviewer();
            } else {
                ChangePreviewViewerDescriptor descriptor = element.getChangePreviewViewerDescriptor();
                if (this.fCurrentDescriptor != descriptor) {
                    IChangePreviewViewer newViewer;
                    if (descriptor != null) {
                        newViewer = descriptor.createViewer();
                        newViewer.createControl((Composite)this.fPreviewContainer);
                    } else {
                        newViewer = this.fNullPreviewer;
                    }
                    this.fCurrentDescriptor = descriptor;
                    element.feedInput(newViewer);
                    if (this.fCurrentPreviewViewer != null && this.fCurrentPreviewViewer != this.fNullPreviewer) {
                        this.fCurrentPreviewViewer.getControl().dispose();
                    }
                    this.fCurrentPreviewViewer = newViewer;
                    this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
                } else {
                    element.feedInput(this.fCurrentPreviewViewer);
                }
            }
        }
        catch (CoreException e) {
            this.showNullPreviewer();
            ExceptionHandler.handle(e, this.getShell(), RefactoringUIMessages.PreviewWizardPage_refactoring, RefactoringUIMessages.PreviewWizardPage_Internal_error);
        }
    }

    private void showNullPreviewer() {
        this.fCurrentDescriptor = null;
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof CompositeChange) {
            return ((CompositeChange)this.fChange).getChildren().length > 0;
        }
        return true;
    }

    private static class NullPreviewer
    implements IChangePreviewViewer {
        private Label fLabel;

        NullPreviewer() {
        }

        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringUIMessages.PreviewWizardPage_no_preview);
        }

        public void refresh() {
        }

        public Control getControl() {
            return this.fLabel;
        }

        public void setInput(ChangePreviewViewerInput input) {
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_next_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.next_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealNext();
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_previous_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.previous_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealPrevious();
        }
    }
}

