/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.Policy;

class IDEIdleHelper {
    private static final int DEFAULT_GC_INTERVAL = 60000;
    private static final int DEFAULT_GC_MAX = 8000;
    private static final int GC_DELAY_MULTIPLIER = 60;
    private static final int IDLE_INTERVAL = 5000;
    private static final String PROP_GC = "ide.gc";
    private static final String PROP_GC_INTERVAL = "ide.gc.interval";
    private static final String PROP_GC_MAX = "ide.gc.max";
    protected IWorkbenchConfigurer configurer;
    private Listener idleListener;
    private long lastGC = System.currentTimeMillis();
    private int maxGC = 8000;
    private int minGCInterval = 60000;
    private int nextGCInterval = 60000;

    IDEIdleHelper(IWorkbenchConfigurer aConfigurer) {
        this.configurer = aConfigurer;
        if (!Boolean.getBoolean(PROP_GC)) {
            return;
        }
        Integer prop = Integer.getInteger(PROP_GC_INTERVAL);
        if (prop != null && prop >= 0) {
            this.minGCInterval = this.nextGCInterval = prop.intValue();
        }
        if ((prop = Integer.getInteger(PROP_GC_MAX)) != null) {
            this.maxGC = prop;
        }
        final Display display = this.configurer.getWorkbench().getDisplay();
        final Runnable handler = new Runnable(){

            public void run() {
                if (!IDEIdleHelper.this.configurer.getWorkbench().isClosing()) {
                    display.timerExec(IDEIdleHelper.this.performGC(), (Runnable)this);
                }
            }
        };
        this.idleListener = new Listener(){

            public void handleEvent(Event event) {
                display.timerExec(5000, handler);
            }
        };
        display.addFilter(2, this.idleListener);
        display.addFilter(4, this.idleListener);
    }

    protected int performGC() {
        if (!Platform.getJobManager().isIdle()) {
            return 5000;
        }
        long start = System.currentTimeMillis();
        if (start - this.lastGC < (long)this.nextGCInterval) {
            return this.nextGCInterval - (int)(start - this.lastGC);
        }
        System.gc();
        System.runFinalization();
        this.lastGC = start;
        int duration = (int)(System.currentTimeMillis() - start);
        if (Policy.DEBUG_GC) {
            System.out.println("Explicit GC took: " + duration);
        }
        if (duration > this.maxGC) {
            if (Policy.DEBUG_GC) {
                System.out.println("Further explicit GCs disabled due to long GC");
            }
            this.shutdown();
            return -1;
        }
        this.nextGCInterval = Math.max(this.minGCInterval, 60 * duration);
        if (Policy.DEBUG_GC) {
            System.out.println("Next GC to run in: " + this.nextGCInterval);
        }
        return this.nextGCInterval;
    }

    void shutdown() {
        if (this.idleListener == null) {
            return;
        }
        Display display = this.configurer.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.removeFilter(2, this.idleListener);
            display.removeFilter(4, this.idleListener);
        }
    }
}

