/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.ChangeRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDifferExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.quickdiff.CompositeRevertAction;
import org.eclipse.ui.internal.editors.quickdiff.RestoreAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertBlockAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertLineAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertSelectionAction;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.TextChangeHover;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AddMarkerAction;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;

public abstract class AbstractDecoratedTextEditor
extends StatusTextEditor {
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String LINE_NUMBER_COLOR = "lineNumberColor";
    private static final String OVERVIEW_RULER = "overviewRuler";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    private static final String DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    private MarkerAnnotationPreferences fAnnotationPreferences;
    protected IOverviewRuler fOverviewRuler;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected LineNumberRulerColumn fLineNumberRulerColumn;
    private IChangeRulerColumn fChangeRulerColumn;
    private boolean fIsChangeInformationShown;
    private AnnotationRulerColumn fAnnotationRulerColumn;
    private IDocumentProvider fImplicitDocumentProvider;
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public AbstractDecoratedTextEditor() {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.initializeKeyBindingScopes();
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fAnnotationRulerColumn = null;
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer viewer = new SourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        return sharedColors;
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference preference = (AnnotationPreference)e.next();
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        support.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
        if (!this.isOverwriteModeEnabled()) {
            this.enableOverwriteMode(false);
        }
        if (!this.isRangeIndicatorEnabled()) {
            this.getSourceViewer().removeRangeIndication();
            this.getSourceViewer().setRangeIndicator(null);
        }
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IEncodingSupport adapter = (IEncodingSupport)this.getAdapter(clazz);
        DefaultEncodingSupport encodingSupport = null;
        if (adapter instanceof DefaultEncodingSupport) {
            encodingSupport = (DefaultEncodingSupport)adapter;
        }
        if (encodingSupport == null || !encodingSupport.isEncodingError(status)) {
            return super.createStatusControl(parent, status);
        }
        Shell shell = this.getSite().getShell();
        Display display = shell.getDisplay();
        Color bgColor = display.getSystemColor(25);
        Color fgColor = display.getSystemColor(24);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setBackground(bgColor);
        composite.setForeground(fgColor);
        Control control = super.createStatusControl(composite, status);
        control.setLayoutData((Object)new GridData(768));
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData(1808));
        buttonComposite.setBackground(bgColor);
        buttonComposite.setForeground(fgColor);
        encodingSupport.createStatusEncodingChangeControl(buttonComposite, status);
        return composite;
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(OVERVIEW_RULER) : false;
    }

    public void showChangeInformation(boolean show) {
        if (show == this.fIsChangeInformationShown) {
            return;
        }
        if (this.fIsChangeInformationShown) {
            this.uninstallChangeRulerModel();
            this.showChangeRuler(false);
        } else {
            this.ensureChangeInfoCanBeDisplayed();
            this.installChangeRulerModel();
        }
        this.fIsChangeInformationShown = this.getChangeColumn() != null && this.getChangeColumn().getModel() != null;
    }

    private void installChangeRulerModel() {
        IOverviewRuler ruler;
        IChangeRulerColumn column = this.getChangeColumn();
        if (column != null) {
            column.setModel(this.getOrCreateDiffer());
        }
        if ((ruler = this.getOverviewRuler()) != null) {
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffChange");
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffAddition");
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
            ruler.update();
        }
    }

    private void uninstallChangeRulerModel() {
        IAnnotationModel model;
        IOverviewRuler ruler;
        IChangeRulerColumn column = this.getChangeColumn();
        if (column != null) {
            column.setModel(null);
        }
        if ((ruler = this.getOverviewRuler()) != null) {
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffChange");
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffAddition");
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
            ruler.update();
        }
        if ((model = this.getDiffer()) instanceof ILineDifferExtension) {
            ((ILineDifferExtension)model).suspend();
        }
    }

    private void ensureChangeInfoCanBeDisplayed() {
        if (this.fLineNumberRulerColumn != null) {
            if (!(this.fLineNumberRulerColumn instanceof IChangeRulerColumn)) {
                this.hideLineNumberRuler();
                this.showLineNumberRuler();
            }
        } else {
            this.showChangeRuler(true);
        }
    }

    public boolean isChangeInformationShowing() {
        return this.fIsChangeInformationShown;
    }

    /*
     * WARNING - void declaration
     */
    private IAnnotationModel getOrCreateDiffer() {
        IAnnotationModel differ = this.getDiffer();
        if (differ == null) {
            String defaultId;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null && (differ = new QuickDiff().createQuickDiffAnnotationModel((ITextEditor)this, defaultId = store.getString("quickdiff.defaultProvider"))) != null) {
                void var6_6;
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer == null) {
                    return null;
                }
                IAnnotationModel m = viewer.getAnnotationModel();
                if (!(m instanceof IAnnotationModelExtension)) {
                    return null;
                }
                IAnnotationModelExtension model = (IAnnotationModelExtension)m;
                var6_6.addAnnotationModel((Object)"diff", differ);
            }
        } else if (differ instanceof ILineDifferExtension && !this.fIsChangeInformationShown) {
            ((ILineDifferExtension)differ).resume();
        }
        return differ;
    }

    /*
     * WARNING - void declaration
     */
    private IAnnotationModel getDiffer() {
        void var3_3;
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return null;
        }
        IAnnotationModel m = viewer.getAnnotationModel();
        if (!(m instanceof IAnnotationModelExtension)) {
            return null;
        }
        IAnnotationModelExtension model = (IAnnotationModelExtension)m;
        return var3_3.getAnnotationModel((Object)"diff");
    }

    private IChangeRulerColumn getChangeColumn() {
        if (this.fChangeRulerColumn != null) {
            return this.fChangeRulerColumn;
        }
        if (this.fLineNumberRulerColumn instanceof IChangeRulerColumn) {
            return (IChangeRulerColumn)this.fLineNumberRulerColumn;
        }
        return null;
    }

    private void showChangeRuler(boolean show) {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            if (show && this.fChangeRulerColumn == null) {
                c.addDecorator(1, (IVerticalRulerColumn)this.createChangeRulerColumn());
            } else if (!show && this.fChangeRulerColumn != null) {
                c.removeDecorator((IVerticalRulerColumn)this.fChangeRulerColumn);
                this.fChangeRulerColumn = null;
            }
        }
    }

    private void showLineNumberRuler() {
        IVerticalRuler v;
        this.showChangeRuler(false);
        if (this.fLineNumberRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        if (this.fLineNumberRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fLineNumberRulerColumn);
            }
            this.fLineNumberRulerColumn = null;
        }
        if (this.fIsChangeInformationShown) {
            this.showChangeRuler(true);
        }
    }

    protected boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(LINE_NUMBER_RULER) : false;
    }

    protected boolean isOverwriteModeEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? !store.getBoolean(DISABLE_OVERWRITE_MODE) : true;
    }

    private boolean isRangeIndicatorEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean("show_range_indicator") : true;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean("quickdiff.quickDiff") : false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(LINE_NUMBER_COLOR)) {
                rgb = store.isDefault(LINE_NUMBER_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR) : PreferenceConverter.getColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR);
            }
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            rulerColumn.setBackground(sharedColors.getColor(rgb));
            rulerColumn.redraw();
        }
    }

    private void initializeChangeRulerColumn(IChangeRulerColumn changeColumn) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            ISourceViewer v = this.getSourceViewer();
            if (v != null && v.getAnnotationModel() != null) {
                changeColumn.setModel(v.getAnnotationModel());
            }
            Iterator iter = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
            while (iter.hasNext()) {
                RGB rgb;
                AnnotationPreference pref = (AnnotationPreference)iter.next();
                if ("org.eclipse.ui.workbench.texteditor.quickdiffChange".equals(pref.getAnnotationType())) {
                    rgb = this.getColorPreference(store, pref);
                    changeColumn.setChangedColor(sharedColors.getColor(rgb));
                    continue;
                }
                if ("org.eclipse.ui.workbench.texteditor.quickdiffAddition".equals(pref.getAnnotationType())) {
                    rgb = this.getColorPreference(store, pref);
                    changeColumn.setAddedColor(sharedColors.getColor(rgb));
                    continue;
                }
                if (!"org.eclipse.ui.workbench.texteditor.quickdiffDeletion".equals(pref.getAnnotationType())) continue;
                rgb = this.getColorPreference(store, pref);
                changeColumn.setDeletedColor(sharedColors.getColor(rgb));
            }
            RGB rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            changeColumn.setBackground(sharedColors.getColor(rgb));
            if (changeColumn instanceof LineNumberChangeRulerColumn) {
                LineNumberChangeRulerColumn lncrc = (LineNumberChangeRulerColumn)changeColumn;
                lncrc.setDisplayMode(store.getBoolean("quickdiff.characterMode"));
            }
        }
        changeColumn.redraw();
    }

    private RGB getColorPreference(IPreferenceStore store, AnnotationPreference pref) {
        RGB rgb = null;
        if (store.contains(pref.getColorPreferenceKey())) {
            rgb = store.isDefault(pref.getColorPreferenceKey()) ? pref.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)store, (String)pref.getColorPreferenceKey());
        }
        if (rgb == null) {
            rgb = pref.getColorPreferenceValue();
        }
        return rgb;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        if (this.isPrefQuickDiffAlwaysOn()) {
            LineNumberChangeRulerColumn column = new LineNumberChangeRulerColumn(this.getSharedColors());
            column.setHover((IAnnotationHover)this.createChangeHover());
            this.initializeChangeRulerColumn((IChangeRulerColumn)column);
            this.fLineNumberRulerColumn = column;
        } else {
            this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        }
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected LineChangeHover createChangeHover() {
        return new TextChangeHover();
    }

    protected IChangeRulerColumn createChangeRulerColumn() {
        ChangeRulerColumn column = new ChangeRulerColumn();
        column.setHover((IAnnotationHover)this.createChangeHover());
        this.fChangeRulerColumn = column;
        this.initializeChangeRulerColumn(this.fChangeRulerColumn);
        return this.fChangeRulerColumn;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        IPreferenceStore store = this.getPreferenceStore();
        if (ruler != null && store != null) {
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof AnnotationRulerColumn)) continue;
                this.fAnnotationRulerColumn = (AnnotationRulerColumn)column;
                Iterator iter2 = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
                while (iter2.hasNext()) {
                    AnnotationPreference preference = (AnnotationPreference)iter2.next();
                    String key = preference.getVerticalRulerPreferenceKey();
                    boolean showAnnotation = true;
                    if (key != null && store.contains(key)) {
                        showAnnotation = store.getBoolean(key);
                    }
                    if (!showAnnotation) continue;
                    this.fAnnotationRulerColumn.addAnnotationType(preference.getAnnotationType());
                }
                this.fAnnotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
                break;
            }
        }
        return ruler;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        } else if (this.isPrefQuickDiffAlwaysOn()) {
            ruler.addDecorator(1, (IVerticalRulerColumn)this.createChangeRulerColumn());
        }
        return ruler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    try {
                                        AnnotationPreference annotationPreference;
                                        String annotationType;
                                        Object type;
                                        IChangeRulerColumn column;
                                        AnnotationPreference pref;
                                        ISourceViewer sourceViewer = this.getSourceViewer();
                                        if (sourceViewer == null) {
                                            Object var8_3 = null;
                                            break block26;
                                        }
                                        String property = event.getProperty();
                                        if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(property)) {
                                            if (this.isOverviewRulerVisible()) {
                                                this.showOverviewRuler();
                                                break block27;
                                            } else {
                                                this.hideOverviewRuler();
                                            }
                                            break block27;
                                        }
                                        if (DISABLE_OVERWRITE_MODE.equals(property)) {
                                            this.enableOverwriteMode(this.isOverwriteModeEnabled());
                                            break block28;
                                        }
                                        if (LINE_NUMBER_RULER.equals(property)) {
                                            if (this.isLineNumberRulerVisible()) {
                                                this.showLineNumberRuler();
                                                break block29;
                                            } else {
                                                this.hideLineNumberRuler();
                                            }
                                            break block29;
                                        }
                                        if ("quickdiff.quickDiff".equals(property)) {
                                            this.showChangeInformation(this.isPrefQuickDiffAlwaysOn());
                                        }
                                        if ("tabWidth".equals(property)) {
                                            IPreferenceStore store = this.getPreferenceStore();
                                            if (store != null) {
                                                sourceViewer.getTextWidget().setTabs(store.getInt("tabWidth"));
                                            }
                                            break block30;
                                        }
                                        if ("undoHistorySize".equals(property) && sourceViewer instanceof ITextViewerExtension6) {
                                            IPreferenceStore store = this.getPreferenceStore();
                                            if (store != null) {
                                                ((ITextViewerExtension6)sourceViewer).getUndoManager().setMaximalUndoLevel(store.getInt("undoHistorySize"));
                                            }
                                            break block31;
                                        }
                                        if (this.fLineNumberRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
                                        }
                                        if (this.fChangeRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                            this.initializeChangeRulerColumn(this.fChangeRulerColumn);
                                        }
                                        if (this.fLineNumberRulerColumn instanceof LineNumberChangeRulerColumn && "quickdiff.characterMode".equals(property)) {
                                            this.initializeChangeRulerColumn(this.getChangeColumn());
                                        }
                                        if ("show_range_indicator".equals(property)) {
                                            if (this.isRangeIndicatorEnabled()) {
                                                this.getSourceViewer().setRangeIndicator(this.getRangeIndicator());
                                            } else {
                                                this.getSourceViewer().removeRangeIndication();
                                                this.getSourceViewer().setRangeIndicator(null);
                                            }
                                        }
                                        if ((pref = this.getAnnotationPreference(property)) != null && (column = this.getChangeColumn()) != null && (type = pref.getAnnotationType()) instanceof String && (annotationType = (String)type).startsWith("org.eclipse.ui.workbench.texteditor.quickdiff")) {
                                            this.initializeChangeRulerColumn(column);
                                        }
                                        if ((annotationPreference = this.getVerticalRulerAnnotationPreference(property)) != null && event.getNewValue() instanceof Boolean) {
                                            type = annotationPreference.getAnnotationType();
                                            if (((Boolean)event.getNewValue()).booleanValue()) {
                                                this.fAnnotationRulerColumn.addAnnotationType(type);
                                            } else {
                                                this.fAnnotationRulerColumn.removeAnnotationType(type);
                                            }
                                            this.getVerticalRuler().update();
                                        }
                                        break block32;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_9 = null;
                                        super.handlePreferenceStoreChanged(event);
                                        throw throwable;
                                    }
                                }
                                super.handlePreferenceStoreChanged(event);
                                return;
                            }
                            Object var8_4 = null;
                            super.handlePreferenceStoreChanged(event);
                            return;
                        }
                        Object var8_5 = null;
                        super.handlePreferenceStoreChanged(event);
                        return;
                    }
                    Object var8_6 = null;
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                Object var8_7 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var8_8 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var8_10 = null;
        super.handlePreferenceStoreChanged(event);
    }

    private AnnotationPreference getAnnotationPreference(String colorKey) {
        Iterator iter = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iter.hasNext()) {
            AnnotationPreference pref = (AnnotationPreference)iter.next();
            if (!colorKey.equals(pref.getColorPreferenceKey())) continue;
            return pref;
        }
        return null;
    }

    private AnnotationPreference getVerticalRulerAnnotationPreference(String preferenceKey) {
        if (preferenceKey == null) {
            return null;
        }
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (info == null || !preferenceKey.equals(info.getVerticalRulerPreferenceKey())) continue;
            return info;
        }
        return null;
    }

    protected void showOverviewRuler() {
        if (this.fOverviewRuler != null && this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return this.fAnnotationPreferences;
    }

    public void gotoMarker(IMarker marker) {
        if (this.getSourceViewer() == null) {
            return;
        }
        int start = MarkerUtilities.getCharStart(marker);
        int end = MarkerUtilities.getCharEnd(marker);
        if (start < 0 || end < 0) {
            int line = MarkerUtilities.getLineNumber(marker);
            if (line > -1) {
                --line;
                try {
                    IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    this.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            IDocument document;
            int length;
            IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
            if (model instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
                Position pos = markerModel.getMarkerPosition(marker);
                if (pos != null && !pos.isDeleted()) {
                    start = pos.getOffset();
                    end = pos.getOffset() + pos.getLength();
                }
                if (pos != null && pos.isDeleted()) {
                    return;
                }
            }
            if (end - 1 < (length = (document = this.getDocumentProvider().getDocument((Object)this.getEditorInput())).getLength()) && start < length) {
                this.selectAndReveal(start, end - start);
            }
        }
    }

    protected boolean isErrorStatus(IStatus status) {
        return super.isErrorStatus(status) && status.getCode() != 279 && status.getSeverity() != 8;
    }

    protected void createActions() {
        super.createActions();
        Object action = new AddMarkerAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddBookmark.", (ITextEditor)this, "org.eclipse.core.resources.bookmark", true);
        action.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.setAction(IDEActionFactory.BOOKMARK.getId(), (IAction)action);
        action = new AddTaskAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddTask.", (ITextEditor)this);
        action.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)action);
        action = new ChangeEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.", (ITextEditor)this);
        action.setHelpContextId("org.eclipse.ui.ChangeEncoding_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.changeEncoding");
        this.setAction("ChangeEncoding", (IAction)action);
        this.markAsPropertyDependentAction("ChangeEncoding", true);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleLineNumbersAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleLineNumberRuler();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.editors.lineNumberToggle");
        this.setAction("Linenumbers.Toggle", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleQuickDiffAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleQuickDiffRuler();
            }
        };
        action.setActionDefinitionId("org.eclipse.quickdiff.toggle");
        this.setAction("QuickDiff.Toggle", (IAction)action);
        action = new RevertLineAction((ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revertLine");
        this.setAction("QuickDiff.RevertLine", (IAction)action);
        action = new RevertSelectionAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertSelection", (IAction)action);
        action = new RevertBlockAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertBlock", (IAction)action);
        action = new RestoreAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertDeletion", (IAction)action);
        CompositeRevertAction action2 = new CompositeRevertAction(new IAction[]{this.getAction("QuickDiff.RevertSelection"), this.getAction("QuickDiff.RevertBlock"), this.getAction("QuickDiff.RevertDeletion"), this.getAction("QuickDiff.RevertLine")});
        action2.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revert");
        this.setAction("QuickDiff.Revert", (IAction)action2);
        final Shell shell = this.getSourceViewer() != null ? this.getSourceViewer().getTextWidget().getShell() : null;
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] preferencePages = AbstractDecoratedTextEditor.this.collectRulerMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        };
        this.setAction("Preferences.RulerAction", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ContextPreferencesAction."){

            public void run() {
                String[] preferencePages = AbstractDecoratedTextEditor.this.collectContextMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        };
        this.setAction("Preferences.ContextAction", (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fGotoMarkerAdapter;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getAnnotationAccess();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ISelection selection = null;
                    ISelectionProvider selectionProvider = AbstractDecoratedTextEditor.this.getSelectionProvider();
                    if (selectionProvider != null) {
                        selection = selectionProvider.getSelection();
                    }
                    return new ShowInContext((Object)AbstractDecoratedTextEditor.this.getEditorInput(), selection);
                }
            };
        }
        return super.getAdapter(adapter);
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider instanceof ForwardingDocumentProvider) {
            ForwardingDocumentProvider forwarder = (ForwardingDocumentProvider)provider;
            forwarder.setParentProvider(this.fImplicitDocumentProvider);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider == null) {
            return this.fImplicitDocumentProvider;
        }
        return provider;
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.fImplicitDocumentProvider = null;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (this.fIsChangeInformationShown) {
            if (this.isPrefQuickDiffAlwaysOn()) {
                this.uninstallChangeRulerModel();
                this.fIsChangeInformationShown = false;
            } else {
                this.showChangeInformation(false);
            }
        }
        super.doSetInput(input);
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("debug"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("restore"));
        menu.add((IContributionItem)new Separator("add"));
        menu.add((IContributionItem)new Separator("rulers"));
        menu.add((IContributionItem)new Separator("group.rest"));
        super.rulerContextMenuAboutToShow(menu);
        if (this.isEditorInputModifiable()) {
            IAction quickdiffAction = this.getAction("QuickDiff.Toggle");
            quickdiffAction.setChecked(this.isChangeInformationShowing());
            menu.appendToGroup("rulers", quickdiffAction);
            if (this.isChangeInformationShowing()) {
                RevertLineAction revertLine = new RevertLineAction((ITextEditor)this, true);
                RevertSelectionAction revertSelection = new RevertSelectionAction((ITextEditor)this, true);
                RevertBlockAction revertBlock = new RevertBlockAction((ITextEditor)this, true);
                RestoreAction revertDeletion = new RestoreAction((ITextEditor)this, true);
                revertSelection.update();
                revertBlock.update();
                revertLine.update();
                revertDeletion.update();
                if (revertSelection.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertSelection);
                } else if (revertBlock.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertBlock);
                }
                if (revertLine.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertLine);
                }
                if (revertDeletion.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertDeletion);
                }
            }
        }
        IAction lineNumberAction = this.getAction("Linenumbers.Toggle");
        lineNumberAction.setChecked(this.fLineNumberRulerColumn != null);
        menu.appendToGroup("rulers", lineNumberAction);
        IAction preferencesAction = this.getAction("Preferences.RulerAction");
        menu.appendToGroup("rulers", (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    private void toggleLineNumberRuler() {
        boolean newSetting;
        boolean bl = newSetting = this.fLineNumberRulerColumn == null;
        if (newSetting) {
            this.showLineNumberRuler();
        } else {
            this.hideLineNumberRuler();
        }
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            store.setValue(LINE_NUMBER_RULER, newSetting);
        }
    }

    private void toggleQuickDiffRuler() {
        boolean newSetting = !this.isChangeInformationShowing();
        this.showChangeInformation(newSetting);
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            store.setValue("quickdiff.quickDiff", newSetting);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        menu.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling"};
    }

    protected String[] collectRulerMenuPreferencePages() {
        return this.collectContextMenuPreferencePages();
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext undoContext) {
        if (this.getEditorInput() instanceof IStorageEditorInput) {
            IStorage affectedObject;
            try {
                affectedObject = ((IStorageEditorInput)this.getEditorInput()).getStorage();
            }
            catch (CoreException coreException) {
                affectedObject = this.getEditorInput();
            }
            Object[] objectArray = new Object[]{affectedObject};
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new NonLocalUndoUserApprover(undoContext, (IEditorPart)this, objectArray, (Class)clazz);
        }
        return super.getUndoRedoOperationApprover(undoContext);
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            AbstractDecoratedTextEditor.this.gotoMarker(marker);
        }
    }
}

