/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class MemoryViewUtil {
    public static final int[] ignoreKeyEvents = new int[]{0x1000001, 0x1000002, 0x1000003, 0x1000004, 0x1000005, 0x1000006, 0x1000007, 0x1000008, 0x1000009, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015, 0x1000016, 0x1000017, 0x1000018, 0x1000051, 16777298, 16777299, 16777300, 0x1000055, 16777302, 16777303, 27, 262144, 65536};
    static /* synthetic */ Class class$0;

    public static boolean isValidSelection(ISelection selection) {
        IMemoryBlockRetrieval memRetrieval;
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return false;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return false;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IDebugElement iDebugElement = (IDebugElement)elem;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
            memRetrieval = debugTarget;
        }
        if (debugTarget == null) {
            return false;
        }
        if (debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            return false;
        }
        return memRetrieval.supportsStorageRetrieval();
    }

    public static void openError(String title, String message, Exception e) {
        String detail = "";
        if (e != null) {
            detail = e.getMessage();
        }
        Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + "\n" + detail));
    }

    static IMemoryBlockManager getMemoryBlockManager() {
        return DebugPlugin.getDefault().getMemoryBlockManager();
    }

    public static boolean isLinuxGTK() {
        String ws = Platform.getWS();
        return ws.equals("gtk");
    }

    public static boolean isValidEditEvent(int event) {
        int i = 0;
        while (i < ignoreKeyEvents.length) {
            if (event == ignoreKeyEvents[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static BigInteger alignDoubleWordBoundary(BigInteger integer) {
        String str = integer.toString(16);
        if (!str.endsWith("0")) {
            str = str.substring(0, str.length() - 1);
            str = String.valueOf(str) + "0";
            integer = new BigInteger(str, 16);
        }
        return integer;
    }
}

