/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneSelectionProvider;
import org.eclipse.debug.internal.ui.views.memory.renderings.BasicDebugViewContentProvider;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MemoryBlocksTreeViewPane
implements ISelectionListener,
IMemoryViewPane {
    public static final String PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.MemoryBlocksTreeViewPane";
    private IViewPart fParent;
    private TreeViewer fTreeViewer;
    private MemoryBlocksViewerContentProvider fContentProvider;
    protected IDebugTarget fDebugTarget;
    private ViewPaneSelectionProvider fSelectionProvider;
    private AddMemoryBlockAction fAddMemoryBlockAction;
    private IAction fRemoveMemoryBlockAction;
    private IAction fRemoveAllMemoryBlocksAction;
    private Hashtable fTargetMemoryBlockMap = new Hashtable();
    private String fPaneId;
    private boolean fVisible = true;
    private ArrayList fMemoryBlocks = new ArrayList();

    public MemoryBlocksTreeViewPane(IViewPart parent) {
        this.fParent = parent;
        this.fSelectionProvider = new ViewPaneSelectionProvider();
    }

    public Control createViewPane(Composite parent, String paneId, String label) {
        this.fPaneId = paneId;
        this.fTreeViewer = new TreeViewer(parent);
        this.fContentProvider = new MemoryBlocksViewerContentProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new MemoryBlocksViewerLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fParent.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object mem;
                ISelection treeSelected = event.getSelection();
                MemoryBlocksTreeViewPane.this.fSelectionProvider.setSelection(treeSelected);
                if (treeSelected instanceof IStructuredSelection && (mem = ((IStructuredSelection)treeSelected).getFirstElement()) != null) {
                    MemoryBlocksTreeViewPane.this.fTargetMemoryBlockMap.put(MemoryBlocksTreeViewPane.this.fDebugTarget, mem);
                }
            }
        });
        this.populateViewPane();
        MenuManager mgr = this.createContextMenuManager();
        Menu menu = mgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fDebugTarget);
        if (memoryBlocks.length > 0) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)memoryBlocks[0]));
        }
        return this.fTreeViewer.getControl();
    }

    private void populateViewPane() {
        Object obj;
        ISelection selected = this.fParent.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selected instanceof IStructuredSelection && (obj = ((IStructuredSelection)selected).getFirstElement()) instanceof IDebugElement) {
            this.fTreeViewer.setInput((Object)((IDebugElement)obj).getDebugTarget());
        }
        ISelection selection = null;
        if (this.fParent.getSite().getSelectionProvider() != null) {
            selection = this.fParent.getSite().getSelectionProvider().getSelection();
        }
        IMemoryBlock memoryBlock = null;
        if (selection == null) {
            return;
        }
        memoryBlock = this.getMemoryBlock(selection);
        if (memoryBlock != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)memoryBlock));
        }
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    protected MenuManager createContextMenuManager() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)MemoryBlocksTreeViewPane.this.fAddMemoryBlockAction);
                manager.add(MemoryBlocksTreeViewPane.this.fRemoveMemoryBlockAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.fParent.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)this.fSelectionProvider);
        return menuMgr;
    }

    public void dispose() {
        this.fMemoryBlocks.clear();
        this.fParent.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.fContentProvider.dispose();
        this.fAddMemoryBlockAction.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IDebugTarget debugTarget;
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IDebugElement && (debugTarget = ((IDebugElement)obj).getDebugTarget()) != null && this.fTreeViewer != null && this.fDebugTarget != debugTarget) {
                IMemoryBlock[] memBlks;
                this.fTreeViewer.setInput((Object)debugTarget);
                Object selectedObj = this.fTargetMemoryBlockMap.get(debugTarget);
                if (selectedObj == null && (memBlks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(debugTarget)).length > 0) {
                    selectedObj = memBlks[0];
                }
                if (selectedObj != null) {
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection(selectedObj));
                }
            }
            if (obj instanceof IMemoryBlock && part == this.fParent) {
                ISelection treeSel = this.fTreeViewer.getSelection();
                if (treeSel instanceof IStructuredSelection && ((IStructuredSelection)treeSel).getFirstElement() == obj) {
                    return;
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(obj));
            }
        }
    }

    public String getId() {
        return this.fPaneId;
    }

    public IAction[] getActions() {
        if (this.fAddMemoryBlockAction == null) {
            this.fAddMemoryBlockAction = new AddMemoryBlockAction((IMemoryRenderingSite)this.fParent);
        }
        if (this.fRemoveMemoryBlockAction == null) {
            this.fRemoveMemoryBlockAction = new TreeViewerRemoveMemoryBlocksAction();
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            this.fRemoveAllMemoryBlocksAction = new TreeViewerRemoveAllMemoryBlocksAction();
        }
        this.updateActionsEnablement();
        return new IAction[]{this.fAddMemoryBlockAction, this.fRemoveMemoryBlockAction, this.fRemoveAllMemoryBlocksAction};
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ViewPaneSelectionProvider();
        }
        this.fSelectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelctionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            return;
        }
        this.fSelectionProvider.removeSelectionChangedListener(listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void restoreViewPane() {
        this.populateViewPane();
        this.updateActionsEnablement();
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public void setVisible(boolean visible) {
        if (this.fVisible != visible) {
            this.fVisible = visible;
            if (this.fVisible) {
                this.fTreeViewer.refresh();
            }
        }
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    private void updateActionsEnablement() {
        if (this.fRemoveMemoryBlockAction == null) {
            return;
        }
        if (this.fMemoryBlocks == null) {
            return;
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            return;
        }
        if (this.fMemoryBlocks.size() > 0) {
            this.fRemoveMemoryBlockAction.setEnabled(true);
            this.fRemoveAllMemoryBlocksAction.setEnabled(true);
        } else {
            this.fRemoveMemoryBlockAction.setEnabled(false);
            this.fRemoveAllMemoryBlocksAction.setEnabled(false);
        }
    }

    static /* synthetic */ IViewPart access$3(MemoryBlocksTreeViewPane memoryBlocksTreeViewPane) {
        return memoryBlocksTreeViewPane.fParent;
    }

    class TreeViewerRemoveMemoryBlocksAction
    extends Action {
        TreeViewerRemoveMemoryBlocksAction() {
            this.setText(DebugUIMessages.RemoveMemoryBlockAction_title);
            this.setToolTipText(DebugUIMessages.RemoveMemoryBlockAction_tooltip);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveMemoryBlockAction_context");
            this.setEnabled(true);
        }

        public void run() {
            ISelection selected = MemoryBlocksTreeViewPane.this.fTreeViewer.getSelection();
            if (selected != null && selected instanceof IStructuredSelection) {
                Object[] selectedMemBlks = ((IStructuredSelection)selected).toArray();
                IMemoryBlock[] memBlocks = new IMemoryBlock[selectedMemBlks.length];
                System.arraycopy(selectedMemBlks, 0, memBlocks, 0, selectedMemBlks.length);
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memBlocks);
            }
        }
    }

    class TreeViewerRemoveAllMemoryBlocksAction
    extends Action {
        TreeViewerRemoveAllMemoryBlocksAction() {
            this.setText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setToolTipText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_ALL"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_ALL"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_ALL"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveAllMemoryBlocksAction_context");
        }

        public void run() {
            IContentProvider contentProvider;
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            boolean proceed = MessageDialog.openQuestion((Shell)window.getShell(), (String)DebugUIMessages.MemoryBlocksTreeViewPane_0, (String)DebugUIMessages.MemoryBlocksTreeViewPane_1);
            if (proceed && (contentProvider = MemoryBlocksTreeViewPane.this.fTreeViewer.getContentProvider()) instanceof IStructuredContentProvider) {
                IStructuredContentProvider strucContentProv = (IStructuredContentProvider)contentProvider;
                Object[] elements = strucContentProv.getElements((Object)MemoryBlocksTreeViewPane.this.fDebugTarget);
                IMemoryBlock[] memBlocks = new IMemoryBlock[elements.length];
                System.arraycopy(elements, 0, memBlocks, 0, elements.length);
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memBlocks);
            }
        }
    }

    class MemoryBlocksViewerContentProvider
    extends BasicDebugViewContentProvider
    implements IMemoryBlockListener,
    ITreeContentProvider {
        public MemoryBlocksViewerContentProvider() {
            DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != MemoryBlocksTreeViewPane.this.fDebugTarget && newInput instanceof IDebugTarget) {
                MemoryBlocksTreeViewPane.this.fDebugTarget = (IDebugTarget)newInput;
                MemoryBlocksTreeViewPane.this.fMemoryBlocks.clear();
                this.getMemoryBlocks();
                MemoryBlocksTreeViewPane.this.updateActionsEnablement();
            }
            super.inputChanged(viewer, oldInput, newInput);
        }

        private void getMemoryBlocks() {
            if (MemoryBlocksTreeViewPane.this.fDebugTarget == null) {
                return;
            }
            IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksTreeViewPane.this.fDebugTarget);
            int i = 0;
            while (i < memoryBlocks.length) {
                if (!MemoryBlocksTreeViewPane.this.fMemoryBlocks.contains(memoryBlocks[i])) {
                    MemoryBlocksTreeViewPane.this.fMemoryBlocks.add(memoryBlocks[i]);
                }
                ++i;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IDebugTarget) {
                MemoryBlocksTreeViewPane.this.fDebugTarget = (IDebugTarget)inputElement;
                return MemoryBlocksTreeViewPane.this.fMemoryBlocks.toArray(new IMemoryBlock[MemoryBlocksTreeViewPane.this.fMemoryBlocks.size()]);
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
            super.dispose();
            DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            DebugUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(this, memory){
                final /* synthetic */ MemoryBlocksViewerContentProvider this$1;
                private final /* synthetic */ IMemoryBlock[] val$memory;
                {
                    this.this$1 = memoryBlocksViewerContentProvider;
                    this.val$memory = iMemoryBlockArray;
                }

                public void run() {
                    if (MemoryBlocksViewerContentProvider.access$0(this.this$1)) {
                        return;
                    }
                    boolean setSelection = false;
                    if (MemoryBlocksTreeViewPane.access$1(MemoryBlocksViewerContentProvider.access$1(this.this$1)).size() == 0) {
                        setSelection = true;
                    }
                    IMemoryBlock[] memoryBlocks = this.val$memory;
                    int i = 0;
                    while (i < memoryBlocks.length) {
                        if (!MemoryBlocksTreeViewPane.access$1(MemoryBlocksViewerContentProvider.access$1(this.this$1)).contains(memoryBlocks[i])) {
                            MemoryView mv;
                            MemoryBlocksTreeViewPane.access$1(MemoryBlocksViewerContentProvider.access$1(this.this$1)).add(memoryBlocks[i]);
                            if (MemoryBlocksTreeViewPane.access$3(MemoryBlocksViewerContentProvider.access$1(this.this$1)) instanceof MemoryView && (mv = (MemoryView)MemoryBlocksTreeViewPane.access$3(MemoryBlocksViewerContentProvider.access$1(this.this$1))).isMemoryBlockRegistered(memoryBlocks[i])) {
                                setSelection = true;
                            }
                        }
                        ++i;
                    }
                    MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).refresh();
                    if (MemoryBlocksTreeViewPane.access$3(MemoryBlocksViewerContentProvider.access$1(this.this$1)) instanceof MemoryView) {
                        MemoryView mv = (MemoryView)MemoryBlocksTreeViewPane.access$3(MemoryBlocksViewerContentProvider.access$1(this.this$1));
                        if (!mv.isPinMBDisplay() || setSelection) {
                            MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object[])this.val$memory));
                            MemoryBlocksTreeViewPane.access$4(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object[])this.val$memory));
                        }
                    } else {
                        MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object[])this.val$memory));
                        MemoryBlocksTreeViewPane.access$4(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object[])this.val$memory));
                    }
                    MemoryBlocksTreeViewPane.access$2(MemoryBlocksViewerContentProvider.access$1(this.this$1));
                }
            });
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            DebugUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(this, memory){
                final /* synthetic */ MemoryBlocksViewerContentProvider this$1;
                private final /* synthetic */ IMemoryBlock[] val$memory;
                {
                    this.this$1 = memoryBlocksViewerContentProvider;
                    this.val$memory = iMemoryBlockArray;
                }

                public void run() {
                    int i = 0;
                    while (i < this.val$memory.length) {
                        MemoryBlocksTreeViewPane.access$1(MemoryBlocksViewerContentProvider.access$1(this.this$1)).remove(this.val$memory[i]);
                        ++i;
                    }
                    if (!MemoryBlocksViewerContentProvider.access$0(this.this$1)) {
                        MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).refresh();
                        IStructuredSelection selection = (IStructuredSelection)MemoryBlocksTreeViewPane.access$4(MemoryBlocksViewerContentProvider.access$1(this.this$1)).getSelection();
                        if (!selection.isEmpty()) {
                            IMemoryBlock currentSel = (IMemoryBlock)selection.getFirstElement();
                            IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksViewerContentProvider.access$1((MemoryBlocksViewerContentProvider)this.this$1).fDebugTarget);
                            boolean selectionRemoved = true;
                            int i2 = 0;
                            while (i2 < memoryBlocks.length) {
                                if (memoryBlocks[i2] == currentSel) {
                                    selectionRemoved = false;
                                }
                                ++i2;
                            }
                            if (selectionRemoved && memoryBlocks != null && memoryBlocks.length > 0) {
                                MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)memoryBlocks[0]));
                            }
                        } else {
                            IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksViewerContentProvider.access$1((MemoryBlocksViewerContentProvider)this.this$1).fDebugTarget);
                            if (memoryBlocks != null && memoryBlocks.length > 0) {
                                MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$1(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)memoryBlocks[0]));
                            }
                        }
                    }
                    MemoryBlocksTreeViewPane.access$2(MemoryBlocksViewerContentProvider.access$1(this.this$1));
                }
            });
        }

        protected void doHandleDebugEvent(DebugEvent event) {
            IDebugElement elem;
            if (this.fDisposed) {
                return;
            }
            if (event.getKind() == 8) {
                if (event.getSource() == MemoryBlocksTreeViewPane.this.fDebugTarget) {
                    MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(null);
                } else if (event.getSource() instanceof IDebugTarget) {
                    IDebugTarget target = (IDebugTarget)event.getSource();
                    MemoryBlocksTreeViewPane.this.fTargetMemoryBlockMap.remove(target);
                }
            } else if (event.getKind() == 2 && event.getSource() instanceof IDebugElement && (elem = (IDebugElement)event.getSource()).getDebugTarget() == MemoryBlocksTreeViewPane.this.fDebugTarget && MemoryBlocksTreeViewPane.this.fVisible) {
                MemoryBlocksTreeViewPane.this.fTreeViewer.refresh();
            }
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDebugTarget) {
                return null;
            }
            return MemoryBlocksTreeViewPane.this.fDebugTarget;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IDebugTarget;
        }

        static /* synthetic */ boolean access$0(MemoryBlocksViewerContentProvider memoryBlocksViewerContentProvider) {
            return memoryBlocksViewerContentProvider.fDisposed;
        }

        static /* synthetic */ MemoryBlocksTreeViewPane access$1(MemoryBlocksViewerContentProvider memoryBlocksViewerContentProvider) {
            return memoryBlocksViewerContentProvider.MemoryBlocksTreeViewPane.this;
        }
    }

    class MemoryBlocksViewerLabelProvider
    extends LabelProvider {
        MemoryBlocksViewerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IMemoryBlock) {
                return DebugPluginImages.getImage("IMG_OBJS_VARIABLE");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IMemoryBlock) {
                return this.getLabel((IMemoryBlock)element);
            }
            return element.toString();
        }

        private String getLabel(IMemoryBlock memoryBlock) {
            String memoryBlockLabel = " ";
            if (memoryBlock instanceof IMemoryBlockExtension) {
                if (((IMemoryBlockExtension)memoryBlock).getExpression() != null) {
                    memoryBlockLabel = String.valueOf(memoryBlockLabel) + ((IMemoryBlockExtension)memoryBlock).getExpression();
                }
            } else {
                long address = memoryBlock.getStartAddress();
                memoryBlockLabel = Long.toHexString(address);
            }
            return memoryBlockLabel;
        }
    }
}

