/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CodePagesPrefDialog
extends Dialog {
    private Text fAsciiCodePage;
    private Text fEbcdicCodePage;

    public CodePagesPrefDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".CodePagesPrefDialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DebugUIMessages.CodePagesPrefDialog_1);
        this.setShellStyle(16);
        Composite canvas = new Composite(parent, 0);
        canvas.setLayout((Layout)new GridLayout(2, false));
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = true;
        spec2.grabExcessHorizontalSpace = true;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 2;
        canvas.setLayoutData((Object)spec2);
        Label textLabel = new Label(canvas, 64);
        textLabel.setText(DebugUIMessages.CodePagesPrefDialog_2);
        GridData textLayout = new GridData();
        textLayout.widthHint = 280;
        textLayout.horizontalSpan = 2;
        textLabel.setLayoutData((Object)textLayout);
        this.fAsciiCodePage = new Text(canvas, 2048);
        GridData asciispec = new GridData();
        asciispec.grabExcessVerticalSpace = false;
        asciispec.grabExcessHorizontalSpace = true;
        asciispec.horizontalAlignment = 4;
        asciispec.verticalAlignment = 1;
        asciispec.horizontalSpan = 1;
        this.fAsciiCodePage.setLayoutData((Object)asciispec);
        String codepage = DebugUITools.getPreferenceStore().getString(IDebugUIConstants.PREF_DEFAULT_ASCII_CODE_PAGE);
        if (codepage == null || codepage.length() == 0) {
            codepage = "CP1252";
        }
        this.fAsciiCodePage.setText(codepage);
        Label ebcdicLabel = new Label(canvas, 64);
        ebcdicLabel.setText(DebugUIMessages.CodePagesPrefDialog_4);
        GridData ebcdicLayout = new GridData();
        ebcdicLayout.widthHint = 280;
        ebcdicLayout.horizontalSpan = 2;
        ebcdicLabel.setLayoutData((Object)ebcdicLayout);
        this.fEbcdicCodePage = new Text(canvas, 2048);
        GridData ebcdicspec = new GridData();
        ebcdicspec.grabExcessVerticalSpace = false;
        ebcdicspec.grabExcessHorizontalSpace = true;
        ebcdicspec.horizontalAlignment = 4;
        ebcdicspec.verticalAlignment = 1;
        ebcdicspec.horizontalSpan = 1;
        this.fAsciiCodePage.setLayoutData((Object)ebcdicspec);
        this.fEbcdicCodePage.setLayoutData((Object)asciispec);
        codepage = DebugUITools.getPreferenceStore().getString(IDebugUIConstants.PREF_DEFAULT_EBCDIC_CODE_PAGE);
        this.fEbcdicCodePage.setText(codepage);
        if (codepage == null || codepage.length() == 0) {
            codepage = "CP037";
        }
        return canvas;
    }

    protected void okPressed() {
        String asciiCodePage = this.fAsciiCodePage.getText();
        asciiCodePage = asciiCodePage.trim();
        try {
            new String(new byte[]{1}, asciiCodePage);
        }
        catch (UnsupportedEncodingException e) {
            Shell shell = DebugUIPlugin.getShell();
            if (shell != null) {
                IStatus status = DebugUIPlugin.newErrorStatus(DebugUIMessages.CodePagesPrefDialog_0, e);
                ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.CodePagesPrefDialog_6, (String)DebugUIMessages.CodePagesPrefDialog_7, (IStatus)status);
            }
            return;
        }
        String ebcdicCodePage = this.fEbcdicCodePage.getText();
        ebcdicCodePage = ebcdicCodePage.trim();
        try {
            new String(new byte[]{1}, ebcdicCodePage);
        }
        catch (UnsupportedEncodingException e) {
            Shell shell = DebugUIPlugin.getShell();
            if (shell != null) {
                IStatus status = DebugUIPlugin.newErrorStatus(DebugUIMessages.CodePagesPrefDialog_0, e);
                ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.CodePagesPrefDialog_8, (String)DebugUIMessages.CodePagesPrefDialog_9, (IStatus)status);
            }
            return;
        }
        IPreferenceStore store = DebugUITools.getPreferenceStore();
        store.setValue(IDebugUIConstants.PREF_DEFAULT_ASCII_CODE_PAGE, asciiCodePage);
        store.setValue(IDebugUIConstants.PREF_DEFAULT_EBCDIC_CODE_PAGE, ebcdicCodePage);
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button defaultButton = this.createButton(parent, 3, DebugUIMessages.CodePagesPrefDialog_13, false);
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String defaultASCII = "CP1252";
                CodePagesPrefDialog.this.fAsciiCodePage.setText(defaultASCII);
                String defaulgEBCDIC = "CP037";
                CodePagesPrefDialog.this.fEbcdicCodePage.setText(defaulgEBCDIC);
            }
        });
        super.createButtonsForButtonBar(parent);
    }
}

