/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Plugin;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2PreferencePage;

class JSchSession {
    private static final int SSH_DEFAULT_PORT = 22;
    private static JSch jsch = new JSch();
    private static Hashtable pool = new Hashtable();
    private static String current_ssh_home = null;
    private final Session session;
    private final UserInfo prompter;
    private final ICVSRepositoryLocation location;

    protected static int getCVSTimeoutInMillis() {
        return CVSProviderPlugin.getPlugin().getTimeout() * 1000;
    }

    public static boolean isAuthenticationFailure(JSchException ee) {
        return ee.getMessage().equals("Auth fail");
    }

    /*
     * Unable to fully structure code
     */
    static JSchSession getSession(ICVSRepositoryLocation location, String username, String password, String hostname, int port, IProgressMonitor monitor) throws JSchException {
        if (port == 0) {
            port = JSchSession.getPort(location);
        }
        store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        if (JSchSession.current_ssh_home == null || !JSchSession.current_ssh_home.equals(ssh_home)) {
            JSchSession.current_ssh_home = ssh_home;
            if (ssh_home.length() == 0) {
                ssh_home = CVSSSH2Plugin.SSH_HOME_DEFAULT;
            }
            try {
                JSchSession.loadKnownHosts();
                pkeys = store.getString("CVSSSH2PreferencePage.PRIVATEKEY");
                pkey = pkeys.split(",");
                i = 0;
                while (i < pkey.length) {
                    file = new File(ssh_home, pkey[i]);
                    if (file.exists()) {
                        JSchSession.jsch.addIdentity(file.getPath());
                    }
                    ++i;
                }
            }
            catch (Exception v0) {}
        }
        key = JSchSession.getPoolKey(username, hostname, port);
        try {
            block26: {
                block24: {
                    block25: {
                        jschSession = (JSchSession)JSchSession.pool.get(key);
                        if (jschSession != null && !jschSession.getSession().isConnected()) {
                            JSchSession.pool.remove(key);
                            jschSession = null;
                        }
                        if (jschSession != null) break block26;
                        useProxy = store.getString("CVSSSH2PreferencePage.PROXY").equals("true");
                        proxy = null;
                        if (useProxy) {
                            _type = store.getString("CVSSSH2PreferencePage.PROXY_TYPE");
                            _host = store.getString("CVSSSH2PreferencePage.PROXY_HOST");
                            _port = store.getString("CVSSSH2PreferencePage.PROXY_PORT");
                            useAuth = store.getString("CVSSSH2PreferencePage.PROXY_AUTH").equals("true");
                            _user = "";
                            _pass = "";
                            map = Platform.getAuthorizationInfo((URL)CVSSSH2PreferencePage.FAKE_URL, (String)"proxy", (String)"");
                            if (map != null) {
                                _user = (String)map.get("CVSSSH2PreferencePage.PROXY_USER");
                                _pass = (String)map.get("CVSSSH2PreferencePage.PROXY_PASS");
                            }
                            proxyhost = String.valueOf(_host) + ":" + _port;
                            if (_type.equals("HTTP")) {
                                proxy = new ProxyHTTP(proxyhost);
                                if (useAuth) {
                                    proxy.setUserPasswd(_user, _pass);
                                }
                            } else if (_type.equals("SOCKS5")) {
                                proxy = new ProxySOCKS5(proxyhost);
                                if (useAuth) {
                                    ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
                                }
                            } else {
                                proxy = null;
                            }
                        }
                        ui = new MyUserInfo(username, password, location);
                        wrapperUI = new UserInfoTimer(ui);
                        ui.aboutToConnect();
                        session = null;
                        try {
                            session = JSchSession.createSession(username, password, hostname, port, new ResponsiveSocketFacory(monitor), proxy, wrapperUI);
                            break block24;
                        }
                        catch (JSchException e) {
                            if (JSchSession.isAuthenticationFailure(e) && wrapperUI.hasPromptExceededTimeout()) {
                                session = JSchSession.createSession(username, password, hostname, port, new ResponsiveSocketFacory(monitor), proxy, wrapperUI);
                                break block24;
                            }
                            if (!JSchSession.isHostKeyChangeError(e) || !ui.isPurgeHostKey()) break block25;
                            hkr = JSchSession.getJSch().getHostKeyRepository();
                            keys = hkr.getHostKey();
                            i = 0;
                            ** while (i < keys.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            hostKey = keys[i];
                            if (hostKey.getHost().equals(hostname)) {
                                hkr.remove(hostKey.getHost(), hostKey.getType());
                            }
                            ++i;
                            continue;
                        }
lbl76:
                        // 1 sources

                        session = JSchSession.createSession(username, password, hostname, port, new ResponsiveSocketFacory(monitor), (Proxy)proxy, wrapperUI);
                        break block24;
                    }
                    throw e;
                }
                ui.connectionMade();
                schSession = new JSchSession(session, location, wrapperUI);
                JSchSession.pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            JSchSession.pool.remove(key);
            if (e.toString().indexOf("Auth cancel") != -1) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private static boolean isHostKeyChangeError(JSchException e) {
        return e.getMessage().equals("HostKey has been changed");
    }

    private static Session createSession(String username, String password, String hostname, int port, SocketFactory socketFactory, Proxy proxy, UserInfo wrapperUI) throws JSchException {
        Session session = jsch.getSession(username, hostname, port);
        if (proxy != null) {
            session.setProxy(proxy);
        }
        session.setPassword(password);
        session.setUserInfo(wrapperUI);
        session.setSocketFactory(socketFactory);
        try {
            session.connect();
        }
        catch (JSchException e) {
            if (session.isConnected()) {
                session.disconnect();
            }
            throw e;
        }
        return session;
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return String.valueOf(username) + "@" + hostname + ":" + port;
    }

    private static String getPoolKey(ICVSRepositoryLocation location) {
        return String.valueOf(location.getUsername()) + "@" + location.getHost() + ":" + JSchSession.getPort(location);
    }

    private static int getPort(ICVSRepositoryLocation location) {
        int port = location.getPort();
        if (port == 0) {
            port = 22;
        }
        return port;
    }

    static void loadKnownHosts() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        String ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        if (ssh_home.length() == 0) {
            ssh_home = CVSSSH2Plugin.SSH_HOME_DEFAULT;
        }
        try {
            File file = new File(ssh_home, "known_hosts");
            jsch.setKnownHosts(file.getPath());
        }
        catch (Exception exception) {}
    }

    static void shutdown() {
        if (jsch != null && pool.size() > 0) {
            Enumeration e = pool.elements();
            while (e.hasMoreElements()) {
                JSchSession session = (JSchSession)e.nextElement();
                try {
                    session.getSession().disconnect();
                }
                catch (Exception exception) {}
            }
            pool.clear();
        }
    }

    static JSch getJSch() {
        return jsch;
    }

    private JSchSession(Session session, ICVSRepositoryLocation location, UserInfo prompter) {
        this.session = session;
        this.location = location;
        this.prompter = prompter;
    }

    public Session getSession() {
        return this.session;
    }

    public UserInfo getPrompter() {
        return this.prompter;
    }

    public boolean hasPromptExceededTimeout() {
        UserInfoTimer timer;
        if (this.prompter instanceof UserInfoTimer && !(timer = (UserInfoTimer)this.prompter).isPrompting()) {
            return timer.getLastDuration() > (long)JSchSession.getCVSTimeoutInMillis();
        }
        return false;
    }

    public void dispose() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        pool.remove(JSchSession.getPoolKey(this.location));
    }

    public static class SimpleSocketFactory
    implements SocketFactory {
        InputStream in = null;
        OutputStream out = null;

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = new Socket(host, port);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            if (this.in == null) {
                this.in = socket.getInputStream();
            }
            return this.in;
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            if (this.out == null) {
                this.out = socket.getOutputStream();
            }
            return this.out;
        }
    }

    public static class ResponsiveSocketFacory
    extends SimpleSocketFactory {
        private IProgressMonitor monitor;

        public ResponsiveSocketFacory(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = Util.createSocket((String)host, (int)port, (IProgressMonitor)this.monitor);
            this.monitor = new NullProgressMonitor();
            socket.setSoTimeout(JSchSession.getCVSTimeoutInMillis());
            return socket;
        }
    }

    private static class UserInfoTimer
    implements UserInfo,
    UIKeyboardInteractive {
        private UserInfo wrappedInfo;
        private long startTime;
        private long endTime;
        private boolean prompting;

        public UserInfoTimer(UserInfo wrappedInfo) {
            this.wrappedInfo = wrappedInfo;
        }

        private synchronized void startTimer() {
            this.prompting = true;
            this.startTime = System.currentTimeMillis();
        }

        private synchronized void endTimer() {
            this.prompting = false;
            this.endTime = System.currentTimeMillis();
        }

        public long getLastDuration() {
            return Math.max(0L, this.endTime - this.startTime);
        }

        public boolean hasPromptExceededTimeout() {
            if (!this.isPrompting()) {
                return this.getLastDuration() > (long)JSchSession.getCVSTimeoutInMillis();
            }
            return false;
        }

        public String getPassphrase() {
            return this.wrappedInfo.getPassphrase();
        }

        public String getPassword() {
            return this.wrappedInfo.getPassword();
        }

        public boolean promptPassword(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptPassword(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean promptPassphrase(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptPassphrase(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean promptYesNo(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptYesNo(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void showMessage(String arg0) {
            try {
                this.startTimer();
                this.wrappedInfo.showMessage(arg0);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.endTimer();
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.endTimer();
                return;
            }
        }

        public String[] promptKeyboardInteractive(String arg0, String arg1, String arg2, String[] arg3, boolean[] arg4) {
            try {
                this.startTimer();
                String[] stringArray = ((UIKeyboardInteractive)this.wrappedInfo).promptKeyboardInteractive(arg0, arg1, arg2, arg3, arg4);
                Object var6_7 = null;
                this.endTimer();
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean isPrompting() {
            return this.prompting;
        }
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String username;
        private String password;
        private String passphrase;
        private ICVSRepositoryLocation location;
        private IUserAuthenticator authenticator;
        private int attemptCount;
        private boolean passwordChanged;
        private boolean purgeHostKey;

        MyUserInfo(String username, String password, ICVSRepositoryLocation location) {
            this.location = location;
            this.username = username;
            this.password = password;
            ICVSRepositoryLocation _location = location;
            if (_location == null) {
                String dummy = ":extssh:dummy@dummy:/";
                try {
                    _location = CVSRepositoryLocation.fromString((String)dummy);
                }
                catch (CVSException cVSException) {}
            }
            this.authenticator = _location.getUserAuthenticator();
        }

        public String getPassword() {
            return this.password;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptYesNo(String str) {
            int prompt = this.authenticator.prompt(this.location, 3, CVSSSH2Messages.JSchSession_5, str, new int[]{2, 3}, 0);
            return prompt == 0;
        }

        private String promptSecret(String message, boolean includeLocation) throws CVSException {
            String[] _password = new String[1];
            IUserInfo info = new IUserInfo(this, _password){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String[] val$_password;
                {
                    this.this$1 = myUserInfo;
                    this.val$_password = stringArray;
                }

                public String getUsername() {
                    return MyUserInfo.access$0(this.this$1);
                }

                public boolean isUsernameMutable() {
                    return false;
                }

                public void setPassword(String password) {
                    this.val$_password[0] = password;
                }

                public void setUsername(String username) {
                }
            };
            try {
                this.authenticator.promptForUserInfo(includeLocation ? this.location : null, info, message);
            }
            catch (OperationCanceledException operationCanceledException) {
                _password[0] = null;
            }
            return _password[0];
        }

        public boolean promptPassphrase(String message) {
            try {
                String _passphrase = this.promptSecret(message, false);
                if (_passphrase != null) {
                    this.passphrase = _passphrase;
                }
                return _passphrase != null;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }

        public boolean promptPassword(String message) {
            try {
                String _password = this.promptSecret(message, true);
                if (_password != null) {
                    this.password = _password;
                    if (this.location != null) {
                        ((CVSRepositoryLocation)this.location).setPassword(this.password);
                    }
                }
                return _password != null;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }

        public void showMessage(String message) {
            if (this.isHostKeyChangeWarning(message)) {
                this.handleHostKeyChange();
            } else {
                this.authenticator.prompt(this.location, 2, CVSSSH2Messages.JSchSession_5, message, new int[1], 0);
            }
        }

        private void handleHostKeyChange() {
            this.purgeHostKey = this.authenticator.promptForHostKeyChange(this.location);
        }

        private boolean isHostKeyChangeWarning(String message) {
            return message.indexOf("WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED") != -1;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt.length == 0) {
                return new String[0];
            }
            try {
                if (this.attemptCount == 0 && this.password != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    ++this.attemptCount;
                    return new String[]{this.password};
                }
                String[] result = this.authenticator.promptForKeyboradInteractive(this.location, destination, name, instruction, prompt, echo);
                if (result == null) {
                    return null;
                }
                if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    this.password = result[0];
                    this.passwordChanged = true;
                }
                ++this.attemptCount;
                return result;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            catch (CVSException cVSException) {
                return null;
            }
        }

        public void aboutToConnect() {
            this.attemptCount = 0;
            this.passwordChanged = false;
        }

        public void connectionMade() {
            this.attemptCount = 0;
            if (this.passwordChanged && this.password != null) {
                this.location.setPassword(this.password);
            }
        }

        public boolean isPurgeHostKey() {
            return this.purgeHostKey;
        }

        static /* synthetic */ String access$0(MyUserInfo myUserInfo) {
            return myUserInfo.username;
        }
    }
}

