/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.spy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.spy.JdwpCommandPacket;
import org.eclipse.jdi.internal.spy.JdwpConversation;
import org.eclipse.jdi.internal.spy.JdwpPacket;
import org.eclipse.jdi.internal.spy.JdwpReplyPacket;
import org.eclipse.jdi.internal.spy.TcpIpSpyMessages;
import org.eclipse.jdi.internal.spy.UnableToParseDataException;
import org.eclipse.jdi.internal.spy.VerbosePacketStream;

public class TcpipSpy
extends Thread {
    private static final byte[] handshakeBytes = "JDWP-Handshake".getBytes();
    private boolean fVMtoDebugger;
    private DataInputStream fDataIn;
    private DataOutputStream fDataOut;
    private static VerbosePacketStream out = new VerbosePacketStream(System.out);
    private static Map fPackets = new HashMap();
    private static int fFieldIDSize;
    private static int fMethodIDSize;
    private static int fObjectIDSize;
    private static int fReferenceTypeIDSize;
    private static int fFrameIDSize;
    private static boolean fHasSizes;

    public TcpipSpy(boolean VMtoDebugger, InputStream in, OutputStream out) {
        this.fVMtoDebugger = VMtoDebugger;
        this.fDataIn = new DataInputStream(new BufferedInputStream(in));
        this.fDataOut = new DataOutputStream(new BufferedOutputStream(out));
        fHasSizes = false;
    }

    public static void main(String[] args) {
        int inPort = 0;
        String serverHost = null;
        int outPort = 0;
        String outputFile = null;
        try {
            inPort = Integer.parseInt(args[0]);
            serverHost = args[1];
            outPort = Integer.parseInt(args[2]);
            if (args.length > 3) {
                outputFile = args[3];
            }
        }
        catch (Exception exception) {
            out.println(TcpIpSpyMessages.TcpipSpy_usage__TcpipSpy__client_port___server_host___server_port____output_file___1);
            System.exit(-1);
        }
        if (outputFile != null) {
            File file = new File(outputFile);
            out.println(MessageFormat.format(TcpIpSpyMessages.TcpipSpy_Writing_output_to__0__2, file.getAbsolutePath()));
            try {
                out = new VerbosePacketStream(new BufferedOutputStream(new FileOutputStream(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                out.println(MessageFormat.format(TcpIpSpyMessages.TcpipSpy_Could_not_open__0____Using_stdout_instead_3, file.getAbsolutePath()));
            }
        }
        out.println();
        try {
            ServerSocket serverSock = new ServerSocket(inPort);
            Socket inSock = serverSock.accept();
            Socket outSock = new Socket(InetAddress.getByName(serverHost), outPort);
            new TcpipSpy(false, inSock.getInputStream(), outSock.getOutputStream()).start();
            new TcpipSpy(true, outSock.getInputStream(), inSock.getOutputStream()).start();
        }
        catch (Exception e) {
            out.println(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                int handshakeLength = handshakeBytes.length;
                while (true) {
                    if (handshakeLength-- <= 0) {
                        this.fDataOut.flush();
                        while (true) {
                            JdwpPacket p = JdwpPacket.read(this.fDataIn);
                            if (!this.fVMtoDebugger || (p.getFlags() & 0xFFFFFF80) != 0) {
                                TcpipSpy.store(p);
                            }
                            out.print(p, this.fVMtoDebugger);
                            out.flush();
                            p.write(this.fDataOut);
                            this.fDataOut.flush();
                        }
                    }
                    int b = this.fDataIn.read();
                    this.fDataOut.write(b);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (SocketException socketException) {
            }
            catch (IOException e) {
                out.println(MessageFormat.format(TcpIpSpyMessages.TcpipSpy_Caught_exception___0__5, e.toString()));
                e.printStackTrace(out);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                this.fDataIn.close();
                this.fDataOut.close();
            }
            catch (IOException iOException) {}
            out.flush();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        this.fDataIn.close();
        this.fDataOut.close();
        out.flush();
    }

    public static JdwpCommandPacket getCommand(int id) {
        JdwpConversation conversation = (JdwpConversation)fPackets.get(new Integer(id));
        if (conversation != null) {
            return conversation.getCommand();
        }
        return null;
    }

    protected static void store(JdwpPacket packet) {
        int id = packet.getId();
        JdwpConversation conversation = (JdwpConversation)fPackets.get(new Integer(id));
        if (conversation == null) {
            conversation = new JdwpConversation(id);
            fPackets.put(new Integer(id), conversation);
        }
        if ((packet.getFlags() & 0xFFFFFF80) != 0) {
            conversation.setReply((JdwpReplyPacket)packet);
        } else {
            conversation.setCommand((JdwpCommandPacket)packet);
        }
    }

    public static int getCommand(JdwpPacket packet) throws UnableToParseDataException {
        JdwpCommandPacket command = null;
        if (packet instanceof JdwpCommandPacket) {
            command = (JdwpCommandPacket)packet;
        } else {
            command = TcpipSpy.getCommand(packet.getId());
            if (command == null) {
                throw new UnableToParseDataException(TcpIpSpyMessages.TcpIpSpy_This_packet_is_marked_as_reply__but_there_is_no_command_with_the_same_id__1, null);
            }
        }
        return command.getCommand();
    }

    public static boolean hasSizes() {
        return fHasSizes;
    }

    public static void setHasSizes(boolean value) {
        fHasSizes = value;
    }

    public static void setFieldIDSize(int fieldIDSize) {
        fFieldIDSize = fieldIDSize;
    }

    public static int getFieldIDSize() {
        return fFieldIDSize;
    }

    public static void setMethodIDSize(int methodIDSize) {
        fMethodIDSize = methodIDSize;
    }

    public static int getMethodIDSize() {
        return fMethodIDSize;
    }

    public static void setObjectIDSize(int objectIDSize) {
        fObjectIDSize = objectIDSize;
    }

    public static int getObjectIDSize() {
        return fObjectIDSize;
    }

    public static void setReferenceTypeIDSize(int referenceTypeIDSize) {
        fReferenceTypeIDSize = referenceTypeIDSize;
    }

    public static int getReferenceTypeIDSize() {
        return fReferenceTypeIDSize;
    }

    public static void setFrameIDSize(int frameIDSize) {
        fFrameIDSize = frameIDSize;
    }

    public static int getFrameIDSize() {
        return fFrameIDSize;
    }
}

