/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.internal.INavigatable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelManager;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelManager;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.StructuredViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelManager;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.actions.ExpandAllAction;
import org.eclipse.team.internal.ui.synchronize.actions.NavigateAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TreeViewerAdvisor
extends StructuredViewerAdvisor {
    public static final int CHECKBOX = 1;
    private ExpandAllAction expandAllAction;
    private Action collapseAll;
    private NavigateAction gotoNext;
    private NavigateAction gotoPrevious;
    static /* synthetic */ Class class$0;

    public static StructuredViewer createViewer(Composite parent, ISynchronizePageConfiguration configuration) {
        int style = ((SynchronizePageConfiguration)configuration).getViewerStyle();
        if ((style & 1) > 0) {
            NavigableCheckboxTreeViewer v = new NavigableCheckboxTreeViewer(parent, 770);
            configuration.getSite().setSelectionProvider((ISelectionProvider)v);
            return v;
        }
        NavigableTreeViewer v = new NavigableTreeViewer(parent, 770);
        configuration.getSite().setSelectionProvider((ISelectionProvider)v);
        return v;
    }

    public TreeViewerAdvisor(Composite parent, ISynchronizePageConfiguration configuration) {
        super(configuration);
        INavigatable nav = (INavigatable)configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
        if (nav == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.compare.internal.INavigatable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            configuration.setProperty("org.eclipse.team.ui.P_NAVIGATOR", this.getAdapter(clazz));
        }
        configuration.addActionContribution(new NavigationActionGroup());
        StructuredViewer viewer = TreeViewerAdvisor.createViewer(parent, configuration);
        GridData data = new GridData(1808);
        viewer.getControl().setLayoutData((Object)data);
        this.initializeViewer(viewer);
    }

    protected SynchronizeModelManager createModelManager(ISynchronizePageConfiguration configuration) {
        IChangeSetProvider provider;
        ChangeSetCapability changeSetCapability;
        ISynchronizeParticipant participant = configuration.getParticipant();
        if (participant instanceof IChangeSetProvider && (changeSetCapability = (provider = (IChangeSetProvider)((Object)participant)).getChangeSetCapability()) != null && (changeSetCapability.supportsActiveChangeSets() || changeSetCapability.supportsCheckedInChangeSets())) {
            return new ChangeSetModelManager(configuration);
        }
        return new HierarchicalModelManager(configuration);
    }

    public boolean navigate(boolean next) {
        return TreeViewerAdvisor.navigate((TreeViewer)this.getViewer(), next, false, false);
    }

    public boolean validateViewer(StructuredViewer viewer) {
        return viewer instanceof AbstractTreeViewer;
    }

    protected boolean handleDoubleClick(StructuredViewer viewer, DoubleClickEvent event) {
        if (super.handleDoubleClick(viewer, event)) {
            return true;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        AbstractTreeViewer treeViewer = (AbstractTreeViewer)this.getViewer();
        if (element != null) {
            if (treeViewer.getExpandedState(element)) {
                treeViewer.collapseToLevel(element, -1);
            } else {
                TreeViewerAdvisor.navigate((TreeViewer)this.getViewer(), true, false, true);
            }
        }
        return true;
    }

    protected void initializeListeners(StructuredViewer viewer) {
        super.initializeListeners(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewerAdvisor.this.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
    }

    void updateStatusLine(IStructuredSelection selection) {
        IWorkbenchSite ws = this.getConfiguration().getSite().getWorkbenchSite();
        if (ws != null && ws instanceof IViewSite) {
            String msg = this.getStatusLineMessage(selection);
            ((IViewSite)ws).getActionBars().getStatusLineManager().setMessage(msg);
        }
    }

    private String getStatusLineMessage(IStructuredSelection selection) {
        Object first;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof SyncInfoModelElement) {
            SyncInfoModelElement node = (SyncInfoModelElement)first;
            IResource resource = node.getResource();
            if (resource == null) {
                return node.getName();
            }
            return resource.getFullPath().makeRelative().toString();
        }
        if (selection.size() > 1) {
            return String.valueOf(selection.size()) + TeamUIMessages.SynchronizeView_13;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static TreeItem findNextPrev(TreeViewer viewer, TreeItem item, boolean next) {
        if (item == null || !(viewer instanceof ITreeViewerAccessor)) {
            return null;
        }
        children = null;
        treeAccessor = (ITreeViewerAccessor)viewer;
        if (!next) {
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index > 0) {
                    item = children[index - 1];
                    while (true) {
                        treeAccessor.createChildren(item);
                        n = item.getItemCount();
                        if (n <= 0) break;
                        item.setExpanded(true);
                        item = item.getItems()[n - 1];
                    }
                    return item;
                }
            }
            return parent;
        }
        item.setExpanded(true);
        treeAccessor.createChildren(item);
        if (item.getItemCount() <= 0) ** GOTO lbl42
        children = item.getItems();
        return children[0];
lbl-1000:
        // 1 sources

        {
            children = null;
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index < children.length - 1) {
                    return children[index + 1];
                }
            }
            item = parent;
lbl42:
            // 2 sources

            ** while (item != null)
        }
lbl43:
        // 1 sources

        return item;
    }

    private static void setSelection(TreeViewer viewer, TreeItem ti, boolean fireOpen, boolean expandOnly) {
        Object data;
        if (ti != null && (data = ti.getData()) != null) {
            StructuredSelection selection = new StructuredSelection(data);
            if (expandOnly) {
                viewer.expandToLevel(data, 0);
            } else {
                viewer.setSelection((ISelection)selection, true);
                ISelection currentSelection = viewer.getSelection();
                if (fireOpen && currentSelection != null && selection.equals(currentSelection) && viewer instanceof ITreeViewerAccessor) {
                    ((ITreeViewerAccessor)viewer).openSelection();
                }
            }
        }
    }

    public static boolean navigate(TreeViewer viewer, boolean next, boolean fireOpen, boolean expandOnly) {
        Tree tree = viewer.getTree();
        if (tree == null) {
            return false;
        }
        TreeItem item = null;
        TreeItem[] children = tree.getSelection();
        if (children != null && children.length > 0) {
            item = children[0];
        }
        if (item == null && (children = tree.getItems()) != null && children.length > 0 && (item = children[0]) != null && item.getItemCount() <= 0) {
            TreeViewerAdvisor.setSelection(viewer, item, fireOpen, expandOnly);
            return false;
        }
        while ((item = TreeViewerAdvisor.findNextPrev(viewer, item, next)) != null && item.getItemCount() > 0) {
        }
        if (item != null) {
            TreeViewerAdvisor.setSelection(viewer, item, fireOpen, expandOnly);
            return false;
        }
        return true;
    }

    class NavigationActionGroup
    extends SynchronizePageActionGroup {
        NavigationActionGroup() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            StructuredViewer viewer = TreeViewerAdvisor.this.getViewer();
            if (viewer instanceof AbstractTreeViewer) {
                TreeViewerAdvisor.this.expandAllAction = new ExpandAllAction((AbstractTreeViewer)viewer);
                Utils.initAction((IAction)TreeViewerAdvisor.this.expandAllAction, "action.expandAll.");
                TreeViewerAdvisor.this.collapseAll = new Action(this, viewer){
                    final /* synthetic */ NavigationActionGroup this$1;
                    private final /* synthetic */ StructuredViewer val$viewer;
                    {
                        this.this$1 = navigationActionGroup;
                        this.val$viewer = structuredViewer;
                    }

                    public void run() {
                        if (this.val$viewer == null || this.val$viewer.getControl().isDisposed() || !(this.val$viewer instanceof AbstractTreeViewer)) {
                            return;
                        }
                        this.val$viewer.getControl().setRedraw(false);
                        ((AbstractTreeViewer)this.val$viewer).collapseToLevel(this.val$viewer.getInput(), -1);
                        this.val$viewer.getControl().setRedraw(true);
                    }
                };
                Utils.initAction((IAction)TreeViewerAdvisor.this.collapseAll, "action.collapseAll.");
                ISynchronizeParticipant participant = configuration.getParticipant();
                ISynchronizePageSite site = configuration.getSite();
                TreeViewerAdvisor.this.gotoNext = new NavigateAction(site, participant, configuration, true);
                TreeViewerAdvisor.this.gotoPrevious = new NavigateAction(site, participant, configuration, false);
            }
        }

        public void fillContextMenu(IMenuManager manager) {
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)TreeViewerAdvisor.this.expandAllAction);
        }

        public void fillActionBars(IActionBars actionBars) {
            IToolBarManager manager = actionBars.getToolBarManager();
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)TreeViewerAdvisor.this.gotoNext);
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)TreeViewerAdvisor.this.gotoPrevious);
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)TreeViewerAdvisor.this.collapseAll);
        }
    }

    public static interface ITreeViewerAccessor {
        public void createChildren(TreeItem var1);

        public void openSelection();
    }

    public static class NavigableCheckboxTreeViewer
    extends ContainerCheckedTreeViewer
    implements ITreeViewerAccessor {
        public NavigableCheckboxTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.setUseHashlookup(true);
        }

        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }
    }

    public static class NavigableTreeViewer
    extends TreeViewer
    implements ITreeViewerAccessor {
        public NavigableTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.setUseHashlookup(true);
        }

        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }
    }
}

