/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.IPreferenceIds;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SyncViewerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPreferenceIds {
    private BooleanFieldEditor showSyncInLabels = null;
    private RadioGroupFieldEditor synchronizePerspectiveSwitch = null;
    private RadioGroupFieldEditor defaultLayout = null;

    public SyncViewerPreferencePage() {
        super(1);
        this.setTitle(TeamUIMessages.SyncViewerPreferencePage_6);
        this.setDescription(TeamUIMessages.SyncViewerPreferencePage_7);
        this.setPreferenceStore(TeamUIPlugin.getPlugin().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.ui.sync_preference_page_context");
    }

    public void createFieldEditors() {
        this.showSyncInLabels = new BooleanFieldEditor("org.eclipse.team.ui.view_syncinfo_in_label", TeamUIMessages.SyncViewerPreferencePage_19, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showSyncInLabels);
        this.defaultLayout = new RadioGroupFieldEditor("org.eclipse.team.ui.default_layout", TeamUIMessages.SyncViewerPreferencePage_0, 3, (String[][])new String[][]{{TeamUIMessages.SyncViewerPreferencePage_1, "org.eclipse.team.ui.flay_layout"}, {TeamUIMessages.SyncViewerPreferencePage_2, "org.eclipse.team.ui.tree_layout"}, {TeamUIMessages.SyncViewerPreferencePage_3, "org.eclipse.team.ui.compressed_layout"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.defaultLayout);
        this.synchronizePerspectiveSwitch = new RadioGroupFieldEditor("org.eclipse.team.ui.sychronizing_default_perspective_to_show", TeamUIMessages.SyncViewerPreferencePage_13, 3, (String[][])new String[][]{{TeamUIMessages.SyncViewerPreferencePage_14, "always"}, {TeamUIMessages.SyncViewerPreferencePage_42, "never"}, {TeamUIMessages.SyncViewerPreferencePage_16, "prompt"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.synchronizePerspectiveSwitch);
        Group perspectiveGroup = this.createGroup(this.getFieldEditorParent(), TeamUIMessages.SyncViewerPreferencePage_15);
        this.createLabel((Composite)perspectiveGroup, TeamUIMessages.SynchronizationViewPreference_defaultPerspectiveDescription, 1);
        SyncViewerPreferencePage.handleDeletedPerspectives();
        String[][] perspectiveNamesAndIds = this.getPerspectiveNamesAndIds();
        ComboFieldEditor comboEditor = new ComboFieldEditor("org.eclipse.team.ui.syncview_default_perspective", TeamUIMessages.SynchronizationViewPreference_defaultPerspectiveLabel, perspectiveNamesAndIds, (Composite)perspectiveGroup);
        this.addField(comboEditor);
        Dialog.applyDialogFont((Control)this.getFieldEditorParent());
        this.updateLayout((Composite)perspectiveGroup);
        this.getFieldEditorParent().layout(true);
    }

    private Label createLabel(Composite parent, String title, int spacer) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        if (spacer != 0) {
            data.verticalSpan = spacer;
        }
        data.horizontalAlignment = 4;
        l.setLayoutData((Object)data);
        if (title != null) {
            l.setText(title);
        }
        return l;
    }

    private Group createGroup(Composite parent, String title) {
        Group display = new Group(parent, 0);
        this.updateLayout((Composite)display);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        display.setLayoutData((Object)data);
        display.setText(title);
        return display;
    }

    private void updateLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public boolean performOk() {
        TeamUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    protected void initialize() {
        super.initialize();
        this.updateEnablements();
    }

    protected void updateEnablements() {
    }

    private String[][] getPerspectiveNamesAndIds() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectiveDescriptors = registry.getPerspectives();
        Arrays.sort(perspectiveDescriptors, new PerspectiveDescriptorComparator());
        String[][] table = new String[perspectiveDescriptors.length + 1][2];
        table[0][0] = TeamUIMessages.SynchronizationViewPreference_defaultPerspectiveNone;
        table[0][1] = "org.eclipse.team.ui.sync_view_perspective_none";
        int i = 0;
        while (i < perspectiveDescriptors.length) {
            table[i + 1][0] = perspectiveDescriptors[i].getLabel();
            table[i + 1][1] = perspectiveDescriptors[i].getId();
            ++i;
        }
        return table;
    }

    private static void handleDeletedPerspectives() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        String id = store.getString("org.eclipse.team.ui.syncview_default_perspective");
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.sync_view_perspective_none");
        }
    }

    private static class PerspectiveDescriptorComparator
    implements Comparator {
        PerspectiveDescriptorComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IPerspectiveDescriptor && o2 instanceof IPerspectiveDescriptor) {
                String id1 = ((IPerspectiveDescriptor)o1).getLabel();
                String id2 = ((IPerspectiveDescriptor)o2).getLabel();
                return Collator.getInstance().compare(id1, id2);
            }
            return 0;
        }
    }
}

