/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.internal.resources.mapping.ResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class Utils {
    public static final Comparator resourceComparator = new Comparator(){

        public boolean equals(Object obj) {
            return false;
        }

        public int compare(Object o1, Object o2) {
            IResource resource0 = (IResource)o1;
            IResource resource1 = (IResource)o2;
            return resource0.getFullPath().toString().compareTo(resource1.getFullPath().toString());
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)exception).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.TeamAction_internal, t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                TeamUIPlugin.log(toShow.getSeverity(), message, t);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void runWithProgress(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 141->145)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Shell getShell(IWorkbenchSite site) {
        IWorkbenchWindow window;
        Shell shell;
        if (site != null && !(shell = site.getShell()).isDisposed()) {
            return shell;
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return null;
        }
        return new Shell(display);
    }

    public static void handle(final Throwable exception) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                Object error = null;
                Throwable t = exception;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.simpleInternal, t));
                Shell shell = new Shell(Display.getDefault());
                if (error.getSeverity() == 1) {
                    MessageDialog.openInformation((Shell)shell, (String)TeamUIMessages.information, (String)error.getMessage());
                } else {
                    ErrorDialog.openError((Shell)shell, (String)TeamUIMessages.exception, null, (IStatus)error);
                }
                shell.dispose();
                if (!(t instanceof TeamException)) {
                    TeamUIPlugin.log(error.getSeverity(), error.getMessage(), t);
                }
            }
        });
    }

    public static Shell findShell() {
        Display display = TeamUIPlugin.getStandardDisplay();
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            return activeShell;
        }
        return new Shell(display);
    }

    public static void initAction(IAction a, String prefix) {
        Utils.initAction(a, prefix, Policy.getActionBundle());
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle) {
        Utils.initAction(a, prefix, bundle, null);
    }

    public static void updateLabels(SyncInfo sync, CompareConfiguration config) {
        IResourceVariant remote = sync.getRemote();
        IResourceVariant base = sync.getBase();
        String localContentId = sync.getLocalContentIdentifier();
        if (localContentId != null) {
            config.setLeftLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelExists, (Object[])new String[]{localContentId}));
        } else {
            config.setLeftLabel(TeamUIMessages.SyncInfoCompareInput_localLabel);
        }
        if (remote != null) {
            config.setRightLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelExists, (Object[])new String[]{remote.getContentIdentifier()}));
        } else {
            config.setRightLabel(TeamUIMessages.SyncInfoCompareInput_remoteLabel);
        }
        if (base != null) {
            config.setAncestorLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelExists, (Object[])new String[]{base.getContentIdentifier()}));
        } else {
            config.setAncestorLabel(TeamUIMessages.SyncInfoCompareInput_baseLabel);
        }
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle, String[] bindings) {
        String relPath;
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        String s = null;
        s = bindings != null ? NLS.bind((String)Utils.getString(labelKey, bundle), (Object[])bindings) : Utils.getString(labelKey, bundle);
        if (s != null) {
            a.setText(s);
        }
        if ((s = Utils.getString(tooltipKey, bundle)) != null) {
            a.setToolTipText(s);
        }
        if ((s = Utils.getString(descriptionKey, bundle)) != null) {
            a.setDescription(s);
        }
        if ((relPath = Utils.getString(imageKey, bundle)) != null && !relPath.equals(imageKey) && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = TeamImages.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = TeamUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
            }
        }
    }

    public static String getString(String key, ResourceBundle b) {
        try {
            return b.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case 1: {
                return TeamUIMessages.Utils_22;
            }
            case 2: {
                return TeamUIMessages.Utils_23;
            }
            case 4: {
                return TeamUIMessages.Utils_24;
            }
            case 8: {
                return TeamUIMessages.Utils_25;
            }
        }
        return TeamUIMessages.Utils_26;
    }

    private static IResource[] getResources(Object[] elements, List nonResources, boolean isContributed) {
        ArrayList<Object> resources = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            boolean isResource = false;
            if (element instanceof IResource) {
                resources.add(element);
                isResource = true;
            } else if (element instanceof ISynchronizeModelElement) {
                IResource resource = ((ISynchronizeModelElement)element).getResource();
                if (resource != null) {
                    resources.add(resource);
                    isResource = true;
                }
            } else if (element instanceof ResourceMapping) {
                isResource = true;
                Utils.getResources((ResourceMapping)element, resources);
            } else {
                Object adapted;
                if (isContributed) {
                    adapted = LegacyResourceSupport.getAdaptedResource((Object)element);
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    adapted = Utils.getAdapter(element, clazz);
                }
                if (adapted instanceof IResource) {
                    IResource resource = (IResource)adapted;
                    isResource = true;
                    if (resource.getType() != 8) {
                        resources.add(resource);
                    }
                } else {
                    if (isContributed) {
                        adapted = LegacyResourceSupport.getAdaptedContributorResourceMapping((Object)element);
                    } else {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.internal.resources.mapping.ResourceMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapted = Utils.getAdapter(element, clazz);
                    }
                    if (adapted instanceof ResourceMapping) {
                        isResource = true;
                        Utils.getResources((ResourceMapping)adapted, resources);
                    }
                }
            }
            if (!isResource && nonResources != null) {
                nonResources.add(element);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static void getResources(ResourceMapping element, List resources) {
        try {
            ResourceTraversal[] traversals = element.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int k = 0;
            while (k < traversals.length) {
                ResourceTraversal traversal = traversals[k];
                IResource[] resourceArray = traversal.getResources();
                int j = 0;
                while (j < resourceArray.length) {
                    IResource resource = resourceArray[j];
                    resources.add(resource);
                    ++j;
                }
                ++k;
            }
        }
        catch (CoreException e) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 0, "Error traversing resource mapping", (Throwable)e));
        }
    }

    public static Object[] getNonResources(Object[] elements) {
        ArrayList nonResources = new ArrayList();
        Utils.getResources(elements, nonResources, false);
        return nonResources.toArray();
    }

    public static IResource[] getResources(Object[] element) {
        return Utils.getResources(element, null, false);
    }

    public static IResource[] getContributedResources(Object[] elements) {
        return Utils.getResources(elements, null, true);
    }

    public static Object getAdapter(Object element, Class adapter) {
        if (element instanceof IAdaptable) {
            return ((IAdaptable)element).getAdapter(adapter);
        }
        return null;
    }

    public static boolean hasMatchingDescendant(IStructuredSelection selection, FastSyncInfoFilter filter) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ISynchronizeModelElement) || !Utils.hasMatchingDescendant((ISynchronizeModelElement)o, filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMatchingDescendant(ISynchronizeModelElement element, FastSyncInfoFilter filter) {
        SyncInfo info;
        if (element.getKind() != 0 && element instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)element).getSyncInfo()) != null && filter.select(info)) {
            return true;
        }
        IDiffElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement child = children[i];
            if (child instanceof ISynchronizeModelElement && Utils.hasMatchingDescendant((ISynchronizeModelElement)child, filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IDiffElement[] getDiffNodes(Object[] selected) {
        HashSet result = new HashSet();
        int i = 0;
        while (i < selected.length) {
            Object object = selected[i];
            if (object instanceof IDiffElement) {
                Utils.collectAllNodes((IDiffElement)object, result);
            }
            ++i;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private static void collectAllNodes(IDiffElement element, Set nodes) {
        if (element.getKind() != 0) {
            nodes.add(element);
        }
        if (element instanceof IDiffContainer) {
            IDiffElement[] children = ((IDiffContainer)element).getChildren();
            int i = 0;
            while (i < children.length) {
                Utils.collectAllNodes(children[i], nodes);
                ++i;
            }
        }
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        if (site != null) {
            IWorkbenchSiteProgressService siteProgress;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((siteProgress = (IWorkbenchSiteProgressService)site.getAdapter((Class)clazz)) != null) {
                siteProgress.schedule(job, 0L, true);
                return;
            }
        }
        job.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos;
        block18: {
            bos = new ByteArrayOutputStream();
            try {
                try {
                    int c;
                    while ((c = in.read()) != -1) {
                        bos.write(c);
                    }
                }
                catch (IOException iOException) {
                    byte[] byArray = null;
                    Object var3_4 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    try {
                        bos.close();
                        return byArray;
                    }
                    catch (IOException iOException3) {}
                    return byArray;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (in != null) {
                    try {}
                    catch (IOException iOException) {}
                    in.close();
                }
                try {}
                catch (IOException iOException) {}
                bos.close();
                throw throwable;
                throw throwable;
            }
            {
                Object var3_6 = null;
                if (in == null) break block18;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        try {}
        catch (IOException iOException) {
            return bos.toByteArray();
        }
        bos.close();
        return bos.toByteArray();
    }

    public static boolean equalObject(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String getKey(String id, String secondaryId) {
        return secondaryId == null ? id : String.valueOf(id) + '/' + secondaryId;
    }

    public static String convertSelection(IResource[] resources) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(resource.getFullPath());
            ++i;
        }
        return buffer.toString();
    }

    public static String shortenText(int maxWidth, String textValue) {
        int pivot;
        int length = textValue.length();
        if (length < maxWidth) {
            return textValue;
        }
        int ellipsisWidth = 3;
        int start = pivot = length / 2;
        int end = pivot + 1;
        while (start >= 0 && end < length) {
            int l2;
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = s1.length();
            if (l1 + ellipsisWidth + (l2 = s2.length()) < maxWidth) {
                return String.valueOf(s1) + "..." + s2;
            }
            --start;
            ++end;
        }
        return textValue;
    }

    public static String getTypeName(ISynchronizeParticipant participant) {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        return manager.getParticipantDescriptor(participant.getId()).getName();
    }

    public static boolean canUpdateViewer(StructuredViewer viewer) {
        if (viewer == null || viewer.getControl().isDisposed()) {
            return false;
        }
        Display display = viewer.getControl().getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static void asyncExec(final Runnable r, StructuredViewer v) {
        if (v == null) {
            return;
        }
        final Control ctrl = v.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                    }
                }
            });
        }
    }

    public static void syncExec(final Runnable r, StructuredViewer v) {
        if (v == null) {
            return;
        }
        final Control ctrl = v.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                    }
                }
            });
        }
    }

    public static SyncInfo getSyncInfo(ISynchronizeModelElement node) {
        if (node instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)node;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (SyncInfo)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public static abstract class Sorter {
        public abstract boolean compare(Object var1, Object var2);

        private Object[] quickSort(Object[] sortedCollection, int left, int right) {
            int originalLeft = left;
            int originalRight = right;
            Object mid = sortedCollection[(left + right) / 2];
            while (true) {
                if (this.compare(sortedCollection[left], mid)) {
                    ++left;
                    continue;
                }
                while (this.compare(mid, sortedCollection[right])) {
                    --right;
                }
                if (left <= right) {
                    Object tmp = sortedCollection[left];
                    sortedCollection[left] = sortedCollection[right];
                    sortedCollection[right] = tmp;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (originalLeft < right) {
                sortedCollection = this.quickSort(sortedCollection, originalLeft, right);
            }
            if (left < originalRight) {
                sortedCollection = this.quickSort(sortedCollection, left, originalRight);
            }
            return sortedCollection;
        }

        public Object[] sort(Object[] unSortedCollection) {
            int size = unSortedCollection.length;
            Object[] sortedCollection = new Object[size];
            System.arraycopy(unSortedCollection, 0, sortedCollection, 0, size);
            if (size > 1) {
                this.quickSort(sortedCollection, 0, size - 1);
            }
            return sortedCollection;
        }
    }
}

