/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.StringWrapper;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SuperInterfaceSelectionDialog
extends TypeSelectionDialog2 {
    private static final int ADD_ID = 1025;
    private ListDialogField fList;
    private List fOldContent;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, ListDialogField list, IJavaProject p) {
        super(parent, true, context, SuperInterfaceSelectionDialog.createSearchScope(p), 6);
        this.fList = list;
        this.fOldContent = this.fList.getElements();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.SuperInterfaceSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fList.setElements(this.fOldContent);
    }

    protected void cancelPressed() {
        this.fList.setElements(this.fOldContent);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterface();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedInterface();
        super.okPressed();
    }

    private void addSelectedInterface() {
        TypeInfo[] selection = this.getSelectedTypes();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            TypeInfo type = selection[i];
            String qualifiedName = type.getFullyQualifiedName();
            this.addStringWrapper(qualifiedName);
            String message = Messages.format(NewWizardMessages.SuperInterfaceSelectionDialog_interfaceadded_info, qualifiedName);
            this.updateStatus(new StatusInfo(1, message));
            ++i;
        }
    }

    private void addStringWrapper(String qualifiedName) {
        int i = 0;
        while (i < this.fList.getSize()) {
            StringWrapper element = (StringWrapper)this.fList.getElement(i);
            if (qualifiedName.equals(element.getString())) {
                return;
            }
            ++i;
        }
        this.fList.addElement(new StringWrapper(qualifiedName));
    }

    private static IJavaSearchScope createSearchScope(IJavaProject p) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
    }

    protected void handleDefaultSelected(TypeInfo[] selection) {
        if (selection.length > 0) {
            this.buttonPressed(1025);
        }
    }

    protected void handleWidgetSelected(TypeInfo[] selection) {
        super.handleWidgetSelected(selection);
        this.getButton(1025).setEnabled(selection.length > 0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.super_interface_selection_dialog_context");
    }
}

