/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    private int fFilterProperties;

    public final void addFilter(int filter) {
        this.fFilterProperties |= filter;
    }

    public final void removeFilter(int filter) {
        this.fFilterProperties &= 0xFFFFFFFF ^ filter;
    }

    public final boolean hasFilter(int filter) {
        return (this.fFilterProperties & filter) != 0;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        try {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                int memberType = member.getElementType();
                if (this.hasFilter(4) && memberType == 8) {
                    return false;
                }
                if (this.hasFilter(8) && memberType == 7 && this.isLocalType((IType)member)) {
                    return false;
                }
                if (member.getElementName().startsWith("<")) {
                    return false;
                }
                int flags = member.getFlags();
                if (this.hasFilter(2) && (Flags.isStatic((int)flags) || this.isFieldInInterfaceOrAnnotation(member)) && memberType != 7) {
                    return false;
                }
                if (!(!this.hasFilter(1) || Flags.isPublic((int)flags) || this.isMemberInInterfaceOrAnnotation(member) || this.isTopLevelType(member) || this.isEnumConstant(member))) {
                    return false;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return true;
    }

    private boolean isLocalType(IType type) {
        IJavaElement parent = type.getParent();
        return parent instanceof IMember && !(parent instanceof IType);
    }

    private boolean isMemberInInterfaceOrAnnotation(IMember member) throws JavaModelException {
        IType parent = member.getDeclaringType();
        return parent != null && JavaModelUtil.isInterfaceOrAnnotation(parent);
    }

    private boolean isFieldInInterfaceOrAnnotation(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JavaModelUtil.isInterfaceOrAnnotation(member.getDeclaringType());
    }

    private boolean isTopLevelType(IMember member) {
        IType parent = member.getDeclaringType();
        return parent == null;
    }

    private boolean isEnumConstant(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && ((IField)member).isEnumConstant();
    }
}

