/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingProblem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class JavaSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private IProblemRequestor fRequestor;
    private ISpellingProblemCollector fCollector = new SpellingProblemCollector();

    public JavaSpellingReconcileStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.updateProblemRequester();
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.fRequestor != null) {
            try {
                SpellingContext context = new SpellingContext();
                context.setContentType(this.getContentType());
                EditorsUI.getSpellingService().check(this.fDocument, context, this.fCollector, this.fProgressMonitor);
            }
            catch (CoreException coreException) {}
        }
    }

    private IContentType getContentType() throws CoreException {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider instanceof IDocumentProviderExtension4) {
            return ((IDocumentProviderExtension4)documentProvider).getContentType((Object)this.fEditor.getEditorInput());
        }
        return null;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.updateProblemRequester();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = JavaSpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IEditorInput editorInput;
                    int line = JavaSpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                    String word = JavaSpellingReconcileStrategy.this.fDocument.get(problem.getOffset(), problem.getLength());
                    boolean dictionaryMatch = false;
                    boolean sentenceStart = false;
                    if (problem instanceof JavaSpellingProblem) {
                        dictionaryMatch = ((JavaSpellingProblem)problem).isDictionaryMatch();
                        sentenceStart = ((JavaSpellingProblem)problem).isSentenceStart();
                    }
                    if ((editorInput = JavaSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, JavaSpellingReconcileStrategy.this.fDocument, editorInput.getName());
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

